/* This is -*- C -*- */
/* $Id: guppi-garray.c,v 1.1 2000/02/09 22:44:22 trow Exp $ */

/*
 * guppi-garray.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-garray.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_garray_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_garray_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_garray_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_garray_finalize(GtkObject* obj)
{
  GuppiGArray* ga = GUPPI_GARRAY(obj);
  
  if (ga->array) {
    g_array_free(ga->array, TRUE);
    ga->array = NULL;
  }

  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_garray_class_init(GuppiGArrayClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(GTK_TYPE_OBJECT);

  object_class->get_arg = guppi_garray_get_arg;
  object_class->set_arg = guppi_garray_set_arg;
  object_class->destroy = guppi_garray_destroy;
  object_class->finalize = guppi_garray_finalize;

}

static void
guppi_garray_init(GuppiGArray* obj)
{

}

GtkType
guppi_garray_get_type(void)
{
  static GtkType guppi_garray_type = 0;
  if (!guppi_garray_type) {
    static const GtkTypeInfo guppi_garray_info = {
      "GuppiGArray",
      sizeof(GuppiGArray),
      sizeof(GuppiGArrayClass),
      (GtkClassInitFunc)guppi_garray_class_init,
      (GtkObjectInitFunc)guppi_garray_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_garray_type = gtk_type_unique(GTK_TYPE_OBJECT, &guppi_garray_info);
  }
  return guppi_garray_type;
}

void
guppi_garray_construct(GuppiGArray* ga, guint elt_size)
{
  g_return_if_fail(ga != NULL);
  ga->array = g_array_new(FALSE, FALSE, elt_size);
}

GuppiGArray*
guppi_garray_new(guint elt_size)
{
  GuppiGArray* ga = GUPPI_GARRAY(gtk_type_new(guppi_garray_get_type()));
  guppi_garray_construct(ga, elt_size);
  return ga;
}



/* $Id: guppi-garray.c,v 1.1 2000/02/09 22:44:22 trow Exp $ */
