/* This is -*- C -*- */
/* $Id: guppi-struct.c,v 1.1 2000/02/09 21:04:56 trow Exp $ */

/*
 * guppi-struct.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-struct.h"
#include "guppi-struct-impl.h"
#include "guppi-struct-core-impl.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_struct_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_struct_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_struct_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_struct_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static GList*
v_subdata(GuppiData* data)
{
  GuppiStruct* str = GUPPI_STRUCT(data);
  gchar** stringv = NULL;
  gint i=0;
  GuppiData* subdata;
  GList* subdata_list = NULL;

  stringv = guppi_struct_get_field_names(str);
  if (stringv == NULL)
    return NULL;

  while (stringv[i] != NULL) {
    subdata = guppi_struct_get(str, stringv[i]);
    subdata_list = g_list_append(subdata_list, subdata);
    gtk_object_ref(GTK_OBJECT(subdata));
    ++i;
  }

  g_strfreev(stringv);

  return subdata_list;
}

static void
guppi_struct_class_init(GuppiStructClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;
  GuppiDataClass* data_class = GUPPI_DATA_CLASS(klass);

  parent_class = gtk_type_class(GUPPI_TYPE_DATA);

  data_class->default_impl = GUPPI_TYPE_STRUCT_CORE_IMPL;
  data_class->type_name = _("Struct");

  data_class->general_subdata = v_subdata;

  object_class->get_arg = guppi_struct_get_arg;
  object_class->set_arg = guppi_struct_set_arg;
  object_class->destroy = guppi_struct_destroy;
  object_class->finalize = guppi_struct_finalize;

}

static void
guppi_struct_init(GuppiStruct* obj)
{

}

GtkType
guppi_struct_get_type(void)
{
  static GtkType guppi_struct_type = 0;
  if (!guppi_struct_type) {
    static const GtkTypeInfo guppi_struct_info = {
      "GuppiStruct",
      sizeof(GuppiStruct),
      sizeof(GuppiStructClass),
      (GtkClassInitFunc)guppi_struct_class_init,
      (GtkObjectInitFunc)guppi_struct_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_struct_type = gtk_type_unique(GUPPI_TYPE_DATA, &guppi_struct_info);
  }
  return guppi_struct_type;
}

GuppiData*
guppi_struct_new(void)
{
  return GUPPI_DATA(gtk_type_new(guppi_struct_get_type()));
}

/*****************************************************************************/

GtkType
guppi_struct_get_field_type(const GuppiStruct* gs, const gchar* field)
{
  const GuppiStructImpl* impl;
  GuppiStructImplClass* impl_class;

  g_return_val_if_fail(gs != NULL, (GtkType)0);
  g_return_val_if_fail(field != NULL, (GtkType)0);

  impl = GUPPI_STRUCT_IMPL(guppi_data_impl(GUPPI_DATA(gs)));
  impl_class = GUPPI_STRUCT_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  g_assert(impl_class->field_type);
  return (impl_class->field_type)(impl, field);
}

gchar**
guppi_struct_get_field_names(const GuppiStruct* gs)
{
  const GuppiStructImpl* impl;
  GuppiStructImplClass* impl_class;

  g_return_val_if_fail(gs != NULL, (GtkType)0);

  impl = GUPPI_STRUCT_IMPL(guppi_data_impl(GUPPI_DATA(gs)));
  impl_class = GUPPI_STRUCT_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  g_assert(impl_class->get_names);
  return (impl_class->get_names)(impl);
}

gsize
guppi_struct_size(const GuppiStruct* gs)
{
  const GuppiStructImpl* impl;
  GuppiStructImplClass* impl_class;

  g_return_val_if_fail(gs != NULL, (GtkType)0);

  impl = GUPPI_STRUCT_IMPL(guppi_data_impl(GUPPI_DATA(gs)));
  impl_class = GUPPI_STRUCT_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  g_assert(impl_class->get_size);
  return (impl_class->get_size)(impl);
}

GuppiData*
guppi_struct_get(const GuppiStruct* gs, const gchar* field)
{
  const GuppiStructImpl* impl;
  GuppiStructImplClass* impl_class;

  g_return_val_if_fail(gs != NULL, NULL);
  g_return_val_if_fail(field != NULL, NULL);

  impl = GUPPI_STRUCT_IMPL(guppi_data_impl(GUPPI_DATA(gs)));
  impl_class = GUPPI_STRUCT_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  g_assert(impl_class->get);
  return (impl_class->get)(impl, field);
}

void
guppi_struct_set(GuppiStruct* gs, const gchar* field, GuppiData* data)
{
  GuppiStructImpl* impl;
  GuppiStructImplClass* impl_class;
  gboolean success;

  g_return_if_fail(gs != NULL);
  g_return_if_fail(field != NULL);

  impl = GUPPI_STRUCT_IMPL(guppi_data_impl(GUPPI_DATA(gs)));
  impl_class = GUPPI_STRUCT_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  g_assert(impl_class->set);
  success = (impl_class->set)(impl, field, data);
  if (!success)
    g_warning("struct set failed - unknown field: %s", field);

  gtk_signal_emit_by_name(GTK_OBJECT(gs), "changed");
  gtk_signal_emit_by_name(GTK_OBJECT(gs), "changed_subdata");
}

void
guppi_struct_add_field(GuppiStruct* gs, const gchar* field, GtkType type)
{
  GuppiStructImpl* impl;
  GuppiStructImplClass* impl_class;
  gboolean success;

  g_return_if_fail(gs != NULL);
  g_return_if_fail(field != NULL);

  impl = GUPPI_STRUCT_IMPL(guppi_data_impl(GUPPI_DATA(gs)));
  impl_class = GUPPI_STRUCT_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  g_assert(impl_class->add_field);
  success = (impl_class->add_field)(impl, field, type);
  if (!success)
    g_warning("struct add failed - field collision: %s", field);
}

void
guppi_struct_add_free_field(GuppiStruct* gs, const gchar* field)
{
  guppi_struct_add_field(gs, field, (GtkType)0);
}



/* $Id: guppi-struct.c,v 1.1 2000/02/09 21:04:56 trow Exp $ */
