/* This is -*- C -*- */
/* $Id: alpha-template.h,v 1.4 2000/02/06 03:17:13 trow Exp $ */

/*
 * alpha-template.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_ALPHA_TEMPLATE_H
#define _INC_ALPHA_TEMPLATE_H

#include <config.h>
#include <gnome.h>

typedef struct _AlphaTemplate AlphaTemplate;

struct _AlphaTemplate {
  gint width, height;
  guchar* data;
};

AlphaTemplate* alpha_template_new(gint w, gint h);
void alpha_template_free(AlphaTemplate*);

guchar alpha_template_get(AlphaTemplate*, gint x, gint y);
void alpha_template_set(AlphaTemplate*, gint x, gint y, guchar a);

void alpha_template_print(AlphaTemplate*,
			  gint x, gint y,
			  guchar r, guchar g, guchar b, guchar a,
			  guchar* rgbbuf, gint buf_stride,
			  gint buf_w, gint buf_h,
			  gint adj_x, gint adj_y);

AlphaTemplate* alpha_template_copy_rectangle(AlphaTemplate*,
					     gint x, gint y, gint w, gint h);
void alpha_template_auto_crop(AlphaTemplate*);

#define alpha_template_get_unsafe(atemp, x, y) \
((atemp)->data[(atemp)->width * (y) + (x)])

#define alpha_template_set_unsafe(atemp, x, y, val) \
((atemp)->data[(atemp)->width * (y) + (x)] = val)

AlphaTemplate* alpha_template_new_frame(gint w, gint h);
AlphaTemplate* alpha_template_new_circle(double r);
AlphaTemplate* alpha_template_new_ring(double r, double w);
AlphaTemplate* alpha_template_new_cross(double r, double w, double th);
AlphaTemplate* alpha_template_new_ast(double r, double w, double th);
AlphaTemplate* alpha_template_new_rectangle(double r, double w, double th);
AlphaTemplate* alpha_template_new_box(double r, double th);

#endif /* _INC_ALPHA_TEMPLATE_H */

/* $Id: alpha-template.h,v 1.4 2000/02/06 03:17:13 trow Exp $ */



