/* $Id: guppi-scm-useful.c,v 1.1 2000/01/17 05:44:56 trow Exp $ */

/*
 * guppi-scm-useful.c
 *
 * Copyright (C) 1999, 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-guile.h"
#include "guppi-splash.h"
#include "guppi-exit.h"
#include "guppi-scm-useful.h"

GUPPI_PROC(splashmsg, "splash-message",
	   1,0,0, (SCM scm_msg))
{
  gchar* msg;
  gint len;

  SCM_ASSERT(gh_string_p(scm_msg), scm_msg, SCM_ARG1, str_splashmsg);

  msg = gh_scm2newstr(scm_msg, &len);
  guppi_splash_message(msg);

  return SCM_UNSPECIFIED;
}

static gboolean
scm_approval_thunk(gpointer user_data)
{
  SCM thunk = (SCM)user_data;
  SCM rv;

  g_return_val_if_fail(gh_procedure_p(thunk), TRUE);
  rv = guppi_safe_apply_thunk(thunk);

  /* Any return value other than a #f is considered approval. */
  return !(gh_boolean_p(rv) && gh_scm2bool(rv) == FALSE);
}

static void
scm_shutdown_thunk(gpointer user_data)
{
  SCM thunk = (SCM)user_data;
  g_return_if_fail(gh_procedure_p(thunk));
  guppi_safe_apply_thunk((SCM)thunk);
}

GUPPI_PROC(con_approv_thunk, "connect-approval-thunk",
	   1,0,0, (SCM thunk))
{
  SCM_ASSERT(gh_procedure_p(thunk), thunk, SCM_ARG1, str_con_approv_thunk);
  guppi_exit_connect_approval_func(scm_approval_thunk, (gpointer)thunk);
  return SCM_UNSPECIFIED;
}

GUPPI_PROC(con_shutdown_thunk, "connect-shutdown-thunk",
	   1,0,0, (SCM thunk))
{
  SCM_ASSERT(gh_procedure_p(thunk), thunk, SCM_ARG1, str_con_shutdown_thunk);
  guppi_exit_connect_shutdown_func(scm_shutdown_thunk, (gpointer)thunk);
  return SCM_UNSPECIFIED;
}

GUPPI_PROC(gupexit, "guppi-exit",
	   0,0,0, ())
{
  guppi_exit();
  return SCM_UNSPECIFIED;
}

GUPPI_PROC(gupabort, "guppi-abort",
	   0,0,0, ())
{
  guppi_abort();
  return SCM_UNSPECIFIED;
}

GUPPI_PROC(gupmsg, "guppi-message",
	   1,0,0, (SCM s))
{
  gchar* str;

  SCM_ASSERT(gh_string_p(s), s, SCM_ARG1, str_gupmsg);
  str = gh_scm2newstr(s, NULL);
  g_message(str);
  g_free(str);
  return SCM_UNSPECIFIED;
}

GUPPI_PROC(gupwarn, "guppi-warning",
	   1,0,0, (SCM s))
{
  gchar* str;

  SCM_ASSERT(gh_string_p(s), s, SCM_ARG1, str_gupwarn);
  str = gh_scm2newstr(s, NULL);
  g_warning(str);
  g_free(str);
  return SCM_UNSPECIFIED;
}

void
guppi_scm_useful_init(void)
{
  static gboolean init = FALSE;
  g_return_if_fail(init == FALSE);
  init = TRUE;

#include "guppi-scm-useful.x"
}



/* $Id: guppi-scm-useful.c,v 1.1 2000/01/17 05:44:56 trow Exp $ */
