/* $Id: guppi-scm-data-catalog.c,v 1.1 2000/01/17 06:44:17 trow Exp $ */

/*
 * guppi-scm-data-catalog.c
 *
 * Copyright (C) 1999, 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <guppi-guile.h>
#include "guppi-scm-data.h"
#include "guppi-data-catalog.h"
#include "guppi-scm-data-catalog.h"

/* Right now you can only access the global catalog, not a locally-constructed
   one. */

GUPPI_PROC(dc_add, "data-catalog-add!",
	   1,0,0, (SCM scm_data))
{
  SCM_ASSERT(scm_data_p(scm_data), scm_data, SCM_ARG1, str_dc_add);

  guppi_data_catalog_add(NULL, scm2data(scm_data));
  return SCM_UNSPECIFIED;
}

GUPPI_PROC(dc_remove, "data-catalog-remove!",
	   1,0,0, (SCM scm_data))
{
  SCM_ASSERT(scm_data_p(scm_data), scm_data, SCM_ARG1, str_dc_remove);

  guppi_data_catalog_remove(NULL, scm2data(scm_data));
  return SCM_UNSPECIFIED;
}

GUPPI_PROC(dc_size, "data-catalog-size",
	   0,0,0, ())
{
  return gh_int2scm(guppi_data_catalog_size(NULL));
}

GUPPI_PROC(dc_get, "data-catalog-get",
	   1,0,0, (SCM scm_i))
{
  gint i;
  GuppiData* d;
  SCM scmd;

  SCM_ASSERT(gh_exact_p(scm_i), scm_i, SCM_ARG1, str_dc_get);

  i = gh_scm2int(scm_i);
  if (i<0 || i>=guppi_data_catalog_size(NULL))
    return SCM_BOOL_F;

  d = guppi_data_catalog_get(NULL, i);
  if (d != NULL) {
    scmd = data2scm(d);
    gtk_object_unref(GTK_OBJECT(d));
    return scmd;
  }

  return SCM_BOOL_F;
}

void
guppi_scm_data_catalog_init(void)
{
  static gboolean initialized = FALSE;
  g_return_if_fail(!initialized);
  initialized = TRUE;

#include "guppi-scm-data-catalog.x"
}


/* $Id: guppi-scm-data-catalog.c,v 1.1 2000/01/17 06:44:17 trow Exp $ */
