/* This is -*- C++ -*- */
/* $Id: guppi-data-browser.h,v 1.1.1.1 1999/12/03 07:02:40 trow Exp $ */

/*
 * guppi-data-browser.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_DATA_BROWSER_H
#define _INC_GUPPI_DATA_BROWSER_H

#include <gtk/gtk.h>
#include "guppi-data.h"

typedef struct _GuppiDataBrowser GuppiDataBrowser;
typedef struct _GuppiDataBrowserClass GuppiDataBrowserClass;

struct _GuppiDataBrowser {
  GtkCList base;

  GuppiData** data;
  gsize data_count;
  
  dindex_t i0, i1;
};

struct _GuppiDataBrowserClass {
  GtkCListClass parent_class;
};

#define GUPPI_TYPE_DATA_BROWSER (guppi_data_browser_get_type())
#define GUPPI_DATA_BROWSER(obj) (GTK_CHECK_CAST((obj), \
                                 GUPPI_TYPE_DATA_BROWSER, \
				 GuppiDataBrowser))
#define GUPPI_DATA_BROWSER_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), \
                                         GUPPI_TYPE_DATA_BROWSER, \
                                         GuppiDataBrowserClass))
#define GUPPI_IS_DATA_BROWSER(obj) (GTK_CHECK_TYPE((obj), \
				    GUPPI_TYPE_DATA_BROWSER))
#define GUPPI_IS_DATA_BROWSER_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), \
                                            GUPPI_TYPE_DATA_BROWSER))

GtkType guppi_data_browser_get_type(void);

GtkWidget* guppi_data_browser_new(GuppiData**);





#endif /* _INC_GUPPI_DATA_BROWSER_H */

/* $Id: guppi-data-browser.h,v 1.1.1.1 1999/12/03 07:02:40 trow Exp $ */
