/* This is -*- C -*- */
/* $Id: guppi-categorical-data.h,v 1.2 1999/12/07 17:06:11 trow Exp $ */

/*
 * guppi-categorical-data.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_CATEGORICAL_DATA_H
#define _INC_GUPPI_CATEGORICAL_DATA_H

#include <config.h>
#include <gnome.h>
#include "guppi-data.h"
#include "guppi-string-data.h"

#define GUPPI_CATEGORICAL_DATA_BAD_CODE ((guint)-1)

typedef struct _GuppiCategoricalData GuppiCategoricalData;
typedef struct _GuppiCategoricalDataClass GuppiCategoricalDataClass;

struct _GuppiCategoricalData {
  GuppiData base;

  gboolean frozen;

  GuppiStringData* category;
  guint catsize;

  gpointer data;
  gsize intsize, size, poolsize;
};

struct _GuppiCategoricalDataClass {
  GuppiDataClass parent_class;
};

#define GUPPI_TYPE_CATEGORICAL_DATA (guppi_categorical_data_get_type())
#define GUPPI_CATEGORICAL_DATA(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_CATEGORICAL_DATA,GuppiCategoricalData))
#define GUPPI_CATEGORICAL_DATA_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_CATEGORICAL_DATA,GuppiCategoricalDataClass))
#define GUPPI_IS_CATEGORICAL_DATA(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_CATEGORICAL_DATA))
#define GUPPI_IS_CATEGORICAL_DATA_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_CATEGORICAL_DATA))

GtkType guppi_categorical_data_get_type(void);

GuppiData* guppi_categorical_data_new(void);

gboolean guppi_categorical_data_frozen(const GuppiCategoricalData*);
void guppi_categorical_data_set_freeze(GuppiCategoricalData*, gboolean);

#define guppi_categorical_data_freeze(cd) guppi_categorical_data_set_freeze(cd, TRUE)
#define guppi_categorical_data_unfreeze(cd) guppi_categorical_data_set_freeze(cd, FALSE)

guint guppi_categorical_data_encode(const GuppiCategoricalData*, const gchar*);
const gchar* guppi_categorical_data_decode(const GuppiCategoricalData*, guint);

gboolean guppi_categorical_data_validate_code(const GuppiCategoricalData*,
					      guint);

const gchar* guppi_categorical_data_get(const GuppiCategoricalData*, dindex_t);
guint guppi_categorical_data_get_code(const GuppiCategoricalData*, dindex_t);
void guppi_categorical_data_set(GuppiCategoricalData*, dindex_t i,
				const gchar*);
void guppi_categorical_data_set_code(GuppiCategoricalData*, dindex_t i,
				     guint);
void guppi_categorical_data_add(GuppiCategoricalData*, const gchar*);
void guppi_categorical_data_add_code(GuppiCategoricalData*, guint);
void guppi_categorical_data_insert(GuppiCategoricalData*, dindex_t i,
				   const gchar*);
void guppi_categorical_data_insert_code(GuppiCategoricalData*,
					dindex_t i, guint);
void guppi_categorical_data_delete(GuppiCategoricalData*, dindex_t i);

/* A disgusting macro hack explosion! */
#define guppi_categorical_data_get_code_unsafe(cd, i) \
(cd)->intsize == 1 ? \
(guint)((guint8*)(cd)->data)[(i)-guppi_data_min_index(GUPPI_DATA(cd))] : \
( (cd)->intsize == 2 ? \
(guint)((guint16*)(cd)->data)[(i)-guppi_data_min_index(GUPPI_DATA(cd))] : \
  (guint)((guint32*)(cd)->data)[(i)-guppi_data_min_index(GUPPI_DATA(cd))])


#endif /* _INC_GUPPI_CATEGORICAL_DATA_H */

/* $Id: guppi-categorical-data.h,v 1.2 1999/12/07 17:06:11 trow Exp $ */
