/* This is -*- C++ -*- */
/* $Id: guppi-boolean-data.h,v 1.1.1.1 1999/12/03 07:02:40 trow Exp $ */

/*
 * guppi-boolean-data.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_BOOLEAN_DATA_H
#define _INC_GUPPI_BOOLEAN_DATA_H

#include <config.h>
#include <gnome.h>
#include "guppi-data.h"

typedef struct _GuppiBooleanData GuppiBooleanData;
typedef struct _GuppiBooleanDataClass GuppiBooleanDataClass;

struct _GuppiBooleanData {
  GuppiData base;

  guint32* data;
  gsize asize, capacity;
};

struct _GuppiBooleanDataClass {
  GuppiDataClass parent_class;
};

#define GUPPI_TYPE_BOOLEAN_DATA (guppi_boolean_data_get_type())
#define GUPPI_BOOLEAN_DATA(obj) (GTK_CHECK_CAST((obj), \
                                 GUPPI_TYPE_BOOLEAN_DATA, \
				 GuppiBooleanData))
#define GUPPI_BOOLEAN_DATA_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), \
                                         GUPPI_TYPE_BOOLEAN_DATA, \
                                         GuppiBooleanDataClass))
#define GUPPI_IS_BOOLEAN_DATA(obj) (GTK_CHECK_TYPE((obj), \
				    GUPPI_TYPE_BOOLEAN_DATA))
#define GUPPI_IS_BOOLEAN_DATA_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), \
                                            GUPPI_TYPE_BOOLEAN_DATA))

GtkType guppi_boolean_data_get_type(void);

GuppiData* guppi_boolean_data_new(void);
GuppiData* guppi_boolean_data_new_by_bounds(dindex_t min, dindex_t max);
GuppiData* guppi_boolean_data_new_aligned(const GuppiData*);

void guppi_boolean_data_clear(GuppiBooleanData*);

gboolean guppi_boolean_data_get(const GuppiBooleanData*, dindex_t);
void guppi_boolean_data_set(GuppiBooleanData*, dindex_t, gboolean);
void guppi_boolean_data_add(GuppiBooleanData*, gboolean);
void guppi_boolean_data_insert(GuppiBooleanData*, dindex_t, gboolean);
void guppi_boolean_data_delete(GuppiBooleanData*, dindex_t);

void guppi_boolean_data_logical_and(GuppiBooleanData*, const GuppiBooleanData*);
void guppi_boolean_data_logical_or(GuppiBooleanData*, const GuppiBooleanData*);
void guppi_boolean_data_logical_xor(GuppiBooleanData*, const GuppiBooleanData*);
void guppi_boolean_data_logical_not(GuppiBooleanData*);

void guppi_boolean_data_replace(GuppiBooleanData* dest, const GuppiBooleanData* src);

dindex_t guppi_boolean_data_first_true(const GuppiBooleanData*);
dindex_t guppi_boolean_data_next_true(const GuppiBooleanData*, dindex_t);

guint guppi_boolean_data_true_count(const GuppiBooleanData*);

#define _GBD_RAW_DATA(bd, i) ((GuppiBooleanData*)bd)->data[(i)]
#define _GBD_RAW_INDEX(bd, i) ((i)-((GuppiData*)(bd))->min_index)
#define guppi_boolean_data_get_unsafe(bd, i) \
((gboolean)(((GuppiBooleanData*)(bd))->data[_GBD_RAW_INDEX(bd,i)>>5] & \
(1 << (_GBD_RAW_INDEX(bd,i)&31))))
#define guppi_boolean_data_set_true_unsafe(bd, i) \
{_GBD_RAW_DATA(bd,_GBD_RAW_INDEX(bd,i)>>5) |= (1<<(_GBD_RAW_INDEX(bd,i)&31));}
#define guppi_boolean_data_set_false_unsafe(bd, i) \
{_GBD_RAW_DATA(bd,_GBD_RAW_INDEX(bd,i)>>5) &= ~(1<<(_GBD_RAW_INDEX(bd,i)&31));}

#endif /* _INC_GUPPI_BOOLEAN_DATA_H */

/* $Id: guppi-boolean-data.h,v 1.1.1.1 1999/12/03 07:02:40 trow Exp $ */
