/* $Id: guppi-paths.c,v 1.2 2000/01/17 21:38:34 trow Exp $ */

/*
 * guppi-paths.c
 *
 * Copyright (C) 1999, 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-paths.h"

const gchar*
guppi_logo_graphic_path(void)
{
  static gchar* path = NULL;

#ifdef GUPPI_PIXMAPS
  if (path == NULL) {
    path = g_strdup_printf("%s/guppi-splash.png", GUPPI_PIXMAPS);
    if (!g_file_exists(path)) {
      g_free(path);
      path = NULL;
    }
  }
#endif

  /* This will work iff you are running an uninstalled guppi out of
     the src/guppi directory. */
  if (path == NULL) {
    path = "../../pixmaps/guppi-splash.png";
    if (!g_file_exists(path))
      path = NULL;
  }

  if (path == NULL)
    g_warning("Couldn't find guppi-splash.png");

  return path;
}

gchar*
guppi_glade_path(const gchar* filename)
{
  gchar* resolved = NULL;

  if (g_file_exists(filename))
    return g_strdup(filename);

  resolved = g_strdup_printf("%s/%s", GUPPI_GLADE_PATH, filename);
  if (g_file_exists(resolved)) 
    return resolved;

  /* This is bad... */
  g_free(resolved);
  resolved = g_strdup_printf("../../plug-ins/scatter/%s", filename);
  if (g_file_exists(resolved))
    return resolved;
  
  g_free(resolved);
  g_warning("Couldn't find \"%s\"", filename);
  return NULL;
}

const gchar*
gnome_guile_repl_path(void)
{
  static gchar* path = NULL;

  if (path == NULL) {
    path = gnome_is_program_in_path("gnome-guile-repl");
  }

  /* Maybe we built guppi with some funny prefix and $(prefix)/bin isn't
     in our path. */
  if (path == NULL) {
    path = g_strdup_printf("%s/gnome-guile-repl", GUPPI_PREFIX);
    if (!g_file_exists(path)) {
      g_free(path);
      path = NULL;
    }
  }

  /* Try the hard-wired path, in case we haven't installed yet and
     are running out of src/guppi. */
  if (path == NULL) {
    path = "../guile-server/gnome-guile-repl";
    if (!g_file_exists(path))
      path = NULL;
  }
  
  if (path == NULL) 
    gtk_widget_show_all(gnome_error_dialog(_("\"gnome-guile-repl\" is not in your $PATH.\nWithout it, you cannot access the guile terminal.")));
  
  return path;
}




/* $Id: guppi-paths.c,v 1.2 2000/01/17 21:38:34 trow Exp $ */
