/* This is -*- C -*- */
/* $Id: guppi-stream-preview.h,v 1.2 1999/12/06 05:16:14 trow Exp $ */

/*
 * guppi-stream-preview.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_STREAM_PREVIEW_H
#define _INC_GUPPI_STREAM_PREVIEW_H

#include <config.h>
#include <gnome.h>

#include <guppi-stream.h>

typedef struct _GuppiStreamPreview GuppiStreamPreview;
typedef struct _GuppiStreamPreviewClass GuppiStreamPreviewClass;

struct _GuppiStreamPreview {
  GtkFrame parent;

  GuppiStream* stream;
  GtkLabel* info_label;
  GtkText* text;
  GtkAdjustment* vadj;
  GtkButton* preload_button;
  GtkEntry* eol_combo_entry;
  GtkEntry* begin_ml_combo_entry;
  GtkEntry* end_ml_combo_entry;

  gboolean (*line_skip)(GuppiStreamPreview*, const gchar* line, gint line_no,
			gpointer user_data);
  gpointer line_skip_user_data;

  GdkColor* (*extra_info)(GuppiStreamPreview*, const gchar* line, gint line_no,
			  gchar* sbuf, gint sbuf_len, gpointer user_data);
  gpointer extra_info_user_data;

  GdkColor* (*line_color)(GuppiStreamPreview*, const gchar* line, gint line_no,
			  gpointer user_data);
  gpointer line_color_user_data;
};

struct _GuppiStreamPreviewClass {
  GtkFrameClass parent_class;
};

#define GUPPI_TYPE_STREAM_PREVIEW (guppi_stream_preview_get_type())
#define GUPPI_STREAM_PREVIEW(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_STREAM_PREVIEW,GuppiStreamPreview))
#define GUPPI_STREAM_PREVIEW_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_STREAM_PREVIEW,GuppiStreamPreviewClass))
#define GUPPI_IS_STREAM_PREVIEW(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_STREAM_PREVIEW))
#define GUPPI_IS_STREAM_PREVIEW_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_STREAM_PREVIEW))

GtkType guppi_stream_preview_get_type(void);

GtkWidget* guppi_stream_preview_new(GuppiStream*);

void guppi_stream_preview_refresh(GuppiStreamPreview*);

void guppi_stream_preview_set_line_skip_cb(GuppiStreamPreview*,
					   gboolean (*)(GuppiStreamPreview*,
							const gchar*,
							gint,
							gpointer),
					   gpointer);
void guppi_stream_preview_set_extra_info_cb(GuppiStreamPreview*,
					    GdkColor* (*)(GuppiStreamPreview*,
							  const gchar*,
							  gint,
							  gchar*,
							  gint,
							  gpointer),
					    gpointer);
void guppi_stream_preview_set_line_color_cb(GuppiStreamPreview*,
					    GdkColor* (*)(GuppiStreamPreview*,
							  const gchar*,
							  gint,
							  gpointer),
					    gpointer);




#endif /* _INC_GUPPI_STREAM_PREVIEW_H */

/* $Id: guppi-stream-preview.h,v 1.2 1999/12/06 05:16:14 trow Exp $ */
