/* This is -*- C++ -*- */
/* $Id: guppi-plot-plug-in.h,v 1.1 2000/01/15 05:18:54 trow Exp $ */

/*
 * guppi-plot-plug-in.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_PLOT_PLUG_IN_H
#define _INC_GUPPI_PLOT_PLUG_IN_H

#include <config.h>
#include <gnome.h>

#include "guppi-plot-element.h"

typedef struct _GuppiPlotPlugInInfo GuppiPlotPlugInInfo;

#define GUPPI_PLOT_PLUG_IN_MAGIC_NUMBER 0xbee00001

struct _GuppiPlotPlugInInfo {
  guint32 magic_number;

  const gchar* external_name;
  const gchar* internal_name;

  gint major_version;
  gint minor_version;
  gint micro_version;
  const gchar* copyright;
  const gchar* authors;

  GuppiPlotElement* (*element_constructor)(void);

  const gchar* load_path;
  gpointer reserved;
};

GuppiPlotElement* guppi_plot_element_new(const gchar* name);

void guppi_load_plot_plug_in(const gchar* path);
void guppi_load_plot_plug_in_dir(const gchar* path, gboolean recursive);
void guppi_load_all_plug_ins(void);

GtkWidget* guppi_plot_plug_in_credits_new(void);


#endif /* _INC_GUPPI_PLOT_PLUG_IN_H */

/* $Id: guppi-plot-plug-in.h,v 1.1 2000/01/15 05:18:54 trow Exp $ */
