/* This is -*- C -*- */
/* $Id: guppi-importer.h,v 1.3 2000/01/17 05:44:54 trow Exp $ */

/*
 * guppi-importer.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_IMPORTER_H
#define _INC_GUPPI_IMPORTER_H

#include <config.h>
#include <gnome.h>

#include <guppi-stream.h>
#include "guppi-data.h"
#include "guppi-dataset.h"

typedef struct _GuppiImporter GuppiImporter;
typedef struct _GuppiImporterClass GuppiImporterClass;

struct _GuppiImporter {
  GtkObject parent;

  GuppiStream* stream;
};

struct _GuppiImporterClass {
  GtkObjectClass parent_class;

  /* Default signal handlers */
  void (*changed)(GuppiImporter*);

  /* Virtual functions */
  void (*intuit)(GuppiImporter*);

  void (*import_initialize)(GuppiImporter*);
  gchar* (*preprocess_line)(GuppiImporter*, gchar* line, gint line_no);
  gboolean (*line_skip)(GuppiImporter*, const gchar* line, gint line_no);
  void (*process_line)(GuppiImporter*, const gchar* line, gint line_no);
  GuppiData** (*get_data)(GuppiImporter*);
  GuppiData** (*postprocess)(GuppiImporter*, GuppiData**);
  GuppiDataset* (*import_dataset)(GuppiImporter*);
  void (*import_finalize)(GuppiImporter*);
};

#define GUPPI_TYPE_IMPORTER (guppi_importer_get_type())
#define GUPPI_IMPORTER(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_IMPORTER,GuppiImporter))
#define GUPPI_IMPORTER_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_IMPORTER,GuppiImporterClass))
#define GUPPI_IS_IMPORTER(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_IMPORTER))
#define GUPPI_IS_IMPORTER_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_IMPORTER))

GtkType guppi_importer_get_type(void);

GtkObject* guppi_importer_new(void);

void guppi_importer_set_stream(GuppiImporter*, GuppiStream*);
GuppiStream* guppi_importer_stream(GuppiImporter*);

/*
  Peeking at the top of the stream, make a reasonable guess about
  how this data should be imported.
  The intuit function should not be required to be called before importing,
  and it should be possible to call intuit multiple times without ill
  effect.
*/
void guppi_importer_intuit(GuppiImporter*);

void guppi_importer_import(GuppiImporter*);
GuppiData** guppi_importer_data(GuppiImporter*);

#endif /* _INC_GUPPI_IMPORTER_H */

/* $Id: guppi-importer.h,v 1.3 2000/01/17 05:44:54 trow Exp $ */
