/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

#ifndef __GPA_LIST_H__
#define __GPA_LIST_H__

/*
 *  gpa-list.h: 
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Authors :
 *    Jose M. Celorio <chema@ximian.com>
 *    Lauris Kaplinski <lauris@ximian.com>
 *
 *  Copyright (C) 2000-2001 Ximian, Inc. and Jose M. Celorio
 *
 */

#include <glib.h>

G_BEGIN_DECLS

#define GPA_TYPE_LIST         (gpa_list_get_type ())
#define GPA_LIST(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GPA_TYPE_LIST, GPAList))
#define GPA_LIST_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST ((k),    GPA_TYPE_LIST, GPAListClass))
#define GPA_IS_LIST(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GPA_TYPE_LIST))
#define GPA_IS_LIST_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k),    GPA_TYPE_LIST))
#define GPA_LIST_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o),  GPA_TYPE_LIST, GPAListClass))

#include "gpa-node-private.h"

#define GPA_LIST_DEFAULT_ITEM_KEY "DefaultChild"

typedef struct _GPAList      GPAList;
typedef struct _GPAListClass GPAListClass;

struct _GPAList {
	GPANode node;
	GType childtype;              /* The node type of the list children */
	GPANode *children;            /* A pointer to the first children of the list */
	guint can_have_default : 1;   /* A flag that determines if this list can have a default value */
	GPANode *def;                 /* A GPAReference to the default value */
};

struct _GPAListClass {
	GPANodeClass node_class;
};

GType     gpa_list_get_type (void);

GPAList * gpa_list_new (GType childtype, const gchar *list_name, gboolean can_have_default);
gboolean  gpa_list_set_default (GPAList *list, GPANode *def);
gboolean  gpa_list_prepend (GPAList *list, GPANode *child);


G_END_DECLS

#endif /* __GPA_LIST_H__ */
