# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work envronment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=gdk-pixbuf
VER=2.22.0
REV=1
ARCH=win64

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev
usemingw64
usemsvs9x64

(

set -x

DEPS=`latest --arch=${ARCH} gettext-runtime zlib glib pkg-config libpng`
GETTEXT_RUNTIME=`latest --arch=${ARCH} gettext-runtime`

PKG_CONFIG_PATH=/dummy
for D in $DEPS; do
    [ -d /devel/dist/${ARCH}/$D/lib/pkgconfig ] && PKG_CONFIG_PATH=/devel/dist/${ARCH}/$D/lib/pkgconfig:$PKG_CONFIG_PATH
    PATH=/devel/dist/${ARCH}/$D/bin:$PATH
done

LIBPNG=`latest --arch=${ARCH} libpng`
ZLIB=`latest --arch=${ARCH} zlib`

# Brute force solution for problems with libtool
lt_cv_deplibs_check_method='pass_all' \
CC='x86_64-w64-mingw32-gcc' \
CXX='x86_64-w64-mingw32-g++' \
CPPFLAGS="-I/devel/dist/${ARCH}/${LIBPNG}/include \
-I/devel/dist/${ARCH}/${ZLIB}/include \
-I/devel/dist/${ARCH}/${GETTEXT_RUNTIME}/include" \
LDFLAGS="-L/devel/dist/${ARCH}/${LIBPNG}/lib \
-L/devel/dist/${ARCH}/${ZLIB}/lib \
-L/devel/dist/${ARCH}/${GETTEXT_RUNTIME}/lib \
-Wl,--enable-auto-image-base" \
LIBS=-lintl \
LIBPNG=`pkg-config --libs libpng` \
CFLAGS=-O2 \
./configure --host=x86_64-w64-mingw32 --build=i686-pc-mingw32 \
--enable-gdiplus \
--with-included-loaders \
--without-libjasper \
--enable-debug=yes \
--enable-explicit-deps=no \
--disable-gtk-doc \
--disable-static \
--prefix=$TARGET &&

PATH="$PWD/gdk-pixbuf/.libs:/devel/target/$HEX/bin:$PATH" make -j3 install &&

PATH="/devel/target/$HEX/bin:$PATH" gdk-pixbuf-query-loaders >$TARGET/lib/gdk-pixbuf-2.0/2.10.0/loaders/loaders.cache &&

(echo '# Note: After adding a new separate gdk-pixbuf loader (for instance the svg one)' &&
    echo '# run gdk-pixbuf-query-loaders.exe redirecting its output into this file.' &&
    echo &&
    echo '# Note that the LoaderDir folder below does not name a folder that is' &&
    echo '# expected to exist. It was just a temporary directory used at build time.' &&
    echo &&
    cat $TARGET/lib/gdk-pixbuf-2.0/2.10.0/loaders/loaders.cache ) >$TARGET/lib/gdk-pixbuf-2.0/2.10.0/loaders/loaders.cache.temp &&
    mv $TARGET/lib/gdk-pixbuf-2.0/2.10.0/loaders/loaders.cache.temp $TARGET/lib/gdk-pixbuf-2.0/2.10.0/loaders/loaders.cache &&

rm /tmp/$RUNZIP /tmp/$DEVZIP &&

(cd $TARGET &&
zip /tmp/$RUNZIP bin/libgdk_pixbuf-2.0-0.dll &&
zip /tmp/$RUNZIP bin/gdk-pixbuf-query-loaders.exe &&
zip /tmp/$RUNZIP lib/gdk-pixbuf-2.0/2.10.0/loaders/*.dll lib/gdk-pixbuf-2.0/2.10.0/loaders/loaders.cache &&
zip -r -D /tmp/$RUNZIP share/locale &&

zip -r -D /tmp/$DEVZIP include/gdk-pixbuf-2.0 &&
zip -r -D /tmp/$DEVZIP lib/libgdk_pixbuf-2.0.dll.a lib/gdk_pixbuf-2.0.lib &&
zip -r -D /tmp/$DEVZIP lib/pkgconfig &&
zip /tmp/$DEVZIP bin/gdk-pixbuf-csource.exe &&
zip -r -D /tmp/$DEVZIP share/man share/gtk-doc &&
:) &&

:) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
