# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work envronment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=gtk+
VER=2.18.6
REV=1
ARCH=win64

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev
usemingw64
usemsvs9x64

(

set -x

DEPS=`latest --arch=${ARCH} glib pkg-config atk zlib libpng cairo freetype expat fontconfig pango`
PROXY_LIBINTL=`latest --arch=${ARCH} proxy-libintl`

PKG_CONFIG_PATH=/dummy
for D in $DEPS; do
    [ -d /devel/dist/${ARCH}/$D/lib/pkgconfig ] && PKG_CONFIG_PATH=/devel/dist/${ARCH}/$D/lib/pkgconfig:$PKG_CONFIG_PATH
done

RUNDEPS=`latest --arch=win32 glib atk freetype expat fontconfig zlib libpng cairo pango gtk+`
for D in $RUNDEPS; do
    PATH=/devel/dist/win32/$D/bin:$PATH
done

LIBPNG=`latest --arch=${ARCH} libpng`
ZLIB=`latest --arch=${ARCH} zlib`

patch -p0 <<'EOF'
--- gtk/gtkprintoperation-win32.c
+++ gtk/gtkprintoperation-win32.c
@@ -72,7 +72,7 @@
 
 static const GUID myIID_IPrintDialogCallback  = {0x5852a2c3,0x6530,0x11d1,{0xb6,0xa3,0x0,0x0,0xf8,0x75,0x7b,0xf9}};
 
-#if !defined (_MSC_VER) && !defined (MINGW64) && !defined (__MINGW64)
+#if 0
 #undef INTERFACE
 #define INTERFACE IPrintDialogCallback
 DECLARE_INTERFACE_ (IPrintDialogCallback, IUnknown)
EOF

patch -p0 <<'EOF'
--- configure
+++ configure
@@ -1069,6 +1069,7 @@
 CFLAGS
 CC
 LIB_EXE_MACHINE_FLAG
+EXE_MANIFEST_ARCHITECTURE
 host_os
 host_vendor
 host_cpu
@@ -3094,6 +3094,7 @@
 { $as_echo "$as_me:$LINENO: checking for native Win32" >&5
 $as_echo_n "checking for native Win32... " >&6; }
 LIB_EXE_MACHINE_FLAG=X86
+EXE_MANIFEST_ARCHITECTURE=X86
 case "$host" in
   *-*-mingw*)
     os_win32=yes
@@ -3102,6 +3102,7 @@
     case "$host" in
     x86_64-*-*)
       LIB_EXE_MACHINE_FLAG=X64
+      EXE_MANIFEST_ARCHITECTURE=AMD64
       ;;
     esac
     ;;
--- gtk/Makefile.in
+++ gtk/Makefile.in
@@ -783,6 +783,7 @@
 LIBTOOL = @LIBTOOL@
 LIBTOOL_EXPORT_OPTIONS = @LIBTOOL_EXPORT_OPTIONS@
 LIB_EXE_MACHINE_FLAG = @LIB_EXE_MACHINE_FLAG@
+EXE_MANIFEST_ARCHITECTURE = @EXE_MANIFEST_ARCHITECTURE@
 LIPO = @LIPO@
 LN_S = @LN_S@
 LTLIBOBJS = @LTLIBOBJS@
@@ -2707,7 +2707,7 @@
 @OS_WIN32_TRUE@	(echo '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' ; \
 @OS_WIN32_TRUE@	 echo '<assembly xmlns="urn:schemas-microsoft-com:asm.v1" manifestVersion="1.0">' ; \
 @OS_WIN32_TRUE@	 echo '  <assemblyIdentity version="1.0.0.0"' ; \
-@OS_WIN32_TRUE@	 echo '     processorArchitecture="'$(LIB_EXE_MACHINE_FLAG)'"' ; \
+@OS_WIN32_TRUE@	 echo '     processorArchitecture="'$(EXE_MANIFEST_ARCHITECTURE)'"' ; \
 @OS_WIN32_TRUE@	 echo '     name="gtk-update-icon-cache.exe"' ; \
 @OS_WIN32_TRUE@	 echo '     type="win32"/>' ; \
 @OS_WIN32_TRUE@	 echo '  <!-- Identify the application security requirements. -->' ; \
EOF

# Brute force solution for problems with libtool
lt_cv_deplibs_check_method='pass_all' \
CC='x86_64-w64-mingw32-gcc' \
CXX='x86_64-w64-mingw32-g++' \
CPPFLAGS="-I/devel/dist/${ARCH}/${LIBPNG}/include \
-I/devel/dist/${ARCH}/${ZLIB}/include \
-I/devel/dist/${ARCH}/${PROXY_LIBINTL}/include" \
LDFLAGS="-L/devel/dist/${ARCH}/${LIBPNG}/lib \
-L/devel/dist/${ARCH}/${ZLIB}/lib \
-L/devel/dist/${ARCH}/${PROXY_LIBINTL}/lib -Wl,--exclude-libs=libintl.a \
-Wl,--enable-auto-image-base" \
LIBS=-lintl \
LIBPNG=`pkg-config --libs libpng` \
CFLAGS=-O2 \
./configure --host=x86_64-w64-mingw32 --build=i686-pc-mingw32 \
--with-gdktarget=win32 \
--enable-gdiplus \
--with-included-loaders \
--with-included-immodules \
--without-libjasper \
--enable-debug=yes \
--enable-explicit-deps=no \
--disable-gtk-doc \
--disable-static \
--prefix=$TARGET &&

rm gtk/gtk.def &&

PATH="$PWD/gdk-pixbuf/.libs:/devel/target/$HEX/bin:$PATH" make -j3 install &&

gdk-pixbuf-query-loaders >/devel/target/$HEX/etc/gtk-2.0/gdk-pixbuf.loaders &&

(echo '# Note: After adding a new separate gdk-pixbuf loader (for instance the svg one)' &&
    echo '# run gdk-pixbuf-query-loaders.exe redirecting its output into this file.' &&
    echo &&
    echo '# Note that the LoaderDir folder below does not name a folder that is' &&
    echo '# expected to exist. It was just a temporary directory used at build time.' &&
    echo &&
    cat $TARGET/etc/gtk-2.0/gdk-pixbuf.loaders ) >$TARGET/etc/gtk-2.0/gdk-pixbuf.loaders.temp &&
    mv $TARGET/etc/gtk-2.0/gdk-pixbuf.loaders.temp $TARGET/etc/gtk-2.0/gdk-pixbuf.loaders &&

./gtk-zip.sh &&

# Package also the gtk-update-icon-cache.exe.manifest
(cd $TARGET && zip /tmp/${MOD}-dev-${VER}.zip bin/gtk-update-icon-cache.exe.manifest) &&

mv /tmp/${MOD}-${VER}.zip /tmp/$RUNZIP &&
mv /tmp/${MOD}-dev-${VER}.zip /tmp/$DEVZIP

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
