# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=fontconfig
VER=2.7.1
REV=1
ARCH=win64

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

# We use a string of hex digits to make it more evident that it is
# just a hash value and not supposed to be relevant at end-user
# machines.
HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usestable
usemingw64
usemsvs9x64

(

set -x

EXPAT=`latest --arch=${ARCH} expat`
FREETYPE=`latest --arch=${ARCH} freetype`

# Don't let libtool do its relinking dance. Don't know how relevant
# this is, but it doesn't hurt anyway.

sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

patch -p0 <<\EOF &&
--- src/Makefile.in
+++ src/Makefile.in
@@ -620,6 +620,7 @@
 # gcc import library install/uninstall
 
 @OS_WIN32_TRUE@install-libtool-import-lib: 
+@OS_WIN32_TRUE@	$(mkdir_p) $(DESTDIR)$(libdir)
 @OS_WIN32_TRUE@	$(INSTALL) .libs/libfontconfig.dll.a $(DESTDIR)$(libdir)
 @OS_WIN32_TRUE@	$(INSTALL) fontconfig.def $(DESTDIR)$(libdir)/fontconfig.def
 
@@ -630,9 +630,10 @@
 @OS_WIN32_FALSE@uninstall-libtool-import-lib:
 
 @MS_LIB_AVAILABLE_TRUE@fontconfig.lib : libfontconfig.la
-@MS_LIB_AVAILABLE_TRUE@	lib -name:libfontconfig-$(lt_current_minus_age).dll -def:fontconfig.def -out:$@
+@MS_LIB_AVAILABLE_TRUE@	lib -machine:X64 -name:libfontconfig-$(LIBT_CURRENT_MINUS_AGE).dll -def:fontconfig.def -out:$@
 
 @MS_LIB_AVAILABLE_TRUE@install-ms-import-lib:
+@MS_LIB_AVAILABLE_TRUE@	$(mkdir_p) $(DESTDIR)$(libdir)
 @MS_LIB_AVAILABLE_TRUE@	$(INSTALL) fontconfig.lib $(DESTDIR)$(libdir)
 
 @MS_LIB_AVAILABLE_TRUE@uninstall-ms-import-lib:
--- src/fcxml.c
+++ src/fcxml.c
@@ -53,6 +53,7 @@
 #endif /* ENABLE_LIBXML2 */
 
 #ifdef _WIN32
+#define _WIN32_WINNT 0x0500
 #define STRICT
 #include <windows.h>
 #undef STRICT
--- fontconfig-zip.in
+++ fontconfig-zip.in
@@ -15,7 +15,7 @@
 EOF
 
 rm -f $DEVZIP
-zip -r $DEVZIP -@ <<EOF
+zip -r -D $DEVZIP -@ <<EOF
 etc/fonts/fonts.dtd
 include/fontconfig
 lib/libfontconfig.dll.a
@@ -24,10 +24,6 @@
 lib/pkgconfig/fontconfig.pc
 bin/fc-list.exe
 bin/fc-cache.exe
-man/man1/fc-cache.1
-man/man1/fc-list.1
-man/man5/fonts-conf.5
+share/man
 share/doc/fontconfig
 EOF
-
-zip $DEVZIP man/man3/Fc*.3
EOF

# Brute force solution for problems with libtool: use
# lt_cv_deplibs_check_method= pass_all

lt_cv_deplibs_check_method='pass_all' \
CC='x86_64-w64-mingw32-gcc' \
LDFLAGS='-Wl,--enable-auto-image-base' \
CFLAGS=-O2 \
./configure --host=x86_64-w64-mingw32 --with-arch=win64 --with-expat="/devel/dist/win64/$EXPAT" --with-freetype-config="/devel/dist/${ARCH}/$FREETYPE/bin/freetype-config" --prefix=c:/devel/target/$HEX  --with-confdir=c:/devel/target/$HEX/etc/fonts --disable-static &&

libtoolcacheize &&

make -j3 install &&

(cd /devel/target/$HEX/lib && lib.exe -machine:X64 -def:fontconfig.def -out:fontconfig.lib) &&

sed -e "s/@VERSION@/$VER/" <fontconfig-zip.in >fontconfig-zip.in.tem && mv fontconfig-zip.in.tem fontconfig-zip.in &&

./config.status --file=fontconfig-zip &&
./fontconfig-zip &&

mv /tmp/$MOD-$VER.zip /tmp/$RUNZIP &&
mv /tmp/$MOD-dev-$VER.zip /tmp/$DEVZIP

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
