/* gitg-diff-view.c generated by valac 0.34.7, the Vala compiler
 * generated from gitg-diff-view.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2015 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gtksourceview/gtksource.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdio.h>


#define GITG_TYPE_DIFF_VIEW (gitg_diff_view_get_type ())
#define GITG_DIFF_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW, GitgDiffView))
#define GITG_DIFF_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW, GitgDiffViewClass))
#define GITG_IS_DIFF_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW))
#define GITG_IS_DIFF_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW))
#define GITG_DIFF_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW, GitgDiffViewClass))

typedef struct _GitgDiffView GitgDiffView;
typedef struct _GitgDiffViewClass GitgDiffViewClass;
typedef struct _GitgDiffViewPrivate GitgDiffViewPrivate;

#define GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS (gitg_diff_view_commit_details_get_type ())
#define GITG_DIFF_VIEW_COMMIT_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetails))
#define GITG_DIFF_VIEW_COMMIT_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetailsClass))
#define GITG_IS_DIFF_VIEW_COMMIT_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS))
#define GITG_IS_DIFF_VIEW_COMMIT_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS))
#define GITG_DIFF_VIEW_COMMIT_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetailsClass))

typedef struct _GitgDiffViewCommitDetails GitgDiffViewCommitDetails;
typedef struct _GitgDiffViewCommitDetailsClass GitgDiffViewCommitDetailsClass;

#define GITG_TYPE_DIFF_VIEW_OPTIONS (gitg_diff_view_options_get_type ())
#define GITG_DIFF_VIEW_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_OPTIONS, GitgDiffViewOptions))
#define GITG_DIFF_VIEW_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_OPTIONS, GitgDiffViewOptionsClass))
#define GITG_IS_DIFF_VIEW_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_OPTIONS))
#define GITG_IS_DIFF_VIEW_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_OPTIONS))
#define GITG_DIFF_VIEW_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_OPTIONS, GitgDiffViewOptionsClass))

typedef struct _GitgDiffViewOptions GitgDiffViewOptions;
typedef struct _GitgDiffViewOptionsClass GitgDiffViewOptionsClass;

#define GITG_TYPE_COMMIT (gitg_commit_get_type ())
#define GITG_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COMMIT, GitgCommit))
#define GITG_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COMMIT, GitgCommitClass))
#define GITG_IS_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COMMIT))
#define GITG_IS_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COMMIT))
#define GITG_COMMIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COMMIT, GitgCommitClass))

typedef struct _GitgCommit GitgCommit;
typedef struct _GitgCommitClass GitgCommitClass;

#define GITG_TYPE_REPOSITORY (gitg_repository_get_type ())
#define GITG_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY, GitgRepository))
#define GITG_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY, GitgRepositoryClass))
#define GITG_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY))
#define GITG_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY))
#define GITG_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY, GitgRepositoryClass))

typedef struct _GitgRepository GitgRepository;
typedef struct _GitgRepositoryClass GitgRepositoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_TYPE_DIFF_VIEW_FILE (gitg_diff_view_file_get_type ())
#define GITG_DIFF_VIEW_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFile))
#define GITG_DIFF_VIEW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFileClass))
#define GITG_IS_DIFF_VIEW_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE))
#define GITG_IS_DIFF_VIEW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE))
#define GITG_DIFF_VIEW_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFileClass))

typedef struct _GitgDiffViewFile GitgDiffViewFile;
typedef struct _GitgDiffViewFileClass GitgDiffViewFileClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))

#define GITG_TYPE_DIFF_SELECTABLE (gitg_diff_selectable_get_type ())
#define GITG_DIFF_SELECTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_SELECTABLE, GitgDiffSelectable))
#define GITG_IS_DIFF_SELECTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_SELECTABLE))
#define GITG_DIFF_SELECTABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_DIFF_SELECTABLE, GitgDiffSelectableIface))

typedef struct _GitgDiffSelectable GitgDiffSelectable;
typedef struct _GitgDiffSelectableIface GitgDiffSelectableIface;

#define GITG_TYPE_PATCH_SET (gitg_patch_set_get_type ())
#define GITG_PATCH_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PATCH_SET, GitgPatchSet))
#define GITG_PATCH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PATCH_SET, GitgPatchSetClass))
#define GITG_IS_PATCH_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PATCH_SET))
#define GITG_IS_PATCH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PATCH_SET))
#define GITG_PATCH_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PATCH_SET, GitgPatchSetClass))

typedef struct _GitgPatchSet GitgPatchSet;
typedef struct _GitgPatchSetClass GitgPatchSetClass;

#define GITG_TYPE_DIFF_VIEW_FILE_RENDERER (gitg_diff_view_file_renderer_get_type ())
#define GITG_DIFF_VIEW_FILE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER, GitgDiffViewFileRenderer))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER))
#define GITG_DIFF_VIEW_FILE_RENDERER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER, GitgDiffViewFileRendererIface))

typedef struct _GitgDiffViewFileRenderer GitgDiffViewFileRenderer;
typedef struct _GitgDiffViewFileRendererIface GitgDiffViewFileRendererIface;
#define _ggit_diff_file_unref0(var) ((var == NULL) ? NULL : (var = (ggit_diff_file_unref (var), NULL)))

#define GITG_TYPE_DIFF_VIEW_FILE_INFO (gitg_diff_view_file_info_get_type ())
#define GITG_DIFF_VIEW_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_INFO, GitgDiffViewFileInfo))
#define GITG_DIFF_VIEW_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE_INFO, GitgDiffViewFileInfoClass))
#define GITG_IS_DIFF_VIEW_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_INFO))
#define GITG_IS_DIFF_VIEW_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE_INFO))
#define GITG_DIFF_VIEW_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE_INFO, GitgDiffViewFileInfoClass))

typedef struct _GitgDiffViewFileInfo GitgDiffViewFileInfo;
typedef struct _GitgDiffViewFileInfoClass GitgDiffViewFileInfoClass;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
#define _ggit_diff_delta_unref0(var) ((var == NULL) ? NULL : (var = (ggit_diff_delta_unref (var), NULL)))
typedef struct _Block8Data Block8Data;
#define _ggit_diff_hunk_unref0(var) ((var == NULL) ? NULL : (var = (ggit_diff_hunk_unref (var), NULL)))

#define GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT (gitg_diff_view_file_renderer_text_get_type ())
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT, GitgDiffViewFileRendererText))
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT, GitgDiffViewFileRendererTextClass))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT))
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT, GitgDiffViewFileRendererTextClass))

typedef struct _GitgDiffViewFileRendererText GitgDiffViewFileRendererText;
typedef struct _GitgDiffViewFileRendererTextClass GitgDiffViewFileRendererTextClass;
typedef struct _GitgPatchSetPrivate GitgPatchSetPrivate;

#define GITG_PATCH_SET_TYPE_PATCH (gitg_patch_set_patch_get_type ())

#define GITG_PATCH_SET_TYPE_TYPE (gitg_patch_set_type_get_type ())
typedef struct _GitgPatchSetPatch GitgPatchSetPatch;
#define _gitg_patch_set_unref0(var) ((var == NULL) ? NULL : (var = (gitg_patch_set_unref (var), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GitgDiffView {
	GtkGrid parent_instance;
	GitgDiffViewPrivate * priv;
};

struct _GitgDiffViewClass {
	GtkGridClass parent_class;
	void (*options_changed) (GitgDiffView* self);
};

struct _GitgDiffViewPrivate {
	GitgDiffViewCommitDetails* d_commit_details;
	GtkScrolledWindow* d_scrolledwindow;
	GtkGrid* d_grid_files;
	GtkEventBox* d_event_box;
	GtkRevealer* d_revealer_options;
	GitgDiffViewOptions* d_diff_view_options;
	GtkTextView* d_text_view_message;
	GgitDiff* d_diff;
	GitgCommit* d_commit;
	GgitDiffOptions* d_options;
	GCancellable* d_cancellable;
	gulong d_expanded_notify;
	gulong d_parent_commit_notify;
	gboolean d_changes_inline;
	guint d_reveal_options_timeout;
	guint d_unreveal_options_timeout;
	gboolean _has_selection;
	gboolean _wrap_lines;
	gboolean _staged;
	gboolean _unstaged;
	gboolean _show_parents;
	gboolean _default_collapse_all;
	gboolean _use_gravatar;
	gint _tab_width;
	gboolean _handle_selection;
	gboolean _highlight;
	GitgRepository* _repository;
	gboolean _new_is_workdir;
};

struct _GitgDiffSelectableIface {
	GTypeInterface parent_iface;
	gboolean (*get_has_selection) (GitgDiffSelectable* self);
	gboolean (*get_can_select) (GitgDiffSelectable* self);
	void (*set_can_select) (GitgDiffSelectable* self, gboolean value);
	GitgPatchSet* (*get_selection) (GitgDiffSelectable* self);
};

struct _GitgDiffViewFileRendererIface {
	GTypeInterface parent_iface;
	void (*add_hunk) (GitgDiffViewFileRenderer* self, GgitDiffHunk* hunk, GeeArrayList* lines);
};

typedef void (*GitgDiffViewAnon) (void* user_data);
struct _Block6Data {
	int _ref_count_;
	GitgDiffView* self;
	gint nqueries;
	gboolean finished;
	GeeHashMap* infomap;
	GitgDiffViewAnon check_finish;
	gpointer check_finish_target;
	GDestroyNotify check_finish_target_destroy_notify;
	GgitDiff* diff;
	gboolean preserve_expanded;
	GCancellable* cancellable;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	GgitDiffDelta* delta;
	GitgDiffViewFileInfo* info;
};

struct _Block8Data {
	int _ref_count_;
	GitgDiffView* self;
	GeeArrayList* files;
	GitgDiffViewFile* current_file;
	GgitDiffHunk* current_hunk;
	GeeArrayList* current_lines;
	gboolean current_is_binary;
	gint maxlines;
	GitgDiffViewAnon add_hunk;
	gpointer add_hunk_target;
	GDestroyNotify add_hunk_target_destroy_notify;
	GitgDiffViewAnon add_file;
	gpointer add_file_target;
	GDestroyNotify add_file_target_destroy_notify;
	GeeHashMap* infomap;
	GCancellable* cancellable;
};

typedef enum  {
	GITG_PATCH_SET_TYPE_ADD = 'a',
	GITG_PATCH_SET_TYPE_REMOVE = 'r'
} GitgPatchSetType;

struct _GitgPatchSetPatch {
	GitgPatchSetType type;
	gsize old_offset;
	gsize new_offset;
	gsize length;
};

struct _GitgPatchSet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GitgPatchSetPrivate * priv;
	gchar* filename;
	GitgPatchSetPatch* patches;
	gint patches_length1;
};

struct _GitgPatchSetClass {
	GTypeClass parent_class;
	void (*finalize) (GitgPatchSet *self);
};


static gpointer gitg_diff_view_parent_class = NULL;
static GeeHashSet* gitg_diff_view_s_image_mime_types;
static GeeHashSet* gitg_diff_view_s_image_mime_types = NULL;
static GRegex* gitg_diff_view_s_message_regexp;
static GRegex* gitg_diff_view_s_message_regexp = NULL;

GType gitg_diff_view_get_type (void) G_GNUC_CONST;
GType gitg_diff_view_commit_details_get_type (void) G_GNUC_CONST;
GType gitg_diff_view_options_get_type (void) G_GNUC_CONST;
GType gitg_commit_get_type (void) G_GNUC_CONST;
GType gitg_repository_get_type (void) G_GNUC_CONST;
#define GITG_DIFF_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_DIFF_VIEW, GitgDiffViewPrivate))
enum  {
	GITG_DIFF_VIEW_DUMMY_PROPERTY,
	GITG_DIFF_VIEW_OPTIONS,
	GITG_DIFF_VIEW_HAS_SELECTION,
	GITG_DIFF_VIEW_DIFF,
	GITG_DIFF_VIEW_COMMIT,
	GITG_DIFF_VIEW_WRAP_LINES,
	GITG_DIFF_VIEW_STAGED,
	GITG_DIFF_VIEW_UNSTAGED,
	GITG_DIFF_VIEW_SHOW_PARENTS,
	GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL,
	GITG_DIFF_VIEW_USE_GRAVATAR,
	GITG_DIFF_VIEW_TAB_WIDTH,
	GITG_DIFF_VIEW_HANDLE_SELECTION,
	GITG_DIFF_VIEW_HIGHLIGHT,
	GITG_DIFF_VIEW_REPOSITORY,
	GITG_DIFF_VIEW_NEW_IS_WORKDIR,
	GITG_DIFF_VIEW_IGNORE_WHITESPACE,
	GITG_DIFF_VIEW_CHANGES_INLINE,
	GITG_DIFF_VIEW_CONTEXT_LINES
};
static gboolean gitg_diff_view_flag_get (GitgDiffView* self, GgitDiffOption f);
GgitDiffOptions* gitg_diff_view_get_options (GitgDiffView* self);
static void gitg_diff_view_flag_set (GitgDiffView* self, GgitDiffOption f, gboolean val);
static void gitg_diff_view_real_constructed (GObject* base);
static void gitg_diff_view_update_expanded_files (GitgDiffView* self);
static void _gitg_diff_view_update_expanded_files_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gitg_diff_view_parent_commit_changed (GitgDiffView* self);
static void _gitg_diff_view_parent_commit_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean gitg_diff_view_motion_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventMotion* event);
static gboolean _gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
void gitg_diff_view_options_set_view (GitgDiffViewOptions* self, GitgDiffView* value);
static void gitg_diff_view_real_dispose (GObject* base);
static void gitg_diff_view_update (GitgDiffView* self, gboolean preserve_expanded);
gboolean gitg_diff_view_commit_details_get_expanded (GitgDiffViewCommitDetails* self);
GType gitg_diff_view_file_get_type (void) G_GNUC_CONST;
void gitg_diff_view_file_set_expanded (GitgDiffViewFile* self, gboolean value);
static gchar* gitg_diff_view_message_without_subject (GitgDiffView* self, GitgCommit* commit);
void gitg_diff_view_commit_details_set_commit (GitgDiffViewCommitDetails* self, GgitCommit* value);
GgitCommit* gitg_diff_view_commit_details_get_parent_commit (GitgDiffViewCommitDetails* self);
static void _vala_GgitOId_free (GgitOId* self);
GgitDiff* gitg_commit_get_diff (GitgCommit* self, GgitDiffOptions* options, gint parent);
static void gitg_diff_view_update_diff (GitgDiffView* self, GgitDiff* diff, gboolean preserve_expanded, GCancellable* cancellable);
static void gitg_diff_view_auto_change_expanded (GitgDiffView* self, gboolean expanded);
void gitg_diff_view_commit_details_set_expanded (GitgDiffViewCommitDetails* self, gboolean value);
static void gitg_diff_view_on_selection_changed (GitgDiffView* self);
gpointer gitg_patch_set_ref (gpointer instance);
void gitg_patch_set_unref (gpointer instance);
GParamSpec* gitg_param_spec_patch_set (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gitg_value_set_patch_set (GValue* value, gpointer v_object);
void gitg_value_take_patch_set (GValue* value, gpointer v_object);
gpointer gitg_value_get_patch_set (const GValue* value);
GType gitg_patch_set_get_type (void) G_GNUC_CONST;
GType gitg_diff_selectable_get_type (void) G_GNUC_CONST;
GType gitg_diff_view_file_renderer_get_type (void) G_GNUC_CONST;
GitgDiffViewFileRenderer* gitg_diff_view_file_get_renderer (GitgDiffViewFile* self);
gboolean gitg_diff_selectable_get_has_selection (GitgDiffSelectable* self);
gboolean gitg_diff_view_get_has_selection (GitgDiffView* self);
static void gitg_diff_view_set_has_selection (GitgDiffView* self, gboolean value);
static gchar* gitg_diff_view_primary_path (GitgDiffView* self, GgitDiffDelta* delta);
static gchar* gitg_diff_view_key_for_delta (GitgDiffView* self, GgitDiffDelta* delta);
GType gitg_diff_view_file_info_get_type (void) G_GNUC_CONST;
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda48_ (Block6Data* _data6_);
static void gitg_diff_view_update_diff_hunks (GitgDiffView* self, GgitDiff* diff, gboolean preserve_expanded, GeeHashMap* infomap, GCancellable* cancellable);
static void ___lambda48__gitg_diff_view_anon (gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
GitgRepository* gitg_diff_view_get_repository (GitgDiffView* self);
gboolean gitg_diff_view_get_new_is_workdir (GitgDiffView* self);
GitgDiffViewFileInfo* gitg_diff_view_file_info_new (GitgRepository* repository, GgitDiffDelta* delta, gboolean from_workdir);
GitgDiffViewFileInfo* gitg_diff_view_file_info_construct (GType object_type, GitgRepository* repository, GgitDiffDelta* delta, gboolean from_workdir);
void gitg_diff_view_file_info_query (GitgDiffViewFileInfo* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_diff_view_file_info_query_finish (GitgDiffViewFileInfo* self, GAsyncResult* _res_);
static void _____lambda63_ (Block7Data* _data7_, GObject* obj, GAsyncResult* res);
static void ______lambda63__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda57_ (Block8Data* _data8_);
void gitg_diff_view_file_add_hunk (GitgDiffViewFile* self, GgitDiffHunk* hunk, GeeArrayList* lines);
static void ___lambda57__gitg_diff_view_anon (gpointer self);
static void __lambda58_ (Block8Data* _data8_);
static void _gitg_diff_view_on_selection_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ___lambda58__gitg_diff_view_anon (gpointer self);
static gint ___lambda59_ (Block8Data* _data8_, GgitDiffDelta* delta, gfloat progress);
const gchar* gitg_diff_view_file_info_get_new_file_content_type (GitgDiffViewFileInfo* self);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
GitgDiffViewFile* gitg_diff_view_file_new_image (GitgRepository* repository, GgitDiffDelta* delta);
GitgDiffViewFile* gitg_diff_view_file_construct_image (GType object_type, GitgRepository* repository, GgitDiffDelta* delta);
GitgDiffViewFile* gitg_diff_view_file_new_binary (GitgRepository* repository, GgitDiffDelta* delta);
GitgDiffViewFile* gitg_diff_view_file_construct_binary (GType object_type, GitgRepository* repository, GgitDiffDelta* delta);
gboolean gitg_diff_view_get_handle_selection (GitgDiffView* self);
GitgDiffViewFile* gitg_diff_view_file_new_text (GitgDiffViewFileInfo* info, gboolean handle_selection);
GitgDiffViewFile* gitg_diff_view_file_construct_text (GType object_type, GitgDiffViewFileInfo* info, gboolean handle_selection);
static gint ____lambda59__ggit_diff_file_callback (GgitDiffDelta* delta, gfloat progress, gpointer self);
static gint ___lambda60_ (Block8Data* _data8_, GgitDiffDelta* delta, GgitDiffBinary* binary);
static gint ____lambda60__ggit_diff_binary_callback (GgitDiffDelta* delta, GgitDiffBinary* binary, gpointer self);
static gint ___lambda61_ (Block8Data* _data8_, GgitDiffDelta* delta, GgitDiffHunk* hunk);
static gint ____lambda61__ggit_diff_hunk_callback (GgitDiffDelta* delta, GgitDiffHunk* hunk, gpointer self);
static gint ___lambda62_ (Block8Data* _data8_, GgitDiffDelta* delta, GgitDiffHunk* hunk, GgitDiffLine* line);
static gint ____lambda62__ggit_diff_line_callback (GgitDiffDelta* delta, GgitDiffHunk* hunk, GgitDiffLine* line, gpointer self);
gboolean gitg_diff_view_file_get_expanded (GitgDiffViewFile* self);
GgitDiffDelta* gitg_diff_view_file_get_delta (GitgDiffViewFile* self);
gboolean gitg_diff_view_get_default_collapse_all (GitgDiffView* self);
void gitg_diff_view_commit_details_set_expander_visible (GitgDiffViewCommitDetails* self, gboolean value);
GType gitg_diff_view_file_renderer_text_get_type (void) G_GNUC_CONST;
void gitg_diff_view_file_renderer_text_set_maxlines (GitgDiffViewFileRendererText* self, gint value);
static void gitg_diff_view_auto_update_expanded (GitgDiffView* self);
static void _gitg_diff_view_auto_update_expanded_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gitg_diff_view_update_hide_show_options (GitgDiffView* self, GdkWindow* window, gint ex, gint ey);
static gboolean ___lambda64_ (GitgDiffView* self);
static gboolean ____lambda64__gsource_func (gpointer self);
static gboolean _____lambda65_ (GitgDiffView* self);
static gboolean ______lambda65__gsource_func (gpointer self);
static gboolean gitg_diff_view_leave_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventCrossing* event);
static gboolean _gitg_diff_view_leave_notify_event_on_event_box_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean gitg_diff_view_enter_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventCrossing* event);
static gboolean _gitg_diff_view_enter_notify_event_on_event_box_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
GitgDiffView* gitg_diff_view_new (void);
GitgDiffView* gitg_diff_view_construct (GType object_type);
GgitDiff* gitg_diff_view_get_diff (GitgDiffView* self);
void gitg_diff_view_set_diff (GitgDiffView* self, GgitDiff* value);
GitgCommit* gitg_diff_view_get_commit (GitgDiffView* self);
void gitg_diff_view_set_commit (GitgDiffView* self, GitgCommit* value);
gboolean gitg_diff_view_get_wrap_lines (GitgDiffView* self);
void gitg_diff_view_set_wrap_lines (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_staged (GitgDiffView* self);
void gitg_diff_view_set_staged (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_unstaged (GitgDiffView* self);
void gitg_diff_view_set_unstaged (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_show_parents (GitgDiffView* self);
void gitg_diff_view_set_show_parents (GitgDiffView* self, gboolean value);
void gitg_diff_view_set_default_collapse_all (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_use_gravatar (GitgDiffView* self);
void gitg_diff_view_set_use_gravatar (GitgDiffView* self, gboolean value);
gint gitg_diff_view_get_tab_width (GitgDiffView* self);
void gitg_diff_view_set_tab_width (GitgDiffView* self, gint value);
void gitg_diff_view_set_handle_selection (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_highlight (GitgDiffView* self);
void gitg_diff_view_set_highlight (GitgDiffView* self, gboolean value);
void gitg_diff_view_set_repository (GitgDiffView* self, GitgRepository* value);
void gitg_diff_view_set_new_is_workdir (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_ignore_whitespace (GitgDiffView* self);
void gitg_diff_view_set_ignore_whitespace (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_changes_inline (GitgDiffView* self);
void gitg_diff_view_set_changes_inline (GitgDiffView* self, gboolean value);
gint gitg_diff_view_get_context_lines (GitgDiffView* self);
void gitg_diff_view_set_context_lines (GitgDiffView* self, gint value);
GitgPatchSet** gitg_diff_view_get_selection (GitgDiffView* self, int* result_length1);
GitgPatchSet* gitg_diff_selectable_get_selection (GitgDiffSelectable* self);
GType gitg_patch_set_patch_get_type (void) G_GNUC_CONST;
GType gitg_patch_set_type_get_type (void) G_GNUC_CONST;
GitgPatchSetPatch* gitg_patch_set_patch_dup (const GitgPatchSetPatch* self);
void gitg_patch_set_patch_free (GitgPatchSetPatch* self);
static void _vala_array_add2 (GitgPatchSet*** array, int* length, int* size, GitgPatchSet* value);
static void gitg_diff_view_real_options_changed (GitgDiffView* self);
static void gitg_diff_view_finalize (GObject* obj);
static void _vala_gitg_diff_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_diff_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gboolean gitg_diff_view_flag_get (GitgDiffView* self, GgitDiffOption f) {
	gboolean result = FALSE;
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp1_ = NULL;
	GgitDiffOption _tmp2_ = 0;
	GgitDiffOption _tmp3_ = 0;
	GgitDiffOption _tmp4_ = 0;
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 127 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_get_options (self);
#line 127 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_;
#line 127 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = ggit_diff_options_get_flags (_tmp1_);
#line 127 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_;
#line 127 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = f;
#line 127 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = (_tmp3_ & _tmp4_) != 0;
#line 127 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 491 "gitg-diff-view.c"
}


static void gitg_diff_view_flag_set (GitgDiffView* self, GgitDiffOption f, gboolean val) {
	GgitDiffOption flags = 0;
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp1_ = NULL;
	GgitDiffOption _tmp2_ = 0;
	GgitDiffOption _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	GgitDiffOption _tmp9_ = 0;
	GgitDiffOptions* _tmp10_ = NULL;
	GgitDiffOptions* _tmp11_ = NULL;
	GgitDiffOption _tmp12_ = 0;
	GgitDiffOption _tmp13_ = 0;
#line 130 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 132 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_get_options (self);
#line 132 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_;
#line 132 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = ggit_diff_options_get_flags (_tmp1_);
#line 132 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_;
#line 132 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	flags = _tmp3_;
#line 134 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = val;
#line 134 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp4_) {
#line 523 "gitg-diff-view.c"
		GgitDiffOption _tmp5_ = 0;
		GgitDiffOption _tmp6_ = 0;
#line 136 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp5_ = flags;
#line 136 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp6_ = f;
#line 136 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		flags = _tmp5_ | _tmp6_;
#line 532 "gitg-diff-view.c"
	} else {
		GgitDiffOption _tmp7_ = 0;
		GgitDiffOption _tmp8_ = 0;
#line 140 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = flags;
#line 140 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = f;
#line 140 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		flags = _tmp7_ & (~_tmp8_);
#line 542 "gitg-diff-view.c"
	}
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = flags;
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp10_ = gitg_diff_view_get_options (self);
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp11_ = _tmp10_;
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp12_ = ggit_diff_options_get_flags (_tmp11_);
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp13_ = _tmp12_;
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp9_ != _tmp13_) {
#line 556 "gitg-diff-view.c"
		GgitDiffOptions* _tmp14_ = NULL;
		GgitDiffOptions* _tmp15_ = NULL;
		GgitDiffOption _tmp16_ = 0;
#line 145 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp14_ = gitg_diff_view_get_options (self);
#line 145 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = _tmp14_;
#line 145 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = flags;
#line 145 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		ggit_diff_options_set_flags (_tmp15_, _tmp16_);
#line 146 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_signal_emit_by_name (self, "options-changed");
#line 570 "gitg-diff-view.c"
	}
}


static void _gitg_diff_view_update_expanded_files_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 191 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update_expanded_files ((GitgDiffView*) self);
#line 578 "gitg-diff-view.c"
}


static void _gitg_diff_view_parent_commit_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_parent_commit_changed ((GitgDiffView*) self);
#line 585 "gitg-diff-view.c"
}


static gboolean _gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = gitg_diff_view_motion_notify_event_on_event_box ((GitgDiffView*) self, _sender, event);
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 594 "gitg-diff-view.c"
}


static void gitg_diff_view_real_constructed (GObject* base) {
	GitgDiffView * self;
	GitgDiffViewCommitDetails* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	GitgDiffViewCommitDetails* _tmp2_ = NULL;
	gulong _tmp3_ = 0UL;
	GitgDiffViewCommitDetails* _tmp4_ = NULL;
	GtkEventBox* _tmp5_ = NULL;
	GitgDiffViewOptions* _tmp6_ = NULL;
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = (GitgDiffView*) base;
#line 191 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit_details;
#line 191 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = g_signal_connect_object ((GObject*) _tmp0_, "notify::expanded", (GCallback) _gitg_diff_view_update_expanded_files_g_object_notify, self, 0);
#line 191 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_expanded_notify = _tmp1_;
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = self->priv->d_commit_details;
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = g_signal_connect_object ((GObject*) _tmp2_, "notify::parent-commit", (GCallback) _gitg_diff_view_parent_commit_changed_g_object_notify, self, 0);
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_parent_commit_notify = _tmp3_;
#line 194 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = self->priv->d_commit_details;
#line 194 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_bind_property_with_closures ((GObject*) self, "use-gravatar", (GObject*) _tmp4_, "use-gravatar", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = self->priv->d_event_box;
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp5_, "motion-notify-event", (GCallback) _gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event, self, 0);
#line 197 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = self->priv->d_diff_view_options;
#line 197 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_options_set_view (_tmp6_, self);
#line 633 "gitg-diff-view.c"
}


static void gitg_diff_view_real_dispose (GObject* base) {
	GitgDiffView * self;
	GCancellable* _tmp0_ = NULL;
#line 200 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = (GitgDiffView*) base;
#line 202 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_cancellable;
#line 202 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != NULL) {
#line 646 "gitg-diff-view.c"
		GCancellable* _tmp1_ = NULL;
#line 204 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp1_ = self->priv->d_cancellable;
#line 204 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_cancellable_cancel (_tmp1_);
#line 652 "gitg-diff-view.c"
	}
#line 207 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (gitg_diff_view_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid));
#line 656 "gitg-diff-view.c"
}


static void gitg_diff_view_parent_commit_changed (GitgDiffView* self) {
#line 210 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 212 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update (self, FALSE);
#line 665 "gitg-diff-view.c"
}


static void gitg_diff_view_update_expanded_files (GitgDiffView* self) {
	gboolean expanded = FALSE;
	GitgDiffViewCommitDetails* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkGrid* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
#line 215 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit_details;
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = gitg_diff_view_commit_details_get_expanded (_tmp0_);
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = _tmp1_;
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	expanded = _tmp2_;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = self->priv->d_grid_files;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = gtk_container_get_children ((GtkContainer*) _tmp3_);
#line 690 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp4_;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 698 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 702 "gitg-diff-view.c"
			{
				GtkWidget* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
#line 221 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp5_ = file;
#line 221 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp6_ = expanded;
#line 221 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				gitg_diff_view_file_set_expanded (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp5_) : NULL, _tmp6_);
#line 712 "gitg-diff-view.c"
			}
		}
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_list_free0 (file_collection);
#line 717 "gitg-diff-view.c"
	}
}


static gchar* gitg_diff_view_message_without_subject (GitgDiffView* self, GitgCommit* commit) {
	gchar* result = NULL;
	gchar* message = NULL;
	GitgCommit* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GMatchInfo* minfo = NULL;
	GRegex* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GMatchInfo* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp9_ = NULL;
#line 245 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 245 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (commit != NULL, NULL);
#line 247 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = commit;
#line 247 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = ggit_commit_get_message ((GgitCommit*) _tmp0_);
#line 247 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 247 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	message = _tmp2_;
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = gitg_diff_view_s_message_regexp;
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = message;
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = g_regex_match (_tmp3_, _tmp4_, 0, &_tmp5_);
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_match_info_unref0 (minfo);
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	minfo = _tmp5_;
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp6_) {
#line 758 "gitg-diff-view.c"
		GMatchInfo* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 252 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = minfo;
#line 252 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = g_match_info_fetch_named (_tmp7_, "message");
#line 252 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = _tmp8_;
#line 252 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_match_info_unref0 (minfo);
#line 252 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (message);
#line 252 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 773 "gitg-diff-view.c"
	}
#line 255 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = g_strdup ("");
#line 255 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp9_;
#line 255 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_match_info_unref0 (minfo);
#line 255 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_free0 (message);
#line 255 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 785 "gitg-diff-view.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 285 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 792 "gitg-diff-view.c"
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 293 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 799 "gitg-diff-view.c"
}


static void gitg_diff_view_update (GitgDiffView* self, gboolean preserve_expanded) {
	gboolean _tmp0_ = FALSE;
	GgitDiff* _tmp1_ = NULL;
	GitgDiffViewCommitDetails* _tmp5_ = NULL;
	GtkScrolledWindow* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
	GitgCommit* _tmp9_ = NULL;
	GgitDiff* _tmp56_ = NULL;
#line 258 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 262 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = self->priv->d_diff;
#line 262 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ == NULL) {
#line 818 "gitg-diff-view.c"
		GitgCommit* _tmp2_ = NULL;
#line 262 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = self->priv->d_commit;
#line 262 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 824 "gitg-diff-view.c"
	} else {
#line 262 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 828 "gitg-diff-view.c"
	}
#line 262 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 832 "gitg-diff-view.c"
		GitgDiffViewCommitDetails* _tmp3_ = NULL;
		GtkScrolledWindow* _tmp4_ = NULL;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = self->priv->d_commit_details;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 265 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp4_ = self->priv->d_scrolledwindow;
#line 265 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp4_);
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return;
#line 845 "gitg-diff-view.c"
	}
#line 269 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = self->priv->d_commit_details;
#line 269 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp5_);
#line 270 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = self->priv->d_scrolledwindow;
#line 270 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp6_);
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = self->priv->d_cancellable;
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_cancellable_cancel (_tmp7_);
#line 274 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ = g_cancellable_new ();
#line 274 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_cancellable);
#line 274 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_cancellable = _tmp8_;
#line 276 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = self->priv->d_commit;
#line 276 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp9_ != NULL) {
#line 869 "gitg-diff-view.c"
		GitgDiffViewCommitDetails* _tmp10_ = NULL;
		gulong _tmp11_ = 0UL;
		GitgDiffViewCommitDetails* _tmp12_ = NULL;
		GitgCommit* _tmp13_ = NULL;
		GitgDiffViewCommitDetails* _tmp14_ = NULL;
		gulong _tmp15_ = 0UL;
		gint parent = 0;
		GgitCommitParents* parents = NULL;
		GitgCommit* _tmp16_ = NULL;
		GgitCommitParents* _tmp17_ = NULL;
		GgitCommit* parent_commit = NULL;
		GitgDiffViewCommitDetails* _tmp18_ = NULL;
		GgitCommit* _tmp19_ = NULL;
		GgitCommit* _tmp20_ = NULL;
		GgitCommit* _tmp21_ = NULL;
		GgitCommit* _tmp22_ = NULL;
		GitgCommit* _tmp39_ = NULL;
		GgitDiffOptions* _tmp40_ = NULL;
		GgitDiffOptions* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		GgitDiff* _tmp43_ = NULL;
		GitgDiffViewCommitDetails* _tmp44_ = NULL;
		gchar* message = NULL;
		GitgCommit* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		GtkTextView* _tmp47_ = NULL;
		GtkTextBuffer* _tmp48_ = NULL;
		GtkTextBuffer* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
		GtkTextView* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
#line 278 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp10_ = self->priv->d_commit_details;
#line 278 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp11_ = self->priv->d_parent_commit_notify;
#line 278 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_signal_handler_block (_tmp10_, _tmp11_);
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp12_ = self->priv->d_commit_details;
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp13_ = self->priv->d_commit;
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_commit_details_set_commit (_tmp12_, (GgitCommit*) _tmp13_);
#line 280 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp14_ = self->priv->d_commit_details;
#line 280 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = self->priv->d_parent_commit_notify;
#line 280 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_signal_handler_unblock (_tmp14_, _tmp15_);
#line 282 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		parent = 0;
#line 283 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = self->priv->d_commit;
#line 283 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp17_ = ggit_commit_get_parents ((GgitCommit*) _tmp16_);
#line 283 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		parents = _tmp17_;
#line 285 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp18_ = self->priv->d_commit_details;
#line 285 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp19_ = gitg_diff_view_commit_details_get_parent_commit (_tmp18_);
#line 285 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp20_ = _tmp19_;
#line 285 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp21_ = _g_object_ref0 (_tmp20_);
#line 285 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		parent_commit = _tmp21_;
#line 287 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp22_ = parent_commit;
#line 287 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (_tmp22_ != NULL) {
#line 941 "gitg-diff-view.c"
			{
				gint i = 0;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				i = 0;
#line 946 "gitg-diff-view.c"
				{
					gboolean _tmp23_ = FALSE;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp23_ = TRUE;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					while (TRUE) {
#line 953 "gitg-diff-view.c"
						gint _tmp25_ = 0;
						GgitCommitParents* _tmp26_ = NULL;
						guint _tmp27_ = 0U;
						guint _tmp28_ = 0U;
						GgitOId* id = NULL;
						GgitCommitParents* _tmp29_ = NULL;
						gint _tmp30_ = 0;
						GgitOId* _tmp31_ = NULL;
						GgitOId* _tmp32_ = NULL;
						GgitCommit* _tmp33_ = NULL;
						GgitOId* _tmp34_ = NULL;
						GgitOId* _tmp35_ = NULL;
						gboolean _tmp36_ = FALSE;
						gboolean _tmp37_ = FALSE;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						if (!_tmp23_) {
#line 970 "gitg-diff-view.c"
							gint _tmp24_ = 0;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							_tmp24_ = i;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							i = _tmp24_ + 1;
#line 976 "gitg-diff-view.c"
						}
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp23_ = FALSE;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp25_ = i;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp26_ = parents;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp27_ = ggit_commit_parents_get_size (_tmp26_);
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp28_ = _tmp27_;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						if (!(((guint) _tmp25_) < _tmp28_)) {
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							break;
#line 992 "gitg-diff-view.c"
						}
#line 291 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp29_ = parents;
#line 291 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp30_ = i;
#line 291 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp31_ = ggit_commit_parents_get_id (_tmp29_, (guint) _tmp30_);
#line 291 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						id = _tmp31_;
#line 293 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp32_ = id;
#line 293 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp33_ = parent_commit;
#line 293 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp34_ = ggit_object_get_id ((GgitObject*) _tmp33_);
#line 293 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp35_ = _tmp34_;
#line 293 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp36_ = ggit_oid_equal (_tmp32_, _tmp35_);
#line 293 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp37_ = _tmp36_;
#line 293 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						__vala_GgitOId_free0 (_tmp35_);
#line 293 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						if (_tmp37_) {
#line 1018 "gitg-diff-view.c"
							gint _tmp38_ = 0;
#line 295 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							_tmp38_ = i;
#line 295 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							parent = _tmp38_;
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							__vala_GgitOId_free0 (id);
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							break;
#line 1028 "gitg-diff-view.c"
						}
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						__vala_GgitOId_free0 (id);
#line 1032 "gitg-diff-view.c"
					}
				}
			}
		}
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp39_ = self->priv->d_commit;
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp40_ = gitg_diff_view_get_options (self);
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp41_ = _tmp40_;
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp42_ = parent;
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp43_ = gitg_commit_get_diff (_tmp39_, _tmp41_, _tmp42_);
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_diff);
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_diff = _tmp43_;
#line 302 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp44_ = self->priv->d_commit_details;
#line 302 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_show ((GtkWidget*) _tmp44_);
#line 304 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp45_ = self->priv->d_commit;
#line 304 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp46_ = gitg_diff_view_message_without_subject (self, _tmp45_);
#line 304 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		message = _tmp46_;
#line 306 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp47_ = self->priv->d_text_view_message;
#line 306 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp48_ = gtk_text_view_get_buffer (_tmp47_);
#line 306 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp49_ = _tmp48_;
#line 306 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp50_ = message;
#line 306 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_text_buffer_set_text (_tmp49_, _tmp50_, -1);
#line 307 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp51_ = self->priv->d_text_view_message;
#line 307 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp52_ = message;
#line 307 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp51_, g_strcmp0 (_tmp52_, "") != 0);
#line 276 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (message);
#line 276 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (parent_commit);
#line 276 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (parents);
#line 1083 "gitg-diff-view.c"
	} else {
		GitgDiffViewCommitDetails* _tmp53_ = NULL;
		GitgDiffViewCommitDetails* _tmp54_ = NULL;
		GtkTextView* _tmp55_ = NULL;
#line 311 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp53_ = self->priv->d_commit_details;
#line 311 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_commit_details_set_commit (_tmp53_, NULL);
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp54_ = self->priv->d_commit_details;
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp54_);
#line 314 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp55_ = self->priv->d_text_view_message;
#line 314 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp55_);
#line 1100 "gitg-diff-view.c"
	}
#line 317 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp56_ = self->priv->d_diff;
#line 317 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp56_ != NULL) {
#line 1106 "gitg-diff-view.c"
		GgitDiff* _tmp57_ = NULL;
		gboolean _tmp58_ = FALSE;
		GCancellable* _tmp59_ = NULL;
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp57_ = self->priv->d_diff;
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp58_ = preserve_expanded;
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp59_ = self->priv->d_cancellable;
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_update_diff (self, _tmp57_, _tmp58_, _tmp59_);
#line 1118 "gitg-diff-view.c"
	}
}


static void gitg_diff_view_auto_change_expanded (GitgDiffView* self, gboolean expanded) {
	GitgDiffViewCommitDetails* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	GitgDiffViewCommitDetails* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GitgDiffViewCommitDetails* _tmp4_ = NULL;
	gulong _tmp5_ = 0UL;
#line 323 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit_details;
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = self->priv->d_expanded_notify;
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_signal_handler_block (_tmp0_, _tmp1_);
#line 326 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = self->priv->d_commit_details;
#line 326 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = expanded;
#line 326 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_commit_details_set_expanded (_tmp2_, _tmp3_);
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = self->priv->d_commit_details;
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = self->priv->d_expanded_notify;
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_signal_handler_unblock (_tmp4_, _tmp5_);
#line 1150 "gitg-diff-view.c"
}


static void gitg_diff_view_on_selection_changed (GitgDiffView* self) {
	gboolean something_selected = FALSE;
	GtkGrid* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
#line 330 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 332 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	something_selected = FALSE;
#line 334 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_grid_files;
#line 334 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
#line 1168 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 334 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp1_;
#line 334 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 1176 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 334 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 1180 "gitg-diff-view.c"
			{
				GitgDiffSelectable* selectable = NULL;
				GtkWidget* _tmp2_ = NULL;
				GitgDiffViewFileRenderer* _tmp3_ = NULL;
				GitgDiffViewFileRenderer* _tmp4_ = NULL;
				GitgDiffSelectable* _tmp5_ = NULL;
				GitgDiffSelectable* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
#line 336 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp2_ = file;
#line 336 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp3_ = gitg_diff_view_file_get_renderer (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp2_) : NULL);
#line 336 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp4_ = _tmp3_;
#line 336 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GITG_TYPE_DIFF_SELECTABLE) ? ((GitgDiffSelectable*) _tmp4_) : NULL;
#line 336 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp5_ == NULL) {
#line 336 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_g_object_unref0 (_tmp4_);
#line 1202 "gitg-diff-view.c"
				}
#line 336 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				selectable = _tmp5_;
#line 338 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp6_ = selectable;
#line 338 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp7_ = gitg_diff_selectable_get_has_selection (_tmp6_);
#line 338 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp8_ = _tmp7_;
#line 338 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp8_) {
#line 340 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					something_selected = TRUE;
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_g_object_unref0 (selectable);
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					break;
#line 1220 "gitg-diff-view.c"
				}
#line 334 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (selectable);
#line 1224 "gitg-diff-view.c"
			}
		}
#line 334 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_list_free0 (file_collection);
#line 1229 "gitg-diff-view.c"
	}
#line 345 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = self->priv->_has_selection;
#line 345 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp10_ = something_selected;
#line 345 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp9_ != _tmp10_) {
#line 1237 "gitg-diff-view.c"
		gboolean _tmp11_ = FALSE;
#line 347 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp11_ = something_selected;
#line 347 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_has_selection (self, _tmp11_);
#line 1243 "gitg-diff-view.c"
	}
}


static gchar* gitg_diff_view_primary_path (GitgDiffView* self, GgitDiffDelta* delta) {
	gchar* result = NULL;
	gchar* path = NULL;
	GgitDiffDelta* _tmp0_ = NULL;
	GgitDiffFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
#line 351 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 351 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, NULL);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = delta;
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = ggit_diff_delta_get_old_file (_tmp0_);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = ggit_diff_file_get_path (_tmp1_);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	path = _tmp3_;
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = path;
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp4_ == NULL) {
#line 1274 "gitg-diff-view.c"
		GgitDiffDelta* _tmp5_ = NULL;
		GgitDiffFile* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 357 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp5_ = delta;
#line 357 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp6_ = ggit_diff_delta_get_new_file (_tmp5_);
#line 357 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = ggit_diff_file_get_path (_tmp6_);
#line 357 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = g_strdup (_tmp7_);
#line 357 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (path);
#line 357 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		path = _tmp8_;
#line 1291 "gitg-diff-view.c"
	}
#line 360 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = path;
#line 360 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1297 "gitg-diff-view.c"
}


static gpointer _ggit_diff_file_ref0 (gpointer self) {
#line 367 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return self ? ggit_diff_file_ref (self) : NULL;
#line 1304 "gitg-diff-view.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1412 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1413 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = self;
#line 1413 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 1316 "gitg-diff-view.c"
}


static gchar* gitg_diff_view_key_for_delta (GitgDiffView* self, GgitDiffDelta* delta) {
	gchar* result = NULL;
	GgitDiffFile* new_file = NULL;
	GgitDiffDelta* _tmp0_ = NULL;
	GgitDiffFile* _tmp1_ = NULL;
	GgitDiffFile* _tmp2_ = NULL;
	gchar* new_path = NULL;
	GgitDiffFile* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GgitDiffFile* old_file = NULL;
	GgitDiffDelta* _tmp10_ = NULL;
	GgitDiffFile* _tmp11_ = NULL;
	GgitDiffFile* _tmp12_ = NULL;
	gchar* old_path = NULL;
	GgitDiffFile* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp20_ = NULL;
#line 365 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 365 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, NULL);
#line 367 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = delta;
#line 367 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = ggit_diff_delta_get_new_file (_tmp0_);
#line 367 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = _ggit_diff_file_ref0 (_tmp1_);
#line 367 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	new_file = _tmp2_;
#line 368 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = new_file;
#line 368 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = ggit_diff_file_get_path (_tmp3_);
#line 368 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 368 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	new_path = _tmp5_;
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = new_path;
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp6_ != NULL) {
#line 1365 "gitg-diff-view.c"
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 372 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = new_path;
#line 372 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = string_to_string (_tmp7_);
#line 372 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp9_ = g_strconcat ("path:", _tmp8_, NULL);
#line 372 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = _tmp9_;
#line 372 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (new_path);
#line 372 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_ggit_diff_file_unref0 (new_file);
#line 372 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 1383 "gitg-diff-view.c"
	}
#line 375 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp10_ = delta;
#line 375 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp11_ = ggit_diff_delta_get_old_file (_tmp10_);
#line 375 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp12_ = _ggit_diff_file_ref0 (_tmp11_);
#line 375 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	old_file = _tmp12_;
#line 376 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp13_ = old_file;
#line 376 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp14_ = ggit_diff_file_get_path (_tmp13_);
#line 376 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp15_ = g_strdup (_tmp14_);
#line 376 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	old_path = _tmp15_;
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp16_ = old_path;
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp16_ != NULL) {
#line 1405 "gitg-diff-view.c"
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp17_ = old_path;
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp18_ = string_to_string (_tmp17_);
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp19_ = g_strconcat ("path:", _tmp18_, NULL);
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = _tmp19_;
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (old_path);
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_ggit_diff_file_unref0 (old_file);
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (new_path);
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_ggit_diff_file_unref0 (new_file);
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 1427 "gitg-diff-view.c"
	}
#line 383 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp20_ = g_strdup ("");
#line 383 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp20_;
#line 383 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_free0 (old_path);
#line 383 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_ggit_diff_file_unref0 (old_file);
#line 383 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_free0 (new_path);
#line 383 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_ggit_diff_file_unref0 (new_file);
#line 383 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1443 "gitg-diff-view.c"
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return _data6_;
#line 1452 "gitg-diff-view.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 1461 "gitg-diff-view.c"
		GitgDiffView* self;
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self = _data6_->self;
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		(_data6_->check_finish_target_destroy_notify == NULL) ? NULL : (_data6_->check_finish_target_destroy_notify (_data6_->check_finish_target), NULL);
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data6_->check_finish = NULL;
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data6_->check_finish_target = NULL;
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data6_->check_finish_target_destroy_notify = NULL;
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data6_->infomap);
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data6_->diff);
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data6_->cancellable);
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self);
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_slice_free (Block6Data, _data6_);
#line 1483 "gitg-diff-view.c"
	}
}


static void __lambda48_ (Block6Data* _data6_) {
	GitgDiffView* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data6_->self;
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = _data6_->nqueries;
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp2_ == 0) {
#line 1499 "gitg-diff-view.c"
		gboolean _tmp3_ = FALSE;
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = _data6_->finished;
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp1_ = _tmp3_;
#line 1505 "gitg-diff-view.c"
	} else {
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp1_ = FALSE;
#line 1509 "gitg-diff-view.c"
	}
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_) {
#line 1513 "gitg-diff-view.c"
		gboolean _tmp4_ = FALSE;
		GCancellable* _tmp5_ = NULL;
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp5_ = _data6_->cancellable;
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (_tmp5_ == NULL) {
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp4_ = TRUE;
#line 1522 "gitg-diff-view.c"
		} else {
			GCancellable* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp6_ = _data6_->cancellable;
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp7_ = g_cancellable_is_cancelled (_tmp6_);
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp4_ = !_tmp7_;
#line 1532 "gitg-diff-view.c"
		}
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp4_;
#line 1536 "gitg-diff-view.c"
	} else {
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 1540 "gitg-diff-view.c"
	}
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 1544 "gitg-diff-view.c"
		GgitDiff* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		GeeHashMap* _tmp10_ = NULL;
		GCancellable* _tmp11_ = NULL;
#line 395 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data6_->finished = FALSE;
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = _data6_->diff;
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp9_ = _data6_->preserve_expanded;
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp10_ = _data6_->infomap;
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp11_ = _data6_->cancellable;
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_update_diff_hunks (self, _tmp8_, _tmp9_, _tmp10_, _tmp11_);
#line 1561 "gitg-diff-view.c"
	}
}


static void ___lambda48__gitg_diff_view_anon (gpointer self) {
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	__lambda48_ (self);
#line 1569 "gitg-diff-view.c"
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return _data7_;
#line 1578 "gitg-diff-view.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 1587 "gitg-diff-view.c"
		GitgDiffView* self;
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self = _data7_->_data6_->self;
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data7_->info);
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_ggit_diff_delta_unref0 (_data7_->delta);
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		block6_data_unref (_data7_->_data6_);
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data7_->_data6_ = NULL;
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_slice_free (Block7Data, _data7_);
#line 1601 "gitg-diff-view.c"
	}
}


static void _____lambda63_ (Block7Data* _data7_, GObject* obj, GAsyncResult* res) {
	Block6Data* _data6_;
	GitgDiffView* self;
	GitgDiffViewFileInfo* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GgitDiffDelta* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GitgDiffViewFileInfo* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GitgDiffViewAnon _tmp8_ = NULL;
	void* _tmp8__target = NULL;
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_ = _data7_->_data6_;
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data6_->self;
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (res != NULL);
#line 409 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = _data7_->info;
#line 409 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = res;
#line 409 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_file_info_query_finish (_tmp0_, _tmp1_);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = _data6_->infomap;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _data7_->delta;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = gitg_diff_view_key_for_delta (self, _tmp3_);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = _tmp4_;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = _data7_->info;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, _tmp5_, _tmp6_);
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_free0 (_tmp5_);
#line 413 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = _data6_->nqueries;
#line 413 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->nqueries = _tmp7_ - 1;
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ = _data6_->check_finish;
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp8__target = _data6_->check_finish_target;
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ (_tmp8__target);
#line 1655 "gitg-diff-view.c"
}


static void ______lambda63__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_____lambda63_ (self, source_object, res);
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	block7_data_unref (self);
#line 1664 "gitg-diff-view.c"
}


static void gitg_diff_view_update_diff (GitgDiffView* self, GgitDiff* diff, gboolean preserve_expanded, GCancellable* cancellable) {
	Block6Data* _data6_;
	GgitDiff* _tmp0_ = NULL;
	GgitDiff* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	GeeHashMap* _tmp5_ = NULL;
	GitgDiffViewAnon _tmp21_ = NULL;
	void* _tmp21__target = NULL;
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (diff != NULL);
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->_ref_count_ = 1;
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->self = g_object_ref (self);
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = diff;
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (_data6_->diff);
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->diff = _tmp1_;
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = preserve_expanded;
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->preserve_expanded = _tmp2_;
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = cancellable;
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (_data6_->cancellable);
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->cancellable = _tmp4_;
#line 388 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->nqueries = 0;
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->finished = FALSE;
#line 390 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GITG_TYPE_DIFF_VIEW_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 390 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->infomap = _tmp5_;
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->check_finish = ___lambda48__gitg_diff_view_anon;
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->check_finish_target = block6_data_ref (_data6_);
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->check_finish_target_destroy_notify = block6_data_unref;
#line 1722 "gitg-diff-view.c"
	{
		gint i = 0;
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		i = 0;
#line 1727 "gitg-diff-view.c"
		{
			gboolean _tmp6_ = FALSE;
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp6_ = TRUE;
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			while (TRUE) {
#line 1734 "gitg-diff-view.c"
				Block7Data* _data7_;
				gint _tmp8_ = 0;
				GgitDiff* _tmp9_ = NULL;
				gsize _tmp10_ = 0UL;
				GgitDiff* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				GgitDiffDelta* _tmp13_ = NULL;
				GitgRepository* _tmp14_ = NULL;
				GgitDiffDelta* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				GitgDiffViewFileInfo* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				GitgDiffViewFileInfo* _tmp19_ = NULL;
				GCancellable* _tmp20_ = NULL;
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_data7_ = g_slice_new0 (Block7Data);
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_data7_->_ref_count_ = 1;
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_data7_->_data6_ = block6_data_ref (_data6_);
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (!_tmp6_) {
#line 1757 "gitg-diff-view.c"
					gint _tmp7_ = 0;
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp7_ = i;
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					i = _tmp7_ + 1;
#line 1763 "gitg-diff-view.c"
				}
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp6_ = FALSE;
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp8_ = i;
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp9_ = _data6_->diff;
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp10_ = ggit_diff_get_num_deltas (_tmp9_);
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (!(((gsize) _tmp8_) < _tmp10_)) {
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					block7_data_unref (_data7_);
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_data7_ = NULL;
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					break;
#line 1781 "gitg-diff-view.c"
				}
#line 403 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp11_ = _data6_->diff;
#line 403 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp12_ = i;
#line 403 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp13_ = ggit_diff_get_delta (_tmp11_, (gsize) _tmp12_);
#line 403 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_data7_->delta = _tmp13_;
#line 404 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp14_ = self->priv->_repository;
#line 404 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp15_ = _data7_->delta;
#line 404 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp16_ = self->priv->_new_is_workdir;
#line 404 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp17_ = gitg_diff_view_file_info_new (_tmp14_, _tmp15_, _tmp16_);
#line 404 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_data7_->info = _tmp17_;
#line 406 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp18_ = _data6_->nqueries;
#line 406 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_data6_->nqueries = _tmp18_ + 1;
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp19_ = _data7_->info;
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp20_ = _data6_->cancellable;
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				gitg_diff_view_file_info_query (_tmp19_, _tmp20_, ______lambda63__gasync_ready_callback, block7_data_ref (_data7_));
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				block7_data_unref (_data7_);
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_data7_ = NULL;
#line 1815 "gitg-diff-view.c"
			}
		}
	}
#line 419 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->finished = TRUE;
#line 420 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp21_ = _data6_->check_finish;
#line 420 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp21__target = _data6_->check_finish_target;
#line 420 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp21_ (_tmp21__target);
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	block6_data_unref (_data6_);
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_ = NULL;
#line 1831 "gitg-diff-view.c"
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return _data8_;
#line 1840 "gitg-diff-view.c"
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 1849 "gitg-diff-view.c"
		GitgDiffView* self;
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self = _data8_->self;
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		(_data8_->add_file_target_destroy_notify == NULL) ? NULL : (_data8_->add_file_target_destroy_notify (_data8_->add_file_target), NULL);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->add_file = NULL;
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->add_file_target = NULL;
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->add_file_target_destroy_notify = NULL;
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		(_data8_->add_hunk_target_destroy_notify == NULL) ? NULL : (_data8_->add_hunk_target_destroy_notify (_data8_->add_hunk_target), NULL);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->add_hunk = NULL;
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->add_hunk_target = NULL;
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->add_hunk_target_destroy_notify = NULL;
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->current_lines);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_ggit_diff_hunk_unref0 (_data8_->current_hunk);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->current_file);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->files);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->infomap);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->cancellable);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_slice_free (Block8Data, _data8_);
#line 1885 "gitg-diff-view.c"
	}
}


static void __lambda57_ (Block8Data* _data8_) {
	GitgDiffView* self;
#line 434 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data8_->self;
#line 435 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_data8_->current_hunk != NULL) {
#line 437 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_file_add_hunk (_data8_->current_file, _data8_->current_hunk, _data8_->current_lines);
#line 439 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->current_lines);
#line 439 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->current_lines = NULL;
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_ggit_diff_hunk_unref0 (_data8_->current_hunk);
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->current_hunk = NULL;
#line 1906 "gitg-diff-view.c"
	}
}


static void ___lambda57__gitg_diff_view_anon (gpointer self) {
#line 434 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	__lambda57_ (self);
#line 1914 "gitg-diff-view.c"
}


static void _gitg_diff_view_on_selection_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 450 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_on_selection_changed ((GitgDiffView*) self);
#line 1921 "gitg-diff-view.c"
}


static void __lambda58_ (Block8Data* _data8_) {
	GitgDiffView* self;
#line 444 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data8_->self;
#line 445 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_hunk (_data8_->add_hunk_target);
#line 447 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_data8_->current_file != NULL) {
#line 1933 "gitg-diff-view.c"
		GitgDiffViewFileRenderer* _tmp0_ = NULL;
		GitgDiffViewFileRenderer* _tmp1_ = NULL;
		GitgDiffViewFileRenderer* _tmp2_ = NULL;
#line 449 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_show ((GtkWidget*) _data8_->current_file);
#line 450 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = gitg_diff_view_file_get_renderer (_data8_->current_file);
#line 450 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp1_ = _tmp0_;
#line 450 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _tmp1_;
#line 450 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_signal_connect_object ((GObject*) _tmp2_, "notify::has-selection", (GCallback) _gitg_diff_view_on_selection_changed_g_object_notify, self, 0);
#line 450 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_tmp2_);
#line 452 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _data8_->files, _data8_->current_file);
#line 454 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->current_file);
#line 454 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->current_file = NULL;
#line 1955 "gitg-diff-view.c"
	}
}


static void ___lambda58__gitg_diff_view_anon (gpointer self) {
#line 444 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	__lambda58_ (self);
#line 1963 "gitg-diff-view.c"
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	for (i = 0; i < stack_length; i++) {
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			return TRUE;
#line 1975 "gitg-diff-view.c"
		}
	}
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return FALSE;
#line 1980 "gitg-diff-view.c"
}


static gint ___lambda59_ (Block8Data* _data8_, GgitDiffDelta* delta, gfloat progress) {
	GitgDiffView* self;
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
	GitgDiffViewFileInfo* info = NULL;
	gchar* deltakey = NULL;
	GgitDiffDelta* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GeeHashMap* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GgitDiffDelta* _tmp16_ = NULL;
	GgitDiffFlag _tmp17_ = 0;
	gchar** known_binary_files_types = NULL;
	gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gint known_binary_files_types_length1 = 0;
	gint _known_binary_files_types_size_ = 0;
	gboolean _tmp20_ = FALSE;
	GitgDiffViewFileInfo* _tmp21_ = NULL;
	gchar* mime_type_for_image = NULL;
	gboolean _tmp26_ = FALSE;
	GitgDiffViewFileInfo* _tmp27_ = NULL;
	gboolean _tmp49_ = FALSE;
	const gchar* _tmp50_ = NULL;
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data8_->self;
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, 0);
#line 462 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _data8_->cancellable;
#line 462 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ != NULL) {
#line 2018 "gitg-diff-view.c"
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 462 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _data8_->cancellable;
#line 462 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 462 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp3_;
#line 2027 "gitg-diff-view.c"
	} else {
#line 462 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 2031 "gitg-diff-view.c"
	}
#line 462 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 464 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = 1;
#line 464 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 2039 "gitg-diff-view.c"
	}
#line 467 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_file (_data8_->add_file_target);
#line 469 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	info = NULL;
#line 470 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = delta;
#line 470 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = gitg_diff_view_key_for_delta (self, _tmp4_);
#line 470 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	deltakey = _tmp5_;
#line 472 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = _data8_->infomap;
#line 472 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = deltakey;
#line 472 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp6_, _tmp7_);
#line 472 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp8_) {
#line 2059 "gitg-diff-view.c"
		GeeHashMap* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gpointer _tmp11_ = NULL;
#line 474 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp9_ = _data8_->infomap;
#line 474 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp10_ = deltakey;
#line 474 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp10_);
#line 474 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (info);
#line 474 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		info = (GitgDiffViewFileInfo*) _tmp11_;
#line 2073 "gitg-diff-view.c"
	} else {
		GitgRepository* _tmp12_ = NULL;
		GgitDiffDelta* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		GitgDiffViewFileInfo* _tmp15_ = NULL;
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp12_ = self->priv->_repository;
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp13_ = delta;
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp14_ = self->priv->_new_is_workdir;
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = gitg_diff_view_file_info_new (_tmp12_, _tmp13_, _tmp14_);
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (info);
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		info = _tmp15_;
#line 2091 "gitg-diff-view.c"
	}
#line 481 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp16_ = delta;
#line 481 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp17_ = ggit_diff_delta_get_flags (_tmp16_);
#line 481 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->current_is_binary = (_tmp17_ & GGIT_DIFF_FLAG_BINARY) != 0;
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp18_ = g_strdup ("application/pdf");
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp19_ = g_new0 (gchar*, 1 + 1);
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp19_[0] = _tmp18_;
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	known_binary_files_types = _tmp19_;
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	known_binary_files_types_length1 = 1;
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_known_binary_files_types_size_ = known_binary_files_types_length1;
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp21_ = info;
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp21_ != NULL) {
#line 2115 "gitg-diff-view.c"
		GitgDiffViewFileInfo* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gchar** _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp22_ = info;
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp23_ = gitg_diff_view_file_info_get_new_file_content_type (_tmp22_);
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp24_ = _tmp23_;
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp25_ = known_binary_files_types;
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp25__length1 = known_binary_files_types_length1;
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp20_ = _vala_string_array_contains (_tmp25_, _tmp25__length1, _tmp24_);
#line 2133 "gitg-diff-view.c"
	} else {
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp20_ = FALSE;
#line 2137 "gitg-diff-view.c"
	}
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp20_) {
#line 491 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->current_is_binary = TRUE;
#line 2143 "gitg-diff-view.c"
	}
#line 494 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	mime_type_for_image = NULL;
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp27_ = info;
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp27_ == NULL) {
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp26_ = TRUE;
#line 2153 "gitg-diff-view.c"
	} else {
		GitgDiffViewFileInfo* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp28_ = info;
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp29_ = gitg_diff_view_file_info_get_new_file_content_type (_tmp28_);
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp30_ = _tmp29_;
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp26_ = _tmp30_ == NULL;
#line 2166 "gitg-diff-view.c"
	}
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp26_) {
#line 2170 "gitg-diff-view.c"
		gchar* oldpath = NULL;
		GgitDiffDelta* _tmp31_ = NULL;
		GgitDiffFile* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp31_ = delta;
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp32_ = ggit_diff_delta_get_old_file (_tmp31_);
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp33_ = ggit_diff_file_get_path (_tmp32_);
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp34_ = g_strdup (_tmp33_);
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		oldpath = _tmp34_;
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp35_ = oldpath;
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (_tmp35_ != NULL) {
#line 2191 "gitg-diff-view.c"
			gboolean uncertain = FALSE;
			gchar* ctype = NULL;
			const gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			gchar* _tmp38_ = NULL;
			gboolean _tmp39_ = FALSE;
			gchar* _tmp40_ = NULL;
			gchar* _tmp41_ = NULL;
			const gchar* _tmp42_ = NULL;
#line 504 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp36_ = oldpath;
#line 504 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp37_ = g_path_get_basename (_tmp36_);
#line 504 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp38_ = _tmp37_;
#line 504 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp40_ = g_content_type_guess (_tmp38_, NULL, (gsize) 0, &_tmp39_);
#line 504 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			uncertain = _tmp39_;
#line 504 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp41_ = _tmp40_;
#line 504 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_g_free0 (_tmp38_);
#line 504 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			ctype = _tmp41_;
#line 506 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp42_ = ctype;
#line 506 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			if (_tmp42_ != NULL) {
#line 2221 "gitg-diff-view.c"
				const gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
#line 508 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp43_ = ctype;
#line 508 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp44_ = g_content_type_get_mime_type (_tmp43_);
#line 508 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_free0 (mime_type_for_image);
#line 508 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				mime_type_for_image = _tmp44_;
#line 2232 "gitg-diff-view.c"
			}
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_g_free0 (ctype);
#line 2236 "gitg-diff-view.c"
		}
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (oldpath);
#line 2240 "gitg-diff-view.c"
	} else {
		GitgDiffViewFileInfo* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
#line 514 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp45_ = info;
#line 514 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp46_ = gitg_diff_view_file_info_get_new_file_content_type (_tmp45_);
#line 514 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp47_ = _tmp46_;
#line 514 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp48_ = g_content_type_get_mime_type (_tmp47_);
#line 514 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (mime_type_for_image);
#line 514 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		mime_type_for_image = _tmp48_;
#line 2258 "gitg-diff-view.c"
	}
#line 517 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp50_ = mime_type_for_image;
#line 517 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp50_ != NULL) {
#line 2264 "gitg-diff-view.c"
		GeeHashSet* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		gboolean _tmp53_ = FALSE;
#line 517 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp51_ = gitg_diff_view_s_image_mime_types;
#line 517 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp52_ = mime_type_for_image;
#line 517 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp53_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp51_, _tmp52_);
#line 517 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp49_ = _tmp53_;
#line 2276 "gitg-diff-view.c"
	} else {
#line 517 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp49_ = FALSE;
#line 2280 "gitg-diff-view.c"
	}
#line 517 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp49_) {
#line 2284 "gitg-diff-view.c"
		GitgRepository* _tmp54_ = NULL;
		GgitDiffDelta* _tmp55_ = NULL;
		GitgDiffViewFile* _tmp56_ = NULL;
#line 519 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp54_ = self->priv->_repository;
#line 519 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp55_ = delta;
#line 519 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp56_ = gitg_diff_view_file_new_image (_tmp54_, _tmp55_);
#line 519 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_object_ref_sink (_tmp56_);
#line 519 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->current_file);
#line 519 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->current_file = _tmp56_;
#line 2300 "gitg-diff-view.c"
	} else {
#line 521 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (_data8_->current_is_binary) {
#line 2304 "gitg-diff-view.c"
			GitgRepository* _tmp57_ = NULL;
			GgitDiffDelta* _tmp58_ = NULL;
			GitgDiffViewFile* _tmp59_ = NULL;
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp57_ = self->priv->_repository;
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp58_ = delta;
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp59_ = gitg_diff_view_file_new_binary (_tmp57_, _tmp58_);
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			g_object_ref_sink (_tmp59_);
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_g_object_unref0 (_data8_->current_file);
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_data8_->current_file = _tmp59_;
#line 2320 "gitg-diff-view.c"
		} else {
			GitgDiffViewFileInfo* _tmp60_ = NULL;
			gboolean _tmp61_ = FALSE;
			GitgDiffViewFile* _tmp62_ = NULL;
			GitgDiffViewFileRenderer* _tmp63_ = NULL;
			GitgDiffViewFileRenderer* _tmp64_ = NULL;
			GitgDiffViewFileRenderer* _tmp65_ = NULL;
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp60_ = info;
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp61_ = self->priv->_handle_selection;
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp62_ = gitg_diff_view_file_new_text (_tmp60_, _tmp61_);
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			g_object_ref_sink (_tmp62_);
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_g_object_unref0 (_data8_->current_file);
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_data8_->current_file = _tmp62_;
#line 528 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp63_ = gitg_diff_view_file_get_renderer (_data8_->current_file);
#line 528 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp64_ = _tmp63_;
#line 528 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp65_ = _tmp64_;
#line 528 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			g_object_bind_property_with_closures ((GObject*) self, "highlight", (GObject*) _tmp65_, "highlight", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 528 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_g_object_unref0 (_tmp65_);
#line 2350 "gitg-diff-view.c"
		}
	}
#line 531 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = 0;
#line 531 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_free0 (mime_type_for_image);
#line 531 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	known_binary_files_types = (_vala_array_free (known_binary_files_types, known_binary_files_types_length1, (GDestroyNotify) g_free), NULL);
#line 531 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_free0 (deltakey);
#line 531 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (info);
#line 531 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2365 "gitg-diff-view.c"
}


static gint ____lambda59__ggit_diff_file_callback (GgitDiffDelta* delta, gfloat progress, gpointer self) {
	gint result;
	result = ___lambda59_ (self, delta, progress);
#line 460 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2374 "gitg-diff-view.c"
}


static gint ___lambda60_ (Block8Data* _data8_, GgitDiffDelta* delta, GgitDiffBinary* binary) {
	GitgDiffView* self;
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
#line 534 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data8_->self;
#line 534 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, 0);
#line 534 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (binary != NULL, 0);
#line 536 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _data8_->cancellable;
#line 536 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ != NULL) {
#line 2393 "gitg-diff-view.c"
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 536 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _data8_->cancellable;
#line 536 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 536 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp3_;
#line 2402 "gitg-diff-view.c"
	} else {
#line 536 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 2406 "gitg-diff-view.c"
	}
#line 536 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 538 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = 1;
#line 538 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 2414 "gitg-diff-view.c"
	}
#line 541 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = 0;
#line 541 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2420 "gitg-diff-view.c"
}


static gint ____lambda60__ggit_diff_binary_callback (GgitDiffDelta* delta, GgitDiffBinary* binary, gpointer self) {
	gint result;
	result = ___lambda60_ (self, delta, binary);
#line 460 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2429 "gitg-diff-view.c"
}


static gpointer _ggit_diff_hunk_ref0 (gpointer self) {
#line 557 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return self ? ggit_diff_hunk_ref (self) : NULL;
#line 2436 "gitg-diff-view.c"
}


static gint ___lambda61_ (Block8Data* _data8_, GgitDiffDelta* delta, GgitDiffHunk* hunk) {
	GitgDiffView* self;
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
#line 544 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data8_->self;
#line 544 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, 0);
#line 544 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (hunk != NULL, 0);
#line 545 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _data8_->cancellable;
#line 545 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ != NULL) {
#line 2455 "gitg-diff-view.c"
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 545 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _data8_->cancellable;
#line 545 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 545 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp3_;
#line 2464 "gitg-diff-view.c"
	} else {
#line 545 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 2468 "gitg-diff-view.c"
	}
#line 545 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 547 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = 1;
#line 547 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 2476 "gitg-diff-view.c"
	}
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (!_data8_->current_is_binary) {
#line 2480 "gitg-diff-view.c"
		GgitDiffHunk* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		GgitDiffHunk* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		GgitDiffHunk* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		GgitDiffHunk* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		GgitDiffHunk* _tmp14_ = NULL;
		GgitDiffHunk* _tmp15_ = NULL;
		GeeArrayList* _tmp16_ = NULL;
#line 552 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp4_ = hunk;
#line 552 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp5_ = ggit_diff_hunk_get_old_start (_tmp4_);
#line 552 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp6_ = hunk;
#line 552 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = ggit_diff_hunk_get_old_lines (_tmp6_);
#line 552 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = MAX (_data8_->maxlines, _tmp5_ + _tmp7_);
#line 552 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->maxlines = _tmp8_;
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp9_ = hunk;
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp10_ = ggit_diff_hunk_get_new_start (_tmp9_);
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp11_ = hunk;
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp12_ = ggit_diff_hunk_get_new_lines (_tmp11_);
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp13_ = MAX (_data8_->maxlines, _tmp10_ + _tmp12_);
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->maxlines = _tmp13_;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->add_hunk (_data8_->add_hunk_target);
#line 557 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp14_ = hunk;
#line 557 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = _ggit_diff_hunk_ref0 (_tmp14_);
#line 557 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_ggit_diff_hunk_unref0 (_data8_->current_hunk);
#line 557 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->current_hunk = _tmp15_;
#line 558 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = gee_array_list_new (ggit_diff_line_get_type (), (GBoxedCopyFunc) ggit_diff_line_ref, (GDestroyNotify) ggit_diff_line_unref, NULL, NULL, NULL);
#line 558 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data8_->current_lines);
#line 558 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_->current_lines = _tmp16_;
#line 2534 "gitg-diff-view.c"
	}
#line 561 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = 0;
#line 561 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2540 "gitg-diff-view.c"
}


static gint ____lambda61__ggit_diff_hunk_callback (GgitDiffDelta* delta, GgitDiffHunk* hunk, gpointer self) {
	gint result;
	result = ___lambda61_ (self, delta, hunk);
#line 460 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2549 "gitg-diff-view.c"
}


static gint ___lambda62_ (Block8Data* _data8_, GgitDiffDelta* delta, GgitDiffHunk* hunk, GgitDiffLine* line) {
	GitgDiffView* self;
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data8_->self;
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, 0);
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (hunk != NULL, 0);
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (line != NULL, 0);
#line 565 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _data8_->cancellable;
#line 565 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ != NULL) {
#line 2570 "gitg-diff-view.c"
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 565 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _data8_->cancellable;
#line 565 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 565 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp3_;
#line 2579 "gitg-diff-view.c"
	} else {
#line 565 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 2583 "gitg-diff-view.c"
	}
#line 565 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 567 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = 1;
#line 567 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 2591 "gitg-diff-view.c"
	}
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (!_data8_->current_is_binary) {
#line 2595 "gitg-diff-view.c"
		GgitDiffLine* _tmp4_ = NULL;
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp4_ = line;
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _data8_->current_lines, _tmp4_);
#line 2601 "gitg-diff-view.c"
	}
#line 575 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = 0;
#line 575 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2607 "gitg-diff-view.c"
}


static gint ____lambda62__ggit_diff_line_callback (GgitDiffDelta* delta, GgitDiffHunk* hunk, GgitDiffLine* line, gpointer self) {
	gint result;
	result = ___lambda62_ (self, delta, hunk, line);
#line 460 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2616 "gitg-diff-view.c"
}


static void _gitg_diff_view_auto_update_expanded_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 630 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_auto_update_expanded ((GitgDiffView*) self);
#line 2623 "gitg-diff-view.c"
}


static void gitg_diff_view_update_diff_hunks (GitgDiffView* self, GgitDiff* diff, gboolean preserve_expanded, GeeHashMap* infomap, GCancellable* cancellable) {
	Block8Data* _data8_;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GList* file_widgets = NULL;
	GtkGrid* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	GeeHashSet* was_expanded = NULL;
	GeeHashSet* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	gboolean _tmp25_ = FALSE;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	GitgDiffViewCommitDetails* _tmp29_ = NULL;
	GitgDiffViewCommitDetails* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	GError * _inner_error_ = NULL;
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (diff != NULL);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (infomap != NULL);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_ = g_slice_new0 (Block8Data);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->_ref_count_ = 1;
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->self = g_object_ref (self);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = infomap;
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (_data8_->infomap);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->infomap = _tmp1_;
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = cancellable;
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (_data8_->cancellable);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->cancellable = _tmp3_;
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = gee_array_list_new (GITG_TYPE_DIFF_VIEW_FILE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->files = _tmp4_;
#line 427 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->current_file = NULL;
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->current_hunk = NULL;
#line 429 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->current_lines = NULL;
#line 430 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->current_is_binary = FALSE;
#line 432 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->maxlines = 0;
#line 434 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_hunk = ___lambda57__gitg_diff_view_anon;
#line 434 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_hunk_target = block8_data_ref (_data8_);
#line 434 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_hunk_target_destroy_notify = block8_data_unref;
#line 444 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_file = ___lambda58__gitg_diff_view_anon;
#line 444 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_file_target = block8_data_ref (_data8_);
#line 444 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_file_target_destroy_notify = block8_data_unref;
#line 2702 "gitg-diff-view.c"
	{
		GgitDiff* _tmp5_ = NULL;
#line 460 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp5_ = diff;
#line 460 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		ggit_diff_foreach (_tmp5_, ____lambda59__ggit_diff_file_callback, ____lambda60__ggit_diff_binary_callback, ____lambda61__ggit_diff_hunk_callback, ____lambda62__ggit_diff_line_callback, _data8_, &_inner_error_);
#line 460 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2711 "gitg-diff-view.c"
			goto __catch33_g_error;
		}
	}
	goto __finally33;
	__catch33_g_error:
	{
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_clear_error (&_inner_error_);
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_inner_error_ = NULL;
#line 2722 "gitg-diff-view.c"
	}
	__finally33:
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		block8_data_unref (_data8_);
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data8_ = NULL;
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_clear_error (&_inner_error_);
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return;
#line 2737 "gitg-diff-view.c"
	}
#line 580 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_hunk (_data8_->add_hunk_target);
#line 581 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_->add_file (_data8_->add_file_target);
#line 583 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = self->priv->d_grid_files;
#line 583 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = gtk_container_get_children ((GtkContainer*) _tmp6_);
#line 583 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	file_widgets = _tmp7_;
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	was_expanded = _tmp8_;
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = file_widgets;
#line 2755 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp9_;
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 2763 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 2767 "gitg-diff-view.c"
			{
				GitgDiffViewFile* f = NULL;
				GtkWidget* _tmp10_ = NULL;
				GitgDiffViewFile* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				GitgDiffViewFile* _tmp24_ = NULL;
#line 588 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp10_ = file;
#line 588 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp10_) : NULL);
#line 588 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				f = _tmp11_;
#line 590 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp13_ = preserve_expanded;
#line 590 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp13_) {
#line 2785 "gitg-diff-view.c"
					GitgDiffViewFile* _tmp14_ = NULL;
					gboolean _tmp15_ = FALSE;
					gboolean _tmp16_ = FALSE;
#line 590 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp14_ = f;
#line 590 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp15_ = gitg_diff_view_file_get_expanded (_tmp14_);
#line 590 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp16_ = _tmp15_;
#line 590 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp12_ = _tmp16_;
#line 2797 "gitg-diff-view.c"
				} else {
#line 590 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp12_ = FALSE;
#line 2801 "gitg-diff-view.c"
				}
#line 590 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp12_) {
#line 2805 "gitg-diff-view.c"
					gchar* path = NULL;
					GitgDiffViewFile* _tmp17_ = NULL;
					GgitDiffDelta* _tmp18_ = NULL;
					GgitDiffDelta* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
#line 592 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp17_ = f;
#line 592 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp18_ = gitg_diff_view_file_get_delta (_tmp17_);
#line 592 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp19_ = _tmp18_;
#line 592 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp20_ = gitg_diff_view_primary_path (self, _tmp19_);
#line 592 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					path = _tmp20_;
#line 594 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp21_ = path;
#line 594 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					if (_tmp21_ != NULL) {
#line 2826 "gitg-diff-view.c"
						GeeHashSet* _tmp22_ = NULL;
						const gchar* _tmp23_ = NULL;
#line 596 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp22_ = was_expanded;
#line 596 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp23_ = path;
#line 596 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
#line 2835 "gitg-diff-view.c"
					}
#line 590 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_g_free0 (path);
#line 2839 "gitg-diff-view.c"
				}
#line 600 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp24_ = f;
#line 600 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				gtk_widget_destroy ((GtkWidget*) _tmp24_);
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (f);
#line 2847 "gitg-diff-view.c"
			}
		}
	}
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data8_->files);
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp27_ = _tmp26_;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp27_ <= 1) {
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp25_ = TRUE;
#line 2859 "gitg-diff-view.c"
	} else {
		gboolean _tmp28_ = FALSE;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp28_ = self->priv->_default_collapse_all;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp25_ = !_tmp28_;
#line 2866 "gitg-diff-view.c"
	}
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp29_ = self->priv->d_commit_details;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_commit_details_set_expanded (_tmp29_, _tmp25_);
#line 604 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp30_ = self->priv->d_commit_details;
#line 604 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data8_->files);
#line 604 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp32_ = _tmp31_;
#line 604 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_commit_details_set_expander_visible (_tmp30_, _tmp32_ > 1);
#line 2880 "gitg-diff-view.c"
	{
		gint i = 0;
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		i = 0;
#line 2885 "gitg-diff-view.c"
		{
			gboolean _tmp33_ = FALSE;
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp33_ = TRUE;
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			while (TRUE) {
#line 2892 "gitg-diff-view.c"
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				GitgDiffViewFile* file = NULL;
				gint _tmp38_ = 0;
				gpointer _tmp39_ = NULL;
				gchar* path = NULL;
				GitgDiffViewFile* _tmp40_ = NULL;
				GgitDiffDelta* _tmp41_ = NULL;
				GgitDiffDelta* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				gboolean _tmp44_ = FALSE;
				GitgDiffViewCommitDetails* _tmp45_ = NULL;
				gboolean _tmp46_ = FALSE;
				gboolean _tmp47_ = FALSE;
				GitgDiffViewFile* _tmp53_ = NULL;
				GitgDiffViewFileRendererText* renderer_text = NULL;
				GitgDiffViewFile* _tmp54_ = NULL;
				GitgDiffViewFileRenderer* _tmp55_ = NULL;
				GitgDiffViewFileRenderer* _tmp56_ = NULL;
				GitgDiffViewFileRendererText* _tmp57_ = NULL;
				GitgDiffViewFileRendererText* _tmp58_ = NULL;
				gint _tmp62_ = 0;
				gint _tmp63_ = 0;
				gint _tmp64_ = 0;
				GtkGrid* _tmp66_ = NULL;
				GitgDiffViewFile* _tmp67_ = NULL;
				GitgDiffViewFile* _tmp68_ = NULL;
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (!_tmp33_) {
#line 2923 "gitg-diff-view.c"
					gint _tmp34_ = 0;
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp34_ = i;
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					i = _tmp34_ + 1;
#line 2929 "gitg-diff-view.c"
				}
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp33_ = FALSE;
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp35_ = i;
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data8_->files);
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp37_ = _tmp36_;
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (!(_tmp35_ < _tmp37_)) {
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					break;
#line 2943 "gitg-diff-view.c"
				}
#line 608 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp38_ = i;
#line 608 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _data8_->files, _tmp38_);
#line 608 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				file = (GitgDiffViewFile*) _tmp39_;
#line 609 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp40_ = file;
#line 609 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp41_ = gitg_diff_view_file_get_delta (_tmp40_);
#line 609 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp42_ = _tmp41_;
#line 609 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp43_ = gitg_diff_view_primary_path (self, _tmp42_);
#line 609 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				path = _tmp43_;
#line 611 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp45_ = self->priv->d_commit_details;
#line 611 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp46_ = gitg_diff_view_commit_details_get_expanded (_tmp45_);
#line 611 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp47_ = _tmp46_;
#line 611 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp47_) {
#line 611 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp44_ = TRUE;
#line 2971 "gitg-diff-view.c"
				} else {
					gboolean _tmp48_ = FALSE;
					const gchar* _tmp49_ = NULL;
#line 611 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp49_ = path;
#line 611 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					if (_tmp49_ != NULL) {
#line 2979 "gitg-diff-view.c"
						GeeHashSet* _tmp50_ = NULL;
						const gchar* _tmp51_ = NULL;
						gboolean _tmp52_ = FALSE;
#line 611 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp50_ = was_expanded;
#line 611 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp51_ = path;
#line 611 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp52_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp50_, _tmp51_);
#line 611 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp48_ = _tmp52_;
#line 2991 "gitg-diff-view.c"
					} else {
#line 611 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp48_ = FALSE;
#line 2995 "gitg-diff-view.c"
					}
#line 611 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp44_ = _tmp48_;
#line 2999 "gitg-diff-view.c"
				}
#line 611 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp53_ = file;
#line 611 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				gitg_diff_view_file_set_expanded (_tmp53_, _tmp44_);
#line 613 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp54_ = file;
#line 613 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp55_ = gitg_diff_view_file_get_renderer (_tmp54_);
#line 613 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp56_ = _tmp55_;
#line 613 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp57_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT) ? ((GitgDiffViewFileRendererText*) _tmp56_) : NULL;
#line 613 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp57_ == NULL) {
#line 613 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_g_object_unref0 (_tmp56_);
#line 3017 "gitg-diff-view.c"
				}
#line 613 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				renderer_text = _tmp57_;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp58_ = renderer_text;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp58_ != NULL) {
#line 3025 "gitg-diff-view.c"
					GitgDiffViewFileRendererText* _tmp59_ = NULL;
					GitgDiffViewFileRendererText* _tmp60_ = NULL;
					GitgDiffViewFileRendererText* _tmp61_ = NULL;
#line 617 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp59_ = renderer_text;
#line 617 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					gitg_diff_view_file_renderer_text_set_maxlines (_tmp59_, _data8_->maxlines);
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp60_ = renderer_text;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					g_object_bind_property_with_closures ((GObject*) self, "wrap-lines", (GObject*) _tmp60_, "wrap-lines", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 620 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp61_ = renderer_text;
#line 620 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					g_object_bind_property_with_closures ((GObject*) self, "tab-width", (GObject*) _tmp61_, "tab-width", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 3041 "gitg-diff-view.c"
				}
#line 623 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp62_ = i;
#line 623 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp63_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data8_->files);
#line 623 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp64_ = _tmp63_;
#line 623 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp62_ == (_tmp64_ - 1)) {
#line 3051 "gitg-diff-view.c"
					GitgDiffViewFile* _tmp65_ = NULL;
#line 625 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp65_ = file;
#line 625 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					gtk_widget_set_vexpand ((GtkWidget*) _tmp65_, TRUE);
#line 3057 "gitg-diff-view.c"
				}
#line 628 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp66_ = self->priv->d_grid_files;
#line 628 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp67_ = file;
#line 628 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				gtk_container_add ((GtkContainer*) _tmp66_, (GtkWidget*) _tmp67_);
#line 630 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp68_ = file;
#line 630 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				g_signal_connect_object ((GObject*) _tmp68_, "notify::expanded", (GCallback) _gitg_diff_view_auto_update_expanded_g_object_notify, self, 0);
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (renderer_text);
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_free0 (path);
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (file);
#line 3075 "gitg-diff-view.c"
			}
		}
	}
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (was_expanded);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_list_free0 (file_widgets);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	block8_data_unref (_data8_);
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data8_ = NULL;
#line 3087 "gitg-diff-view.c"
}


static void gitg_diff_view_auto_update_expanded (GitgDiffView* self) {
	GtkGrid* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
#line 634 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 636 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_grid_files;
#line 636 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
#line 3100 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 636 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp1_;
#line 636 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 3108 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 636 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 3112 "gitg-diff-view.c"
			{
				GtkWidget* _tmp2_ = NULL;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
#line 638 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp2_ = file;
#line 638 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp3_ = gitg_diff_view_file_get_expanded (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp2_) : NULL);
#line 638 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp4_ = _tmp3_;
#line 638 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (!_tmp4_) {
#line 640 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					gitg_diff_view_auto_change_expanded (self, FALSE);
#line 641 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_g_list_free0 (file_collection);
#line 641 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					return;
#line 3131 "gitg-diff-view.c"
				}
			}
		}
#line 636 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_list_free0 (file_collection);
#line 3137 "gitg-diff-view.c"
	}
#line 645 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_auto_change_expanded (self, TRUE);
#line 3141 "gitg-diff-view.c"
}


static gboolean ___lambda64_ (GitgDiffView* self) {
	gboolean result = FALSE;
	GtkRevealer* _tmp0_ = NULL;
#line 697 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_reveal_options_timeout = (guint) 0;
#line 698 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_revealer_options;
#line 698 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
#line 699 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 699 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3158 "gitg-diff-view.c"
}


static gboolean ____lambda64__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda64_ ((GitgDiffView*) self);
#line 696 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3167 "gitg-diff-view.c"
}


static gboolean _____lambda65_ (GitgDiffView* self) {
	gboolean result = FALSE;
	GtkRevealer* _tmp0_ = NULL;
#line 715 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_unreveal_options_timeout = (guint) 0;
#line 716 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_revealer_options;
#line 716 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
#line 717 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 717 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3184 "gitg-diff-view.c"
}


static gboolean ______lambda65__gsource_func (gpointer self) {
	gboolean result;
	result = _____lambda65_ ((GitgDiffView*) self);
#line 714 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3193 "gitg-diff-view.c"
}


static void gitg_diff_view_update_hide_show_options (GitgDiffView* self, GdkWindow* window, gint ex, gint ey) {
	void* data = NULL;
	GdkWindow* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	GtkWidget* w = NULL;
	void* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	gint x = 0;
	gint y = 0;
	GtkWidget* _tmp5_ = NULL;
	GtkEventBox* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GtkAllocation alloc = {0};
	GtkAllocation revealer_alloc = {0};
	GtkEventBox* _tmp11_ = NULL;
	GtkAllocation _tmp12_ = {0};
	GtkRevealer* _tmp13_ = NULL;
	GtkAllocation _tmp14_ = {0};
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	GtkRevealer* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
#line 668 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 668 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (window != NULL);
#line 671 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = window;
#line 671 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gdk_window_get_user_data (_tmp0_, &_tmp1_);
#line 671 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	data = _tmp1_;
#line 673 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = data;
#line 673 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp2_) : NULL);
#line 673 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	w = _tmp3_;
#line 675 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = w;
#line 675 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp4_ == NULL) {
#line 677 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (w);
#line 677 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return;
#line 3249 "gitg-diff-view.c"
	}
#line 681 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = w;
#line 681 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = self->priv->d_event_box;
#line 681 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = ex;
#line 681 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ = ey;
#line 681 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_translate_coordinates (_tmp5_, (GtkWidget*) _tmp6_, _tmp7_, _tmp8_, &_tmp9_, &_tmp10_);
#line 681 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	x = _tmp9_;
#line 681 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	y = _tmp10_;
#line 685 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp11_ = self->priv->d_event_box;
#line 685 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_get_allocation ((GtkWidget*) _tmp11_, &_tmp12_);
#line 685 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	alloc = _tmp12_;
#line 686 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp13_ = self->priv->d_revealer_options;
#line 686 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_get_allocation ((GtkWidget*) _tmp13_, &_tmp14_);
#line 686 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	revealer_alloc = _tmp14_;
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp18_ = self->priv->d_revealer_options;
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp19_ = gtk_revealer_get_reveal_child (_tmp18_);
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp20_ = _tmp19_;
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (!_tmp20_) {
#line 3285 "gitg-diff-view.c"
		gint _tmp21_ = 0;
		GtkAllocation _tmp22_ = {0};
		gint _tmp23_ = 0;
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp21_ = y;
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp22_ = alloc;
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp23_ = _tmp22_.height;
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp17_ = _tmp21_ >= (_tmp23_ - 18);
#line 3297 "gitg-diff-view.c"
	} else {
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp17_ = FALSE;
#line 3301 "gitg-diff-view.c"
	}
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp17_) {
#line 3305 "gitg-diff-view.c"
		gint _tmp24_ = 0;
		GtkAllocation _tmp25_ = {0};
		gint _tmp26_ = 0;
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp24_ = x;
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp25_ = alloc;
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp26_ = _tmp25_.width;
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = _tmp24_ >= (_tmp26_ - 150);
#line 3317 "gitg-diff-view.c"
	} else {
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = FALSE;
#line 3321 "gitg-diff-view.c"
	}
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp16_) {
#line 3325 "gitg-diff-view.c"
		guint _tmp27_ = 0U;
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp27_ = self->priv->d_reveal_options_timeout;
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = _tmp27_ == ((guint) 0);
#line 3331 "gitg-diff-view.c"
	} else {
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = FALSE;
#line 3335 "gitg-diff-view.c"
	}
#line 688 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp15_) {
#line 3339 "gitg-diff-view.c"
		guint _tmp28_ = 0U;
		guint _tmp30_ = 0U;
#line 690 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp28_ = self->priv->d_unreveal_options_timeout;
#line 690 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (_tmp28_ != ((guint) 0)) {
#line 3346 "gitg-diff-view.c"
			guint _tmp29_ = 0U;
#line 692 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp29_ = self->priv->d_unreveal_options_timeout;
#line 692 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			g_source_remove (_tmp29_);
#line 693 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			self->priv->d_unreveal_options_timeout = (guint) 0;
#line 3354 "gitg-diff-view.c"
		}
#line 696 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp30_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, ____lambda64__gsource_func, g_object_ref (self), g_object_unref);
#line 696 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_reveal_options_timeout = _tmp30_;
#line 3360 "gitg-diff-view.c"
	} else {
		GtkRevealer* _tmp31_ = NULL;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
#line 702 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp31_ = self->priv->d_revealer_options;
#line 702 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp32_ = gtk_revealer_get_reveal_child (_tmp31_);
#line 702 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp33_ = _tmp32_;
#line 702 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (_tmp33_) {
#line 3373 "gitg-diff-view.c"
			gboolean above = FALSE;
			gint _tmp34_ = 0;
			GtkAllocation _tmp35_ = {0};
			gint _tmp36_ = 0;
			GtkAllocation _tmp37_ = {0};
			gint _tmp38_ = 0;
			gboolean _tmp39_ = FALSE;
			gboolean _tmp40_ = FALSE;
#line 704 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp34_ = y;
#line 704 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp35_ = alloc;
#line 704 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp36_ = _tmp35_.height;
#line 704 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp37_ = revealer_alloc;
#line 704 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp38_ = _tmp37_.height;
#line 704 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			above = _tmp34_ <= ((_tmp36_ - 6) - _tmp38_);
#line 706 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp40_ = above;
#line 706 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			if (_tmp40_) {
#line 3398 "gitg-diff-view.c"
				guint _tmp41_ = 0U;
#line 706 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp41_ = self->priv->d_unreveal_options_timeout;
#line 706 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp39_ = _tmp41_ == ((guint) 0);
#line 3404 "gitg-diff-view.c"
			} else {
#line 706 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp39_ = FALSE;
#line 3408 "gitg-diff-view.c"
			}
#line 706 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			if (_tmp39_) {
#line 3412 "gitg-diff-view.c"
				guint _tmp42_ = 0U;
				guint _tmp44_ = 0U;
#line 708 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp42_ = self->priv->d_reveal_options_timeout;
#line 708 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp42_ != ((guint) 0)) {
#line 3419 "gitg-diff-view.c"
					guint _tmp43_ = 0U;
#line 710 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp43_ = self->priv->d_reveal_options_timeout;
#line 710 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					g_source_remove (_tmp43_);
#line 711 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					self->priv->d_reveal_options_timeout = (guint) 0;
#line 3427 "gitg-diff-view.c"
				}
#line 714 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp44_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, ______lambda65__gsource_func, g_object_ref (self), g_object_unref);
#line 714 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				self->priv->d_unreveal_options_timeout = _tmp44_;
#line 3433 "gitg-diff-view.c"
			} else {
				gboolean _tmp45_ = FALSE;
				gboolean _tmp46_ = FALSE;
#line 720 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp46_ = above;
#line 720 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (!_tmp46_) {
#line 3441 "gitg-diff-view.c"
					guint _tmp47_ = 0U;
#line 720 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp47_ = self->priv->d_unreveal_options_timeout;
#line 720 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp45_ = _tmp47_ != ((guint) 0);
#line 3447 "gitg-diff-view.c"
				} else {
#line 720 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp45_ = FALSE;
#line 3451 "gitg-diff-view.c"
				}
#line 720 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp45_) {
#line 3455 "gitg-diff-view.c"
					guint _tmp48_ = 0U;
#line 722 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp48_ = self->priv->d_unreveal_options_timeout;
#line 722 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					g_source_remove (_tmp48_);
#line 723 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					self->priv->d_unreveal_options_timeout = (guint) 0;
#line 3463 "gitg-diff-view.c"
				}
			}
		}
	}
#line 668 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (w);
#line 3470 "gitg-diff-view.c"
}


static gboolean gitg_diff_view_leave_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventCrossing* event) {
	gboolean result = FALSE;
	GdkEventCrossing* _tmp0_ = NULL;
	GdkWindow* _tmp1_ = NULL;
	GdkEventCrossing* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	GdkEventCrossing* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
#line 729 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 729 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 729 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 731 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = event;
#line 731 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_->window;
#line 731 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = event;
#line 731 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_->x;
#line 731 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = event;
#line 731 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = _tmp4_->y;
#line 731 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update_hide_show_options (self, _tmp1_, (gint) _tmp3_, (gint) _tmp5_);
#line 732 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 732 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3506 "gitg-diff-view.c"
}


static gboolean _gitg_diff_view_leave_notify_event_on_event_box_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = gitg_diff_view_leave_notify_event_on_event_box ((GitgDiffView*) self, _sender, event);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3515 "gitg-diff-view.c"
}


static gboolean gitg_diff_view_enter_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventCrossing* event) {
	gboolean result = FALSE;
	GdkEventCrossing* _tmp0_ = NULL;
	GdkWindow* _tmp1_ = NULL;
	GdkEventCrossing* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	GdkEventCrossing* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
#line 736 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 736 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 736 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 738 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = event;
#line 738 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_->window;
#line 738 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = event;
#line 738 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_->x;
#line 738 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = event;
#line 738 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = _tmp4_->y;
#line 738 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update_hide_show_options (self, _tmp1_, (gint) _tmp3_, (gint) _tmp5_);
#line 739 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 739 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3551 "gitg-diff-view.c"
}


static gboolean _gitg_diff_view_enter_notify_event_on_event_box_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = gitg_diff_view_enter_notify_event_on_event_box ((GitgDiffView*) self, _sender, event);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3560 "gitg-diff-view.c"
}


static gboolean gitg_diff_view_motion_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventMotion* event) {
	gboolean result = FALSE;
	GdkEventMotion* _tmp0_ = NULL;
	GdkWindow* _tmp1_ = NULL;
	GdkEventMotion* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	GdkEventMotion* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
#line 743 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 743 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 743 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 745 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = event;
#line 745 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_->window;
#line 745 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = event;
#line 745 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_->x;
#line 745 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = event;
#line 745 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = _tmp4_->y;
#line 745 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update_hide_show_options (self, _tmp1_, (gint) _tmp3_, (gint) _tmp5_);
#line 746 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 746 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3596 "gitg-diff-view.c"
}


GitgDiffView* gitg_diff_view_construct (GType object_type) {
	GitgDiffView * self = NULL;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = (GitgDiffView*) g_object_new (object_type, NULL);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return self;
#line 3606 "gitg-diff-view.c"
}


GitgDiffView* gitg_diff_view_new (void) {
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return gitg_diff_view_construct (GITG_TYPE_DIFF_VIEW);
#line 3613 "gitg-diff-view.c"
}


GgitDiffOptions* gitg_diff_view_get_options (GitgDiffView* self) {
	GgitDiffOptions* result;
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp2_ = NULL;
#line 59 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_options;
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ == NULL) {
#line 3627 "gitg-diff-view.c"
		GgitDiffOptions* _tmp1_ = NULL;
#line 63 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp1_ = ggit_diff_options_new ();
#line 63 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_options);
#line 63 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_options = _tmp1_;
#line 3635 "gitg-diff-view.c"
	}
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = self->priv->d_options;
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp2_;
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3643 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_has_selection (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 72 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 72 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_has_selection;
#line 72 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 72 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3658 "gitg-diff-view.c"
}


static void gitg_diff_view_set_has_selection (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 72 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 72 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 72 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_has_selection = _tmp0_;
#line 72 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "has-selection");
#line 3672 "gitg-diff-view.c"
}


GgitDiff* gitg_diff_view_get_diff (GitgDiffView* self) {
	GgitDiff* result;
	GgitDiff* _tmp0_ = NULL;
#line 77 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 77 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_diff;
#line 77 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 77 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3687 "gitg-diff-view.c"
}


void gitg_diff_view_set_diff (GitgDiffView* self, GgitDiff* value) {
	GgitDiff* _tmp0_ = NULL;
	GgitDiff* _tmp1_ = NULL;
#line 78 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 80 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_diff;
#line 80 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = value;
#line 80 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != _tmp1_) {
#line 3702 "gitg-diff-view.c"
		GgitDiff* _tmp2_ = NULL;
		GgitDiff* _tmp3_ = NULL;
#line 82 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = value;
#line 82 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 82 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_diff);
#line 82 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_diff = _tmp3_;
#line 83 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_commit);
#line 83 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_commit = NULL;
#line 3717 "gitg-diff-view.c"
	}
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update (self, FALSE);
#line 78 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "diff");
#line 3723 "gitg-diff-view.c"
}


GitgCommit* gitg_diff_view_get_commit (GitgDiffView* self) {
	GitgCommit* result;
	GitgCommit* _tmp0_ = NULL;
#line 92 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 92 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit;
#line 92 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 92 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3738 "gitg-diff-view.c"
}


void gitg_diff_view_set_commit (GitgDiffView* self, GitgCommit* value) {
	GitgCommit* _tmp0_ = NULL;
	GitgCommit* _tmp1_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 95 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit;
#line 95 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = value;
#line 95 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != _tmp1_) {
#line 3753 "gitg-diff-view.c"
		GitgCommit* _tmp2_ = NULL;
		GitgCommit* _tmp3_ = NULL;
#line 97 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = value;
#line 97 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 97 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_commit);
#line 97 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_commit = _tmp3_;
#line 98 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_diff);
#line 98 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_diff = NULL;
#line 3768 "gitg-diff-view.c"
	}
#line 101 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update (self, FALSE);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "commit");
#line 3774 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_wrap_lines (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_wrap_lines;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3789 "gitg-diff-view.c"
}


void gitg_diff_view_set_wrap_lines (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_wrap_lines = _tmp0_;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "wrap-lines");
#line 3803 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_staged (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_staged;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3818 "gitg-diff-view.c"
}


void gitg_diff_view_set_staged (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_staged = _tmp0_;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "staged");
#line 3832 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_unstaged (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_unstaged;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3847 "gitg-diff-view.c"
}


void gitg_diff_view_set_unstaged (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_unstaged = _tmp0_;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "unstaged");
#line 3861 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_show_parents (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_show_parents;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3876 "gitg-diff-view.c"
}


void gitg_diff_view_set_show_parents (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_show_parents = _tmp0_;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "show-parents");
#line 3890 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_default_collapse_all (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_default_collapse_all;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3905 "gitg-diff-view.c"
}


void gitg_diff_view_set_default_collapse_all (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_default_collapse_all = _tmp0_;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "default-collapse-all");
#line 3919 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_use_gravatar (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_use_gravatar;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3934 "gitg-diff-view.c"
}


void gitg_diff_view_set_use_gravatar (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_use_gravatar = _tmp0_;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "use-gravatar");
#line 3948 "gitg-diff-view.c"
}


gint gitg_diff_view_get_tab_width (GitgDiffView* self) {
	gint result;
	gint _tmp0_ = 0;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_tab_width;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3963 "gitg-diff-view.c"
}


void gitg_diff_view_set_tab_width (GitgDiffView* self, gint value) {
	gint _tmp0_ = 0;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_tab_width = _tmp0_;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "tab-width");
#line 3977 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_handle_selection (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_handle_selection;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3992 "gitg-diff-view.c"
}


void gitg_diff_view_set_handle_selection (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_handle_selection = _tmp0_;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "handle-selection");
#line 4006 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_highlight (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_highlight;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 4021 "gitg-diff-view.c"
}


void gitg_diff_view_set_highlight (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_highlight = _tmp0_;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "highlight");
#line 4035 "gitg-diff-view.c"
}


GitgRepository* gitg_diff_view_get_repository (GitgDiffView* self) {
	GitgRepository* result;
	GitgRepository* _tmp0_ = NULL;
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_repository;
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 4050 "gitg-diff-view.c"
}


void gitg_diff_view_set_repository (GitgDiffView* self, GitgRepository* value) {
	GitgRepository* _tmp0_ = NULL;
	GitgRepository* _tmp1_ = NULL;
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->_repository);
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_repository = _tmp1_;
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "repository");
#line 4069 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_new_is_workdir (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_new_is_workdir;
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 4084 "gitg-diff-view.c"
}


void gitg_diff_view_set_new_is_workdir (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_new_is_workdir = _tmp0_;
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "new-is-workdir");
#line 4098 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_ignore_whitespace (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 152 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 152 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_flag_get (self, GGIT_DIFF_IGNORE_WHITESPACE);
#line 152 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 152 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 4113 "gitg-diff-view.c"
}


void gitg_diff_view_set_ignore_whitespace (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 153 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 153 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 153 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_flag_set (self, GGIT_DIFF_IGNORE_WHITESPACE, _tmp0_);
#line 153 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "ignore-whitespace");
#line 4127 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_changes_inline (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 158 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 158 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_changes_inline;
#line 158 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 158 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 4142 "gitg-diff-view.c"
}


void gitg_diff_view_set_changes_inline (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_changes_inline;
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = value;
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != _tmp1_) {
#line 4157 "gitg-diff-view.c"
		gboolean _tmp2_ = FALSE;
#line 163 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = value;
#line 163 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_changes_inline = _tmp2_;
#line 4163 "gitg-diff-view.c"
	}
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "changes-inline");
#line 4167 "gitg-diff-view.c"
}


gint gitg_diff_view_get_context_lines (GitgDiffView* self) {
	gint result;
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 173 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 173 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_get_options (self);
#line 173 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_;
#line 173 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = ggit_diff_options_get_n_context_lines (_tmp1_);
#line 173 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_;
#line 173 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp3_;
#line 173 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 4191 "gitg-diff-view.c"
}


void gitg_diff_view_set_context_lines (GitgDiffView* self, gint value) {
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 175 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_get_options (self);
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = ggit_diff_options_get_n_context_lines (_tmp1_);
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = value;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp3_ != _tmp4_) {
#line 4215 "gitg-diff-view.c"
		GgitDiffOptions* _tmp5_ = NULL;
		GgitDiffOptions* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		GgitDiffOptions* _tmp8_ = NULL;
		GgitDiffOptions* _tmp9_ = NULL;
		gint _tmp10_ = 0;
#line 179 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp5_ = gitg_diff_view_get_options (self);
#line 179 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp6_ = _tmp5_;
#line 179 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = value;
#line 179 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		ggit_diff_options_set_n_context_lines (_tmp6_, _tmp7_);
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = gitg_diff_view_get_options (self);
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp9_ = _tmp8_;
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp10_ = value;
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		ggit_diff_options_set_n_interhunk_lines (_tmp9_, _tmp10_);
#line 182 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_signal_emit_by_name (self, "options-changed");
#line 4240 "gitg-diff-view.c"
	}
#line 175 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "context-lines");
#line 4244 "gitg-diff-view.c"
}


static void _vala_array_add2 (GitgPatchSet*** array, int* length, int* size, GitgPatchSet* value) {
#line 660 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if ((*length) == (*size)) {
#line 660 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 660 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		*array = g_renew (GitgPatchSet*, *array, (*size) + 1);
#line 4255 "gitg-diff-view.c"
	}
#line 660 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	(*array)[(*length)++] = value;
#line 660 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	(*array)[*length] = NULL;
#line 4261 "gitg-diff-view.c"
}


GitgPatchSet** gitg_diff_view_get_selection (GitgDiffView* self, int* result_length1) {
	GitgPatchSet** result;
	GitgPatchSet** ret = NULL;
	GitgPatchSet** _tmp0_ = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	GtkGrid* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GitgPatchSet** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
#line 650 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 652 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = g_new0 (GitgPatchSet*, 0 + 1);
#line 652 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	ret = _tmp0_;
#line 652 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	ret_length1 = 0;
#line 652 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_ret_size_ = ret_length1;
#line 654 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = self->priv->d_grid_files;
#line 654 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
#line 4289 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 654 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp2_;
#line 654 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 4297 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 654 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 4301 "gitg-diff-view.c"
			{
				GitgDiffSelectable* sel = NULL;
				GtkWidget* _tmp3_ = NULL;
				GitgDiffViewFileRenderer* _tmp4_ = NULL;
				GitgDiffViewFileRenderer* _tmp5_ = NULL;
				GitgDiffSelectable* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				GitgDiffSelectable* _tmp9_ = NULL;
#line 656 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp3_ = file;
#line 656 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp4_ = gitg_diff_view_file_get_renderer (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp3_) : NULL);
#line 656 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp5_ = _tmp4_;
#line 656 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GITG_TYPE_DIFF_SELECTABLE) ? ((GitgDiffSelectable*) _tmp5_) : NULL;
#line 656 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp6_ == NULL) {
#line 656 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_g_object_unref0 (_tmp5_);
#line 4323 "gitg-diff-view.c"
				}
#line 656 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				sel = _tmp6_;
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp9_ = sel;
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp9_ != NULL) {
#line 4331 "gitg-diff-view.c"
					GitgDiffSelectable* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp10_ = sel;
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp11_ = gitg_diff_selectable_get_has_selection (_tmp10_);
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp12_ = _tmp11_;
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp8_ = _tmp12_;
#line 4343 "gitg-diff-view.c"
				} else {
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp8_ = FALSE;
#line 4347 "gitg-diff-view.c"
				}
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp8_) {
#line 4351 "gitg-diff-view.c"
					GitgDiffSelectable* _tmp13_ = NULL;
					GitgPatchSet* _tmp14_ = NULL;
					GitgPatchSet* _tmp15_ = NULL;
					GitgPatchSet* _tmp16_ = NULL;
					GitgPatchSetPatch* _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp13_ = sel;
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp14_ = gitg_diff_selectable_get_selection (_tmp13_);
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp15_ = _tmp14_;
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp16_ = _tmp15_;
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp17_ = _tmp16_->patches;
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp17__length1 = _tmp16_->patches_length1;
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp7_ = _tmp17__length1 != 0;
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_gitg_patch_set_unref0 (_tmp16_);
#line 4374 "gitg-diff-view.c"
				} else {
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp7_ = FALSE;
#line 4378 "gitg-diff-view.c"
				}
#line 658 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp7_) {
#line 4382 "gitg-diff-view.c"
					GitgPatchSet** _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					GitgDiffSelectable* _tmp19_ = NULL;
					GitgPatchSet* _tmp20_ = NULL;
					GitgPatchSet* _tmp21_ = NULL;
#line 660 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp18_ = ret;
#line 660 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp18__length1 = ret_length1;
#line 660 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp19_ = sel;
#line 660 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp20_ = gitg_diff_selectable_get_selection (_tmp19_);
#line 660 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp21_ = _tmp20_;
#line 660 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_vala_array_add2 (&ret, &ret_length1, &_ret_size_, _tmp21_);
#line 4400 "gitg-diff-view.c"
				}
#line 654 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (sel);
#line 4404 "gitg-diff-view.c"
			}
		}
#line 654 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_list_free0 (file_collection);
#line 4409 "gitg-diff-view.c"
	}
#line 664 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp22_ = ret;
#line 664 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp22__length1 = ret_length1;
#line 664 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (result_length1) {
#line 664 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		*result_length1 = _tmp22__length1;
#line 4419 "gitg-diff-view.c"
	}
#line 664 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp22_;
#line 664 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 4425 "gitg-diff-view.c"
}


static void gitg_diff_view_real_options_changed (GitgDiffView* self) {
	GitgCommit* _tmp0_ = NULL;
#line 107 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit;
#line 107 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != NULL) {
#line 109 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_update (self, TRUE);
#line 4437 "gitg-diff-view.c"
	}
}


static void gitg_diff_view_class_init (GitgDiffViewClass * klass) {
	gint GitgDiffView_private_offset;
	GeeHashSet* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_type_class_add_private (klass, sizeof (GitgDiffViewPrivate));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	((GObjectClass *) klass)->constructed = (void (*)(GObject*)) gitg_diff_view_real_constructed;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	((GObjectClass *) klass)->dispose = (void (*)(GObject*)) gitg_diff_view_real_dispose;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	((GitgDiffViewClass *) klass)->options_changed = gitg_diff_view_real_options_changed;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_diff_view_get_property;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_diff_view_set_property;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_diff_view_finalize;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_OPTIONS, g_param_spec_object ("options", "options", "options", ggit_diff_options_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_HAS_SELECTION, g_param_spec_boolean ("has-selection", "has-selection", "has-selection", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_DIFF, g_param_spec_object ("diff", "diff", "diff", ggit_diff_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_COMMIT, g_param_spec_object ("commit", "commit", "commit", GITG_TYPE_COMMIT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_WRAP_LINES, g_param_spec_boolean ("wrap-lines", "wrap-lines", "wrap-lines", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_STAGED, g_param_spec_boolean ("staged", "staged", "staged", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_UNSTAGED, g_param_spec_boolean ("unstaged", "unstaged", "unstaged", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_SHOW_PARENTS, g_param_spec_boolean ("show-parents", "show-parents", "show-parents", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL, g_param_spec_boolean ("default-collapse-all", "default-collapse-all", "default-collapse-all", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_USE_GRAVATAR, g_param_spec_boolean ("use-gravatar", "use-gravatar", "use-gravatar", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_TAB_WIDTH, g_param_spec_int ("tab-width", "tab-width", "tab-width", G_MININT, G_MAXINT, 4, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_HANDLE_SELECTION, g_param_spec_boolean ("handle-selection", "handle-selection", "handle-selection", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_HIGHLIGHT, g_param_spec_boolean ("highlight", "highlight", "highlight", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_REPOSITORY, g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_NEW_IS_WORKDIR, g_param_spec_boolean ("new-is-workdir", "new-is-workdir", "new-is-workdir", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_IGNORE_WHITESPACE, g_param_spec_boolean ("ignore-whitespace", "ignore-whitespace", "ignore-whitespace", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_CHANGES_INLINE, g_param_spec_boolean ("changes-inline", "changes-inline", "changes-inline", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_CONTEXT_LINES, g_param_spec_int ("context-lines", "context-lines", "context-lines", G_MININT, G_MAXINT, 3, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	GitgDiffView_private_offset = g_type_class_get_instance_private_offset (klass);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-diff-view.ui");
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_signal_new ("options_changed", GITG_TYPE_DIFF_VIEW, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgDiffViewClass, options_changed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "commit_details", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_commit_details));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scrolledwindow", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_scrolledwindow));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid_files", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_grid_files));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "event_box", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_event_box));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "revealer_options", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_revealer_options));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "diff_view_options", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_diff_view_options));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_view_message", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_text_view_message));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "leave_notify_event_on_event_box", G_CALLBACK(_gitg_diff_view_leave_notify_event_on_event_box_gtk_widget_leave_notify_event));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "enter_notify_event_on_event_box", G_CALLBACK(_gitg_diff_view_enter_notify_event_on_event_box_gtk_widget_enter_notify_event));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "motion_notify_event_on_event_box", G_CALLBACK(_gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event));
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (gitg_diff_view_s_image_mime_types);
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_s_image_mime_types = _tmp0_;
#line 231 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = gdk_pixbuf_get_formats ();
#line 4533 "gitg-diff-view.c"
	{
		GSList* format_collection = NULL;
		GSList* format_it = NULL;
#line 231 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		format_collection = _tmp1_;
#line 231 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		for (format_it = format_collection; format_it != NULL; format_it = format_it->next) {
#line 4541 "gitg-diff-view.c"
			GdkPixbufFormat* format = NULL;
#line 231 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			format = (GdkPixbufFormat*) format_it->data;
#line 4545 "gitg-diff-view.c"
			{
				GdkPixbufFormat* _tmp2_ = NULL;
				gchar** _tmp3_ = NULL;
				gchar** _tmp4_ = NULL;
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp2_ = format;
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp4_ = _tmp3_ = gdk_pixbuf_format_get_mime_types (_tmp2_);
#line 4554 "gitg-diff-view.c"
				{
					gchar** mime_type_collection = NULL;
					gint mime_type_collection_length1 = 0;
					gint _mime_type_collection_size_ = 0;
					gint mime_type_it = 0;
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					mime_type_collection = _tmp4_;
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					mime_type_collection_length1 = _vala_array_length (_tmp3_);
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					for (mime_type_it = 0; mime_type_it < _vala_array_length (_tmp3_); mime_type_it = mime_type_it + 1) {
#line 4566 "gitg-diff-view.c"
						gchar* _tmp5_ = NULL;
						gchar* mime_type = NULL;
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp5_ = g_strdup (mime_type_collection[mime_type_it]);
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						mime_type = _tmp5_;
#line 4573 "gitg-diff-view.c"
						{
							GeeHashSet* _tmp6_ = NULL;
							const gchar* _tmp7_ = NULL;
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							_tmp6_ = gitg_diff_view_s_image_mime_types;
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							_tmp7_ = mime_type;
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp7_);
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							_g_free0 (mime_type);
#line 4585 "gitg-diff-view.c"
						}
					}
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					mime_type_collection = (_vala_array_free (mime_type_collection, mime_type_collection_length1, (GDestroyNotify) g_free), NULL);
#line 4590 "gitg-diff-view.c"
				}
			}
		}
#line 231 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_slist_free0 (format_collection);
#line 4596 "gitg-diff-view.c"
	}
	{
		GRegex* _tmp8_ = NULL;
		GRegex* _tmp9_ = NULL;
		GRegex* _tmp10_ = NULL;
#line 241 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp9_ = g_regex_new (".*[\\R\\s]*(?P<message>(?:.|\\R)*?)\\s*$", 0, 0, &_inner_error_);
#line 241 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = _tmp9_;
#line 241 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4608 "gitg-diff-view.c"
			goto __catch34_g_error;
		}
#line 241 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp10_ = _tmp8_;
#line 241 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = NULL;
#line 241 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_regex_unref0 (gitg_diff_view_s_message_regexp);
#line 241 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_s_message_regexp = _tmp10_;
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_regex_unref0 (_tmp8_);
#line 4621 "gitg-diff-view.c"
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* e = NULL;
		FILE* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		e = _inner_error_;
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_inner_error_ = NULL;
#line 242 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp11_ = stderr;
#line 242 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp12_ = e;
#line 242 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp13_ = _tmp12_->message;
#line 242 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp14_ = string_to_string (_tmp13_);
#line 242 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = g_strconcat ("Failed to compile regex: ", _tmp14_, "\n", NULL);
#line 242 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = _tmp15_;
#line 242 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		fprintf (_tmp11_, "%s", _tmp16_);
#line 242 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (_tmp16_);
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_error_free0 (e);
#line 4655 "gitg-diff-view.c"
	}
	__finally34:
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_clear_error (&_inner_error_);
#line 4664 "gitg-diff-view.c"
	}
}


static void gitg_diff_view_instance_init (GitgDiffView * self) {
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv = GITG_DIFF_VIEW_GET_PRIVATE (self);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_wrap_lines = TRUE;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_staged = FALSE;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_unstaged = FALSE;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_show_parents = FALSE;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_default_collapse_all = TRUE;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_use_gravatar = TRUE;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_tab_width = 4;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_handle_selection = FALSE;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_highlight = TRUE;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_type_ensure (GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_type_ensure (GITG_TYPE_DIFF_VIEW_OPTIONS);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 4696 "gitg-diff-view.c"
}


static void gitg_diff_view_finalize (GObject* obj) {
	GitgDiffView * self;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_VIEW, GitgDiffView);
#line 24 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_commit_details);
#line 27 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_scrolledwindow);
#line 30 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_grid_files);
#line 33 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_event_box);
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_revealer_options);
#line 39 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_diff_view_options);
#line 42 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_text_view_message);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_diff);
#line 45 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_commit);
#line 46 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_options);
#line 47 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_cancellable);
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->_repository);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (gitg_diff_view_parent_class)->finalize (obj);
#line 4730 "gitg-diff-view.c"
}


GType gitg_diff_view_get_type (void) {
	static volatile gsize gitg_diff_view_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_diff_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgDiffViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_diff_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDiffView), 0, (GInstanceInitFunc) gitg_diff_view_instance_init, NULL };
		GType gitg_diff_view_type_id;
		gitg_diff_view_type_id = g_type_register_static (gtk_grid_get_type (), "GitgDiffView", &g_define_type_info, 0);
		g_once_init_leave (&gitg_diff_view_type_id__volatile, gitg_diff_view_type_id);
	}
	return gitg_diff_view_type_id__volatile;
}


static void _vala_gitg_diff_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgDiffView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW, GitgDiffView);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	switch (property_id) {
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_OPTIONS:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_object (value, gitg_diff_view_get_options (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HAS_SELECTION:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_has_selection (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_DIFF:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_object (value, gitg_diff_view_get_diff (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_COMMIT:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_object (value, gitg_diff_view_get_commit (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_WRAP_LINES:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_wrap_lines (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_STAGED:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_staged (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_UNSTAGED:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_unstaged (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_SHOW_PARENTS:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_show_parents (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_default_collapse_all (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_USE_GRAVATAR:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_use_gravatar (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_TAB_WIDTH:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_int (value, gitg_diff_view_get_tab_width (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HANDLE_SELECTION:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_handle_selection (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HIGHLIGHT:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_highlight (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_REPOSITORY:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_object (value, gitg_diff_view_get_repository (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_NEW_IS_WORKDIR:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_new_is_workdir (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_IGNORE_WHITESPACE:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_ignore_whitespace (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_CHANGES_INLINE:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_changes_inline (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_CONTEXT_LINES:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_int (value, gitg_diff_view_get_context_lines (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 4859 "gitg-diff-view.c"
		default:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 4865 "gitg-diff-view.c"
	}
}


static void _vala_gitg_diff_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgDiffView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW, GitgDiffView);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	switch (property_id) {
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HAS_SELECTION:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_has_selection (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_DIFF:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_diff (self, g_value_get_object (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_COMMIT:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_commit (self, g_value_get_object (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_WRAP_LINES:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_wrap_lines (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_STAGED:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_staged (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_UNSTAGED:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_unstaged (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_SHOW_PARENTS:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_show_parents (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_default_collapse_all (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_USE_GRAVATAR:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_use_gravatar (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_TAB_WIDTH:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_tab_width (self, g_value_get_int (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HANDLE_SELECTION:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_handle_selection (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HIGHLIGHT:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_highlight (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_REPOSITORY:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_repository (self, g_value_get_object (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_NEW_IS_WORKDIR:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_new_is_workdir (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_IGNORE_WHITESPACE:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_ignore_whitespace (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_CHANGES_INLINE:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_changes_inline (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_CONTEXT_LINES:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_context_lines (self, g_value_get_int (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 4977 "gitg-diff-view.c"
		default:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 4983 "gitg-diff-view.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



