#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "ppport.h"
#include <string.h>
#include "words.h"

#ifndef U64
typedef uint64_t U64;
#endif

/* Macro for choosing the ending corresponding to the specified value */
#define ending4value(value)                                          \
	((value) % 100 / 10 - 1) && (value) % 10 > 0 && (value) % 10 < 5 \
		? (value) % 10 > 1 ? COUPLE : SINGLE : SEVERAL

SV *
kopek2words(U8 value, bool words) {
	U8 ending = ending4value(value);
	SV *value_pv = sv_2mortal(newSVpvs(""));
	if (words) {
		if (value % 100 > 20) {
			sv_catpvn(value_pv, tens[value % 100 / 10], strlen(tens[value % 100 / 10]));
			sv_catpvn(value_pv, units[value % 10], strlen(units[value % 10]));
		} else {
			sv_catpvn(value_pv, units[value % 100], strlen(units[value % 100]));
		}
	} else {
		char value_str[4];
		sprintf(value_str, "%02d ", value);
		sv_catpvn(value_pv, value_str, strlen(value_str));
	}
	sv_catpvn(value_pv, kopek[ending], strlen(kopek[ending]));
	return value_pv;
}

SV *
ruble2words(U16 value, U8 order, bool words) {
	U8 ending = ending4value(value);
	SV *value_pv = sv_2mortal(newSVpvs(""));
	if (!value) {
		if (!order)
			sv_catpvn(value_pv, ruble[order][ending], strlen(ruble[order][ending]));
		return value_pv;
	}
	if (words) {
		sv_catpvn(value_pv, hundreds[value / 100], strlen(hundreds[value / 100]));
		if (value % 100 > 20) {
			sv_catpvn(value_pv, tens[value % 100 / 10], strlen(tens[value % 100 / 10]));
			sv_catpvn(value_pv, units[value % 10], strlen(units[value % 10]));
		} else {
			sv_catpvn(value_pv, units[value % 100], strlen(units[value % 100]));
		}
	} else {
		char value_str[5];
		sprintf(value_str, "%d ", value);
		sv_catpvn(value_pv, value_str, strlen(value_str));
	}
	sv_catpvn(value_pv, ruble[order][ending], strlen(ruble[order][ending]));
	return value_pv;
}

MODULE = Lingua::RU::Money::XS		PACKAGE = Lingua::RU::Money::XS

void
rur2words(SV *amount)
	PROTOTYPE: $
	PPCODE:
		/* Negative amount can't be processed */
		if (SvNV(amount) < 0) {
			ST(0) = &PL_sv_undef;
			XSRETURN(1);
		}
		AV *stack = (AV *) sv_2mortal((SV *) newAV());
		U64 ruble_v = (U64) (SvNV(amount));
		U8 decade;
		av_push(stack, kopek2words((U8) ((SvNV(amount) - ruble_v) * 100) % 100, false));
		for (decade = UNIT; ruble_v > 0 && decade <= TRILLION; ruble_v /= 1000, decade++)
			av_push(stack, ruble2words(ruble_v % 1000, decade, true));
		/* Build the result string */
		SV *words = sv_2mortal(newSVpvs(""));
		while (av_len(stack) + 1)
			sv_catsv(words, av_pop(stack));
		SvUTF8_on(words);
		ST(0) = words;
		XSRETURN(1);
