#!/usr/bin/env perl 
#
# Before `make install' is performed this script should be runnable with
# `make test'.
# After `make install' it should work as `perl 200_Slurm-SAAccount-echo.t'
use strict;
use warnings;

use Test::More;
use Cwd qw(abs_path);
use File::Basename qw(dirname);

use Slurm::Sacctmgr;
use Slurm::Sacctmgr::Account;

my $testDir = dirname(abs_path($0));
our $num_tests_run = 0;

require "$testDir/helpers/echo-help.pl";

my $sa = Slurm::Sacctmgr->new(sacctmgr=>"${testDir}/helpers/echo_cmdline");
my $saacct = 'Slurm::Sacctmgr::Account';

my $results;
my $args;
my $err;
my $argstr;
my (@temp, @temp2);
my ($temp, $temp2);

#Test various commands with echo sacctmgr

my @listtmp1 = ( 'list', 'account', 'format=account,description,organization' );
my @listtmp2 = ( '--parsable2', '--noheader', '--readonly' );
@temp = ( name=>'testacct1', );
$results = $saacct->sacctmgr_list($sa,@temp);
$results = $saacct->_eblist_last_raw_output;
$args = [ @listtmp1, hash_to_arglist_lexical(@temp), @listtmp2 ];
check_results($args, $results, 'sacctmgr_list single acct');

@temp = ( cluster => 'yottascale', organization=>'nsa'  );
$results = $saacct->sacctmgr_list($sa,@temp);
$results = $saacct->_eblist_last_raw_output;
$args = [ @listtmp1, hash_to_arglist_lexical(@temp), @listtmp2 ];
check_results($args, $results, 'sacctmgr_list acct multi-fields');


@temp = ( cluster=>'yottascale', parent=>'special',  name=>'abc124', organization=>'nsa');
$results = $saacct->sacctmgr_add($sa,@temp);
$results = $saacct->_ebadddel_last_raw_output;
$args = [ '-i', 'add', 'account', hash_to_arglist_lexical(@temp) ];
check_results($args, $results, 'sacctmgr_add account');

note('Ignore output to stderr about return value from sacctmgr_modify');
@temp = ( cluster=>'yottascale', account=>'abc124', organization=>'nsa', );
@temp2 = ( parent=>'topsecret', rawusage=>0 );
$temp = { @temp }; 
$temp2 = { @temp2 };
$results = $saacct->sacctmgr_modify($sa,$temp, $temp2);
$results = $saacct->_ebmod_last_raw_output;
$args = [ '-i', 'modify', 'account', 'where',  hash_to_arglist_lexical(@temp), 'set', hash_to_arglist_lexical(@temp2) ];
check_results($args, $results, 'sacctmgr_modify account');

@temp = ( cluster=>'yottascale', account=>'abc124' );
$results = $saacct->sacctmgr_delete($sa,@temp);
$results = $saacct->_ebadddel_last_raw_output;
$args = [ '-i', 'delete', 'account', 'where', hash_to_arglist_lexical(@temp) ];
check_results($args, $results, 'sacctmgr_delete account');

$results = $saacct->zero_usage_on_account_cluster($sa, 'abc124', 'yottascale');
$results = $saacct->_ebmod_last_raw_output;
$args = [ '-i', 'modify', 'account', 'where', "cluster='yottascale'", "name='abc124'", 
	'set', "rawusage='0'" ];
check_results($args, $results, 'zero_usage_on_account_cluster');

$results = $saacct->set_cpumin_limit_on_account_cluster($sa, 'abc124', 'yottascale', 1357);
$results = $saacct->_ebmod_last_raw_output;
$args = [ '-i', 'modify', 'account', 'where', "cluster='yottascale'", "name='abc124'", 
	'set', "grpcpumins='1357'" ];
check_results($args, $results, 'set_cpumin_limit_on_account_cluster');


#Now verify that nothing is run when we are in debug mode
note('The remaining tests generate [DRYRUN] lines, which you can ignore');
note('We just want to make sure they dont actually _do_ anything');
$sa->dryrun(1);

@temp = ( organization=>'nsa', parent=>'special', cluster=>'yottascale', name=>'abc124', );
$temp = $saacct->_ebadddel_last_raw_output;
$results = $saacct->sacctmgr_add($sa,@temp);
$results =$saacct->_ebadddel_last_raw_output; 
is_deeply( $results, [], "sacctmgr_add account (dryrun mode)");
$num_tests_run++;

@temp = ( cluster=>'yottascale', account=>'abc124', organization=>'nsa', );
@temp2 = ( parent=>'topsecret', rawusage=>0 );
$temp = { @temp }; 
$temp2 = { @temp2 };
$results = $saacct->sacctmgr_modify($sa,$temp, $temp2);
$results = $saacct->_ebmod_last_raw_output;
is_deeply( $results, [], "sacctmgr_modify account (dryrun mode)");
$num_tests_run++;

@temp = ( cluster=>'yottascale', account=>'abc124' );
$results = $saacct->sacctmgr_delete($sa,@temp);
$results = $saacct->_ebadddel_last_raw_output;
is_deeply( $results, [], "sacctmgr_delete account (dryrun mode)");
$num_tests_run++;

$results = $saacct->zero_usage_on_account_cluster($sa, 'abc124', 'yottascale');
$results = $saacct->_ebmod_last_raw_output;
is_deeply( $results, [], "zero_usage_on_account_cluster (dryrun mode)");
$num_tests_run++;

$results = $saacct->set_cpumin_limit_on_account_cluster($sa, 'abc124', 'yottascale', 1357);
$results = $saacct->_ebmod_last_raw_output;
is_deeply( $results, [], "set_cpumin_limit_on_account_cluster (dryrun mode)");
$num_tests_run++;

#This one actually _should_ run, as is just a list
@temp = ( name=>'abc123', );
$results = $saacct->sacctmgr_list($sa,@temp);
$results = $saacct->_eblist_last_raw_output;
$args = [ @listtmp1, hash_to_arglist(@temp), @listtmp2 ];
check_results($args, $results, 'sacctmgr_list single account (dryrun mode)');

done_testing($num_tests_run);

