##-*- Mode: CPerl -*-

## File: DTA::CAB::Server::HTTP::Handler::Response.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description:
##  + DTA::CAB::Server::HTTP handler class: static response
##======================================================================

package DTA::CAB::Server::HTTP::Handler::Response;
use DTA::CAB::Server::HTTP::Handler;
use HTTP::Status;
use Carp;
use strict;

our @ISA = qw(DTA::CAB::Server::HTTP::Handler);

##--------------------------------------------------------------
## Aliases
BEGIN {
  DTA::CAB::Server::HTTP::Handler->registerAlias(
						 'DTA::CAB::Server::HTTP::Handler::response' => __PACKAGE__,
						 'response' => __PACKAGE__,
						);
}

##--------------------------------------------------------------
## Methods

## $h = $class_or_obj->new(%options)
##  + %options
##     response => $obj,  ##-- HTTP::Response object
sub new {
  my $that = shift;
  return bless { response=>undef, @_ }, ref($that)||$that;
}

## $rsp = $h->run($server, $localPath, $clientConn, $hreq)
sub run {
  my ($h,$srv,$path,$csock,$hreq) = @_;
  return $h->cerror($csock, RC_NOT_FOUND) if (!defined($h->{response}));
  return $h->{response};
}


1; ##-- be happy

__END__

##========================================================================
## POD DOCUMENTATION, auto-generated by podextract.perl
=pod

=cut

##========================================================================
## NAME
=pod

=head1 NAME

DTA::CAB::Server::HTTP::Handler::Response - CAB HTTP Server: request handler: static response

=cut

##========================================================================
## SYNOPSIS
=pod

=head1 SYNOPSIS

 ##========================================================================
 ## PRELIMINARIES
 
 use DTA::CAB::Server::HTTP::Handler::Response;
 
 ##========================================================================
 ## Methods
 
 $h   = $class_or_obj->new(%options);
 $rsp = $h->run($server, $localPath, $clientConn, $hreq);

=cut

##========================================================================
## DESCRIPTION
=pod

=head1 DESCRIPTION

=cut

##----------------------------------------------------------------
## DESCRIPTION: DTA::CAB::Server::HTTP::Handler::Response: Methods
=pod

=head2 Methods

=over 4

=item new

 $h = $class_or_obj->new(%options);

%$h, %options:

 response => $obj,  ##-- HTTP::Response object

=item run

 $rsp = $h->run($server, $localPath, $clientConn, $hreq)

Returns $h-E<gt>{response},
or sends a "404 not found" error to the client if not defined.

=back

=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl

##======================================================================
## Footer
##======================================================================
=pod

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2010-2019 by Bryan Jurish

This package is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.24.1 or,
at your option, any later version of Perl 5 you may have available.

=head1 SEE ALSO


L<DTA::CAB::Server::HTTP::Handler(3pm)|DTA::CAB::Server::HTTP::Handler>,
L<DTA::CAB::Server::HTTP(3pm)|DTA::CAB::Server::HTTP>,
L<DTA::CAB(3pm)|DTA::CAB>,
L<perl(1)|perl>,
...

=cut
