package Business::EDI::CodeList::ContactFunctionCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.01;
my $list_number = 3139;
my $usage       = 'B';

# 3139  Contact function code                                   [B]
# Desc: Code specifying the function of a contact (e.g.
# department or person).
# Repr: an..3

my %code_hash = (
'AA' => [ 'Insurance contact',
    'Department/person to contact for matters regarding insurance.' ],
'AB' => [ 'Workshop contact',
    'Department/person to contact for matters regarding the workshop.' ],
'AC' => [ 'Accepting contact',
    'Department/person in charge of accepting incoming goods.' ],
'AD' => [ 'Accounting contact',
    'The contact responsible for accounting matters.' ],
'AE' => [ 'Contract contact',
    'Department/person to contact for matters regarding contracts.' ],
'AF' => [ 'Land registry contact',
    'Department/person to contact for matters regarding land registry.' ],
'AG' => [ 'Agent',
    'Department/person of the agent which acts on behalf of another party.' ],
'AH' => [ 'Coordination contact',
    'Department/person to contact for matters regarding technical coordination of works.' ],
'AI' => [ 'Project management contact',
    'Department/person to contact for matters regarding project management on behalf of the contractor.' ],
'AJ' => [ 'Investment contact',
    'Department/person to contact for matters regarding investments.' ],
'AK' => [ 'Works management contact',
    'Department/person to contact for matters regarding management of works on behalf of the owner.' ],
'AL' => [ 'Personnel contact',
    'Department/person to contact for matters regarding personnel (human resources).' ],
'AM' => [ 'Claims contact',
    'Department/person to contact for matters regarding claims.' ],
'AN' => [ 'Laboratory contact',
    'Department/person to contact for laboratory matters.' ],
'AO' => [ 'Plant/equipment contact',
    'Department/person to contact for matters regarding plant/equipment.' ],
'AP' => [ 'Accounts payable contact',
    'Department/person responsible for the accounts payable function within a corporation.' ],
'AQ' => [ 'Quantity surveyor contact',
    'Department/person to contact for matters regarding quantity surveying.' ],
'AR' => [ 'Accounts receivable contact',
    'Department/person responsible for the accounts receivable within a corporation.' ],
'AS' => [ 'Public relations contact',
    'Department/person to contact for matters regarding public relations.' ],
'AT' => [ 'Technical contact',
    'Department/person to contact for matters regarding technical issues.' ],
'AU' => [ 'City works authority contact',
    'Department/person to contact for matters regarding city works.' ],
'AV' => [ 'Maintenance contact',
    'Department/person to contact for matters regarding maintenance.' ],
'AW' => [ 'Town planning contact',
    'Department/person to contact for matters regarding town planning.' ],
'AX' => [ 'Traffic authority contact',
    'Department/person to contact for matters regarding traffic.' ],
'AY' => [ 'Electricity supply contact',
    'Department/person to contact for matters regarding electricity supply.' ],
'AZ' => [ 'Gas supply contact',
    'Department/person to contact for matters regarding gas supply.' ],
'BA' => [ 'Water supply contact',
    'Department/person to contact for matters regarding water supply.' ],
'BB' => [ 'Telecommunications network contact',
    'Department/person to contact for matters regarding telecommunications network.' ],
'BC' => [ 'Banking contact',
    'Contact person for bank.' ],
'BD' => [ 'New developments contact',
    'Department/person to contact for matters regarding new developments (e.g. construction).' ],
'BE' => [ 'Transport infrastructure authority',
    'Department/person to contact for matters regarding transport infrastructure.' ],
'BF' => [ 'Service contact',
    'Department/person to be contacted in service matters.' ],
'BG' => [ 'Auditing contact',
    'Department or person to contact with regard to auditing.' ],
'BH' => [ 'Legal auditing contact',
    'Department or person to contact with regard to legal auditing.' ],
'BI' => [ 'Software house contact',
    'Department or person to contact with regard to software house.' ],
'BJ' => [ 'Department or person responsible for processing purchase',
    'order Identification of the department or person responsible for the processing of purchase orders.' ],
'BK' => [ 'Electronic data interchange coordinator',
    'Code specifying a person responsible for the coordination of matters related to the exchange of information in electronic data interchange format.' ],
'BL' => [ 'Waiver contact',
    'Code specifying a party knowledgeable about a waiver.' ],
'BM' => [ 'Automated clearing house (ACH) contact',
    'Code specifying a person to be contacted at an automated clearing house.' ],
'BN' => [ 'Certification contact',
    'Code specifying a contact with knowledge of a certification action.' ],
'BO' => [ 'After business hours contact',
    'Department/person to contact after normal working hours.' ],
'BP' => [ 'Company Security Officers 24-hour contact',
    'The round the clock contact of the Company Security Officer who is responsible for the vessel.' ],
'BQ' => [ 'Agent of ship at the intended port of arrival',
    'Contact details of the agent of the ship at the intended port of arrival.' ],
'BU' => [ 'Ultimate consignee',
    'Final recipient of the consignment.' ],
'CA' => [ 'Carrier',
    '(3126) Party undertaking or arranging transport of goods between named points.' ],
'CB' => [ 'Changed by',
    'Person who made the change.' ],
'CC' => [ 'Responsible person for information production',
    'Responsible person to contact for matters regarding the production of information.' ],
'CD' => [ 'Responsible person for information dissemination',
    'Responsible person to contact for matters regarding information dissemination.' ],
'CE' => [ 'Head of unit for computer data processing',
    'Head of unit to contact for matters regarding computer data processing.' ],
'CF' => [ 'Head of unit for information production',
    'Head of unit to contact for matters regarding the production of information.' ],
'CG' => [ 'Head of unit for information dissemination',
    'Head of unit to contact for matters regarding dissemination of information.' ],
'CN' => [ 'Consignee',
    '(3132) Party to which goods are consigned.' ],
'CO' => [ 'Consignor',
    '(3336) Party which, by contract with a carrier, consigns or sends goods with the carrier, or has them conveyed by him. Synonym: shipper/sender.' ],
'CP' => [ 'Responsible person for computer data processing',
    'Responsible person to contact for matters regarding computer data processing.' ],
'CR' => [ 'Customer relations',
    'Individual responsible for customer relations.' ],
'CW' => [ 'Confirmed with',
    'Person with whom the contents of the purchase order has been discussed and agreed (e.g. by telephone) prior to the sending of this message.' ],
'DE' => [ 'Department/employee to execute export procedures',
    'Department/employee which/who executes export procedures.' ],
'DI' => [ 'Department/employee to execute import procedures',
    'Department/employee which/who executes import procedures.' ],
'DL' => [ 'Delivery contact',
    'Department/person responsible for delivery.' ],
'EB' => [ 'Entered by',
    'Name of an individual who made the entry.' ],
'EC' => [ 'Education coordinator',
    'Person in charge of coordination of education.' ],
'ED' => [ 'Engineering contact',
    'Department/person to contact for matters regarding engineering.' ],
'EX' => [ 'Expeditor',
    'The contact for expediting.' ],
'GR' => [ 'Goods receiving contact',
    'Department/person responsible for receiving the goods at the place of delivery.' ],
'HE' => [ 'Emergency dangerous goods contact',
    'Party who is to be contacted to intervene in case of emergency.' ],
'HG' => [ 'Dangerous goods contact',
    'Department/person to be contacted for details about the transportation of dangerous goods/hazardous material.' ],
'HM' => [ 'Hazardous material contact',
    'Department/person responsible for hazardous material control.' ],
'IC' => [ 'Information contact',
    'Department/person to contact for questions regarding transactions.' ],
'IN' => [ 'Insurer contact',
    'Department/employee to be contacted at the insurer.' ],
'LB' => [ 'Place of delivery contact',
    'Department/employee to be contacted at the place of delivery.' ],
'LO' => [ 'Place of collection contact',
    'Department/employee to be contacted at the place of collection.' ],
'MC' => [ 'Material control contact',
    'Department/person responsible for the controlling/inspection of goods.' ],
'MD' => [ 'Material disposition contact',
    'Department/person responsible for the disposition/scheduling of goods.' ],
'MH' => [ 'Material handling contact',
    'Department/employee to be contacted for material handling.' ],
'MR' => [ 'Message recipient contact',
    'Department/employee to be contacted at the message recipient.' ],
'MS' => [ 'Message sender contact',
    'Department/employee to be contacted at the message sender.' ],
'NT' => [ 'Notification contact',
    'Department/employee to be notified.' ],
'OC' => [ 'Order contact',
    'An individual to contact for questions regarding this order.' ],
'PA' => [ 'Prototype coordinator',
    'Department/employee to be contacted as prototype co- ordinator.' ],
'PD' => [ 'Purchasing contact',
    'Department/person responsible for issuing this purchase order.' ],
'PE' => [ 'Payee contact',
    'Department/employee to be contacted at the payee.' ],
'PM' => [ 'Product management contact',
    'Department/person to contact for questions regarding this order.' ],
'QA' => [ 'Quality assurance contact',
    'Quality assurance contact within an organization.' ],
'QC' => [ 'Quality coordinator contact',
    'Quality coordinator contact within an organization.' ],
'RD' => [ 'Receiving dock contact',
    'The receiving dock contact within an organization.' ],
'SA' => [ 'Sales administration',
    'Name of the sales administration contact within a corporation.' ],
'SC' => [ 'Schedule contact',
    'Name of the scheduling contact within a corporation.' ],
'SD' => [ 'Shipping contact',
    'The shipping department contact within an organization.' ],
'SR' => [ 'Sales representative or department',
    'The sales representative or department contact within an organization.' ],
'SU' => [ 'Supplier contact',
    'Department/person to be contacted at the supplier.' ],
'TA' => [ 'Traffic administrator',
    'The traffic administrator contact within an organization.' ],
'TD' => [ 'Test contact',
    'Department/person responsible for testing contact.' ],
'TI' => [ 'Technical documentation recipient',
    'Department/person to receive technical documentation.' ],
'TR' => [ 'Transport contact',
    'Department/person in charge of transportation.' ],
'WH' => [ 'Warehouse',
    'The warehouse contact within an organization.' ],
'WI' => [ 'Alternate contact',
    'Alternate department or person to contact.' ],
'WJ' => [ 'Office Manager',
    'An individual responsible for managing the day to day activities of an office.' ],
'WK' => [ 'Chartered accountant contact',
    'Code identifying a chartered accountant contact.' ],
'ZZZ' => [ 'Mutually defined',
    'A code assigned within a code list to be used on an interim basis and as defined among trading partners until a precise code can be assigned to the code list.' ],
);
sub get_codes { return \%code_hash; }

1;
