package Business::EDI::CodeList::PaymentConditionsCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.01;
my $list_number = 4439;
my $usage       = 'C';

# *    4439  Payment conditions code                                 [C]
# Desc: Code specifying the payment conditions.
# Repr: an..3

my %code_hash = (
'1' => [ 'Direct payment',
    'An assigned invoice has been paid by the buyer to the factor.' ],
'2' => [ 'Automatic clearing house credit',
    'Credit transaction via an ACH (Automated Clearing House).' ],
'3' => [ 'Automatic clearing house debit',
    'Debit transaction via an ACH (Automated Clearing House).' ],
'4' => [ 'Automatic clearing house credit-savings account',
    'Credit transaction via an ACH (Automated Clearing House) to an interest bearing deposit account without a stated maturity.' ],
'5' => [ 'Automatic clearing house debit-demand account',
    'Debit transaction via an ACH (Automated Clearing House) to an account paying funds on demand without notice of intended withdrawal.' ],
'6' => [ 'Bank book transfer (credit)',
    'Current value of an asset, moved from one account to another, as it appears on the balance sheet (credit).' ],
'7' => [ 'Bank book transfer (debit)',
    'Current value of an asset, moved from one account to another, as it appears on the balance sheet (debit).' ],
'8' => [ 'Doc collection via 3rd party with bill of EX',
    'Presentment of negotiable instruments to the point of origin, and receiving payment from the paying bank, using a 3rd party with bill of exchange.' ],
'9' => [ 'Doc collection via 3rd party no bill of EX',
    'Presentment of negotiable instruments to the point of origin, and receiving payment from the paying bank, using a 3rd party without bill of exchange.' ],
'10' => [ 'Irrevocable documentary credit',
    'Written undertaking by a bank to pay a seller against stipulated documents that cannot be amended or cancelled without the consent of all parties involved.' ],
'11' => [ 'Transferable irrevocable documentary credit',
    'Written undertaking by a bank to pay a seller against stipulated documents that cannot be amended or cancelled without the consent of all parties involved and that can be transferred by the first beneficiary to one or more beneficiaries.' ],
'12' => [ 'Confirmed irrevocable documentary credit',
    'Written undertaking by a bank to pay a seller against credit conform stipulated documents that cannot be amended or cancelled without the consent of all parties involved.' ],
'13' => [ 'Transferable confirmed irrevocable documentary credit',
    'Written undertaking by a bank to pay a seller against credit conform stipulated documents that cannot be amended or cancelled without the consent of all parties involved and that can be transferred by the first beneficiary to one or more beneficiaries.' ],
'14' => [ 'Revocable documentary credit',
    'Written undertaking by a bank to pay a seller against stipulated documents that can be amended or cancelled at any time.' ],
'15' => [ 'Irrevocable letter of credit-confirmed',
    'Letter of credit that cannot be cancelled or amended without agreement by all the parties involved, and carries the endorsement of both the issuing bank and its correspondent, guaranteeing payment of all drafts written against.' ],
'16' => [ 'Letter of guarantee',
    'Any guarantee, bond or other payment undertaking given for the payment of money on presentation in conformity with the terms of the undertaking of a demand for payment and other documents specified.' ],
'17' => [ 'Revocable letter of credit',
    'Letter of credit that can be cancelled or amended at any time by the issuing bank.' ],
'18' => [ 'Standby letter of credit',
    "Letter of credit which is a contingent (future) obligation of the issuing bank to make payment to the designated beneficiary if the bank's customer fails to perform as called for under the terms of a contract." ],
'19' => [ 'Irrevocable letter of credit unconfirmed',
    'Letter of credit that cannot be cancelled or amended before a specific date without agreement by all the parties involved, and carries no guarantee that a correspondent will honour drafts presented for payment.' ],
'20' => [ 'Clean collection (ICC)',
    'A collection in which the seller has already sent the goods and any documents giving control of such goods directly to the buyer, and where he subsequently sends his claim for payment. This type of collection involves financial documents only.' ],
'21' => [ 'Documentary collection (ICC)',
    'A collection in which the seller exchanges the delivery of the goods and any documents giving control of such goods for payment or upon promise of payment by acceptance of a commercial document. This type of collection involves financial and commercial documents. International Chamber of Commerce (ICC) term.' ],
'22' => [ 'Documentary sight collection (ICC)',
    'A collection in which the commercial documents are delivered against immediate payment. International Chamber of Commerce (ICC) term.' ],
'23' => [ 'Documentary collection with date of expiry (ICC)',
    'A collection in which the commercial documents are valid for a term or until a specified date. International Chamber of Commerce (ICC) term.' ],
'24' => [ 'Documentary collection: bill of exchange against acceptance',
    'A collection in which the bill of exchange is handed over on acceptance and the payment will take place on a future date.' ],
'25' => [ 'Documentary collection: bill of exchange against payment',
    'A collection in which the bill of exchange is handed over when payment is obtained.' ],
'26' => [ "Collection subject to buyer's approval (ICC)",
    "The collection is subject to the buyer's approval. International Chamber of Commerce (ICC) term." ],
'27' => [ 'Collection by a bank consignee for the goods (ICC)',
    'A collection in which the bank stores the goods on its premises. International Chamber of Commerce (ICC) term.' ],
'34' => [ 'Seller to advise buyer',
    'Payment conditions to be advised by the seller to the buyer.' ],
'35' => [ 'Documents through banks',
    "Also known as 'documents against presentation', the documents are sent to a bank, and the buyer obtains the documents by paying the invoice amount to the bank." ],
'36' => [ 'Charging (to account)',
    'Amount due booked to accounts payable/accounts receivables accordingly.' ],
'37' => [ 'Available with issuing bank',
    'Documentary credit is available with the issuing bank.' ],
'38' => [ 'Available with advising bank',
    'Documentary credit is available with the advising bank.' ],
'39' => [ 'Available with named bank',
    'Documentary credit is available with the financial institution identified in the FII segment.' ],
'40' => [ 'Available with any bank',
    'Documentary credit is available with any bank.' ],
'41' => [ 'Available with any bank in ...',
    'Documentary credit is available with any bank located in a place identified in the LOC segment.' ],
'42' => [ 'Indirect payment',
    "An assigned invoice has been paid by the buyer to the seller or to the seller's agent instead of to the factor." ],
'43' => [ 'Reassignment',
    'An invoice or credit note assigned to a factor has been reassigned back to the seller or to another factor.' ],
'44' => [ 'Offset',
    "An invoice/credit note has been (partly) offset against other items on the seller's or buyer's account." ],
'45' => [ 'Special entries',
    'Payment to be treated as special booking entry by the beneficiary.' ],
'46' => [ 'Instalment payment',
    'Payment is to be made in one or more instalments.' ],
'47' => [ 'Instalment payment with draft',
    'Payment is to be made by bank draft in one or more instalments.' ],
'48' => [ 'Available with advise through bank',
    'Available with the financial institution through which the advising bank is to advise the documentary credit.' ],
'49' => [ 'General conditions of sale',
    'Refer to general conditions of sale for payment condition information.' ],
'50' => [ 'Special payment',
    'Payment with special condition(s).' ],
'61' => [ 'Set-off by exchange of documents',
    'Payment will be initiated by the exchange of documents.' ],
'62' => [ 'Set-off by reciprocal credits',
    'Payment will be initiated by the settling of reciprocal credits.' ],
'64' => [ 'Set-off by exchange of goods',
    'Payment will be initiated by the exchange of goods.' ],
'65' => [ 'Reverse factoring',
    'Condition of payment to suppliers in which a third party (for example, a bank) manages the payments that one company has to make to its suppliers.' ],
'69' => [ 'Other set-off',
    'Payment will be initiated by an action not otherwise stipulated.' ],
'70' => [ 'Supplier to invoice',
    'To identify in an order that the supplier is required to invoice for payment.' ],
'71' => [ 'Recipient to self bill',
    'To identify in an order that the receiver of the goods is expected to self bill.' ],
'ZZZ' => [ 'Mutually defined',
    'A code assigned within a code list to be used on an interim basis and as defined among trading partners until a precise code can be assigned to the code list.' ],
);
sub get_codes { return \%code_hash; }

1;
