/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.AbstractHandler;
import com.javonet.utils.Command;
import com.javonet.utils.exceptions.JavonetArgumentsMismatchException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class GetStaticFieldHandler
extends AbstractHandler {
    private final int requiredArgumentsCount = 2;

    @Override
    public Object process(Command command) throws Exception {
        if (command.getPayload().length < 2) {
            throw new JavonetArgumentsMismatchException(this.getClass().getName(), 2);
        }
        Class classToLoad = (Class)command.getPayload()[0];
        String field = command.getPayload()[1].toString();
        try {
            return classToLoad.getDeclaredField(field).get(null);
        }
        catch (NoSuchFieldException e) {
            Field[] fields = classToLoad.getDeclaredFields();
            StringBuilder message = new StringBuilder("Field " + field + " not found in class " + classToLoad.getName() + ". Available static fields:\n");
            for (Field f : fields) {
                if (!Modifier.isStatic(f.getModifiers())) continue;
                message.append(f.getName()).append("\n");
            }
            throw new NoSuchFieldException(message.toString());
        }
    }
}

