package App::Manoc::Controller::Vlan;
#ABSTRACT: Vlan controller

use Moose;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use namespace::autoclean;
use App::Manoc::Form::Vlan;

BEGIN { extends 'Catalyst::Controller'; }
with
    'App::Manoc::ControllerRole::CommonCRUD' => { -excludes => 'list' },
    'App::Manoc::ControllerRole::JSONView';

__PACKAGE__->config(
    # define PathPart
    action => {
        setup => {
            PathPart => 'vlan',
        }
    },
    class                   => 'ManocDB::Vlan',
    form_class              => 'App::Manoc::Form::Vlan',
    json_columns            => [ 'id', 'name', 'description' ],
    enable_permission_check => 1,
    view_object_perm        => undef,
    object_list_options     => {
        prefetch => 'vlan_range',
    }
);


sub index : Path : Args(0) {
    my ( $self, $c ) = @_;
    $c->res->redirect( $c->uri_for_action('vlanrange/list') );
}


before 'create' => sub {
    my ( $self, $c ) = @_;

    my $range_id = $c->req->query_parameters->{'range'};
    $c->stash( form_defaults => { vlan_range => $range_id } );
};


sub object_delete {
    my ( $self, $c ) = @_;
    my $vlan = $c->stash->{'object'};

    if ( $vlan->ip_ranges->count ) {
        $c->flash( error_msg => 'There are subnets in this vlan' );
        return;
    }

    $vlan->delete;
}


sub get_form_success_url {
    my ( $self, $c ) = @_;

    return $c->uri_for_action("vlanrange/list");
}

__PACKAGE__->meta->make_immutable;

1;

__END__

=pod

=head1 NAME

App::Manoc::Controller::Vlan - Vlan controller

=head1 VERSION

version 2.99.2

=head1 ACTIONS

=head2 index

=head2 create

=head1 METHODS

=head2 object_delete

=head2 get_form_success_url

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
