/*
 * ASPIDEF - communication with Advanced SCSI Programming Interface
 *
 * LAST CHANGE:
 *   10/17/93 - first version,	OK
 */

/* aspi functions error messages */
#define ASPIE_SUCCESS 0 	/* Ok */
#define ASPIE_PENDING -1	/* Pending SCSI request  */
#define ASPIE_FATAL -2		/* Undefined ASPI error */
#define ASPIE_INVDEVICEID -5	/* SCSI device not installed */
#define ASPIE_INVSCSIREQ -6	/* Invalid SCSI request */
#define ASPIE_INVADAPTERID -7	/* Invalid host adapter number */
#define ASPIE_HOSTABORT -8	/* ASPI request aborted by host */
#define ASPIE_SELTIMEOUT -9	/* Selection timeout */
#define ASPIE_DATAOVERRUN -10	/* Data over-run/under-run */
#define ASPIE_BUSFREE -11	/* Unexpected bus free */
#define ASPIE_PHASEERR -12	/* Target bus phase sequence failure */
#define ASPIE_TARGETBUSY -13	/* Specified target is busy */
#define ASPIE_RESERVATION -14	/* Reservation conflict */
#define ASPIE_UNITNOTREADY -15	/* Unit not ready */
#define ASPIE_MEDIUM -16	/* Medium error */
#define ASPIE_HARDWARE -17	/* Non-recoverable hardware failure */
#define ASPIE_ILLEGALREQ -18	/* Illegal request */
#define ASPIE_UNITATTENTION -19 /* Unit attention */
#define ASPIE_DATAPROTECT -20	/* Medium is write protected */
#define ASPIE_BLANKCHECK -21	/* Encountered non blank data */
#define ASPIE_TARGETABORT -22	/* Command aborted by target */
#define ASPIE_VOLOVERFLOW -23	/* Volume overflow */
#define ASPIE_IOERROR -25	/* Unknown I/O error */
#define ASPIE_ENDOFMEDIUM -37	/* End of medium detected */

/* srb.flags values */
#define SRBF_POSTING		0x01
#define SRBF_LINKED		0x02
#define SRBF_NOLENCHECK 	0x00	/* direction ctrled by SCSI cmd */
#define SRBF_READ		0x08	/* xfer to host, length checked */
#define SRBF_WRITE		0x10	/* xfer to target, length checked */
#define SRBF_NOXFER		0x18	/* no data transfer */

/* srb.cmd values */
#define SRBC_INQUIRY		0
#define SRBC_GETDEVTYPE 	1
#define SRBC_EXECIO		2
#define SRBC_ABORTSRB		3
#define SRBC_RESETDEVICE	4
#define SRBC_SETADAPTERCONFIG	5
#define SRBC_GETDRIVEINFO	6

/* srb.status results */
#define SRBS_PENDING		0x00 /* SCSI request in progress */
#define SRBS_COMPLETE		0x01 /* SCSI request completed no error */
#define SRBS_ABORTED		0x02 /* SCSI request aborted */
#define SRBS_ERROR		0x04 /* SCSI request completed with error */
#define SRBS_INVSCSIREQ 	0x80 /* Invalid SCSI request */
#define SRBS_INVADAPTERID	0x81 /* Invalid host adapter number */
#define SRBS_INVDEVICEID	0x82 /* SCSI device not installed */

/* srb.bAdapterStatus results */
#define SRB_ADS_SUCCESS 	0x00 /* No adapter status available */
#define SRB_ADS_TIMEOUT 	0x11 /* Selection timeout */
#define SRB_ADS_DATAOVFL	0x12 /* Data overrun/underrun error */
#define SRB_ADS_BUSFREE 	0x13 /* Unexpected bus free */
#define SRB_ADS_PHASEERR	0x14 /* Target bus phase sequence error */

/* srb.bTargetStatus results */
#define SRB_TGS_GOOD		0x00 /* Good status or none available */
#define SRB_TGS_CHECKCOND	0x02 /* Check Condition */
#define SRB_TGS_CONDMET 	0x04 /* Condition met */
#define SRB_TGS_BUSY		0x08 /* Target busy */
#define SRB_TGS_INTERM		0x10 /* Intermediate command good */
#define SRB_TGS_INTERMCONDMET	0x14 /* Intermediate condition met */
#define SRB_TGS_RESCONFLICT	0x18 /* Reservation conflict */
#define SRB_TGS_CMDTERMINATED	0x22 /* Command terminated */
#define SRB_TGS_QUEUEFULL	0x28 /* Queue full */


/* result of 'AspiHostAdapterInquiry' */
typedef struct HA_INQUIRY {
  int nAdapters;
  int adapterTargetId;
  char szManager [17];
  char szAdapter [17];
} HA_INQUIRY;


/* result of 'AspiGetDiskDriveInfo' */
typedef struct HA_DRIVEINFO {
  BYTE bDriveFlags;
  BYTE bInt13Drive;
  BYTE bPreferredHeadTranslation;
  BYTE bPreferredSectorTranslation;
  BYTE _reserved [10];
} HA_DRIVEINFO;


/* flags of 'DriveInfo.bDriveFlags' & DDF_INT13INFO */
#define DDFM_INT13INFO	0x03
#define DDF_ASPICONTROL 0	/* no INT 13h support for this LUN */
#define DDF_DOSCONTROL	1	/* LUN has INT 13h support, ctrled by DOS */
#define DDF_BIOSCONTROL 2	/* LUN ctrled by INT 13h but no DOS support */

/*
 * Parameter structure of 'AspiSetAdapterConfig' and a 1522 adapter.
 * This structure is highly adapter specific (might not work for other
 * controlers).
 */
typedef struct HA_SETADAPTERCONFIG {
  BYTE irqChannel;		/* Interrupt channel # */
  BYTE dmaChannel;		/* DMA channel # */
  BYTE haScsiId;		/* Host Adapter SCSI ID */
  BYTE fParity; 		/* Parity enabled/disabled */
  BYTE busOnTime;		/* DMA bus-on timing (usec) */
  BYTE busOffTime;		/* DMA bus-off timing (usec) */
  BYTE fSyncMode;		/* Synchronous mode enabled? */
  BYTE selectionTimeout;	/* Selection timeout (usec) */
  BYTE fAllowDisconnect;	/* Allow SCSI disconnection? */
  BYTE transferMode;		/* 0 = PIO, 1 = DMA */
  BYTE _reserved1;
  BYTE _reserved2;
  DWORD revisionLevel;		/* firmware rev. level */
  DWORD _reserved3;
  DWORD _reserved4;
  DWORD _reserved5;
  BYTE parameters [16];
} HA_SETADAPTERCONFIG;


#pragma pack (1)	/* no alignment, tight packing */

typedef struct SRB {
  BYTE bCmd;
  BYTE bStatus;
  BYTE bAdapterId;
  BYTE bFlags;
  DWORD _dwReserved;
} SRB;

typedef VOID (FAR *LPFNASPIPOST) (SRB FAR *lpSrb);


typedef struct SRB_INQUIRY {
  SRB srb;
  BYTE nAdapters;
  BYTE adapterTargetId;
  char achManager [16];
  char achAdapter [16];
  BYTE parameters [16];
} SRB_INQUIRY;


typedef struct SRB_SETADAPTERCONFIG {
  SRB srb;
  HA_SETADAPTERCONFIG config;
} SRB_GETCONFIG;


typedef struct SRB_GETDEVTYPE {
  SRB srb;
  BYTE bTargetId;
  BYTE bLun;
  BYTE bDeviceTypeCode;
} SRB_GETDEVTYPE;


typedef struct SRB_GETDRIVEINFO {
  SRB srb;
  BYTE bTargetId;
  BYTE bLun;
  HA_DRIVEINFO driveInfo;
} SRB_GETDRIVEINFO;


typedef struct SRB_ABORT {
  SRB srb;
  SRB FAR *lpSrbToAbort;
} SRB_ABORT;


typedef struct SRB_RESET {
  SRB srb;
  BYTE bTargetId;
  BYTE bLun;
  BYTE _reserved [14];
  BYTE bAdapterStatus;
  BYTE bTargetStatus;
  LPFNASPIPOST lpfnPost;
  BYTE _workspace [34];
} SRB_RESET;


typedef struct SENSEDATA {
  BYTE bErrorCode;	/* =70h current error, =71h deferred error */
  BYTE bSegmentNum;	/* Number of current segment descriptor */
  BYTE bSenseKey;	/* Sense key Bit 0..4, 5=ILI, 6=EOM, 7=FILEMRK */
  BYTE wInfo;		/* Information MSB/LSB */
  BYTE cbAddData;	/* Additional sense length */
  WORD bCmdSpecInfo;	/* Command specific information MSB/LSB */
  BYTE bAddSenseCode;	/* Additional sense code */
  BYTE bAddSenseQual;	/* Additional sense code qualifier */
  BYTE bFieldRepUCode;	/* Field replaceable unit code */
  BYTE bMore [4];	/* Additional sense bytes... */
} SENSEDATA;


typedef struct CDB_6 {
  BYTE bCmd;
  BYTE bLun;
  BYTE b2, b3, b4, b5;
  BYTE sense [14];
} CDB_6;


typedef struct CDB_10 {
  BYTE bCmd;
  BYTE bLun;
  BYTE b2, b3, b4, b5, b6, b7, b8, b9;
  BYTE sense [14];
} CDB_10;


/* scsi inquiry command */
typedef struct CDB_INQUIRY {
  unsigned bCmd : 8;
  unsigned fEvpd : 1;
  unsigned _reserved1 : 4;
  unsigned bLun : 3;
  unsigned bPageCode : 8;
  unsigned _reserved2 : 8;
  unsigned bLen : 8;
  unsigned bControl : 8;
  BYTE sense [14];
} CDB_INQUIRY;


/* start/stop unit command */
typedef struct CDB_SSUNIT {
  unsigned bCmd : 8;
  unsigned fImmed : 1;
  unsigned _reserved1 : 4;
  unsigned bLun : 3;
  unsigned _reserved2 : 8;
  unsigned _reserved3 : 8;
  unsigned fStart : 1;
  unsigned fEject : 1;
  unsigned _reserved4 : 6;
  unsigned bControl : 8;
  BYTE sense [14];
} CDB_SSUNIT;


/* allow medium removal command */
typedef struct CDB_MEDREM {
  unsigned bCmd : 8;
  unsigned _reserved1 : 5;
  unsigned bLun : 3;
  unsigned _reserved2 : 8;
  unsigned _reserved3 : 8;
  unsigned fPrevent : 1;
  unsigned _reserved4 : 7;
  unsigned bControl : 8;
  BYTE sense [14];
} CDB_MEDREM;


typedef struct SRB_IO {
  SRB srb;
  BYTE bTargetId;
  BYTE bLun;
  DWORD cbData;
  BYTE cbSense;
  VOID FAR *lpData;
  SRB FAR *lpSrbLink;
  BYTE cCdb;
  BYTE bAdapterStatus;
  BYTE bTargetStatus;
  LPFNASPIPOST lpfnPost;
  WORD wPostRealDS;
  SRB FAR *lpSrbReal;
  WORD _reserved1;
  DWORD dwSrbPhysAddr;
  BYTE workspace [22];
  union cdb {
    CDB_6 cdb6;
    CDB_10 cdb10;
    CDB_INQUIRY inquiry;
    CDB_SSUNIT ssunit;
    CDB_MEDREM medrem;
    BYTE raw [32];
  } cdb;
} SRB_IO;


/* result of function 'ScsiInquiry' */
typedef struct SCSI_INQUIRY {
  unsigned deviceTypeCode : 5;		/* byte 0 */
  unsigned peripheralQualifier : 3;
  unsigned deviceTypeQualifier : 7;	/* byte 1 */
  unsigned fRemovableMedium : 1;
  unsigned scsiVersion : 3;		/* byte 2 */
  unsigned ecmaVersion : 3;
  unsigned isoVersion : 2;
  unsigned responseDataFormat : 4;	/* byte 3 */
  unsigned _reserved1 : 2;
  unsigned canTerminateIoProcess : 1;
  unsigned fAsyncEventNotify : 1;
  unsigned cbVendorData : 8;		/* byte 4 */
  unsigned _reserved2 : 8;		/* byte 5 */
  unsigned _reserved3 : 8;		/* byte 6 */
  unsigned fSoftReset : 1;		/* byte 7 */
  unsigned fCmdQueueing : 1;
  unsigned cache : 1;
  unsigned fLinkedCommands : 1;
  unsigned fSynchronousTransfer : 1;
  unsigned fWideScsi16 : 1;
  unsigned fWideScsi32 : 1;
  unsigned fRelativeAddrMode : 1;
  char achVendor [8];			/* byte 8.. */
  char achProduct [16];
  char achRevision [4];
  BYTE vendorData [60];
} SCSI_INQUIRY;

/* Inquiry DeviceTypeCodes */
#define DTC_DISK	0x00 /* Direct-access device */
#define DTC_TAPE	0x01 /* Sequential-access device */
#define DTC_PRINTER	0x02 /* Printer device */
#define DTC_PROCESSOR	0x03 /* Processor device */
#define DTC_WORM	0x04 /* Write-once device */
#define DTC_CDROM	0x05 /* CD-ROM device */
#define DTC_SCANNER	0x06 /* Scanner device */
#define DTC_OPTICAL	0x07 /* Optical memory device */
#define DTC_JUKEBOX	0x08 /* Medium changer device */
#define DTC_COMM	0x09 /* Communications device */
#define DTC_PREPRESS1	0x0A /* Pre-press device 1 */
#define DTC_PREPRESS2	0x0B /* Pre-press device 2 */
#define DTC_UNKNOWN	0x1F /* Unknown or no device type */

#pragma pack ()


#define memzero(x) memset (&(x), 0, sizeof (x))

static VOID (FAR * NEAR fnAspi) (SRB FAR *) = NULL;


/*$proto:aspilib.c*/
char *AspiGetErrorText (int errorCode);
BOOL AspiInit (VOID);
int AspiPostRequest (SRB *srb);
int AspiGetError (SRB *srb);
int AspiRequestWait (SRB *srb);
int AspiAbortRequest (SRB *srb);
int AspiHostAdapterInquiry (int adapterId, HA_INQUIRY *pInquiry);
int AspiGetDeviceType (int adapterId, int targetId, int lun);
int AspiResetDevice (int adapterId, int targetId, int lun);
int AspiGetDiskDriveInfo (int adapterId, int targetId, int lun,
  HA_DRIVEINFO *pDriveInfo);
int ScsiTestUnitReady (int adapterId, int targetId, int lun);
int ScsiInquiry (int adapterId, int targetId, int lun,
  SCSI_INQUIRY *pInquiry);
int ScsiRead (int adapterId, int targetId, int lun, VOID *pBuffer,
  int firstBlock, int nBlocks);
int ScsiWrite (int adapterId, int targetId, int lun, VOID *pBuffer,
  int firstBlock, int nBlocks);
