/*  Zutils - Utilities dealing with compressed files
    Copyright (C) 2009, 2010, 2011, 2012, 2013 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

const char * const Program_name = "Zutils";
const char * const program_name = "zutils";
const char * const program_year = "2013";
extern const char * invocation_name;
extern const char * util_name;

extern int verbosity;

enum { fmt_bz2, fmt_gz, fmt_lz, fmt_xz, num_formats };
const char * const format_names[num_formats] = { "bz2", "gz", "lz", "xz" };
const char * const simple_extensions[num_formats] =
  { ".bz2", ".gz", ".lz", ".xz" };
const char * const decompressor_names[num_formats] =
  { "bzip2", "gzip", "lzip", "xz" };
const int8_t format_order[num_formats] =
  { fmt_lz, fmt_bz2, fmt_gz, fmt_xz };		// search order

// first magic byte must be different among formats
enum { bzip2_magic_size = 3,
        gzip_magic_size = 2,
        lzip_magic_size = 4,
          xz_magic_size = 5 };
const uint8_t bzip2_magic[bzip2_magic_size] =
  { 0x42, 0x5A, 0x68 };				// "BZh"
const uint8_t gzip_magic[gzip_magic_size] =
  { 0x1F, 0x8B };
const uint8_t lzip_magic[lzip_magic_size] =
  { 0x4C, 0x5A, 0x49, 0x50 };			// "LZIP"
const uint8_t xz_magic[xz_magic_size] =
  { 0xFD, 0x37, 0x7A, 0x58, 0x5A };		// 0xFD, "7zXZ"


int get_format_type( const std::string & arg );

int readblock( const int fd, uint8_t * const buf, const int size );
int writeblock( const int fd, const uint8_t * const buf, const int size );
bool feed_data( const int infd, const int outfd,
                const uint8_t * magic_data, const int magic_size );
bool set_data_feeder( int * const infdp, pid_t * const pidp,
                      const int format_type );

void show_help_addr();
void show_version( const char * const Util_name = 0 );
void show_error( const char * const msg, const int errcode = 0,
                 const bool help = false );
void show_error2( const char * const msg, const char * const name );
void show_close_error( const char * const prog_name );
void show_exec_error( const char * const prog_name );
void show_fork_error( const char * const prog_name );
void internal_error( const char * const msg );

const char * test_format( const int infd,
                          const uint8_t ** const magic_datap,
                          int * const magic_sizep );

// Returns exit status of child process 'pid', or 'eretval' in case of error.
//
int wait_for_child( const pid_t pid, const char * const name,
                    const int eretval = 2 );

// Returns -1 if child not terminated, 'eretval' in case of error, or
// exit status of child process 'pid'.
//
int child_status( const pid_t pid, const char * const name,
                  const int eretval = 2 );
