#
# spec file for quilt - patch management scripts
#

Name:		quilt
Summary:	Scripts for working with series of patches
License:	GPL
Group:		Productivity/Text/Utilities
Version:	0.32
Release:	1
Requires:	coreutils diffutils patch gzip bzip2 perl mktemp gettext
Autoreqprov:	off
Source:		quilt-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-build

%description
The scripts allow to manage a series of patches by keeping
track of the changes each patch makes. Patches can be
applied, un-applied, refreshed, etc.

The scripts are heavily based on Andrew Morton's patch scripts
found at http://www.zip.com.au/~akpm/linux/patches/.

Authors:
--------
    Andrew Morton <akpm@digeo.com>
    Andreas Gruenbacher <agruen@suse.de>

%prep
%setup

%build
./configure
make prefix=/usr BUILD_ROOT=$RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
make install prefix=/usr BUILD_ROOT=$RPM_BUILD_ROOT
%{find_lang} %{name}

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(-, root, root)
/usr/bin/guards
/usr/bin/quilt
/usr/share/quilt/
/usr/lib/quilt/
/etc/bash_completion.d/quilt
%doc %{_mandir}/man1/guards.1.gz
%doc %{_mandir}/man1/quilt.1.gz
%doc %{_docdir}/%{name}-%{version}/README
%doc %{_docdir}/%{name}-%{version}/quilt.pdf

%changelog
* Sun Mar 14 2004 - agruen@suse.de
- Change `quilt import' to allow importing multiple patches
  at once.
- Fix a bug in backup-files.c (introduced just before).
- Update to version 0.32.
* Sun Mar 14 2004 - agruen@suse.de
- Add `quilt graph' command for generating a dependency graph
  between patches. This requires the graphviz package for
  removing transitive edges (optional) and for rendering the
  graph. Please note that the graph command itself is minimal,
  while the underlying scripts/dependency-graph is more flexible.
- Complete one more detail in scripts/dependency-graph.
- Revert `quilt fork' to how it originally worked: fork the
  *topmost* patch, not the next unapplied patch. Adapt the
  test suite accordingly.
- Add flag to backup-files.c to make sure that files in the
  working tree have a link count of at most one. Use this where
  appropriate.
- Fix a bug in `quilt snapshot': Taking snapshots caused files
  to get link counts bigger than one, so modifying them could
  cause multiple files to get modified. Speed up the command,
  too.
- Update the documentation. Add example1.test from the
  documentation.
* Wed Mar 10 2004 - agruen@suse.de
- Quilt push/pop: exit with a non-zero status when beyond series.
- Ignore empty lines in series file.
- Add man page to tarball and to spec file; add make dependencies.
- Sort the commands in the man page command reference.
* Tue Mar  9 2004 - agruen@suse.de
- Make files writeable in `quilt add' (and `quilt edit') for
  working with read-only trees.
* Wed Feb 25 2004 - martin.quinson@tuxfamily.org
- Add completion to the edit command in bash
* Sun Feb 22 2004 - martin.quinson@tuxfamily.org
- Add a man page (generated automatically from -h)
* Sat Feb 21 2004 - agruen@suse.de
- Sub-directory support: `quilt setup' could get confused, too.
* Fri Feb 20 2004 - agruen@suse.de
- Sub-directory support:
  + Fix another bug that triggers when /patches exists.
  + Working in sub-directories: Force `quilt new' to always create

