#
# spec file for quilt - patch management scripts
#

Name:		quilt
Summary:	Scripts for working with series of patches
License:	GPL
Group:		Productivity/Text/Utilities
Version:	0.28
Release:	1
Requires:	coreutils diffutils patch gzip bzip2 perl mktemp gettext
Autoreqprov:	off
Source:		quilt-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-build

%description
The scripts allow to manage a series of patches by keeping
track of the changes each patch makes. Patches can be
applied, un-applied, refreshed, etc.

The scripts are heavily based on Andrew Morton's patch scripts
found at http://www.zip.com.au/~akpm/linux/patches/.

Authors:
--------
    Andrew Morton <akpm@digeo.com>
    Andreas Gruenbacher <agruen@suse.de>

%prep
%setup

%build
./configure
make prefix=/usr BUILD_ROOT=$RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
make install prefix=/usr BUILD_ROOT=$RPM_BUILD_ROOT
%{find_lang} %{name}

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(-, root, root)
/usr/bin/guards
/usr/bin/quilt
/usr/share/quilt/
/usr/lib/quilt/
/etc/bash_completion.d/quilt
%doc %{_mandir}/man1/guards.1.gz
%doc %{_docdir}/%{name}-%{version}/README

%changelog
* Fri Oct 31 2003 - agruen@suse.de
- Bump version number to 0.28 (cvs tag VER_0_28).
* Fri Oct 31 2003 - agruen@suse.de
- No longer verify if patches remove cleanly by reverse applying
  them: This doesn't always succeed, and the  the equivalent of
  `quilt diff -z' should suffice, anyway.
- Add `touch .pc/$patch' after successful refresh: Speeds up
  `quilt pop' after a refresh.
- Update test suite.
- apatch was printing a spurious newline.
* Wed Oct 29 2003 - agruen@suse.de
- If a patch does not apply cleanly and `quilt push' removes
  rejects files it GNU patch left behind, change the output from
  ``saving rejects to file x.rej'' to ``rejects in file x''.
* Tue Oct 28 2003 - agruen@suse.de
- Remove .pc/*/.pc files, and adjust various scripts accordingly.
- Run test/one.test inside sub-directory.
- Bump version number to 0.27 (cvs tag VER_0_27).
* Tue Oct 28 2003 - agruen@suse.de
- Change name and semantics of PATCHSCRIPTS variable: Before, if
  PATCHSCRIPTS was set, the patches were in $PATCHSCRIPTS/patches.
  Now, if QUILT_PATCHES is set, the patches are in $QUILT_PATCHES.
  QUILT_PATCHES defaults to "patches", like before.
* Sun Oct 26 2003 - agruen@suse.de
- Get rid of patches_per cache_in `quilt patches'. Remove
  patches_per_file and associated functions. `quilt patches'
  now is a bit slow for unapplied patches.
* Sun Oct 26 2003 - agruen@suse.de
- Rename snapshot directory from ".snap0" to ".snap".
- `quilt diff: Speed up file list generation in `quilt diff'.
  Don't use modified_files anymore. Instead, add first_modified_by
  function. I want to get rid of the patches_per_file cache;
  it sometimes was not brought up to date. Some cleanups.
- Add test/snapshot.test.
- Fix two errors in the date format in quilt.changes.
* Fri Oct 24 2003 - agruen@suse.de
- `quilt add': Return exit code 2 when a file has already been
  added.
- Add `quilt edit' command: Does a `quilt add' and then invokes
  $EDITOR (fallback is `vi'). Files that don't exist after editing
  are again removed from the patch.
* Wed Oct 22 2003 - agruen@suse.de
- `Quilt fork' should better fork the next patch instead of the
  topmost one. Also fix a bug in updating the series file when
  forking. The rename_in_db() function is no longer needed.
* Tue Oct 21 2003 - agruen@suse.de
- Add `quilt fork' command.
- Add `quilt snapshot' command and `quilt diff --snapshot' option.
- Bump the version number to 0.26.
* Tue Sep  9 2003 - martin.quinson@tuxfamily.org
- fix LC_ALL to C during building the reference so that the 
  documentation comes to english and not to french when build 
  on my box.
- Update the french translation
- Bump the version number to 0.25
* Tue Sep  2 2003 - agruen@suse.de
- Pipe rpmbuild output to /dev/null in spec2series (seems to be
  necessary since rpm4).
* Mon Jul 28 2003 - agruen@suse.de
- Use %{find_lang} macro in spec file.
* Sat Jul 26 2003 - agruen@suse.de
- Pushing is only possible if the topmost file is found in the
  series file. Fix from Tom Wang <wangdi@clusterfs.com>.
* Sat Jul 26 2003 - agruen@suse.de
- When popping files, go through the list of applied patches
  instead of looking at the series file: The series file may
  have changed.
* Sat Jul 26 2003 - agruen@suse.de
- Install package documentation into $RPM_DOC_DIR if this
  environment variable is set.  On RedHat 9 $RPM_DOC_DIR points to
  /usr/share/doc/packages, but documentation lives in
  /usr/share/doc.  This is a bug in RedHat's RPM configuration;
  working around it would break other distributions.
* Wed Jul 23 2003 - agruen@suse.de
- Add Autoconf test for rpmbuild vs. rpm (needed for `make rpm').
- Update spec2series accordingly.
* Sun Jul 20 2003 - agruen@suse.de
- lib/backup-files.c: Copy files if hard linking is not possible,
  e.g., because the backups go to a ram disc, etc.
* Wed Jun 26 2003 - martin.quinson@tuxfamily.org
- Add what needed to have inteligent bash completion when using quilt
- Bump version to 0.24
* Wed Jun 25 2003 - martin.quinson@tuxfamily.org
- Make clean before dist to avoid to put cruft in tarballs
- remove po/*mo on make clean
- update fr.po
- Fix a typo in push.in help message about --interactive
* Tue May 20 2003 - agruen@suse.de
- Preserve permissions of files added with `quilt add'.
* Sun May 18 2003 - agruen@suse.de
- Do not add the whole /usr/share/locale directory to the RPM
  file list, but only the quilt message catalogs: Otherwise RPM
  complains when uninstalling.
* Fri May 16 2003 - agruen@suse.de
- Rename DIFF_OPTS environment variable to QUILT_DIFF_OPTS
- Add ~/.quiltrc resource file (this file is sourced from
  the patchfsn file, which is used by all commands).
* Fri Apr 11 2003 - agruen@suse.de
- Apply patches with `patch -f' by default. Add --interactive
  option top `quilt push' to allow applying patches without
  `patch -f'.
* Wed Apr  9 2003 - agruen@suse.de
- Remove awk hacks in Makefile.in with shell loop and sed hack:
  The awk hack(s) didn't work for Martin Quinson.
* Wed Apr  9 2003 - agruen@suse.de
- Never reorder files in patches. (Previously the file list
  was run through (sort | uniq) to remove duplicate entries.)
- Update test script to new format, and add regression test
  cases.
* Wed Apr  9 2003 - agruen@suse.de
- The change from Mar 24 caused empty lines to be removed in
  patch descriptions.
* Mon Apr  7 2003 - agruen@suse.de
- `head -1' and `tail -1' is non-standard and deprecated, and
  does not work with coreutils-5.0 any longer.
* Sat Apr  5 2003 - agruen@suse.de
- Improve error checking of `quilt diff'.
* Mon Mar 24 2003 - agruen@suse.de
- Update patch_description function used in `quilt refresh' to
  recognize `====' lines. Without that, quilt thinks these
  lines are part of the comments before the actual patch starts,
  so those lines will accumulate.
* Sun Mar 23 2003 - agruen@suse.de
- Update test script to reflect recent patch format changes.
* Sat Mar 22 2003 - agruen@suse.de
- Also substitute @SED@ and @AWK@.
- Some versions of sed don't like '\t'. Expand those in the
  shell instead.
* Fri Mar 21 2003 - agruen@suse.de
- Bump version number to 0.23 (CVS tag VER_0_23).
* Fri Feb 14 2003 - agruen@suse.de
- A couple more I18N fixes, minor cleanups in status messages.
- Remove "quilt guidiff" (obsolete).
* Fri Feb 14 2003 - martin.quinson@tuxfamily.org
- Implement i18n, along with the french l10n.
- It was long enough that we didn't release, so bump the version number.
* Sat Feb  8 2003 - agruen@suse.de
- Merge James Rowe <Jay@jnrowe.uklinux.net>'s quilt-help.diff
  patch that fixes several help messages.
* Thu Feb  6 2003 - agruen@suse.de
- Quilt refresh: Create sub-directories in patches directory
  so that new patches in sub-directories can be added easily.
* Wed Feb  5 2003 - agruen@suse.de
- Quilt diff: If a patch has been force applied, quilt diff -z
  will also have failures when generating the temporary files.
  Ignore these failures in this case.
- Add -R option to quilt diff to generate a a reverse patch.
- Fix deleting the temporary directory (by using an absolute
  instead of a relative path).
* Sun Feb  2 2003 - agruen@suse.de
- Make quilt setup recognize the "# Sourcedir:" directive.
- Fix bug with spurious `Index:' lines in diff/refresh output.
- Add --diff option to quilt diff that allows to specify a
  different utility that diff to run files through. (That utility
  is only called for files that contain differences, not for
  files that are in a patches' file list but jave not been
  changed.)
* Sat Feb  1 2003 - agruen@suse.de
- Integrate James Rowe's Autoconf setup (with a comple of
  additional changes/fixes).
- Add some messages in configure.ac.
- Make distclean removes autoconf garbage. The configure script is
  no source file. Add rule to create it when necessary.
- Invoke configure in the RPM spec file.
- Merge James Rowe's guidiff.
* Fri Jan 31 2003 - agruen@suse.de
- Add syntax highlighting tags for emacs and vim.
- Move all scripts from lib/ to scripts/. Install lib/backup-files
  in /usr/lib/quilt/, and install the scripts in
  /usr/share/quilt/scripts/, so that no binaries are installed
  under /usr/share.
- Fix quoting strings for inclusion in regular expressions.
- Change literal '@SUBST@' strings in Makefile to '@SUBST''@',
  so that Autoconf won't mess them up later.
* Fri Jan 31 2003 - Martin.Quinson@ens-lyon.fr
- Change '#!@BASH@' to '#! @BASH@'. It can look a bit stupid, but
  it's needed for maximal portability.
* Fri Jan 31 2003 - Martin.Quinson@ens-lyon.fr
- Fight lintian warnings (lintian is a tool to check debian
  packages):
- Remove the dependencies on essential packages diff, gzip,
  debianutils
- Format the copyright file properly
- Remove the #! /bin/bash header from patchfns, since it's not an
  executable script, but a stuff to be sourced by others.
* Thu Jan 30 2003 - agruen@suse.de
- Also substitute @MKTEMP@.
- For improved scripting support, add -n option to scripts that
  print patch names prints the patch file name instead. This
  is useful for selecting which patches to grep, etc.
* Thu Jan 30 2003 - agruen@suse.de
- Allow a file list to be diffed to be passed to quilt diff. Add
  -P option for specifying a patch different from the topmost
  patch,
* Thu Jan 30 2003 -  Martin.Quinson@ens-lyon.fr
- Remove useless oldies. Missing functionnalities needs to be
  reimplemented almost from the scratch due to the bunch of
  changes to the core since those scripts were written.
* Thu Jan 30 2003 - agruen@suse.de
- Fix some regex quoting; use grep -E because we quote for extended
  regexps. Filenames with "+^$" in it did not work in some places. 
- Prepare for GNU Autoconf: substitute @PERL@, @BASH@, @DIFF@,
  @PATCH@ in scripts.
- Some cleanups in Makefile.
- Move documentation to doc/.
- Forgot to mention that the patches produced now contain
  `Index: dir/filename' just before the diff output for each file.
  This is required by POSIX, and is also used by diffstat.
- Adjust patch_description documentation extraction function to
  check for Index: lines.
- Quilt refresh looses text before actual patch due to but in
  patch_description function.
* Tue Jan 28 2003 - agruen@suse.de
- Add --leave-rejects option to quilt push and apatch, to
  leave reject files around for inspection even if a patch
  does not apply.
* Tue Jan 28 2003 - agruen@suse.de
- Restart change log at quilt-0.21. Let orderly development
  begin :)

