/*
 *  Status monitor for Canon CAPT Printer.
 *  Copyright CANON INC. 2004
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 *  OTHER DEALINGS IN THE SOFTWARE.
 */


#define	CCPD_PORT_ID_CUPSMON	39787

#define	HEADER_REQ_STR		"ccp0"
#define	HEADER_RES_STR		"ccp1"

typedef enum
{
	CCPD_REQ_STATUS = 1,
	CCPD_REQ_PAUSE,
	CCPD_REQ_RESUME,
	CCPD_REQ_CANCEL,
	CCPD_REQ_CLEANING,
	CCPD_REQ_CLEANING2,
	CCPD_REQ_SET_FLASH,
	CCPD_REQ_PRT_INFO,
	CCPD_REQ_CALIBRATION,
	CCPD_REQ_CALIB_DATA,
	CCPD_REQ_SET_FL_DATA,
	CCPD_REQ_GET_FL_DATA,
	CCPD_REQ_COUNTER,
	CCPD_REQ_CRG_STATUS,
	CCPD_REQ_NIC_PARAM,
	CCPD_REQ_SET_NIC,
	CCPD_REQ_CLEANING3,
	CCPD_REQ_PRT_INFO2,
	CCPD_DEVICE_REQUEST,
	CCPD_REQ_PTBL_UPDATE,
	CCPD_REQ_BOTTOM,
} ENUM_UIRequestID;


#define	DREQ_PAUSE		0x1001
#define	DREQ_RESUME		0x1002
#define	DREQ_CANCEL		0x1003
#define	DREQ_ERRORSKIP		0x1004

#define	DREQ_CLEANING		0x18001
#define	DREQ_CALIBRATION	0x18002
#define	DREQ_REGISTRATION	0x18003
#define	DREQ_SERVICECHART	0x18004
#define DREQ_CLEANING2		0x18005
#define DREQ_ERRCLR			0x18006
#define	DREQ_REGISTRATION2	0x18007
#define	DREQ_ROTATE_CARTRIDGE_C	0x18008
#define DREQ_ROTATE_CARTRIDGE_M	0x1800a
#define DREQ_ROTATE_CARTRIDGE_Y	0x1800b
#define DREQ_ROTATE_CARTRIDGE_K	0x1800c
#define	DREQ_CHG_CARTRIDGEMODE_ON	0x18009
#define DREQ_CHG_CARTRIDGEMODE_OFF	0x1800d
#define DREQ_CLEANING3		0x18010

#define	DREQ_SET_IMAGESHIFT	0x19001
#define	DREQ_SET_SLEEPTIMER	0x19002
#define	DREQ_SET_PARTSRESET	0x19003
#define	DREQ_SET_WARNING	0x19004
#define	DREQ_SET_NIC_PARAM	0x19005
#define	DREQ_SET_INPUTINFO	0x19006
#define	DREQ_SET_JOBCANCEL	0x19007
#define	DREQ_SET_CALIB		0x19008
#define	DREQ_SET_CASSET_FLAG	0x19009
#define	DREQ_SET_PRINTMODE	0x1900A
#define	DREQ_SET_STATUSID	0x1900B
#define	DREQ_SET_STARTUPSET	0x1900C
#define DREQ_SET_IMAGESHIFT_VERT	0x1900d
#define DREQ_SET_MPTRAY_FIRST	0x1900e
#define DREQ_SET_ASTINFO		0x1900f

#define	DREQ_GET_DEVICEINFO	0x1a001
#define	DREQ_GET_IMAGESHIFT	0x1a002
#define	DREQ_GET_SLEEPTIMER	0x1a003
#define	DREQ_GET_CALIB_DATA	0x1a004
#define	DREQ_GET_COUNTER	0x1a005
#define	DREQ_GET_WARNING	0x1a006
#define	DREQ_GET_TIME		0x1a007
#define	DREQ_GET_USBINFO	0x1a008
#define	DREQ_GET_ENGINEVER	0x1a009
#define	DREQ_GET_CONSUMABLE	0x1a00A
#define	DREQ_GET_NIC_PARAM	0x1a00B
#define	DREQ_GET_INPUTINFO	0x1a00C
#define	DREQ_GET_JOBCANCEL	0x1a00D
#define	DREQ_GET_CALIB		0x1a00E
#define	DREQ_GET_CASSET_FLAG	0x1a00F
#define	DREQ_GET_PRINTMODE	0x1a010
#define	DREQ_GET_CALIB_DATA2	0x1a011
#define DREQ_GET_DIGREGDATA 0x1a012
#define	DREQ_GET_STARTUPSET	0x1a013
#define DREQ_GET_CALIB_DATA3 0x01a014
#define DREQ_GET_IMAGESHIFT_VERT	0x1a015
#define DREQ_GET_MPTRAY_FIRST	0x1a016
#define DREQ_GET_PRINTERINFO	0x1a017
#define DREQ_GET_DEVICEINFO2	0x1a018
#define DREQ_GET_SCANNERPROFILE	0x1a019
#define DREQ_GET_ITBPROFILE		0x1a01a
#define DREQ_GET_ASTINFO		0x1a01b

#define DREQ_SET_UST		0x1b001

#define	DREQ_SET_SV_SMALL	0x1d001
#define	DREQ_SET_SV_REGIST	0x1d002
#define	DREQ_SET_SV_VDOFS	0x1d003
#define	DREQ_SET_SV_VBACK	0x1d004
#define	DREQ_SET_SV_ATRPT	0x1d005
#define	DREQ_SET_SV_SUPLY	0x1d006
#define	DREQ_SET_SV_AC		0x1d007
#define	DREQ_SET_SV_TONER	0x1d008
#define	DREQ_SET_SV_TWRNG	0x1d009
#define	DREQ_SET_SV_LSLEEP	0x1d00a
#define	DREQ_SET_SV_DRMT	0x1d00b
#define	DREQ_SET_SV_LDUTY	0x1d00c
#define	DREQ_SET_SV_FIXSPD	0x1d00d
#define	DREQ_SET_SV_DMAXADJ	0x1d00e
#define	DREQ_SET_SV_DHALFADJ	0x1d00f
#define	DREQ_SET_SV_ATRINT	0x1d010
#define	DREQ_SET_SV_CLNINT	0x1d011
#define	DREQ_SET_SV_FIXTEMP	0x1d012
#define	DREQ_SET_SV_ITOPTEMP	0x1d013
#define	DREQ_SET_SV_1TR		0x1d014
#define	DREQ_SET_SV_2TR		0x1d015
#define	DREQ_SET_SV_MAINOFS	0x1d016
#define	DREQ_SET_SV_SUBOFS	0x1d017
#define	DREQ_SET_SV_AAAA	0x1d018
#define	DREQ_SET_SV_BBBB	0x1d019
#define DREQ_SET_SYSIMAGESHIFT	0x1d01a
#define DREQ_SET_PARTSRESET2		0x1d01b
#define DREQ_SET_DRUMCOUNTER	0x1d01c
#define DREQ_SET_SV_SET		0x1d01d
#define DREQ_SET_SPECIALPRINT	0x1d01e
#define DREQ_SET_SV_SPECIAL	0x1d01f
#define DREQ_SET_REGIROLLER	0x1d020
#define DREQ_SET_PRINTCONTINUOUS 0x1d021

#define	DREQ_GET_SV_SMALL	0x1e001
#define	DREQ_GET_SV_REGIST	0x1e002
#define	DREQ_GET_SV_VDOFS	0x1e003
#define	DREQ_GET_SV_VBACK	0x1e004
#define	DREQ_GET_SV_ATRPT	0x1e005
#define	DREQ_GET_SV_SUPLY	0x1e006
#define	DREQ_GET_SV_AC		0x1e007
#define	DREQ_GET_SV_TONER	0x1e008
#define	DREQ_GET_SV_TWRNG	0x1e009
#define	DREQ_GET_SV_LSLEEP	0x1e00a
#define	DREQ_GET_SV_DRMT	0x1e00b
#define	DREQ_GET_SV_LDUTY	0x1e00c
#define	DREQ_GET_SV_FIXSPD	0x1e00d
#define	DREQ_GET_SV_DMAXADJ	0x1e00e
#define	DREQ_GET_SV_DHALFADJ	0x1e00f
#define	DREQ_GET_SV_ATRINT	0x1e010
#define	DREQ_GET_SV_CLNINT	0x1e011
#define	DREQ_GET_SV_FIXTEMP	0x1e012
#define	DREQ_GET_SV_ITOPTEMP	0x1e013
#define	DREQ_GET_SV_1TR		0x1e014
#define	DREQ_GET_SV_2TR		0x1e015
#define	DREQ_GET_SV_MAINOFS	0x1e016
#define	DREQ_GET_SV_SUBOFS	0x1e017
#define	DREQ_GET_SV_AAAA	0x1e018
#define	DREQ_GET_SV_BBBB	0x1e019
#define	DREQ_GET_SV_CRGCNT	0x1e01a
#define DREQ_GET_SYSIMAGESHIFT	0x1e01b
#define DREQ_GET_PARTSLIST		0x1e01c
#define DREQ_GET_DRUMCOUNTER 0x1e01d
#define DREQ_GET_SV_SET		0x1e01e
#define DREQ_GET_SPECIALPRINT	0x1e01f
#define DREQ_GET_SV_SPECIAL	0x1e020
#define DREQ_GET_PRINTCONTINUOUS 0x1e021

#define	DREQ_CLEANING_MODE1	0x0001
#define	DREQ_CLEANING_MODE2	0x0002
#define	DREQ_CLEANING_MODE3	0x0003
#define	DREQ_CLEANING_MODE4	0x0004

#define	DREQ_SERVICE_CHART1	0x0001
#define	DREQ_SERVICE_CHART2	0x0002
#define	DREQ_SERVICE_CHART3	0x0003

#define	DREQ_PARTS_FUSER	0x0001
#define	DREQ_PARTS_TONER_Y	0x0002
#define	DREQ_PARTS_TONER_M	0x0004
#define	DREQ_PARTS_TONER_C	0x0008
#define	DREQ_PARTS_TONER_K	0x0010

#define	DREQ_WARNING_TONER	0x0001
#define	DREQ_WARNING_DRUM	0x0002
#define	DREQ_WARNING_WASTETONER	0x0004
#define	DREQ_WARNING_FUSER	0x0008
#define	DREQ_WARNING_ITB	0x0010
#define	DREQ_WARNING_DRUMOUT	0x0020
#define	DREQ_WARNING_IGNORECPP	0x0020
#define DREQ_WARNING_CRGOUT	0x0040
#define DREQ_WARNING_IGNORECALIB	0x0080
#define DREQ_WARNING_TONER2	0x0100

#define	DREQ_DISABLE_CANCEL_WHILE_ERROR		0x0001
#define	DREQ_DISABLE_CANCEL_WHILE_NOERROR	0x0002

#define	DREQ_ENABLE_CASSETTE1	0x0001
#define	DREQ_ENABLE_CASSETTE2	0x0002
#define	DREQ_ENABLE_CASSETTE3	0x0004
#define	DREQ_ENABLE_CASSETTE4	0x0008
#define	DREQ_LEF_CASSETTE1		0x0010
#define	DREQ_LEF_CASSETTE2		0x0020
#define	DREQ_LEF_CASSETTE3		0x0040
#define	DREQ_LEF_CASSETTE4		0x0080

#define DREQ_ENABLE_FEEDROLLER_MULTI	0x0001
#define DREQ_ENABLE_FEEDROLLER_CAS1	0x0002
#define DREQ_ENABLE_FEEDROLLER_CAS2	0x0004
#define DREQ_ENABLE_FEEDROLLER_CAS3	0x0008
#define DREQ_ENABLE_FEEDROLLER_CAS4	0x0010
#define DREQ_ENABLE_ITBUNIT			0x0020
#define DREQ_ENABLE_TRANSROLLER		0x0040
#define DREQ_ENABLE_FUSER2			0x0080
#define DREQ_ENABLE_2NDTRANSROLLER	0x0100
#define DREQ_ENABLE_REGIROLLER		0x0200

#define DREQ_PARTS_DRUM_Y	0x0001
#define DREQ_PARTS_DRUM_M	0x0002
#define DREQ_PARTS_DRUM_C	0x0004
#define DREQ_PARTS_DRUM_K	0x0008

#define	DREQ_ENABLE_HIGHSPEEDPRINT	0x0100
#define	DREQ_ENABLE_REDUCE_STREAKS	0x0200
#define DREQ_ENABLE_PREVENTQUALITY	0x0400
#define DREQ_ENABLE_CLEANPER2SHEETS	0x0800
#define DREQ_ENABLE_HEAT_CONDITION	0x1000
#define DREQ_ENABLE_QUIET_MODE		0x2000

#define DREQ_SPECIAL_MODE_1		0x80
#define DREQ_SPECIAL_MODE_2		0x40
#define DREQ_SPECIAL_MODE_3		0x20
#define DREQ_SPECIAL_MODE_4		0x10
#define DREQ_SPECIAL_MODE_5		0x08
#define DREQ_SPECIAL_MODE_6		0x04
#define DREQ_SPECIAL_MODE_7		0x02

#define	DREQ_FUNCTION_A			0
#define DREQ_FUNCTION_B			1
#define DREQ_FUNCTION_C			2
#define DREQ_FUNCTION_D			3
#define DREQ_FUNCTION_E			4
#define DREQ_FUNCTION_F			5
#define DREQ_FUNCTION_G			6
#define DREQ_FUNCTION_H			7
#define DREQ_FUNCTION_I			8
#define DREQ_FUNCTION_J			9

#define DREQ_RESET_PARTS_REGIROLLER			5

typedef enum
{
	CCPD_RES_OK,
	CCPD_RES_NOPRINTER,
	CCPD_RES_PRINTER_ERR,
	CCPD_RES_TIME_OUT,
	CCPD_RES_INVALID_REQ,
	CCPD_RES_ERROR,
	CCPD_RES_FIFO_ERROR,
} ENUM_UIResponseID;

enum {
	CCPD_SB_READY_BIT,
	CCPD_SB_CLEANING_BIT,
	CCPD_SB_PRINTING_BIT,
	CCPD_SB_PAUSE_BIT,
	CCPD_SB_WARNING_BIT,
	CCPD_SB_CRITICAL_BIT,
	CCPD_SB_ENA_RESUME_BIT,
	CCPD_SB_IF_ERROR_BIT,
	CCPD_SB_COM_ERROR_BIT,
	CCPD_SB_SETTINGS_BIT,
};

#define	CCPD_SB_READY			( 1<<CCPD_SB_READY_BIT )
#define	CCPD_SB_CLEANING		( 1<<CCPD_SB_CLEANING_BIT )
#define	CCPD_SB_PRINTING		( 1<<CCPD_SB_PRINTING_BIT )
#define	CCPD_SB_PAUSE    		( 1<<CCPD_SB_PAUSE_BIT )
#define	CCPD_SB_WARNING 		( 1<<CCPD_SB_WARNING_BIT )
#define	CCPD_SB_CRITICAL		( 1<<CCPD_SB_CRITICAL_BIT )
#define	CCPD_SB_ENA_RESUME		( 1<<CCPD_SB_ENA_RESUME_BIT )
#define CCPD_SB_IF_ERROR		( 1<<CCPD_SB_IF_ERROR_BIT )
#define CCPD_SB_COM_ERROR		( 1<<CCPD_SB_COM_ERROR_BIT )
#define CCPD_SB_SETTINGS		( 1<<CCPD_SB_SETTINGS_BIT )
#define	CCPD_SB_STARTJOB		0x8000

#define	CCPD_SB_READY2	(CCPD_SB_READY | CCPD_SB_SETTINGS)



enum {
        PAPER_UNKNOWN,
        PAPER_A3,
        PAPER_A4,
        PAPER_A5,
        PAPER_B4 = 6,
        PAPER_B5,
        PAPER_EXECTIVE = 10,
        PAPER_LEDGER,
        PAPER_LEGAL,
        PAPER_LETTER,
        PAPER_POSTCARD,
        PAPER_DBL_POSTCARD,
        PAPER_ENV_C5 = 21,
        PAPER_ENV_COM10,
        PAPER_ENV_MONARCH,
        PAPER_ENV_DL,
        PAPER_ENV_B5,
        PAPER_ENV_YOU4,
        PAPER_ENV_KAKU2,
        PAPER_ENV_YOU2,
        PAPER_4X1_POSTCARD = 55,
        PAPER_STATEMENT = 60,
        PAPER_INDEX3X5 = 64,
        PAPER_SRA3 = 74,
        PAPER_12x18 = 102,
		PAPER_ENV_CHOU3 = 193,
        PAPER_16K = 212,
		PAPER_ENV_YOU_CHOU3 = 254,
};


enum {
	READ_TYPE_BYTE = 1,
	READ_TYPE_SHORT,
	READ_TYPE_LONG,
	READ_TYPE_ARRAY,
	READ_TYPE_ALL,
};

#define	DATA_LENGTH_BYTE	1
#define	DATA_LENGTH_SHORT	2
#define	DATA_LENGTH_LONG	4

#define	FL_DATAID_CAS1_PAPER	2
#define	FL_DATAID_CAS2_PAPER	3
#define	FL_DATAID_SLEEP_TIMER	11
#define	FL_DATAID_USERFLAG	14

#define	COUNTER_ID_MONO		0
#define	COUNTER_ID_COLOR	2

#define DREQ_REGION_OTHER			0x0000
#define DREQ_REGION_JAPAN			0x0002
#define DREQ_REGION_NORTH_AMERICA	0x0004
#define DREQ_REGION_USA				DREQ_REGION_NORTH_AMERICA
#define DREQ_REGION_CHINA			0x0006
#define DREQ_REGION_ASIA			0x0008
#define DREQ_REGION_SOUTH_AMERICA	0x000a
#define DREQ_REGION_MASK			0x000e
