/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import org.jpedal.PdfDecoder;
import org.jpedal.objects.PdfPageData;

public final class PdfPageFormat {
    private static Set<PageFormat> availablePaper;

    public PdfPageFormat() {
        throw new AssertionError((Object)"PdfPageFormat cannot be instanced.  Use factory methods.");
    }

    public static final PageFormat createPdfPageFormat(MediaSizeName mediaSizeName, PrintService printService) {
        if (printService == null) {
            printService = PrintServiceLookup.lookupDefaultPrintService();
        }
        PageFormat pageFormat = new PageFormat();
        MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
        if (mediaSize == null) {
            mediaSize = MediaSize.getMediaSizeForName(PdfPageFormat.getDefaultMediaSizeName(printService));
        }
        float f = mediaSize.getX(25400) * 72.0f;
        float f2 = mediaSize.getY(25400) * 72.0f;
        Paper paper = new Paper();
        paper.setSize(f, f2);
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printService.getDefaultAttributeValue(MediaPrintableArea.class);
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(mediaSizeName);
        MediaPrintableArea[] mediaPrintableAreaArray = (MediaPrintableArea[])printService.getSupportedAttributeValues(MediaPrintableArea.class, null, hashPrintRequestAttributeSet);
        float[] fArray = mediaPrintableAreaArray[0].getPrintableArea(25400);
        int n = 0;
        while (n < 4) {
            int n2 = n++;
            fArray[n2] = fArray[n2] * 72.0f;
        }
        if (fArray[2] + fArray[0] > f) {
            fArray[2] = f - fArray[0];
        }
        if (fArray[3] + fArray[1] > f2) {
            fArray[3] = f2 - fArray[1];
        }
        paper.setImageableArea(fArray[0], fArray[1], fArray[2], fArray[3]);
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public static PageFormat getDefaultPage(PrintService printService) {
        if (printService == null) {
            printService = PrintServiceLookup.lookupDefaultPrintService();
        }
        return PdfPageFormat.createPdfPageFormat(PdfPageFormat.getDefaultMediaSizeName(printService), printService);
    }

    public static MediaSizeName getDefaultMediaSizeName(PrintService printService) {
        MediaSizeName mediaSizeName = (MediaSizeName)printService.getDefaultAttributeValue(MediaSizeName.class);
        if (mediaSizeName == null || MediaSize.getMediaSizeForName(mediaSizeName) == null) {
            Locale locale = Locale.getDefault();
            mediaSizeName = locale.equals(Locale.UK) ? MediaSizeName.ISO_A4 : (locale.equals(Locale.US) ? MediaSizeName.NA_LETTER : MediaSizeName.ISO_A4);
        }
        return mediaSizeName;
    }

    public static void findPrinterPapers(PrintService printService) {
        Media[] mediaArray;
        availablePaper = new HashSet<PageFormat>();
        if (printService == null) {
            printService = PrintServiceLookup.lookupDefaultPrintService();
        }
        for (Media media : mediaArray = (Media[])printService.getSupportedAttributeValues(Media.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null)) {
            MediaSize mediaSize;
            if (!(media instanceof MediaSizeName) || (mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)media)) == null) continue;
            availablePaper.add(PdfPageFormat.createPdfPageFormat((MediaSizeName)media, printService));
        }
    }

    public static PageFormat getPageFormat(int n, PdfDecoder pdfDecoder) {
        PdfPageData pdfPageData = pdfDecoder.getPdfPageData();
        float f = pdfPageData.getCropBoxWidth(n);
        float f2 = pdfPageData.getCropBoxHeight(n);
        PageFormat pageFormat = PdfPageFormat.getAppropriatePageFormat(f, f2);
        return pageFormat;
    }

    private static PageFormat getAppropriatePageFormat(float f, float f2) {
        if (availablePaper == null) {
            PdfPageFormat.findPrinterPapers(null);
        }
        PageFormat pageFormat = null;
        for (PageFormat pageFormat2 : availablePaper) {
            pageFormat = PdfPageFormat.getClosestPageFormat(pageFormat, pageFormat2, f, f2);
        }
        if (pageFormat == null) {
            pageFormat = PdfPageFormat.getDefaultPage(null);
        }
        return pageFormat;
    }

    private static PageFormat getClosestPageFormat(PageFormat pageFormat, PageFormat pageFormat2, float f, float f2) {
        double d;
        double d2 = pageFormat2.getHeight() > pageFormat2.getWidth() ? pageFormat2.getHeight() : pageFormat2.getWidth();
        double d3 = pageFormat2.getHeight() < pageFormat2.getWidth() ? pageFormat2.getHeight() : pageFormat2.getWidth();
        double d4 = f2 > f ? (double)f2 : (double)f;
        double d5 = d = f2 < f ? (double)f2 : (double)f;
        if (d3 >= d && d2 >= d4) {
            double d6;
            if (pageFormat == null) {
                PageFormat pageFormat3 = (PageFormat)pageFormat2.clone();
                return pageFormat3;
            }
            double d7 = pageFormat.getHeight() > pageFormat.getWidth() ? pageFormat.getHeight() : pageFormat.getWidth();
            double d8 = d6 = pageFormat.getHeight() < pageFormat.getWidth() ? pageFormat.getHeight() : pageFormat.getWidth();
            if (d7 + d6 > d3 + d2) {
                PageFormat pageFormat4 = (PageFormat)pageFormat2.clone();
                return pageFormat4;
            }
        }
        return pageFormat;
    }
}

