/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.MouseMode;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUIMouseHandler;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMousePageTurn;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMousePanMode;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMouseSelector;
import org.jpedal.io.PdfObjectReader;

public class SwingMouseListener
implements GUIMouseHandler,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private PdfDecoder decode_pdf;
    private SwingGUI currentGUI;
    private Values commonValues;
    private Commands currentCommands;
    SwingMouseSelector selectionFunctions;
    SwingMousePanMode panningFunctions;
    SwingMousePageTurn pageTurnFunctions;
    private boolean scrollPageChanging = false;
    private int cx;
    private int cy;
    private String message = "";
    private MouseMode mouseMode = new MouseMode();
    private AutoScrollThread scrollThread = new AutoScrollThread();

    public SwingMouseListener(PdfDecoder pdfDecoder, SwingGUI swingGUI, Values values, Commands commands) {
        this.decode_pdf = pdfDecoder;
        this.currentGUI = swingGUI;
        this.commonValues = values;
        this.currentCommands = commands;
        this.mouseMode = commands.getMouseMode();
        this.selectionFunctions = new SwingMouseSelector(pdfDecoder, swingGUI, values, commands);
        this.panningFunctions = new SwingMousePanMode(pdfDecoder);
        this.pageTurnFunctions = new SwingMousePageTurn(pdfDecoder, swingGUI, values, commands);
        if (SwingUtilities.isEventDispatchThread()) {
            this.scrollThread.init();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    SwingMouseListener.this.scrollThread.init();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
        pdfDecoder.addExternalHandler(this, 10);
    }

    public void setupExtractor() {
        System.out.println("Set up extractor called");
        this.decode_pdf.addMouseMotionListener(this);
        this.decode_pdf.addMouseListener(this);
    }

    public void setupMouse() {
        this.decode_pdf.addMouseMotionListener(this);
        this.decode_pdf.addMouseListener(this);
        this.decode_pdf.addMouseWheelListener(this);
        this.currentGUI.setCursor(3);
    }

    public void updateRectangle() {
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.updateRectangle();
                break;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mouseClicked(mouseEvent);
                break;
            }
        }
        if (this.currentCommands.getPages().getTurnoverOn() && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mouseClicked(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                break;
            }
        }
        if (this.currentCommands.getPages().getTurnoverOn() && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mouseEntered(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        int[] nArray = new int[]{1, 0};
        this.currentGUI.setMultibox(nArray);
        this.scrollThread.setAutoScroll(false, 0, 0, 0);
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mouseExited(mouseEvent);
                break;
            }
        }
        if (this.currentCommands.getPages().getTurnoverOn() && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mouseExited(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mousePressed(mouseEvent);
                break;
            }
            case 1: {
                this.panningFunctions.mousePressed(mouseEvent);
            }
        }
        if (this.currentCommands.getPages().getTurnoverOn() && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mouseReleased(mouseEvent);
                break;
            }
            case 1: {
                this.panningFunctions.mouseReleased(mouseEvent);
            }
        }
        if (this.currentCommands.getPages().getTurnoverOn() && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mouseReleased(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.scrollAndUpdateCoords(mouseEvent);
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mouseDragged(mouseEvent);
                break;
            }
            case 1: {
                this.panningFunctions.mouseDragged(mouseEvent);
            }
        }
        if (this.currentCommands.getPages().getTurnoverOn() && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mouseDragged(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.commonValues.getCurrentPage();
        Point point = this.selectionFunctions.getCoordsOnPage(mouseEvent.getX(), mouseEvent.getY(), n);
        int n2 = (int)point.getX();
        int n3 = (int)point.getY();
        this.updateCoords(n2, n3, mouseEvent.isShiftDown());
        int[] nArray = this.selectionFunctions.updateXY(mouseEvent.getX(), mouseEvent.getY());
        n2 = nArray[0];
        n3 = nArray[1];
        if (!this.currentCommands.extractingAsImage) {
            this.getObjectUnderneath(n2, n3);
        }
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mouseMoved(mouseEvent);
                break;
            }
        }
        if (this.currentCommands.getPages().getTurnoverOn() && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mouseMoved(mouseEvent);
        }
    }

    private int getObjectUnderneath(int n, int n2) {
        if (this.decode_pdf.getDisplayView() == 1) {
            int n3 = this.decode_pdf.getDynamicRenderer().getObjectUnderneath(n, n2);
            switch (n3) {
                case -1: {
                    this.decode_pdf.setPDFCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 1: {
                    this.decode_pdf.setPDFCursor(Cursor.getPredefinedCursor(2));
                    break;
                }
                case 3: {
                    this.decode_pdf.setPDFCursor(Cursor.getPredefinedCursor(1));
                    break;
                }
                case 4: {
                    this.decode_pdf.setPDFCursor(Cursor.getPredefinedCursor(2));
                    break;
                }
                case 5: {
                    this.decode_pdf.setPDFCursor(Cursor.getPredefinedCursor(2));
                    break;
                }
                case 6: {
                    this.decode_pdf.setPDFCursor(Cursor.getPredefinedCursor(2));
                }
            }
            return n3;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        switch (this.decode_pdf.getDisplayView()) {
            case 6: {
                return;
            }
            case 3: {
                if (!this.currentCommands.getPages().getTurnoverOn()) return;
                this.pageTurnFunctions.mouseWheelMoved(mouseWheelEvent);
                return;
            }
        }
        if (this.currentGUI.getProperties().getValue("allowScrollwheelZoom").toLowerCase().equals("true") && (mouseWheelEvent.isMetaDown() || mouseWheelEvent.isControlDown())) {
            int n;
            block28: {
                n = this.currentGUI.getSelectedComboIndex(252);
                if (n != -1) {
                    n = (int)this.decode_pdf.getDPIFactory().removeScaling(this.decode_pdf.getScaling() * 100.0f);
                } else {
                    String string = (String)this.currentGUI.getSelectedComboItem(252);
                    try {
                        n = (int)Float.parseFloat(string);
                    }
                    catch (Exception exception) {
                        char c;
                        int n2;
                        n = -1;
                        int n3 = string.length();
                        for (n2 = 0; n2 < n3 && ((c = string.charAt(n2)) >= '0' && c <= '9') | c == '.'; ++n2) {
                        }
                        if (n2 > 0) {
                            string = string.substring(0, n2);
                        }
                        if (n != -1) break block28;
                        try {
                            n = (int)Float.parseFloat(string);
                        }
                        catch (Exception exception2) {
                            n = -1;
                        }
                    }
                }
            }
            float f = mouseWheelEvent.getWheelRotation();
            if (n == 1) {
                if (!(f < 0.0f)) return;
            }
            f = f < 0.0f ? 1.25f : 0.8f;
            if ((float)n + f < 0.0f) return;
            float f2 = (float)n * f;
            f2 = (int)f2 == n ? (float)(n + 1) : (float)((int)f2);
            if (f2 < 1.0f) {
                f2 = 1.0f;
            }
            if (f2 > 1000.0f) {
                f2 = 1000.0f;
            }
            final Rectangle rectangle = this.decode_pdf.getVisibleRect();
            final double d = (double)mouseWheelEvent.getX() / this.decode_pdf.getBounds().getWidth();
            final double d2 = (double)mouseWheelEvent.getY() / this.decode_pdf.getBounds().getHeight();
            this.currentGUI.snapScalingToDefaults(f2);
            Thread thread = new Thread(){

                public void run() {
                    try {
                        SwingMouseListener.this.decode_pdf.scrollRectToVisible(new Rectangle((int)(d * (double)SwingMouseListener.this.decode_pdf.getWidth() - rectangle.getWidth() / 2.0), (int)(d2 * (double)SwingMouseListener.this.decode_pdf.getHeight() - rectangle.getHeight() / 2.0), (int)SwingMouseListener.this.decode_pdf.getVisibleRect().getWidth(), (int)SwingMouseListener.this.decode_pdf.getVisibleRect().getHeight()));
                        SwingMouseListener.this.decode_pdf.repaint();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            thread.start();
            SwingUtilities.invokeLater(thread);
            return;
        }
        final JScrollBar jScrollBar = ((JScrollPane)this.decode_pdf.getParent().getParent()).getVerticalScrollBar();
        if ((jScrollBar.getValue() >= jScrollBar.getMaximum() - jScrollBar.getHeight() || jScrollBar.getHeight() == 0) && mouseWheelEvent.getUnitsToScroll() > 0 && this.currentGUI.getPageNumber() < this.decode_pdf.getPageCount()) {
            if (this.scrollPageChanging) {
                return;
            }
            this.scrollPageChanging = true;
            this.currentCommands.executeCommand(53, null);
            if (SwingUtilities.isEventDispatchThread()) {
                jScrollBar.setValue(jScrollBar.getMinimum());
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            jScrollBar.setValue(jScrollBar.getMinimum());
                        }
                    });
                }
                catch (Exception exception) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            jScrollBar.setValue(jScrollBar.getMinimum());
                        }
                    });
                }
            }
            this.scrollPageChanging = false;
            return;
        }
        if (jScrollBar.getValue() == jScrollBar.getMinimum() && mouseWheelEvent.getUnitsToScroll() < 0 && this.currentGUI.getPageNumber() > 1) {
            if (this.scrollPageChanging) {
                return;
            }
            this.scrollPageChanging = true;
            this.currentCommands.executeCommand(52, null);
            if (SwingUtilities.isEventDispatchThread()) {
                jScrollBar.setValue(jScrollBar.getMaximum());
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            jScrollBar.setValue(jScrollBar.getMaximum());
                        }
                    });
                }
                catch (Exception exception) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            jScrollBar.setValue(jScrollBar.getMaximum());
                        }
                    });
                }
            }
            this.scrollPageChanging = false;
            return;
        }
        Area area = new Area(this.decode_pdf.getVisibleRect());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(0.0, mouseWheelEvent.getUnitsToScroll() * this.decode_pdf.getScrollInterval());
        area = area.createTransformedArea(affineTransform);
        this.decode_pdf.scrollRectToVisible(area.getBounds());
    }

    protected void scrollAndUpdateCoords(MouseEvent mouseEvent) {
        int n = this.decode_pdf.getScrollInterval();
        Rectangle rectangle = new Rectangle(this.currentGUI.AdjustForAlignment(mouseEvent.getX()), mouseEvent.getY(), n, n);
        if (this.currentGUI.allowScrolling() && !this.decode_pdf.getVisibleRect().contains(rectangle)) {
            this.decode_pdf.scrollRectToVisible(rectangle);
        }
        int n2 = this.commonValues.getCurrentPage();
        Point point = this.selectionFunctions.getCoordsOnPage(mouseEvent.getX(), mouseEvent.getY(), n2);
        int n3 = (int)point.getX();
        int n4 = (int)point.getY();
        this.updateCoords(n3, n4, mouseEvent.isShiftDown());
    }

    public void updateCoords(int n, int n2, boolean bl) {
        int n3 = this.currentGUI.getRotation();
        this.cx = n;
        this.cy = n2;
        if (this.decode_pdf.getDisplayView() != 1) {
            if (SwingMouseSelector.activateMultipageHighlight) {
                if (this.decode_pdf.getDisplayView() == 3) {
                    this.cx = 0;
                    this.cy = 0;
                }
            } else {
                this.cx = 0;
                this.cy = 0;
            }
        }
        SwingMouseListener swingMouseListener = this;
        if (swingMouseListener.commonValues.isProcessing() | this.commonValues.getSelectedFile() == null) {
            this.currentGUI.setCoordText("  X:  Y:   ");
        } else {
            this.currentGUI.setCoordText("  X: " + this.cx + " Y: " + this.cy + ' ' + ' ' + this.message);
        }
    }

    public int[] getCursorLocation() {
        return new int[]{this.cx, this.cy};
    }

    public void checkLinks(boolean bl, PdfObjectReader pdfObjectReader) {
        this.pageTurnFunctions.checkLinks(bl, pdfObjectReader, this.cx, this.cy);
    }

    public void updateCordsFromFormComponent(MouseEvent mouseEvent) {
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        int n = jComponent.getX() + mouseEvent.getX();
        int n2 = jComponent.getY() + mouseEvent.getY();
        Point point = this.selectionFunctions.getCoordsOnPage(n, n2, this.commonValues.getCurrentPage());
        n = (int)point.getX();
        n2 = (int)point.getY();
        this.updateCoords(n, n2, mouseEvent.isShiftDown());
    }

    public boolean getPageTurnAnimating() {
        return this.pageTurnFunctions.getPageTurnAnimating();
    }

    public void setPageTurnAnimating(boolean bl) {
        this.pageTurnFunctions.setPageTurnAnimating(bl);
    }

    class AutoScrollThread
    implements Runnable {
        Thread scroll = new Thread(this);
        boolean autoScroll = false;
        int x = 0;
        int y = 0;
        int interval = 0;
        int usedX;
        int usedY;

        public void setAutoScroll(boolean bl, int n, int n2, int n3) {
            this.autoScroll = bl;
            this.x = SwingMouseListener.this.currentGUI.AdjustForAlignment(n);
            this.y = n2;
            this.interval = n3;
        }

        public void init() {
            this.scroll.start();
        }

        public void run() {
            while (Thread.currentThread().equals(this.scroll)) {
                if (this.autoScroll) {
                    final Rectangle rectangle = new Rectangle(this.x - this.interval, this.y - this.interval, this.interval * 2, this.interval * 2);
                    Rectangle rectangle2 = SwingMouseListener.this.decode_pdf.getVisibleRect();
                    if (!rectangle2.contains(rectangle)) {
                        if (SwingUtilities.isEventDispatchThread()) {
                            SwingMouseListener.this.decode_pdf.scrollRectToVisible(rectangle);
                        } else {
                            Runnable runnable = new Runnable(){

                                public void run() {
                                    SwingMouseListener.this.decode_pdf.scrollRectToVisible(rectangle);
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                        }
                        if (this.x - this.interval * 2 < ((SwingMouseListener)SwingMouseListener.this).decode_pdf.getVisibleRect().x) {
                            this.x -= this.interval;
                        } else if (this.x + this.interval * 2 > ((SwingMouseListener)SwingMouseListener.this).decode_pdf.getVisibleRect().x + ((SwingMouseListener)SwingMouseListener.this).decode_pdf.getVisibleRect().width) {
                            this.x += this.interval;
                        }
                        if (this.y - this.interval * 2 < ((SwingMouseListener)SwingMouseListener.this).decode_pdf.getVisibleRect().y) {
                            this.y -= this.interval;
                        } else if (this.y + this.interval * 2 > ((SwingMouseListener)SwingMouseListener.this).decode_pdf.getVisibleRect().y + ((SwingMouseListener)SwingMouseListener.this).decode_pdf.getVisibleRect().height) {
                            this.y += this.interval;
                        }
                    }
                    this.usedX = this.x;
                    this.usedY = this.y;
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }
}

