/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.ColorMapping;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class SeparationColorSpace
extends GenericColorSpace {
    protected GenericColorSpace altCS;
    static final int Black = 1009857357;
    static final int PANTONE_BLACK = 573970506;
    private static final int Cyan = 323563838;
    private static final int Magenta = 895186280;
    public static final int Yellow = 1010591868;
    protected ColorMapping colorMapper;
    protected Map cachedValues = new HashMap();
    private float[] domain;
    protected int cmykMapping = -1;
    protected boolean isProcess = false;
    protected static final int NOCMYK = -1;
    protected static final int MYK = 1;
    protected static final int CMY = 2;
    protected static final int CMK = 4;
    protected static final int CY = 5;
    protected static final int MY = 6;
    protected static final int CM = 8;
    protected static final int CMYK = 7;
    protected static final int CMYB = 9;

    public SeparationColorSpace() {
    }

    public SeparationColorSpace(PdfObjectReader pdfObjectReader, PdfObject pdfObject) {
        this.value = -2073385820;
        this.processColorToken(pdfObjectReader, pdfObject);
    }

    protected void processColorToken(PdfObjectReader pdfObjectReader, PdfObject pdfObject) {
        int n;
        PdfObject pdfObject2 = pdfObject.getDictionary(895578984);
        PdfObject pdfObject3 = pdfObject.getDictionary(-1313946392);
        this.domain = null;
        if (pdfObject.getDictionary(861242754) != null) {
            this.isProcess = true;
        }
        byte[] byArray = null;
        Object object = null;
        if (this.value == -2073385820) {
            byArray = pdfObject.getStringValueAsByte(506543413);
            if (byArray != null) {
                object = new byte[][]{byArray};
            }
            this.componentCount = 1;
        } else {
            object = pdfObject.getStringArray(1920898752);
            this.componentCount = ((byte[][])object).length;
        }
        this.cmykMapping = -1;
        int[] nArray = new int[this.componentCount];
        if (object != null) {
            for (n = 0; n < this.componentCount; ++n) {
                nArray[n] = PdfDictionary.generateChecksum(1, object[n].length - 1, object[n]);
            }
        }
        switch (this.componentCount) {
            case 1: {
                if (object == null || nArray[0] != 1009857357 && nArray[0] != 573970506) break;
                this.cmykMapping = 1009857357;
                break;
            }
            case 2: {
                if (nArray[0] == 323563838) {
                    if (nArray[1] == 1010591868) {
                        this.cmykMapping = 5;
                        break;
                    }
                    if (nArray[1] != 895186280) break;
                    this.cmykMapping = 8;
                    break;
                }
                if (nArray[0] != 895186280 || nArray[1] != 1010591868) break;
                this.cmykMapping = 6;
                break;
            }
            case 3: {
                if (nArray[0] == 895186280 && nArray[1] == 1010591868 && nArray[2] == 1009857357) {
                    this.cmykMapping = 1;
                    break;
                }
                if (nArray[0] == 323563838 && nArray[1] == 895186280 && nArray[2] == 1010591868) {
                    this.cmykMapping = 2;
                    break;
                }
                if (nArray[0] != 323563838 || nArray[1] != 895186280 || nArray[2] != 1009857357) break;
                this.cmykMapping = 4;
                break;
            }
            case 4: {
                if (nArray[0] != 323563838 || nArray[1] != 895186280 || nArray[2] != 1010591868 || nArray[3] != 1009857357) break;
                this.cmykMapping = 9;
                break;
            }
            case 6: {
                if (nArray[0] != 323563838 || nArray[1] != 895186280 || nArray[2] != 1010591868 || nArray[3] != 1009857357) break;
                this.cmykMapping = 7;
            }
        }
        if (this.cmykMapping != -1) {
            this.altCS = new DeviceCMYKColorSpace();
        } else {
            pdfObject = pdfObject.getDictionary(-1247101998);
            this.altCS = ColorspaceFactory.getColorSpaceInstance(pdfObjectReader, pdfObject);
            if (this.altCS.getID() == 1247168582 && pdfObject.getParameterConstant(2054519176) == 1498837125) {
                this.altCS = new DeviceCMYKColorSpace();
            }
        }
        if (byArray != null) {
            n = byArray.length;
            int n2 = 0;
            byte[] byArray2 = new byte[n];
            for (int i = 0; i < n; ++i) {
                if (byArray[i] == 35) {
                    int n3;
                    if ((n3 = byArray[++i]) >= 65 && n3 <= 70) {
                        n3 -= 55;
                    } else if (n3 >= 97 && n3 <= 102) {
                        n3 -= 87;
                    } else if (n3 >= 48 && n3 <= 57) {
                        n3 -= 48;
                    }
                    ++i;
                    while (byArray[i] == 32 || byArray[i] == 10 || byArray[i] == 13) {
                        ++i;
                    }
                    int n4 = byArray[i];
                    if (n4 >= 65 && n4 <= 70) {
                        n4 -= 55;
                    } else if (n4 >= 97 && n4 <= 102) {
                        n4 -= 87;
                    } else if (n4 >= 48 && n4 <= 57) {
                        n4 -= 48;
                    }
                    byArray2[n2] = (byte)(n4 + (n3 << 4));
                } else {
                    byArray2[n2] = byArray[i];
                }
                ++n2;
            }
            if (n2 != n) {
                byArray = new byte[n2];
                System.arraycopy(byArray2, 0, byArray, 0, n2);
            }
            this.pantoneName = new String(byArray);
        }
        if (pdfObject3 == null) {
            pdfObject.getDictionary(-1313946392);
        }
        if (pdfObject3 == null && pdfObject2 != null) {
            pdfObject3 = pdfObject2.getDictionary(-1313946392);
        }
        this.colorMapper = new ColorMapping(pdfObjectReader, pdfObject3);
        this.domain = pdfObject3.getFloatArray(1026641277);
    }

    private void setColor(float f) {
        try {
            if (this.cmykMapping == 1009857357) {
                float[] fArray = new float[]{0.0f, 0.0f, 0.0f, f};
                this.altCS.setColor(fArray, 1);
            } else {
                int n = 1;
                if (this.domain != null) {
                    n = this.domain.length / 2;
                }
                float[] fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    fArray[i] = f;
                }
                float[] fArray2 = this.colorMapper.getOperandFloat(fArray);
                this.altCS.setColor(fArray2, fArray2.length);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setColor(float[] fArray, int n) {
        this.setColor(fArray[0]);
    }

    public void setColor(String[] stringArray, int n) {
        float[] fArray = new float[]{Float.parseFloat(stringArray[0])};
        this.setColor(fArray, 1);
    }

    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, boolean bl) {
        BufferedImage bufferedImage;
        block9: {
            ImageInputStream imageInputStream;
            ImageReader imageReader;
            ByteArrayInputStream byteArrayInputStream;
            block8: {
                byteArrayInputStream = null;
                imageReader = null;
                imageInputStream = null;
                try {
                    Object object;
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
                    while (iterator.hasNext() && !(imageReader = (object = iterator.next())).canReadRaster()) {
                    }
                    ImageIO.setUseCache(false);
                    imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
                    imageReader.setInput(imageInputStream, true);
                    object = imageReader.readRaster(0, null);
                    object = SeparationColorSpace.cleanupRaster((Raster)object, n3, n4, 1);
                    int n5 = ((Raster)object).getWidth();
                    int n6 = ((Raster)object).getHeight();
                    DataBufferByte dataBufferByte = (DataBufferByte)((Raster)object).getDataBuffer();
                    byte[] byArray2 = dataBufferByte.getData();
                    if (this.altCS.getID() == 1568372915) {
                        for (int i = 0; i < byArray2.length; ++i) {
                            byArray2[i] = (byte)(byArray2[i] ^ 0xFF);
                        }
                        int[] nArray = new int[]{0};
                        bufferedImage = new BufferedImage(n5, n6, 10);
                        WritableRaster writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray2, byArray2.length), n5, n6, n5, 1, nArray, null);
                        bufferedImage.setData(writableRaster);
                    } else {
                        bufferedImage = this.createImage(n5, n6, byArray2, bl);
                    }
                }
                catch (Exception exception) {
                    bufferedImage = null;
                    if (!LogWriter.isOutput()) break block8;
                    LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
                }
            }
            try {
                byteArrayInputStream.close();
                imageReader.dispose();
                imageInputStream.close();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block9;
                LogWriter.writeLog("Problem closing  " + exception);
            }
        }
        return bufferedImage;
    }

    public BufferedImage JPEG2000ToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4) throws PdfException {
        BufferedImage bufferedImage;
        block13: {
            ImageReader imageReader;
            ByteArrayInputStream byteArrayInputStream;
            block12: {
                bufferedImage = null;
                byteArrayInputStream = null;
                try {
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    imageReader = ImageIO.getImageReadersByFormatName("JPEG2000").next();
                }
                catch (Exception exception) {
                    bufferedImage = null;
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Problem reading JPEG 2000: " + exception);
                    }
                    String string = "Exception " + exception + " with JPeg 2000 Image from iir = (ImageReader)ImageIO.getImageReadersByFormatName(\"JPEG2000\").next();";
                    if (!JAIHelper.isJAIused()) {
                        string = "JPeg 2000 Images and JAI not setup.\nYou need both JAI and imageio.jar on classpath, and the VM parameter -Dorg.jpedal.jai=true switch turned on";
                    }
                    throw new PdfException(string);
                }
                if (imageReader == null) {
                    return null;
                }
                try {
                    ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
                    try {
                        imageReader.setInput(imageInputStream, true);
                        bufferedImage = imageReader.read(0);
                        imageReader.dispose();
                        imageInputStream.close();
                        byteArrayInputStream.close();
                    }
                    catch (Exception exception) {
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("Problem reading JPEG 2000: " + exception);
                        }
                        exception.printStackTrace();
                        return null;
                    }
                    bufferedImage = SeparationColorSpace.cleanupImage(bufferedImage, n3, n4, this.value);
                    n = bufferedImage.getWidth();
                    n2 = bufferedImage.getHeight();
                    DataBufferByte dataBufferByte = (DataBufferByte)bufferedImage.getRaster().getDataBuffer();
                    byte[] byArray2 = dataBufferByte.getData();
                    bufferedImage = this.createImage(n, n2, byArray2, false);
                }
                catch (Exception exception) {
                    bufferedImage = null;
                    if (!LogWriter.isOutput()) break block12;
                    LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
                }
            }
            try {
                byteArrayInputStream.close();
                imageReader.dispose();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block13;
                LogWriter.writeLog("Problem closing  " + exception);
            }
        }
        return bufferedImage;
    }

    public BufferedImage dataToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage;
        block2: {
            bufferedImage = null;
            try {
                bufferedImage = this.createImage(n, n2, byArray, false);
            }
            catch (Exception exception) {
                bufferedImage = null;
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Couldn't convert Separation colorspace data: " + exception);
            }
        }
        return bufferedImage;
    }

    private BufferedImage createImage(int n, int n2, byte[] byArray, boolean bl) {
        int n3;
        int n4 = 3 * n * n2;
        byte[] byArray2 = new byte[n4];
        int n5 = byArray.length;
        int n6 = 0;
        float[][] fArray = new float[3][256];
        for (n3 = 0; n3 < 256; ++n3) {
            fArray[0][n3] = -1.0f;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            int n7 = byArray[n3] & 0xFF;
            if (fArray[0][n7] == -1.0f) {
                if (bl) {
                    this.setColor(1.0f - (float)n7 / 255.0f);
                } else {
                    this.setColor((float)n7 / 255.0f);
                }
                fArray[0][n7] = ((Color)((Object)this.getColor())).getRed();
                fArray[1][n7] = ((Color)((Object)this.getColor())).getGreen();
                fArray[2][n7] = ((Color)((Object)this.getColor())).getBlue();
            }
            for (int i = 0; i < 3; ++i) {
                byArray2[n6] = (byte)fArray[i][n7];
                ++n6;
            }
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Raster raster = ColorSpaceConvertor.createInterleavedRaster(byArray2, n, n2);
        bufferedImage.setData(raster);
        return bufferedImage;
    }

    public byte[] convertIndexToRGB(byte[] byArray) {
        byte[] byArray2;
        block6: {
            this.isConverted = true;
            byArray2 = new byte[768];
            try {
                int n = 0;
                float[] fArray = new float[1];
                Color color = null;
                int n2 = byArray.length;
                float[] fArray2 = new float[this.componentCount];
                for (int i = 0; i < n2; i += this.componentCount) {
                    if (this.componentCount == 1 && this.value == -2073385820 && this.colorMapper == null) {
                        fArray = new float[1];
                        fArray[1] = byArray[i] & 0xFF;
                        this.setColor(fArray, 1);
                        color = (Color)((Object)this.getColor());
                    } else {
                        for (int j = 0; j < this.componentCount; ++j) {
                            fArray2[j] = (float)(byArray[i + j] & 0xFF) / 255.0f;
                        }
                        float[] fArray3 = this.colorMapper.getOperandFloat(fArray2);
                        this.altCS.setColor(fArray3, fArray3.length);
                        color = (Color)((Object)this.altCS.getColor());
                    }
                    byArray2[n] = (byte)color.getRed();
                    byArray2[++n] = (byte)color.getGreen();
                    byArray2[++n] = (byte)color.getBlue();
                    ++n;
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception  " + exception + " converting colorspace");
            }
        }
        return byArray2;
    }

    public PdfPaint getColor() {
        return this.altCS.getColor();
    }

    public final Object clone() {
        this.setColorStatus();
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to clone object");
        }
        return object;
    }

    private void setColorStatus() {
        int n = this.altCS.currentColor.getRGB();
        this.r = n >> 16 & 0xFF;
        this.g = n >> 8 & 0xFF;
        this.b = n & 0xFF;
    }

    public void restoreColorStatus() {
        this.altCS.currentColor = new PdfColor(this.r, this.g, this.b);
        this.altCS.clearCache();
    }

    public GenericColorSpace getAltColorSpace() {
        return this.altCS;
    }
}

