/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.synthesis;

import java.awt.Point;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.ProgressWatch;
import jj2000.j2k.wavelet.Subband;
import jj2000.j2k.wavelet.synthesis.CBlkWTDataSrcDec;
import jj2000.j2k.wavelet.synthesis.InverseWT;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public class InvWTFull
extends InverseWT {
    private ProgressWatch pw = null;
    private int cblkToDecode = 0;
    private int nDecCblk = 0;
    private CBlkWTDataSrcDec src;
    private int dtype;
    private DataBlk[] reconstructedComps;
    private int[] ndl;
    private boolean[][] reversible;

    public InvWTFull(CBlkWTDataSrcDec cBlkWTDataSrcDec, DecoderSpecs decoderSpecs) {
        super(cBlkWTDataSrcDec, decoderSpecs);
        this.src = cBlkWTDataSrcDec;
        int n = cBlkWTDataSrcDec.getNumComps();
        this.reconstructedComps = new DataBlk[n];
        this.ndl = new int[n];
        this.pw = FacilityManager.getProgressWatch();
    }

    private boolean isSubbandReversible(Subband subband) {
        if (subband.isNode) {
            return this.isSubbandReversible(subband.getLL()) && this.isSubbandReversible(subband.getHL()) && this.isSubbandReversible(subband.getLH()) && this.isSubbandReversible(subband.getHH()) && ((SubbandSyn)subband).hFilter.isReversible() && ((SubbandSyn)subband).vFilter.isReversible();
        }
        return true;
    }

    public boolean isReversible(int n, int n2) {
        if (this.reversible[n] == null) {
            this.reversible[n] = new boolean[this.getNumComps()];
            for (int i = this.reversible.length - 1; i >= 0; --i) {
                this.reversible[n][i] = this.isSubbandReversible(this.src.getSynSubbandTree(n, i));
            }
        }
        return this.reversible[n][n2];
    }

    public int getNomRangeBits(int n) {
        return this.src.getNomRangeBits(n);
    }

    public int getFixedPoint(int n) {
        return this.src.getFixedPoint(n);
    }

    public final DataBlk getInternCompData(DataBlk dataBlk, int n) {
        int n2 = this.getTileIdx();
        this.dtype = this.src.getSynSubbandTree(n2, n).getHorWFilter() == null ? 3 : this.src.getSynSubbandTree(n2, n).getHorWFilter().getDataType();
        if (this.reconstructedComps[n] == null) {
            switch (this.dtype) {
                case 4: {
                    this.reconstructedComps[n] = new DataBlkFloat(0, 0, this.getTileCompWidth(n2, n), this.getTileCompHeight(n2, n));
                    break;
                }
                case 3: {
                    this.reconstructedComps[n] = new DataBlkInt(0, 0, this.getTileCompWidth(n2, n), this.getTileCompHeight(n2, n));
                }
            }
            this.waveletTreeReconstruction(this.reconstructedComps[n], this.src.getSynSubbandTree(n2, n), n);
            if (this.pw != null && n == this.src.getNumComps() - 1) {
                this.pw.terminateProgressWatch();
            }
        }
        if (dataBlk.getDataType() != this.dtype) {
            dataBlk = this.dtype == 3 ? new DataBlkInt(dataBlk.ulx, dataBlk.uly, dataBlk.w, dataBlk.h) : new DataBlkFloat(dataBlk.ulx, dataBlk.uly, dataBlk.w, dataBlk.h);
        }
        dataBlk.setData(this.reconstructedComps[n].getData());
        dataBlk.offset = this.reconstructedComps[n].w * dataBlk.uly + dataBlk.ulx;
        dataBlk.scanw = this.reconstructedComps[n].w;
        dataBlk.progressive = false;
        return dataBlk;
    }

    public DataBlk getCompData(DataBlk dataBlk, int n) {
        Object[] objectArray = null;
        switch (dataBlk.getDataType()) {
            case 3: {
                int[] nArray = (int[])dataBlk.getData();
                if (nArray == null || nArray.length < dataBlk.w * dataBlk.h) {
                    nArray = new int[dataBlk.w * dataBlk.h];
                }
                objectArray = nArray;
                break;
            }
            case 4: {
                float[] fArray = (float[])dataBlk.getData();
                if (fArray == null || fArray.length < dataBlk.w * dataBlk.h) {
                    fArray = new float[dataBlk.w * dataBlk.h];
                }
                objectArray = fArray;
            }
        }
        dataBlk = this.getInternCompData(dataBlk, n);
        dataBlk.setData(objectArray);
        dataBlk.offset = 0;
        dataBlk.scanw = dataBlk.w;
        return dataBlk;
    }

    private void wavelet2DReconstruction(DataBlk dataBlk, SubbandSyn subbandSyn, int n) {
        int n2;
        if (subbandSyn.w == 0 || subbandSyn.h == 0) {
            return;
        }
        Object object = dataBlk.getData();
        int n3 = subbandSyn.ulx;
        int n4 = subbandSyn.uly;
        int n5 = subbandSyn.w;
        int n6 = subbandSyn.h;
        Object[] objectArray = null;
        switch (subbandSyn.getHorWFilter().getDataType()) {
            case 3: {
                objectArray = new int[n5 >= n6 ? n5 : n6];
                break;
            }
            case 4: {
                objectArray = new float[n5 >= n6 ? n5 : n6];
            }
        }
        int n7 = (n4 - dataBlk.uly) * dataBlk.w + n3 - dataBlk.ulx;
        if (subbandSyn.ulcx % 2 == 0) {
            n2 = 0;
            while (n2 < n6) {
                System.arraycopy(object, n7, objectArray, 0, n5);
                subbandSyn.hFilter.synthetize_lpf(objectArray, 0, (n5 + 1) / 2, 1, objectArray, (n5 + 1) / 2, n5 / 2, 1, object, n7, 1);
                ++n2;
                n7 += dataBlk.w;
            }
        } else {
            n2 = 0;
            while (n2 < n6) {
                System.arraycopy(object, n7, objectArray, 0, n5);
                subbandSyn.hFilter.synthetize_hpf(objectArray, 0, n5 / 2, 1, objectArray, n5 / 2, (n5 + 1) / 2, 1, object, n7, 1);
                ++n2;
                n7 += dataBlk.w;
            }
        }
        n7 = (n4 - dataBlk.uly) * dataBlk.w + n3 - dataBlk.ulx;
        switch (subbandSyn.getVerWFilter().getDataType()) {
            case 3: {
                int[] nArray = (int[])object;
                Object[] objectArray2 = objectArray;
                if (subbandSyn.ulcy % 2 == 0) {
                    int n8 = 0;
                    while (n8 < n5) {
                        n2 = n6 - 1;
                        int n9 = n7 + n2 * dataBlk.w;
                        while (n2 >= 0) {
                            objectArray2[n2] = nArray[n9];
                            --n2;
                            n9 -= dataBlk.w;
                        }
                        subbandSyn.vFilter.synthetize_lpf(objectArray, 0, (n6 + 1) / 2, 1, objectArray, (n6 + 1) / 2, n6 / 2, 1, object, n7, dataBlk.w);
                        ++n8;
                        ++n7;
                    }
                } else {
                    int n10 = 0;
                    while (n10 < n5) {
                        n2 = n6 - 1;
                        int n11 = n7 + n2 * dataBlk.w;
                        while (n2 >= 0) {
                            objectArray2[n2] = nArray[n11];
                            --n2;
                            n11 -= dataBlk.w;
                        }
                        subbandSyn.vFilter.synthetize_hpf(objectArray, 0, n6 / 2, 1, objectArray, n6 / 2, (n6 + 1) / 2, 1, object, n7, dataBlk.w);
                        ++n10;
                        ++n7;
                    }
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                float[] fArray2 = objectArray;
                if (subbandSyn.ulcy % 2 == 0) {
                    int n12 = 0;
                    while (n12 < n5) {
                        n2 = n6 - 1;
                        int n13 = n7 + n2 * dataBlk.w;
                        while (n2 >= 0) {
                            fArray2[n2] = fArray[n13];
                            --n2;
                            n13 -= dataBlk.w;
                        }
                        subbandSyn.vFilter.synthetize_lpf(objectArray, 0, (n6 + 1) / 2, 1, objectArray, (n6 + 1) / 2, n6 / 2, 1, object, n7, dataBlk.w);
                        ++n12;
                        ++n7;
                    }
                } else {
                    int n14 = 0;
                    while (n14 < n5) {
                        n2 = n6 - 1;
                        int n15 = n7 + n2 * dataBlk.w;
                        while (n2 >= 0) {
                            fArray2[n2] = fArray[n15];
                            --n2;
                            n15 -= dataBlk.w;
                        }
                        subbandSyn.vFilter.synthetize_hpf(objectArray, 0, n6 / 2, 1, objectArray, n6 / 2, (n6 + 1) / 2, 1, object, n7, dataBlk.w);
                        ++n14;
                        ++n7;
                    }
                }
                break;
            }
        }
    }

    private void waveletTreeReconstruction(DataBlk dataBlk, SubbandSyn subbandSyn, int n) {
        if (!subbandSyn.isNode) {
            if (subbandSyn.w == 0 || subbandSyn.h == 0) {
                return;
            }
            DataBlk dataBlk2 = this.dtype == 3 ? new DataBlkInt() : new DataBlkFloat();
            Point point = subbandSyn.numCb;
            Object object = dataBlk.getData();
            for (int i = 0; i < point.y; ++i) {
                for (int j = 0; j < point.x; ++j) {
                    dataBlk2 = this.src.getInternCodeBlock(n, i, j, subbandSyn, dataBlk2);
                    Object object2 = dataBlk2.getData();
                    if (this.pw != null) {
                        ++this.nDecCblk;
                        this.pw.updateProgressWatch(this.nDecCblk, null);
                    }
                    for (int k = dataBlk2.h - 1; k >= 0; --k) {
                        System.arraycopy(object2, dataBlk2.offset + k * dataBlk2.scanw, object, (dataBlk2.uly + k) * dataBlk.w + dataBlk2.ulx, dataBlk2.w);
                    }
                }
            }
        } else if (subbandSyn.isNode) {
            this.waveletTreeReconstruction(dataBlk, (SubbandSyn)subbandSyn.getLL(), n);
            if (subbandSyn.resLvl <= this.reslvl - this.maxImgRes + this.ndl[n]) {
                this.waveletTreeReconstruction(dataBlk, (SubbandSyn)subbandSyn.getHL(), n);
                this.waveletTreeReconstruction(dataBlk, (SubbandSyn)subbandSyn.getLH(), n);
                this.waveletTreeReconstruction(dataBlk, (SubbandSyn)subbandSyn.getHH(), n);
                this.wavelet2DReconstruction(dataBlk, subbandSyn, n);
            }
        }
    }

    public int getImplementationType(int n) {
        return 2;
    }

    public void setTile(int n, int n2) {
        super.setTile(n, n2);
        int n3 = this.src.getNumComps();
        int n4 = this.src.getTileIdx();
        for (int i = 0; i < n3; ++i) {
            this.ndl[i] = this.src.getSynSubbandTree((int)n4, (int)i).resLvl;
        }
        if (this.reconstructedComps != null) {
            for (int i = this.reconstructedComps.length - 1; i >= 0; --i) {
                this.reconstructedComps[i] = null;
            }
        }
        this.cblkToDecode = 0;
        for (int i = 0; i < n3; ++i) {
            SubbandSyn subbandSyn = this.src.getSynSubbandTree(n4, i);
            for (int j = 0; j <= this.reslvl - this.maxImgRes + subbandSyn.resLvl; ++j) {
                SubbandSyn subbandSyn2;
                if (j == 0) {
                    subbandSyn2 = (SubbandSyn)subbandSyn.getSubbandByIdx(0, 0);
                    if (subbandSyn2 == null) continue;
                    this.cblkToDecode += subbandSyn2.numCb.x * subbandSyn2.numCb.y;
                    continue;
                }
                subbandSyn2 = (SubbandSyn)subbandSyn.getSubbandByIdx(j, 1);
                if (subbandSyn2 != null) {
                    this.cblkToDecode += subbandSyn2.numCb.x * subbandSyn2.numCb.y;
                }
                if ((subbandSyn2 = (SubbandSyn)subbandSyn.getSubbandByIdx(j, 2)) != null) {
                    this.cblkToDecode += subbandSyn2.numCb.x * subbandSyn2.numCb.y;
                }
                if ((subbandSyn2 = (SubbandSyn)subbandSyn.getSubbandByIdx(j, 3)) == null) continue;
                this.cblkToDecode += subbandSyn2.numCb.x * subbandSyn2.numCb.y;
            }
        }
        this.nDecCblk = 0;
        if (this.pw != null) {
            this.pw.initProgressWatch(0, this.cblkToDecode, "Decoding tile " + n4 + "...");
        }
    }

    public void nextTile() {
        super.nextTile();
        int n = this.src.getNumComps();
        int n2 = this.src.getTileIdx();
        for (int i = 0; i < n; ++i) {
            this.ndl[i] = this.src.getSynSubbandTree((int)n2, (int)i).resLvl;
        }
        if (this.reconstructedComps != null) {
            for (int i = this.reconstructedComps.length - 1; i >= 0; --i) {
                this.reconstructedComps[i] = null;
            }
        }
    }
}

