/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.wbmp;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.wbmp.I18N;
import com.sun.media.imageioimpl.plugins.wbmp.WBMPMetadata;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class WBMPImageReader
extends ImageReader {
    private ImageInputStream iis = null;
    private boolean gotHeader = false;
    private long imageDataOffset;
    private int width;
    private int height;
    private int wbmpType;
    private WBMPMetadata metadata;

    public WBMPImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        this.iis = (ImageInputStream)object;
        this.gotHeader = false;
    }

    public int getNumImages(boolean bl) throws IOException {
        if (this.iis == null) {
            throw new IllegalStateException(I18N.getString("GetNumImages0"));
        }
        if (this.seekForwardOnly && bl) {
            throw new IllegalStateException(I18N.getString("GetNumImages1"));
        }
        return 1;
    }

    public int getWidth(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return this.width;
    }

    public int getHeight(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return this.height;
    }

    public boolean isRandomAccessEasy(int n) throws IOException {
        this.checkIndex(n);
        return true;
    }

    private void checkIndex(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException(I18N.getString("WBMPImageReader0"));
        }
    }

    public void readHeader() throws IOException {
        if (this.gotHeader) {
            this.iis.seek(this.imageDataOffset);
            return;
        }
        if (this.iis == null) {
            throw new IllegalStateException(I18N.getString("WBMPImageReader1"));
        }
        this.metadata = new WBMPMetadata();
        this.wbmpType = this.iis.readByte();
        byte by = this.iis.readByte();
        if (by != 0 || !this.isValidWbmpType(this.wbmpType)) {
            throw new IIOException(I18N.getString("WBMPImageReader2"));
        }
        this.metadata.wbmpType = this.wbmpType;
        this.metadata.width = this.width = ImageUtil.readMultiByteInteger(this.iis);
        this.metadata.height = this.height = ImageUtil.readMultiByteInteger(this.iis);
        this.gotHeader = true;
        this.imageDataOffset = this.iis.getStreamPosition();
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        BufferedImage bufferedImage = new BufferedImage(1, 1, 12);
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        arrayList.add(new ImageTypeSpecifier(bufferedImage));
        return arrayList.iterator();
    }

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.checkIndex(n);
        if (this.metadata == null) {
            this.readHeader();
        }
        return this.metadata;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        if (this.iis == null) {
            throw new IllegalStateException(I18N.getString("WBMPImageReader1"));
        }
        this.checkIndex(n);
        this.clearAbortRequest();
        this.processImageStarted(n);
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        this.readHeader();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        WBMPImageReader.computeRegions(imageReadParam, this.width, this.height, imageReadParam.getDestination(), rectangle, rectangle2);
        int n2 = imageReadParam.getSourceXSubsampling();
        int n3 = imageReadParam.getSourceYSubsampling();
        int n4 = imageReadParam.getSubsamplingXOffset();
        int n5 = imageReadParam.getSubsamplingYOffset();
        BufferedImage bufferedImage = imageReadParam.getDestination();
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, 12);
        }
        boolean bl = rectangle2.equals(new Rectangle(0, 0, this.width, this.height)) && rectangle2.equals(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)bufferedImage.getSampleModel();
        if (bl) {
            if (this.abortRequested()) {
                this.processReadAborted();
                return bufferedImage;
            }
            this.iis.read(((DataBufferByte)writableRaster.getDataBuffer()).getData(), 0, this.height * multiPixelPackedSampleModel.getScanlineStride());
            this.processImageUpdate(bufferedImage, 0, 0, this.width, this.height, 1, 1, new int[]{0});
            this.processImageProgress(100.0f);
        } else {
            int n6 = (this.width + 7) / 8;
            byte[] byArray = new byte[n6];
            byte[] byArray2 = ((DataBufferByte)writableRaster.getDataBuffer()).getData();
            int n7 = multiPixelPackedSampleModel.getScanlineStride();
            this.iis.skipBytes(n6 * rectangle.y);
            int n8 = n6 * (n3 - 1);
            int[] nArray = new int[rectangle2.width];
            int[] nArray2 = new int[rectangle2.width];
            int[] nArray3 = new int[rectangle2.width];
            int[] nArray4 = new int[rectangle2.width];
            int n9 = rectangle2.x;
            int n10 = rectangle.x;
            int n11 = 0;
            while (n9 < rectangle2.x + rectangle2.width) {
                nArray3[n11] = n10 >> 3;
                nArray[n11] = 7 - (n10 & 7);
                nArray4[n11] = n9 >> 3;
                nArray2[n11] = 7 - (n9 & 7);
                ++n9;
                ++n11;
                n10 += n2;
            }
            n9 = 0;
            n10 = rectangle.y;
            n11 = rectangle2.y * n7;
            while (n9 < rectangle2.height && !this.abortRequested()) {
                this.iis.read(byArray, 0, n6);
                for (int i = 0; i < rectangle2.width; ++i) {
                    int n12 = byArray[nArray3[i]] >> nArray[i] & 1;
                    int n13 = n11 + nArray4[i];
                    byArray2[n13] = (byte)(byArray2[n13] | n12 << nArray2[i]);
                }
                n11 += n7;
                this.iis.skipBytes(n8);
                this.processImageUpdate(bufferedImage, 0, n9, rectangle2.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)n9 / (float)rectangle2.height);
                ++n9;
                n10 += n3;
            }
        }
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return bufferedImage;
    }

    public boolean canReadRaster() {
        return true;
    }

    public Raster readRaster(int n, ImageReadParam imageReadParam) throws IOException {
        BufferedImage bufferedImage = this.read(n, imageReadParam);
        return bufferedImage.getData();
    }

    public void reset() {
        super.reset();
        this.iis = null;
        this.gotHeader = false;
    }

    boolean isValidWbmpType(int n) {
        return n == 0;
    }
}

