/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import java.nio.ByteOrder;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TIFFStreamMetadata
extends IIOMetadata {
    static final String nativeMetadataFormatName = "com_sun_media_imageio_plugins_tiff_stream_1.0";
    static final String nativeMetadataFormatClassName = "com.sun.media.imageioimpl.plugins.tiff.TIFFStreamMetadataFormat";
    private static final String bigEndianString = ByteOrder.BIG_ENDIAN.toString();
    private static final String littleEndianString = ByteOrder.LITTLE_ENDIAN.toString();
    public ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;

    public TIFFStreamMetadata() {
        super(false, nativeMetadataFormatName, nativeMetadataFormatClassName, null, null);
    }

    public boolean isReadOnly() {
        return false;
    }

    private static void fatal(Node node, String string) throws IIOInvalidTreeException {
        throw new IIOInvalidTreeException(string, node);
    }

    public Node getAsTree(String string) {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ByteOrder");
        iIOMetadataNode2.setAttribute("value", this.byteOrder.toString());
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    private void mergeNativeTree(Node node) throws IIOInvalidTreeException {
        NamedNodeMap namedNodeMap;
        String string;
        Node node2 = node;
        if (!node2.getNodeName().equals(nativeMetadataFormatName)) {
            TIFFStreamMetadata.fatal(node2, "Root must be com_sun_media_imageio_plugins_tiff_stream_1.0");
        }
        if ((node2 = node2.getFirstChild()) == null || !node2.getNodeName().equals("ByteOrder")) {
            TIFFStreamMetadata.fatal(node2, "Root must have \"ByteOrder\" child");
        }
        if ((string = (namedNodeMap = node2.getAttributes()).getNamedItem("value").getNodeValue()) == null) {
            TIFFStreamMetadata.fatal(node2, "ByteOrder node must have a \"value\" attribute");
        }
        if (string.equals(bigEndianString)) {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
        } else if (string.equals(littleEndianString)) {
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else {
            TIFFStreamMetadata.fatal(node2, "Incorrect value for ByteOrder \"value\" attribute");
        }
    }

    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string.equals(nativeMetadataFormatName)) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
        this.mergeNativeTree(node);
    }

    public void reset() {
        this.byteOrder = ByteOrder.BIG_ENDIAN;
    }
}

