/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.stream;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import javax.imageio.stream.ImageInputStreamImpl;

public class FileChannelImageInputStream
extends ImageInputStreamImpl {
    private FileChannel channel;
    private MappedByteBuffer mappedBuffer;
    private long mappedPos;
    private long mappedUpperBound;

    public FileChannelImageInputStream(FileChannel fileChannel) throws IOException {
        long l;
        if (fileChannel == null) {
            throw new IllegalArgumentException("channel == null");
        }
        if (!fileChannel.isOpen()) {
            throw new IllegalArgumentException("channel.isOpen() == false");
        }
        this.channel = fileChannel;
        this.streamPos = this.flushedPos = (l = fileChannel.position());
        long l2 = fileChannel.size() - l;
        long l3 = Math.min(l2, Integer.MAX_VALUE);
        this.mappedPos = 0L;
        this.mappedUpperBound = this.mappedPos + l3;
        this.mappedBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, l, l3);
    }

    private MappedByteBuffer getMappedBuffer(int n) throws IOException {
        if (this.streamPos < this.mappedPos || this.streamPos + (long)n >= this.mappedUpperBound) {
            this.mappedPos = this.streamPos;
            long l = Math.min(this.channel.size() - this.mappedPos, Integer.MAX_VALUE);
            this.mappedUpperBound = this.mappedPos + l;
            this.mappedBuffer = this.channel.map(FileChannel.MapMode.READ_ONLY, this.mappedPos, l);
            this.mappedBuffer.order(super.getByteOrder());
        }
        return this.mappedBuffer;
    }

    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        MappedByteBuffer mappedByteBuffer = this.getMappedBuffer(1);
        if (mappedByteBuffer.remaining() < 1) {
            return -1;
        }
        int n = mappedByteBuffer.get() & 0xFF;
        ++this.streamPos;
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length");
        }
        if (n2 == 0) {
            return 0;
        }
        this.checkClosed();
        this.bitOffset = 0;
        MappedByteBuffer mappedByteBuffer = this.getMappedBuffer(n2);
        int n3 = mappedByteBuffer.remaining();
        if (n3 < 1) {
            return -1;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        mappedByteBuffer.get(byArray, n, n2);
        this.streamPos += (long)n2;
        return n2;
    }

    public void close() throws IOException {
        super.close();
        this.channel = null;
    }

    public void readFully(char[] cArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length");
        }
        if (n2 == 0) {
            return;
        }
        int n3 = 2 * n2;
        MappedByteBuffer mappedByteBuffer = this.getMappedBuffer(n3);
        if (mappedByteBuffer.remaining() < n3) {
            throw new EOFException();
        }
        CharBuffer charBuffer = mappedByteBuffer.asCharBuffer();
        charBuffer.get(cArray, n, n2);
        this.seek(this.streamPos + (long)n3);
    }

    public void readFully(short[] sArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > sArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > s.length");
        }
        if (n2 == 0) {
            return;
        }
        int n3 = 2 * n2;
        MappedByteBuffer mappedByteBuffer = this.getMappedBuffer(n3);
        if (mappedByteBuffer.remaining() < n3) {
            throw new EOFException();
        }
        ShortBuffer shortBuffer = mappedByteBuffer.asShortBuffer();
        shortBuffer.get(sArray, n, n2);
        this.seek(this.streamPos + (long)n3);
    }

    public void readFully(int[] nArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > nArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length");
        }
        if (n2 == 0) {
            return;
        }
        int n3 = 4 * n2;
        MappedByteBuffer mappedByteBuffer = this.getMappedBuffer(n3);
        if (mappedByteBuffer.remaining() < n3) {
            throw new EOFException();
        }
        IntBuffer intBuffer = mappedByteBuffer.asIntBuffer();
        intBuffer.get(nArray, n, n2);
        this.seek(this.streamPos + (long)n3);
    }

    public void readFully(long[] lArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > lArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > l.length");
        }
        if (n2 == 0) {
            return;
        }
        int n3 = 8 * n2;
        MappedByteBuffer mappedByteBuffer = this.getMappedBuffer(n3);
        if (mappedByteBuffer.remaining() < n3) {
            throw new EOFException();
        }
        LongBuffer longBuffer = mappedByteBuffer.asLongBuffer();
        longBuffer.get(lArray, n, n2);
        this.seek(this.streamPos + (long)n3);
    }

    public void readFully(float[] fArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > fArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > f.length");
        }
        if (n2 == 0) {
            return;
        }
        int n3 = 4 * n2;
        MappedByteBuffer mappedByteBuffer = this.getMappedBuffer(n3);
        if (mappedByteBuffer.remaining() < n3) {
            throw new EOFException();
        }
        FloatBuffer floatBuffer = mappedByteBuffer.asFloatBuffer();
        floatBuffer.get(fArray, n, n2);
        this.seek(this.streamPos + (long)n3);
    }

    public void readFully(double[] dArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > dArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > d.length");
        }
        if (n2 == 0) {
            return;
        }
        int n3 = 8 * n2;
        MappedByteBuffer mappedByteBuffer = this.getMappedBuffer(n3);
        if (mappedByteBuffer.remaining() < n3) {
            throw new EOFException();
        }
        DoubleBuffer doubleBuffer = mappedByteBuffer.asDoubleBuffer();
        doubleBuffer.get(dArray, n, n2);
        this.seek(this.streamPos + (long)n3);
    }

    public long length() {
        long l = -1L;
        try {
            l = this.channel.size();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return l;
    }

    public void seek(long l) throws IOException {
        super.seek(l);
        if (l >= this.mappedPos && l < this.mappedUpperBound) {
            this.mappedBuffer.position((int)(l - this.mappedPos));
        } else {
            int n = (int)Math.min(this.channel.size() - l, Integer.MAX_VALUE);
            this.mappedBuffer = this.getMappedBuffer(n);
        }
    }

    public void setByteOrder(ByteOrder byteOrder) {
        super.setByteOrder(byteOrder);
        this.mappedBuffer.order(byteOrder);
    }
}

