/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import java.io.IOException;
import java.io.OutputStream;

public class LZWDecoder {
    byte[][] stringTable;
    byte[] data = null;
    OutputStream uncompData;
    int tableIndex;
    int bitsToGet = 9;
    int bytePointer;
    int bitPointer;
    int nextData = 0;
    int nextBits = 0;
    int[] andTable = new int[]{511, 1023, 2047, 4095};

    public void decode(byte[] data, OutputStream uncompData) {
        int code;
        if (data[0] == 0 && data[1] == 1) {
            throw new RuntimeException("LZW flavour not supported.");
        }
        this.initializeStringTable();
        this.data = data;
        this.uncompData = uncompData;
        this.bytePointer = 0;
        this.bitPointer = 0;
        this.nextData = 0;
        this.nextBits = 0;
        int oldCode = 0;
        while ((code = this.getNextCode()) != 257) {
            byte[] string2;
            if (code == 256) {
                this.initializeStringTable();
                code = this.getNextCode();
                if (code == 257) break;
                this.writeString(this.stringTable[code]);
                oldCode = code;
                continue;
            }
            if (code < this.tableIndex) {
                string2 = this.stringTable[code];
                this.writeString(string2);
                this.addStringToTable(this.stringTable[oldCode], string2[0]);
                oldCode = code;
                continue;
            }
            string2 = this.stringTable[oldCode];
            string2 = this.composeString(string2, string2[0]);
            this.writeString(string2);
            this.addStringToTable(string2);
            oldCode = code;
        }
    }

    public void initializeStringTable() {
        this.stringTable = new byte[8192][];
        int i = 0;
        while (i < 256) {
            this.stringTable[i] = new byte[1];
            this.stringTable[i][0] = (byte)i;
            ++i;
        }
        this.tableIndex = 258;
        this.bitsToGet = 9;
    }

    public void writeString(byte[] string2) {
        try {
            this.uncompData.write(string2);
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    public void addStringToTable(byte[] oldString, byte newString) {
        int length = oldString.length;
        byte[] string2 = new byte[length + 1];
        System.arraycopy(oldString, 0, string2, 0, length);
        string2[length] = newString;
        this.stringTable[this.tableIndex++] = string2;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public void addStringToTable(byte[] string2) {
        this.stringTable[this.tableIndex++] = string2;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public byte[] composeString(byte[] oldString, byte newString) {
        int length = oldString.length;
        byte[] string2 = new byte[length + 1];
        System.arraycopy(oldString, 0, string2, 0, length);
        string2[length] = newString;
        return string2;
    }

    public int getNextCode() {
        try {
            this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
            this.nextBits += 8;
            if (this.nextBits < this.bitsToGet) {
                this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
                this.nextBits += 8;
            }
            int code = this.nextData >> this.nextBits - this.bitsToGet & this.andTable[this.bitsToGet - 9];
            this.nextBits -= this.bitsToGet;
            return code;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 257;
        }
    }
}

