/* nsuds - The ncurses sudoku program
 * Text-graphical sudoku with pencil-marking support.
 * Copyright (C) 2009, 2010 Vincent Launchbury.
 * -------------------------------------------
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  US
 */
#ifndef _NSUDS_UTIL_H
#define _NSUDS_UTIL_H

extern void *tmalloc(size_t n);
extern void *trealloc(void *p, size_t n);

#define clamp(x,low,high) (((x)>(high)) ? (high) : (((x)<(low)) ? (low) : (x)))

/* Get rid warnings when we need an unused parameter */
#ifdef __GNUC__
#  define unused __attribute__((unused))
#elif defined (__LCLINT__)
#  define unused /*@unused@*/
#else
#  define unused /* */
#endif /* __GNUC__ */

#endif /* _NSUDS_UTIL_H */

