//-------------------------------------------------------------------------
/*
Copyright (C) 2010 EDuke32 developers and contributors

This file is part of EDuke32.

EDuke32 is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License version 2
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
//-------------------------------------------------------------------------

#include "compat.h"
#include "build.h"

#include "namesdyn.h"
#include "global.h"

#define DVPTR(x) &x

int16_t DynamicTileMap[MAXTILES];
int16_t DynamicWeaponMap[MAX_WEAPONS];

struct dynitem
{
    const char *str;
    int32_t *dynvalptr;
    const int16_t staticval;
    const int16_t staticval_rr;
    const int16_t staticval_dn64;
};

static struct dynitem g_dynTileList[] =
{
    { "SECTOREFFECTOR", DVPTR(SECTOREFFECTOR), SECTOREFFECTOR__STATIC, SECTOREFFECTOR__STATICRR },
    { "ACTIVATOR", DVPTR(ACTIVATOR), ACTIVATOR__STATIC, ACTIVATOR__STATICRR },
    { "TOUCHPLATE", DVPTR(TOUCHPLATE), TOUCHPLATE__STATIC, TOUCHPLATE__STATICRR },
    { "ACTIVATORLOCKED", DVPTR(ACTIVATORLOCKED), ACTIVATORLOCKED__STATIC, ACTIVATORLOCKED__STATICRR },
    { "MUSICANDSFX", DVPTR(MUSICANDSFX), MUSICANDSFX__STATIC, MUSICANDSFX__STATICRR },
    { "LOCATORS", DVPTR(LOCATORS), LOCATORS__STATIC, LOCATORS__STATICRR },
    { "CYCLER", DVPTR(CYCLER), CYCLER__STATIC, CYCLER__STATICRR },
    { "MASTERSWITCH", DVPTR(MASTERSWITCH), MASTERSWITCH__STATIC, MASTERSWITCH__STATICRR },
    { "RESPAWN", DVPTR(RESPAWN), RESPAWN__STATIC, RESPAWN__STATICRR },
    { "GPSPEED", DVPTR(GPSPEED), GPSPEED__STATIC, GPSPEED__STATICRR },
    { "FOF", DVPTR(FOF), FOF__STATIC, FOF__STATICRR },
    { "ARROW", DVPTR(ARROW), ARROW__STATIC, ARROW__STATICRR },
    { "FIRSTGUNSPRITE", DVPTR(FIRSTGUNSPRITE), FIRSTGUNSPRITE__STATIC, FIRSTGUNSPRITE__STATICRR },
    { "CHAINGUNSPRITE", DVPTR(CHAINGUNSPRITE), CHAINGUNSPRITE__STATIC, CHAINGUNSPRITE__STATICRR },
    { "RPGSPRITE", DVPTR(RPGSPRITE), RPGSPRITE__STATIC, RPGSPRITE__STATICRR },
    { "FREEZESPRITE", DVPTR(FREEZESPRITE), FREEZESPRITE__STATIC, FREEZESPRITE__STATICRR },
    { "SHRINKERSPRITE", DVPTR(SHRINKERSPRITE), SHRINKERSPRITE__STATIC, SHRINKERSPRITE__STATICRR },
    { "HEAVYHBOMB", DVPTR(HEAVYHBOMB), HEAVYHBOMB__STATIC, HEAVYHBOMB__STATICRR },
    { "TRIPBOMBSPRITE", DVPTR(TRIPBOMBSPRITE), TRIPBOMBSPRITE__STATIC, TRIPBOMBSPRITE__STATICRR },
    { "SHOTGUNSPRITE", DVPTR(SHOTGUNSPRITE), SHOTGUNSPRITE__STATIC, SHOTGUNSPRITE__STATICRR },
    { "DEVISTATORSPRITE", DVPTR(DEVISTATORSPRITE), DEVISTATORSPRITE__STATIC, DEVISTATORSPRITE__STATICRR },
    { "HEALTHBOX", DVPTR(HEALTHBOX), HEALTHBOX__STATIC, HEALTHBOX__STATICRR },
    { "AMMOBOX", DVPTR(AMMOBOX), AMMOBOX__STATIC, AMMOBOX__STATICRR },
    { "GROWSPRITEICON", DVPTR(GROWSPRITEICON), GROWSPRITEICON__STATIC, GROWSPRITEICON__STATICRR },
    { "INVENTORYBOX", DVPTR(INVENTORYBOX), INVENTORYBOX__STATIC, INVENTORYBOX__STATICRR },
    { "DN64TILE34", DVPTR(DN64TILE34), DN64TILE34__STATIC, 0 },
    { "FREEZEAMMO", DVPTR(FREEZEAMMO), FREEZEAMMO__STATIC, FREEZEAMMO__STATICRR },
    { "AMMO", DVPTR(AMMO), AMMO__STATIC, AMMO__STATICRR },
    { "BATTERYAMMO", DVPTR(BATTERYAMMO), BATTERYAMMO__STATIC, BATTERYAMMO__STATICRR },
    { "DEVISTATORAMMO", DVPTR(DEVISTATORAMMO), DEVISTATORAMMO__STATIC, DEVISTATORAMMO__STATICRR },
    { "DN64TILE43", DVPTR(DN64TILE43), DN64TILE43__STATIC, 0 },
    { "RPGAMMO", DVPTR(RPGAMMO), RPGAMMO__STATIC, RPGAMMO__STATICRR },
    { "GROWAMMO", DVPTR(GROWAMMO), GROWAMMO__STATIC, GROWAMMO__STATICRR },
    { "CRYSTALAMMO", DVPTR(CRYSTALAMMO), CRYSTALAMMO__STATIC, CRYSTALAMMO__STATICRR },
    { "HBOMBAMMO", DVPTR(HBOMBAMMO), HBOMBAMMO__STATIC, HBOMBAMMO__STATICRR },
    { "AMMOLOTS", DVPTR(AMMOLOTS), AMMOLOTS__STATIC, AMMOLOTS__STATICRR },
    { "SHOTGUNAMMO", DVPTR(SHOTGUNAMMO), SHOTGUNAMMO__STATIC, SHOTGUNAMMO__STATICRR },
    { "DN64TILE50", DVPTR(DN64TILE50), DN64TILE50__STATIC, 0 },
    { "COLA", DVPTR(COLA), COLA__STATIC, COLA__STATICRR },
    { "SIXPAK", DVPTR(SIXPAK), SIXPAK__STATIC, SIXPAK__STATICRR },
    { "FIRSTAID", DVPTR(FIRSTAID), FIRSTAID__STATIC, FIRSTAID__STATICRR },
    { "SHIELD", DVPTR(SHIELD), SHIELD__STATIC, SHIELD__STATICRR },
    { "STEROIDS", DVPTR(STEROIDS), STEROIDS__STATIC, STEROIDS__STATICRR },
    { "AIRTANK", DVPTR(AIRTANK), AIRTANK__STATIC, AIRTANK__STATICRR },
    { "JETPACK", DVPTR(JETPACK), JETPACK__STATIC, JETPACK__STATICRR },
    { "HEATSENSOR", DVPTR(HEATSENSOR), HEATSENSOR__STATIC, HEATSENSOR__STATICRR },
    { "ACCESSCARD", DVPTR(ACCESSCARD), ACCESSCARD__STATIC, ACCESSCARD__STATICRR },
    { "BOOTS", DVPTR(BOOTS), BOOTS__STATIC, BOOTS__STATICRR },
    { "DN64TILE65", DVPTR(DN64TILE65), DN64TILE65__STATIC, 0 },
    { "DN64TILE66", DVPTR(DN64TILE66), DN64TILE66__STATIC, 0 },
    { "MIRRORBROKE", DVPTR(MIRRORBROKE), MIRRORBROKE__STATIC, MIRRORBROKE__STATICRR },
    { "CLOUDYOCEAN", DVPTR(CLOUDYOCEAN), CLOUDYOCEAN__STATIC, 0 },
    { "CLOUDYSKIES", DVPTR(CLOUDYSKIES), CLOUDYSKIES__STATIC, CLOUDYSKIES__STATICRR },
    { "MOONSKY1", DVPTR(MOONSKY1), MOONSKY1__STATIC, MOONSKY1__STATICRR },
    { "MOONSKY2", DVPTR(MOONSKY2), MOONSKY2__STATIC, MOONSKY2__STATICRR },
    { "MOONSKY3", DVPTR(MOONSKY3), MOONSKY3__STATIC, MOONSKY3__STATICRR },
    { "MOONSKY4", DVPTR(MOONSKY4), MOONSKY4__STATIC, MOONSKY4__STATICRR },
    { "BIGORBIT1", DVPTR(BIGORBIT1), BIGORBIT1__STATIC, BIGORBIT1__STATICRR },
    { "BIGORBIT2", DVPTR(BIGORBIT2), BIGORBIT2__STATIC, BIGORBIT2__STATICRR },
    { "BIGORBIT3", DVPTR(BIGORBIT3), BIGORBIT3__STATIC, BIGORBIT3__STATICRR },
    { "BIGORBIT4", DVPTR(BIGORBIT4), BIGORBIT4__STATIC, BIGORBIT4__STATICRR },
    { "BIGORBIT5", DVPTR(BIGORBIT5), BIGORBIT5__STATIC, BIGORBIT5__STATICRR },
    { "LA", DVPTR(LA), LA__STATIC, LA__STATICRR },
    { "REDSKY1", DVPTR(REDSKY1), REDSKY1__STATIC, REDSKY1__STATICRR },
    { "REDSKY2", DVPTR(REDSKY2), REDSKY2__STATIC, REDSKY2__STATICRR },
    { "ATOMICHEALTH", DVPTR(ATOMICHEALTH), ATOMICHEALTH__STATIC, ATOMICHEALTH__STATICRR },
    { "TECHLIGHT2", DVPTR(TECHLIGHT2), TECHLIGHT2__STATIC, TECHLIGHT2__STATICRR },
    { "TECHLIGHTBUST2", DVPTR(TECHLIGHTBUST2), TECHLIGHTBUST2__STATIC, TECHLIGHTBUST2__STATICRR },
    { "TECHLIGHT4", DVPTR(TECHLIGHT4), TECHLIGHT4__STATIC, TECHLIGHT4__STATICRR },
    { "TECHLIGHTBUST4", DVPTR(TECHLIGHTBUST4), TECHLIGHTBUST4__STATIC, TECHLIGHTBUST4__STATICRR },
    { "WALLLIGHT4", DVPTR(WALLLIGHT4), WALLLIGHT4__STATIC, WALLLIGHT4__STATICRR },
    { "WALLLIGHTBUST4", DVPTR(WALLLIGHTBUST4), WALLLIGHTBUST4__STATIC, WALLLIGHTBUST4__STATICRR },
    { "ACCESSSWITCH", DVPTR(ACCESSSWITCH), ACCESSSWITCH__STATIC, ACCESSSWITCH__STATICRR },
    { "SLOTDOOR", DVPTR(SLOTDOOR), SLOTDOOR__STATIC, SLOTDOOR__STATICRR },
    { "LIGHTSWITCH", DVPTR(LIGHTSWITCH), LIGHTSWITCH__STATIC, LIGHTSWITCH__STATICRR },
    { "SPACEDOORSWITCH", DVPTR(SPACEDOORSWITCH), SPACEDOORSWITCH__STATIC, SPACEDOORSWITCH__STATICRR },
    { "SPACELIGHTSWITCH", DVPTR(SPACELIGHTSWITCH), SPACELIGHTSWITCH__STATIC, SPACELIGHTSWITCH__STATICRR },
    { "FRANKENSTINESWITCH", DVPTR(FRANKENSTINESWITCH), FRANKENSTINESWITCH__STATIC, FRANKENSTINESWITCH__STATICRR },
    { "NUKEBUTTON", DVPTR(NUKEBUTTON), NUKEBUTTON__STATIC, NUKEBUTTON__STATICRR },
    { "MULTISWITCH", DVPTR(MULTISWITCH), MULTISWITCH__STATIC, MULTISWITCH__STATICRR },
    { "DOORTILE5", DVPTR(DOORTILE5), DOORTILE5__STATIC, DOORTILE5__STATICRR },
    { "DOORTILE6", DVPTR(DOORTILE6), DOORTILE6__STATIC, DOORTILE6__STATICRR },
    { "DOORTILE1", DVPTR(DOORTILE1), DOORTILE1__STATIC, DOORTILE1__STATICRR },
    { "DOORTILE2", DVPTR(DOORTILE2), DOORTILE2__STATIC, DOORTILE2__STATICRR },
    { "DOORTILE3", DVPTR(DOORTILE3), DOORTILE3__STATIC, DOORTILE3__STATICRR },
    { "DOORTILE4", DVPTR(DOORTILE4), DOORTILE4__STATIC, DOORTILE4__STATICRR },
    { "DOORTILE7", DVPTR(DOORTILE7), DOORTILE7__STATIC, DOORTILE7__STATICRR },
    { "DOORTILE8", DVPTR(DOORTILE8), DOORTILE8__STATIC, DOORTILE8__STATICRR },
    { "DOORTILE9", DVPTR(DOORTILE9), DOORTILE9__STATIC, DOORTILE9__STATICRR },
    { "DOORTILE10", DVPTR(DOORTILE10), DOORTILE10__STATIC, DOORTILE10__STATICRR },
    { "DOORSHOCK", DVPTR(DOORSHOCK), DOORSHOCK__STATIC, DOORSHOCK__STATICRR },
    { "DIPSWITCH", DVPTR(DIPSWITCH), DIPSWITCH__STATIC, DIPSWITCH__STATICRR },
    { "DIPSWITCH2", DVPTR(DIPSWITCH2), DIPSWITCH2__STATIC, DIPSWITCH2__STATICRR },
    { "TECHSWITCH", DVPTR(TECHSWITCH), TECHSWITCH__STATIC, TECHSWITCH__STATICRR },
    { "DIPSWITCH3", DVPTR(DIPSWITCH3), DIPSWITCH3__STATIC, DIPSWITCH3__STATICRR },
    { "ACCESSSWITCH2", DVPTR(ACCESSSWITCH2), ACCESSSWITCH2__STATIC, ACCESSSWITCH2__STATICRR },
    { "DN64TILE172", DVPTR(DN64TILE172), DN64TILE172__STATIC, 0 },
    { "DN64TILE174", DVPTR(DN64TILE174), DN64TILE174__STATIC, 0 },
    { "DN64TILE176", DVPTR(DN64TILE176), DN64TILE176__STATIC, 0 },
    { "DN64TILE178", DVPTR(DN64TILE178), DN64TILE178__STATIC, 0 },
    { "REFLECTWATERTILE", DVPTR(REFLECTWATERTILE), REFLECTWATERTILE__STATIC, REFLECTWATERTILE__STATICRR },
    { "FLOORSLIME", DVPTR(FLOORSLIME), FLOORSLIME__STATIC, FLOORSLIME__STATICRR },
    { "BIGFORCE", DVPTR(BIGFORCE), BIGFORCE__STATIC, BIGFORCE__STATICRR },
    { "EPISODE", DVPTR(EPISODE), EPISODE__STATIC, EPISODE__STATICRR },
    { "MASKWALL9", DVPTR(MASKWALL9), MASKWALL9__STATIC, MASKWALL9__STATICRR },
    { "W_LIGHT", DVPTR(W_LIGHT), W_LIGHT__STATIC, W_LIGHT__STATICRR },
    { "SCREENBREAK1", DVPTR(SCREENBREAK1), SCREENBREAK1__STATIC, SCREENBREAK1__STATICRR },
    { "SCREENBREAK2", DVPTR(SCREENBREAK2), SCREENBREAK2__STATIC, SCREENBREAK2__STATICRR },
    { "SCREENBREAK3", DVPTR(SCREENBREAK3), SCREENBREAK3__STATIC, SCREENBREAK3__STATICRR },
    { "SCREENBREAK4", DVPTR(SCREENBREAK4), SCREENBREAK4__STATIC, SCREENBREAK4__STATICRR },
    { "SCREENBREAK5", DVPTR(SCREENBREAK5), SCREENBREAK5__STATIC, SCREENBREAK5__STATICRR },
    { "SCREENBREAK6", DVPTR(SCREENBREAK6), SCREENBREAK6__STATIC, SCREENBREAK6__STATICRR },
    { "SCREENBREAK7", DVPTR(SCREENBREAK7), SCREENBREAK7__STATIC, SCREENBREAK7__STATICRR },
    { "SCREENBREAK8", DVPTR(SCREENBREAK8), SCREENBREAK8__STATIC, SCREENBREAK8__STATICRR },
    { "SCREENBREAK9", DVPTR(SCREENBREAK9), SCREENBREAK9__STATIC, SCREENBREAK9__STATICRR },
    { "SCREENBREAK10", DVPTR(SCREENBREAK10), SCREENBREAK10__STATIC, SCREENBREAK10__STATICRR },
    { "SCREENBREAK11", DVPTR(SCREENBREAK11), SCREENBREAK11__STATIC, SCREENBREAK11__STATICRR },
    { "SCREENBREAK12", DVPTR(SCREENBREAK12), SCREENBREAK12__STATIC, SCREENBREAK12__STATICRR },
    { "SCREENBREAK13", DVPTR(SCREENBREAK13), SCREENBREAK13__STATIC, SCREENBREAK13__STATICRR },
    { "MASKWALL1", DVPTR(MASKWALL1), MASKWALL1__STATIC, MASKWALL1__STATICRR },
    { "W_TECHWALL1", DVPTR(W_TECHWALL1), W_TECHWALL1__STATIC, W_TECHWALL1__STATICRR },
    { "W_TECHWALL2", DVPTR(W_TECHWALL2), W_TECHWALL2__STATIC, W_TECHWALL2__STATICRR },
    { "W_TECHWALL15", DVPTR(W_TECHWALL15), W_TECHWALL15__STATIC, W_TECHWALL15__STATICRR },
    { "W_TECHWALL3", DVPTR(W_TECHWALL3), W_TECHWALL3__STATIC, W_TECHWALL3__STATICRR },
    { "W_TECHWALL4", DVPTR(W_TECHWALL4), W_TECHWALL4__STATIC, W_TECHWALL4__STATICRR },
    { "W_TECHWALL10", DVPTR(W_TECHWALL10), W_TECHWALL10__STATIC, W_TECHWALL10__STATICRR },
    { "W_TECHWALL16", DVPTR(W_TECHWALL16), W_TECHWALL16__STATIC, W_TECHWALL16__STATICRR },
    { "WATERTILE2", DVPTR(WATERTILE2), WATERTILE2__STATIC, WATERTILE2__STATICRR },
    { "BPANNEL1", DVPTR(BPANNEL1), BPANNEL1__STATIC, BPANNEL1__STATICRR },
    { "PANNEL1", DVPTR(PANNEL1), PANNEL1__STATIC, PANNEL1__STATICRR },
    { "PANNEL2", DVPTR(PANNEL2), PANNEL2__STATIC, PANNEL2__STATICRR },
    { "WATERTILE", DVPTR(WATERTILE), WATERTILE__STATIC, WATERTILE__STATICRR },
    { "STATIC", DVPTR(STATIC), STATIC__STATIC, STATIC__STATICRR },
    { "W_SCREENBREAK", DVPTR(W_SCREENBREAK), W_SCREENBREAK__STATIC, W_SCREENBREAK__STATICRR },
    { "W_HITTECHWALL3", DVPTR(W_HITTECHWALL3), W_HITTECHWALL3__STATIC, W_HITTECHWALL3__STATICRR },
    { "W_HITTECHWALL4", DVPTR(W_HITTECHWALL4), W_HITTECHWALL4__STATIC, W_HITTECHWALL4__STATICRR },
    { "W_HITTECHWALL2", DVPTR(W_HITTECHWALL2), W_HITTECHWALL2__STATIC, W_HITTECHWALL2__STATICRR },
    { "W_HITTECHWALL1", DVPTR(W_HITTECHWALL1), W_HITTECHWALL1__STATIC, W_HITTECHWALL1__STATICRR },
    { "MASKWALL10", DVPTR(MASKWALL10), MASKWALL10__STATIC, MASKWALL10__STATICRR },
    { "MASKWALL11", DVPTR(MASKWALL11), MASKWALL11__STATIC, MASKWALL11__STATICRR },
    { "DOORTILE22", DVPTR(DOORTILE22), DOORTILE22__STATIC, DOORTILE22__STATICRR },
    { "FANSPRITE", DVPTR(FANSPRITE), FANSPRITE__STATIC, FANSPRITE__STATICRR },
    { "FANSPRITEBROKE", DVPTR(FANSPRITEBROKE), FANSPRITEBROKE__STATIC, FANSPRITEBROKE__STATICRR },
    { "FANSHADOW", DVPTR(FANSHADOW), FANSHADOW__STATIC, FANSHADOW__STATICRR },
    { "FANSHADOWBROKE", DVPTR(FANSHADOWBROKE), FANSHADOWBROKE__STATIC, FANSHADOWBROKE__STATICRR },
    { "DOORTILE18", DVPTR(DOORTILE18), DOORTILE18__STATIC, DOORTILE18__STATICRR },
    { "DOORTILE19", DVPTR(DOORTILE19), DOORTILE19__STATIC, DOORTILE19__STATICRR },
    { "DOORTILE20", DVPTR(DOORTILE20), DOORTILE20__STATIC, DOORTILE20__STATICRR },
    { "SATELLITE", DVPTR(SATELLITE), SATELLITE__STATIC, SATELLITE__STATICRR },
    { "VIEWSCREEN2", DVPTR(VIEWSCREEN2), VIEWSCREEN2__STATIC, VIEWSCREEN2__STATICRR },
    { "VIEWSCREENBROKE", DVPTR(VIEWSCREENBROKE), VIEWSCREENBROKE__STATIC, VIEWSCREENBROKE__STATICRR },
    { "VIEWSCREEN", DVPTR(VIEWSCREEN), VIEWSCREEN__STATIC, VIEWSCREEN__STATICRR },
    { "GLASS", DVPTR(GLASS), GLASS__STATIC, GLASS__STATICRR },
    { "GLASS2", DVPTR(GLASS2), GLASS2__STATIC, GLASS2__STATICRR },
    { "STAINGLASS1", DVPTR(STAINGLASS1), STAINGLASS1__STATIC, STAINGLASS1__STATICRR },
    { "MASKWALL5", DVPTR(MASKWALL5), MASKWALL5__STATIC, MASKWALL5__STATICRR },
    { "SATELITE", DVPTR(SATELITE), SATELITE__STATIC, SATELITE__STATICRR },
    { "FUELPOD", DVPTR(FUELPOD), FUELPOD__STATIC, FUELPOD__STATICRR },
    { "SLIMEPIPE", DVPTR(SLIMEPIPE), SLIMEPIPE__STATIC, SLIMEPIPE__STATICRR },
    { "CRACK1", DVPTR(CRACK1), CRACK1__STATIC, CRACK1__STATICRR },
    { "CRACK2", DVPTR(CRACK2), CRACK2__STATIC, CRACK2__STATICRR },
    { "CRACK3", DVPTR(CRACK3), CRACK3__STATIC, CRACK3__STATICRR },
    { "CRACK4", DVPTR(CRACK4), CRACK4__STATIC, CRACK4__STATICRR },
    { "FOOTPRINTS", DVPTR(FOOTPRINTS), FOOTPRINTS__STATIC, FOOTPRINTS__STATICRR },
    { "DOMELITE", DVPTR(DOMELITE), DOMELITE__STATIC, DOMELITE__STATICRR },
    { "CAMERAPOLE", DVPTR(CAMERAPOLE), CAMERAPOLE__STATIC, CAMERAPOLE__STATICRR },
    { "CHAIR1", DVPTR(CHAIR1), CHAIR1__STATIC, CHAIR1__STATICRR },
    { "CHAIR2", DVPTR(CHAIR2), CHAIR2__STATIC, CHAIR2__STATICRR },
    { "BROKENCHAIR", DVPTR(BROKENCHAIR), BROKENCHAIR__STATIC, BROKENCHAIR__STATICRR },
    { "MIRROR", DVPTR(MIRROR), MIRROR__STATIC, MIRROR__STATICRR },
    { "WATERFOUNTAIN", DVPTR(WATERFOUNTAIN), WATERFOUNTAIN__STATIC, WATERFOUNTAIN__STATICRR },
    { "WATERFOUNTAINBROKE", DVPTR(WATERFOUNTAINBROKE), WATERFOUNTAINBROKE__STATIC, WATERFOUNTAINBROKE__STATICRR },
    { "FEMMAG1", DVPTR(FEMMAG1), FEMMAG1__STATIC, FEMMAG1__STATICRR },
    { "TOILET", DVPTR(TOILET), TOILET__STATIC, TOILET__STATICRR },
    { "STALL", DVPTR(STALL), STALL__STATIC, STALL__STATICRR },
    { "STALLBROKE", DVPTR(STALLBROKE), STALLBROKE__STATIC, STALLBROKE__STATICRR },
    { "FEMMAG2", DVPTR(FEMMAG2), FEMMAG2__STATIC, FEMMAG2__STATICRR },
    { "REACTOR2", DVPTR(REACTOR2), REACTOR2__STATIC, REACTOR2__STATICRR },
    { "REACTOR2BURNT", DVPTR(REACTOR2BURNT), REACTOR2BURNT__STATIC, REACTOR2BURNT__STATICRR },
    { "REACTOR2SPARK", DVPTR(REACTOR2SPARK), REACTOR2SPARK__STATIC, REACTOR2SPARK__STATICRR },
    { "GRATE1", DVPTR(GRATE1), GRATE1__STATIC, GRATE1__STATICRR },
    { "BGRATE1", DVPTR(BGRATE1), BGRATE1__STATIC, BGRATE1__STATICRR },
    { "SOLARPANNEL", DVPTR(SOLARPANNEL), SOLARPANNEL__STATIC, SOLARPANNEL__STATICRR },
    { "NAKED1", DVPTR(NAKED1), NAKED1__STATIC, NAKED1__STATICRR },
    { "ANTENNA", DVPTR(ANTENNA), ANTENNA__STATIC, ANTENNA__STATICRR },
    { "MASKWALL12", DVPTR(MASKWALL12), MASKWALL12__STATIC, MASKWALL12__STATICRR },
    { "TOILETBROKE", DVPTR(TOILETBROKE), TOILETBROKE__STATIC, TOILETBROKE__STATICRR },
    { "PIPE2", DVPTR(PIPE2), PIPE2__STATIC, PIPE2__STATICRR },
    { "PIPE1B", DVPTR(PIPE1B), PIPE1B__STATIC, PIPE1B__STATICRR },
    { "PIPE3", DVPTR(PIPE3), PIPE3__STATIC, PIPE3__STATICRR },
    { "PIPE1", DVPTR(PIPE1), PIPE1__STATIC, PIPE1__STATICRR },
    { "CAMERA1", DVPTR(CAMERA1), CAMERA1__STATIC, CAMERA1__STATICRR },
    { "BRICK", DVPTR(BRICK), BRICK__STATIC, BRICK__STATICRR },
    { "SPLINTERWOOD", DVPTR(SPLINTERWOOD), SPLINTERWOOD__STATIC, SPLINTERWOOD__STATICRR },
    { "PIPE2B", DVPTR(PIPE2B), PIPE2B__STATIC, PIPE2B__STATICRR },
    { "BOLT1", DVPTR(BOLT1), BOLT1__STATIC, BOLT1__STATICRR },
    { "W_NUMBERS", DVPTR(W_NUMBERS), W_NUMBERS__STATIC, W_NUMBERS__STATICRR },
    { "WATERDRIP", DVPTR(WATERDRIP), WATERDRIP__STATIC, WATERDRIP__STATICRR },
    { "WATERBUBBLE", DVPTR(WATERBUBBLE), WATERBUBBLE__STATIC, WATERBUBBLE__STATICRR },
    { "WATERBUBBLEMAKER", DVPTR(WATERBUBBLEMAKER), WATERBUBBLEMAKER__STATIC, WATERBUBBLEMAKER__STATICRR },
    { "W_FORCEFIELD", DVPTR(W_FORCEFIELD), W_FORCEFIELD__STATIC, W_FORCEFIELD__STATICRR },
    { "VACUUM", DVPTR(VACUUM), VACUUM__STATIC, VACUUM__STATICRR },
    { "FOOTPRINTS2", DVPTR(FOOTPRINTS2), FOOTPRINTS2__STATIC, FOOTPRINTS2__STATICRR },
    { "FOOTPRINTS3", DVPTR(FOOTPRINTS3), FOOTPRINTS3__STATIC, FOOTPRINTS3__STATICRR },
    { "FOOTPRINTS4", DVPTR(FOOTPRINTS4), FOOTPRINTS4__STATIC, FOOTPRINTS4__STATICRR },
    { "EGG", DVPTR(EGG), EGG__STATIC, EGG__STATICRR },
    { "SCALE", DVPTR(SCALE), SCALE__STATIC, SCALE__STATICRR },
    { "CHAIR3", DVPTR(CHAIR3), CHAIR3__STATIC, CHAIR3__STATICRR },
    { "CAMERALIGHT", DVPTR(CAMERALIGHT), CAMERALIGHT__STATIC, CAMERALIGHT__STATICRR },
    { "MOVIECAMERA", DVPTR(MOVIECAMERA), MOVIECAMERA__STATIC, MOVIECAMERA__STATICRR },
    { "IVUNIT", DVPTR(IVUNIT), IVUNIT__STATIC, IVUNIT__STATICRR },
    { "POT1", DVPTR(POT1), POT1__STATIC, POT1__STATICRR },
    { "POT2", DVPTR(POT2), POT2__STATIC, POT2__STATICRR },
    { "POT3", DVPTR(POT3), POT3__STATIC, POT3__STATICRR },
    { "PIPE3B", DVPTR(PIPE3B), PIPE3B__STATIC, PIPE3B__STATICRR },
    { "WALLLIGHT3", DVPTR(WALLLIGHT3), WALLLIGHT3__STATIC, WALLLIGHT3__STATICRR },
    { "WALLLIGHTBUST3", DVPTR(WALLLIGHTBUST3), WALLLIGHTBUST3__STATIC, WALLLIGHTBUST3__STATICRR },
    { "WALLLIGHT1", DVPTR(WALLLIGHT1), WALLLIGHT1__STATIC, WALLLIGHT1__STATICRR },
    { "WALLLIGHTBUST1", DVPTR(WALLLIGHTBUST1), WALLLIGHTBUST1__STATIC, WALLLIGHTBUST1__STATICRR },
    { "WALLLIGHT2", DVPTR(WALLLIGHT2), WALLLIGHT2__STATIC, WALLLIGHT2__STATICRR },
    { "WALLLIGHTBUST2", DVPTR(WALLLIGHTBUST2), WALLLIGHTBUST2__STATIC, WALLLIGHTBUST2__STATICRR },
    { "LIGHTSWITCH2", DVPTR(LIGHTSWITCH2), LIGHTSWITCH2__STATIC, LIGHTSWITCH2__STATICRR },
    { "WAITTOBESEATED", DVPTR(WAITTOBESEATED), WAITTOBESEATED__STATIC, WAITTOBESEATED__STATICRR },
    { "DOORTILE14", DVPTR(DOORTILE14), DOORTILE14__STATIC, DOORTILE14__STATICRR },
    { "STATUE", DVPTR(STATUE), STATUE__STATIC, STATUE__STATICRR },
    { "MIKE", DVPTR(MIKE), MIKE__STATIC, MIKE__STATICRR },
    { "VASE", DVPTR(VASE), VASE__STATIC, VASE__STATICRR },
    { "SUSHIPLATE1", DVPTR(SUSHIPLATE1), SUSHIPLATE1__STATIC, SUSHIPLATE1__STATICRR },
    { "SUSHIPLATE2", DVPTR(SUSHIPLATE2), SUSHIPLATE2__STATIC, SUSHIPLATE2__STATICRR },
    { "SUSHIPLATE3", DVPTR(SUSHIPLATE3), SUSHIPLATE3__STATIC, SUSHIPLATE3__STATICRR },
    { "SUSHIPLATE4", DVPTR(SUSHIPLATE4), SUSHIPLATE4__STATIC, SUSHIPLATE4__STATICRR },
    { "DOORTILE16", DVPTR(DOORTILE16), DOORTILE16__STATIC, DOORTILE16__STATICRR },
    { "SUSHIPLATE5", DVPTR(SUSHIPLATE5), SUSHIPLATE5__STATIC, SUSHIPLATE5__STATICRR },
    { "OJ", DVPTR(OJ), OJ__STATIC, OJ__STATICRR },
    { "MASKWALL13", DVPTR(MASKWALL13), MASKWALL13__STATIC, MASKWALL13__STATICRR },
    { "HURTRAIL", DVPTR(HURTRAIL), HURTRAIL__STATIC, HURTRAIL__STATICRR },
    { "POWERSWITCH1", DVPTR(POWERSWITCH1), POWERSWITCH1__STATIC, POWERSWITCH1__STATICRR },
    { "LOCKSWITCH1", DVPTR(LOCKSWITCH1), LOCKSWITCH1__STATIC, LOCKSWITCH1__STATICRR },
    { "POWERSWITCH2", DVPTR(POWERSWITCH2), POWERSWITCH2__STATIC, POWERSWITCH2__STATICRR },
    { "ATM", DVPTR(ATM), ATM__STATIC, ATM__STATICRR },
    { "STATUEFLASH", DVPTR(STATUEFLASH), STATUEFLASH__STATIC, STATUEFLASH__STATICRR },
    { "ATMBROKE", DVPTR(ATMBROKE), ATMBROKE__STATIC, ATMBROKE__STATICRR },
    { "BIGHOLE2", DVPTR(BIGHOLE2), BIGHOLE2__STATIC, BIGHOLE2__STATICRR },
    { "STRIPEBALL", DVPTR(STRIPEBALL), STRIPEBALL__STATIC, STRIPEBALL__STATICRR },
    { "QUEBALL", DVPTR(QUEBALL), QUEBALL__STATIC, QUEBALL__STATICRR },
    { "POCKET", DVPTR(POCKET), POCKET__STATIC, POCKET__STATICRR },
    { "WOODENHORSE", DVPTR(WOODENHORSE), WOODENHORSE__STATIC, WOODENHORSE__STATICRR },
    { "TREE1", DVPTR(TREE1), TREE1__STATIC, TREE1__STATICRR },
    { "TREE2", DVPTR(TREE2), TREE2__STATIC, TREE2__STATICRR },
    { "CACTUS", DVPTR(CACTUS), CACTUS__STATIC, CACTUS__STATICRR },
    { "MASKWALL2", DVPTR(MASKWALL2), MASKWALL2__STATIC, MASKWALL2__STATICRR },
    { "MASKWALL3", DVPTR(MASKWALL3), MASKWALL3__STATIC, MASKWALL3__STATICRR },
    { "MASKWALL4", DVPTR(MASKWALL4), MASKWALL4__STATIC, MASKWALL4__STATICRR },
    { "FIREEXT", DVPTR(FIREEXT), FIREEXT__STATIC, FIREEXT__STATICRR },
    { "TOILETWATER", DVPTR(TOILETWATER), TOILETWATER__STATIC, TOILETWATER__STATICRR },
    { "NEON1", DVPTR(NEON1), NEON1__STATIC, NEON1__STATICRR },
    { "NEON2", DVPTR(NEON2), NEON2__STATIC, NEON2__STATICRR },
    { "CACTUSBROKE", DVPTR(CACTUSBROKE), CACTUSBROKE__STATIC, CACTUSBROKE__STATICRR },
    { "BOUNCEMINE", DVPTR(BOUNCEMINE), BOUNCEMINE__STATIC, BOUNCEMINE__STATICRR },
    { "BROKEFIREHYDRENT", DVPTR(BROKEFIREHYDRENT), BROKEFIREHYDRENT__STATIC, BROKEFIREHYDRENT__STATICRR },
    { "BOX", DVPTR(BOX), BOX__STATIC, BOX__STATICRR },
    { "BULLETHOLE", DVPTR(BULLETHOLE), BULLETHOLE__STATIC, BULLETHOLE__STATICRR },
    { "BOTTLE1", DVPTR(BOTTLE1), BOTTLE1__STATIC, BOTTLE1__STATICRR },
    { "BOTTLE2", DVPTR(BOTTLE2), BOTTLE2__STATIC, BOTTLE2__STATICRR },
    { "BOTTLE3", DVPTR(BOTTLE3), BOTTLE3__STATIC, BOTTLE3__STATICRR },
    { "BOTTLE4", DVPTR(BOTTLE4), BOTTLE4__STATIC, BOTTLE4__STATICRR },
    { "FEMPIC5", DVPTR(FEMPIC5), FEMPIC5__STATIC, FEMPIC5__STATICRR },
    { "FEMPIC6", DVPTR(FEMPIC6), FEMPIC6__STATIC, FEMPIC6__STATICRR },
    { "FEMPIC7", DVPTR(FEMPIC7), FEMPIC7__STATIC, FEMPIC7__STATICRR },
    { "HYDROPLANT", DVPTR(HYDROPLANT), HYDROPLANT__STATIC, HYDROPLANT__STATICRR },
    { "OCEANSPRITE1", DVPTR(OCEANSPRITE1), OCEANSPRITE1__STATIC, OCEANSPRITE1__STATICRR },
    { "OCEANSPRITE2", DVPTR(OCEANSPRITE2), OCEANSPRITE2__STATIC, OCEANSPRITE2__STATICRR },
    { "OCEANSPRITE3", DVPTR(OCEANSPRITE3), OCEANSPRITE3__STATIC, OCEANSPRITE3__STATICRR },
    { "OCEANSPRITE4", DVPTR(OCEANSPRITE4), OCEANSPRITE4__STATIC, OCEANSPRITE4__STATICRR },
    { "OCEANSPRITE5", DVPTR(OCEANSPRITE5), OCEANSPRITE5__STATIC, OCEANSPRITE5__STATICRR },
    { "GENERICPOLE", DVPTR(GENERICPOLE), GENERICPOLE__STATIC, GENERICPOLE__STATICRR },
    { "CONE", DVPTR(CONE), CONE__STATIC, CONE__STATICRR },
    { "HANGLIGHT", DVPTR(HANGLIGHT), HANGLIGHT__STATIC, HANGLIGHT__STATICRR },
    { "HYDRENT", DVPTR(HYDRENT), HYDRENT__STATIC, HYDRENT__STATICRR },
    { "MASKWALL14", DVPTR(MASKWALL14), MASKWALL14__STATIC, MASKWALL14__STATICRR },
    { "TIRE", DVPTR(TIRE), TIRE__STATIC, TIRE__STATICRR },
    { "PIPE5", DVPTR(PIPE5), PIPE5__STATIC, PIPE5__STATICRR },
    { "PIPE6", DVPTR(PIPE6), PIPE6__STATIC, PIPE6__STATICRR },
    { "PIPE4", DVPTR(PIPE4), PIPE4__STATIC, PIPE4__STATICRR },
    { "PIPE4B", DVPTR(PIPE4B), PIPE4B__STATIC, PIPE4B__STATICRR },
    { "BROKEHYDROPLANT", DVPTR(BROKEHYDROPLANT), BROKEHYDROPLANT__STATIC, BROKEHYDROPLANT__STATICRR },
    { "PIPE5B", DVPTR(PIPE5B), PIPE5B__STATIC, PIPE5B__STATICRR },
    { "NEON3", DVPTR(NEON3), NEON3__STATIC, NEON3__STATICRR },
    { "NEON4", DVPTR(NEON4), NEON4__STATIC, NEON4__STATICRR },
    { "NEON5", DVPTR(NEON5), NEON5__STATIC, NEON5__STATICRR },
    { "BOTTLE5", DVPTR(BOTTLE5), BOTTLE5__STATIC, BOTTLE5__STATICRR },
    { "BOTTLE6", DVPTR(BOTTLE6), BOTTLE6__STATIC, BOTTLE6__STATICRR },
    { "BOTTLE8", DVPTR(BOTTLE8), BOTTLE8__STATIC, BOTTLE8__STATICRR },
    { "SPOTLITE", DVPTR(SPOTLITE), SPOTLITE__STATIC, SPOTLITE__STATICRR },
    { "HANGOOZ", DVPTR(HANGOOZ), HANGOOZ__STATIC, HANGOOZ__STATICRR },
    { "MASKWALL15", DVPTR(MASKWALL15), MASKWALL15__STATIC, MASKWALL15__STATICRR },
    { "BOTTLE7", DVPTR(BOTTLE7), BOTTLE7__STATIC, BOTTLE7__STATICRR },
    { "HORSEONSIDE", DVPTR(HORSEONSIDE), HORSEONSIDE__STATIC, HORSEONSIDE__STATICRR },
    { "GLASSPIECES", DVPTR(GLASSPIECES), GLASSPIECES__STATIC, GLASSPIECES__STATICRR },
    { "HORSELITE", DVPTR(HORSELITE), HORSELITE__STATIC, HORSELITE__STATICRR },
    { "DONUTS", DVPTR(DONUTS), DONUTS__STATIC, DONUTS__STATICRR },
    { "NEON6", DVPTR(NEON6), NEON6__STATIC, NEON6__STATICRR },
    { "MASKWALL6", DVPTR(MASKWALL6), MASKWALL6__STATIC, MASKWALL6__STATICRR },
    { "CLOCK", DVPTR(CLOCK), CLOCK__STATIC, CLOCK__STATICRR },
    { "RUBBERCAN", DVPTR(RUBBERCAN), RUBBERCAN__STATIC, RUBBERCAN__STATICRR },
    { "BROKENCLOCK", DVPTR(BROKENCLOCK), BROKENCLOCK__STATIC, BROKENCLOCK__STATICRR },
    { "PLUG", DVPTR(PLUG), PLUG__STATIC, PLUG__STATICRR },
    { "OOZFILTER", DVPTR(OOZFILTER), OOZFILTER__STATIC, OOZFILTER__STATICRR },
    { "FLOORPLASMA", DVPTR(FLOORPLASMA), FLOORPLASMA__STATIC, FLOORPLASMA__STATICRR },
    { "REACTOR", DVPTR(REACTOR), REACTOR__STATIC, REACTOR__STATICRR },
    { "REACTORSPARK", DVPTR(REACTORSPARK), REACTORSPARK__STATIC, REACTORSPARK__STATICRR },
    { "REACTORBURNT", DVPTR(REACTORBURNT), REACTORBURNT__STATIC, REACTORBURNT__STATICRR },
    { "DOORTILE15", DVPTR(DOORTILE15), DOORTILE15__STATIC, DOORTILE15__STATICRR },
    { "HANDSWITCH", DVPTR(HANDSWITCH), HANDSWITCH__STATIC, HANDSWITCH__STATICRR },
    { "CIRCLEPANNEL", DVPTR(CIRCLEPANNEL), CIRCLEPANNEL__STATIC, CIRCLEPANNEL__STATICRR },
    { "CIRCLEPANNELBROKE", DVPTR(CIRCLEPANNELBROKE), CIRCLEPANNELBROKE__STATIC, CIRCLEPANNELBROKE__STATICRR },
    { "PULLSWITCH", DVPTR(PULLSWITCH), PULLSWITCH__STATIC, PULLSWITCH__STATICRR },
    { "MASKWALL8", DVPTR(MASKWALL8), MASKWALL8__STATIC, MASKWALL8__STATICRR },
    { "BIGHOLE", DVPTR(BIGHOLE), BIGHOLE__STATIC, BIGHOLE__STATICRR },
    { "ALIENSWITCH", DVPTR(ALIENSWITCH), ALIENSWITCH__STATIC, ALIENSWITCH__STATICRR },
    { "DOORTILE21", DVPTR(DOORTILE21), DOORTILE21__STATIC, DOORTILE21__STATICRR },
    { "HANDPRINTSWITCH", DVPTR(HANDPRINTSWITCH), HANDPRINTSWITCH__STATIC, HANDPRINTSWITCH__STATICRR },
    { "BOTTLE10", DVPTR(BOTTLE10), BOTTLE10__STATIC, BOTTLE10__STATICRR },
    { "BOTTLE11", DVPTR(BOTTLE11), BOTTLE11__STATIC, BOTTLE11__STATICRR },
    { "BOTTLE12", DVPTR(BOTTLE12), BOTTLE12__STATIC, BOTTLE12__STATICRR },
    { "BOTTLE13", DVPTR(BOTTLE13), BOTTLE13__STATIC, BOTTLE13__STATICRR },
    { "BOTTLE14", DVPTR(BOTTLE14), BOTTLE14__STATIC, BOTTLE14__STATICRR },
    { "BOTTLE15", DVPTR(BOTTLE15), BOTTLE15__STATIC, BOTTLE15__STATICRR },
    { "BOTTLE16", DVPTR(BOTTLE16), BOTTLE16__STATIC, BOTTLE16__STATICRR },
    { "BOTTLE17", DVPTR(BOTTLE17), BOTTLE17__STATIC, BOTTLE17__STATICRR },
    { "BOTTLE18", DVPTR(BOTTLE18), BOTTLE18__STATIC, BOTTLE18__STATICRR },
    { "BOTTLE19", DVPTR(BOTTLE19), BOTTLE19__STATIC, BOTTLE19__STATICRR },
    { "DOORTILE17", DVPTR(DOORTILE17), DOORTILE17__STATIC, DOORTILE17__STATICRR },
    { "MASKWALL7", DVPTR(MASKWALL7), MASKWALL7__STATIC, MASKWALL7__STATICRR },
    { "JAILBARBREAK", DVPTR(JAILBARBREAK), JAILBARBREAK__STATIC, JAILBARBREAK__STATICRR },
    { "DOORTILE11", DVPTR(DOORTILE11), DOORTILE11__STATIC, DOORTILE11__STATICRR },
    { "DOORTILE12", DVPTR(DOORTILE12), DOORTILE12__STATIC, DOORTILE12__STATICRR },
    { "VENDMACHINE", DVPTR(VENDMACHINE), VENDMACHINE__STATIC, VENDMACHINE__STATICRR },
    { "VENDMACHINEBROKE", DVPTR(VENDMACHINEBROKE), VENDMACHINEBROKE__STATIC, VENDMACHINEBROKE__STATICRR },
    { "COLAMACHINE", DVPTR(COLAMACHINE), COLAMACHINE__STATIC, COLAMACHINE__STATICRR },
    { "COLAMACHINEBROKE", DVPTR(COLAMACHINEBROKE), COLAMACHINEBROKE__STATIC, COLAMACHINEBROKE__STATICRR },
    { "CRANEPOLE", DVPTR(CRANEPOLE), CRANEPOLE__STATIC, CRANEPOLE__STATICRR },
    { "CRANE", DVPTR(CRANE), CRANE__STATIC, CRANE__STATICRR },
    { "BARBROKE", DVPTR(BARBROKE), BARBROKE__STATIC, BARBROKE__STATICRR },
    { "BLOODPOOL", DVPTR(BLOODPOOL), BLOODPOOL__STATIC, BLOODPOOL__STATICRR },
    { "NUKEBARREL", DVPTR(NUKEBARREL), NUKEBARREL__STATIC, NUKEBARREL__STATICRR },
    { "NUKEBARRELDENTED", DVPTR(NUKEBARRELDENTED), NUKEBARRELDENTED__STATIC, NUKEBARRELDENTED__STATICRR },
    { "NUKEBARRELLEAKED", DVPTR(NUKEBARRELLEAKED), NUKEBARRELLEAKED__STATIC, NUKEBARRELLEAKED__STATICRR },
    { "CANWITHSOMETHING", DVPTR(CANWITHSOMETHING), CANWITHSOMETHING__STATIC, CANWITHSOMETHING__STATICRR },
    { "MONEY", DVPTR(MONEY), MONEY__STATIC, MONEY__STATICRR },
    { "BANNER", DVPTR(BANNER), BANNER__STATIC, BANNER__STATICRR },
    { "EXPLODINGBARREL", DVPTR(EXPLODINGBARREL), EXPLODINGBARREL__STATIC, EXPLODINGBARREL__STATICRR },
    { "EXPLODINGBARREL2", DVPTR(EXPLODINGBARREL2), EXPLODINGBARREL2__STATIC, EXPLODINGBARREL2__STATICRR },
    { "FIREBARREL", DVPTR(FIREBARREL), FIREBARREL__STATIC, FIREBARREL__STATICRR },
    { "SEENINE", DVPTR(SEENINE), SEENINE__STATIC, SEENINE__STATICRR },
    { "SEENINEDEAD", DVPTR(SEENINEDEAD), SEENINEDEAD__STATIC, SEENINEDEAD__STATICRR },
    { "STEAM", DVPTR(STEAM), STEAM__STATIC, STEAM__STATICRR },
    { "CEILINGSTEAM", DVPTR(CEILINGSTEAM), CEILINGSTEAM__STATIC, CEILINGSTEAM__STATICRR },
    { "PIPE6B", DVPTR(PIPE6B), PIPE6B__STATIC, PIPE6B__STATICRR },
    { "TRANSPORTERBEAM", DVPTR(TRANSPORTERBEAM), TRANSPORTERBEAM__STATIC, TRANSPORTERBEAM__STATICRR },
    { "RAT", DVPTR(RAT), RAT__STATIC, RAT__STATICRR },
    { "TRASH", DVPTR(TRASH), TRASH__STATIC, TRASH__STATICRR },
    { "FEMPIC1", DVPTR(FEMPIC1), FEMPIC1__STATIC, FEMPIC1__STATICRR },
    { "FEMPIC2", DVPTR(FEMPIC2), FEMPIC2__STATIC, FEMPIC2__STATICRR },
    { "BLANKSCREEN", DVPTR(BLANKSCREEN), BLANKSCREEN__STATIC, BLANKSCREEN__STATICRR },
    { "PODFEM1", DVPTR(PODFEM1), PODFEM1__STATIC, PODFEM1__STATICRR },
    { "FEMPIC3", DVPTR(FEMPIC3), FEMPIC3__STATIC, FEMPIC3__STATICRR },
    { "FEMPIC4", DVPTR(FEMPIC4), FEMPIC4__STATIC, FEMPIC4__STATICRR },
    { "FEM1", DVPTR(FEM1), FEM1__STATIC, FEM1__STATICRR },
    { "FEM2", DVPTR(FEM2), FEM2__STATIC, FEM2__STATICRR },
    { "FEM3", DVPTR(FEM3), FEM3__STATIC, FEM3__STATICRR },
    { "FEM5", DVPTR(FEM5), FEM5__STATIC, FEM5__STATICRR },
    { "BLOODYPOLE", DVPTR(BLOODYPOLE), BLOODYPOLE__STATIC, BLOODYPOLE__STATICRR },
    { "FEM4", DVPTR(FEM4), FEM4__STATIC, FEM4__STATICRR },
    { "FEM6", DVPTR(FEM6), FEM6__STATIC, FEM6__STATICRR },
    { "FEM6PAD", DVPTR(FEM6PAD), FEM6PAD__STATIC, FEM6PAD__STATICRR },
    { "FEM8", DVPTR(FEM8), FEM8__STATIC, FEM8__STATICRR },
    { "HELECOPT", DVPTR(HELECOPT), HELECOPT__STATIC, HELECOPT__STATICRR },
    { "FETUSJIB", DVPTR(FETUSJIB), FETUSJIB__STATIC, FETUSJIB__STATICRR },
    { "HOLODUKE", DVPTR(HOLODUKE), HOLODUKE__STATIC, HOLODUKE__STATICRR },
    { "SPACEMARINE", DVPTR(SPACEMARINE), SPACEMARINE__STATIC, SPACEMARINE__STATICRR },
    { "INDY", DVPTR(INDY), INDY__STATIC, INDY__STATICRR },
    { "FETUS", DVPTR(FETUS), FETUS__STATIC, FETUS__STATICRR },
    { "FETUSBROKE", DVPTR(FETUSBROKE), FETUSBROKE__STATIC, FETUSBROKE__STATICRR },
    { "MONK", DVPTR(MONK), MONK__STATIC, MONK__STATICRR },
    { "LUKE", DVPTR(LUKE), LUKE__STATIC, LUKE__STATICRR },
    { "COOLEXPLOSION1", DVPTR(COOLEXPLOSION1), COOLEXPLOSION1__STATIC, COOLEXPLOSION1__STATICRR },
    { "WATERSPLASH2", DVPTR(WATERSPLASH2), WATERSPLASH2__STATIC, WATERSPLASH2__STATICRR },
    { "FIREVASE", DVPTR(FIREVASE), FIREVASE__STATIC, FIREVASE__STATICRR },
    { "SCRATCH", DVPTR(SCRATCH), SCRATCH__STATIC, SCRATCH__STATICRR },
    { "FEM7", DVPTR(FEM7), FEM7__STATIC, FEM7__STATICRR },
    { "APLAYERTOP", DVPTR(APLAYERTOP), APLAYERTOP__STATIC, APLAYERTOP__STATICRR },
    { "APLAYER", DVPTR(APLAYER), APLAYER__STATIC, APLAYER__STATICRR },
    { "PLAYERONWATER", DVPTR(PLAYERONWATER), PLAYERONWATER__STATIC, PLAYERONWATER__STATICRR },
    { "DUKELYINGDEAD", DVPTR(DUKELYINGDEAD), DUKELYINGDEAD__STATIC, DUKELYINGDEAD__STATICRR },
    { "DUKETORSO", DVPTR(DUKETORSO), DUKETORSO__STATIC, DUKETORSO__STATICRR },
    { "DUKEGUN", DVPTR(DUKEGUN), DUKEGUN__STATIC, DUKEGUN__STATICRR },
    { "DUKELEG", DVPTR(DUKELEG), DUKELEG__STATIC, DUKELEG__STATICRR },
    { "SHARK", DVPTR(SHARK), SHARK__STATIC, SHARK__STATICRR },
    { "BLOOD", DVPTR(BLOOD), BLOOD__STATIC, BLOOD__STATICRR },
    { "FIRELASER", DVPTR(FIRELASER), FIRELASER__STATIC, FIRELASER__STATICRR },
    { "TRANSPORTERSTAR", DVPTR(TRANSPORTERSTAR), TRANSPORTERSTAR__STATIC, TRANSPORTERSTAR__STATICRR },
    { "SPIT", DVPTR(SPIT), SPIT__STATIC, SPIT__STATICRR },
    { "LOOGIE", DVPTR(LOOGIE), LOOGIE__STATIC, LOOGIE__STATICRR },
    { "FIST", DVPTR(FIST), FIST__STATIC, FIST__STATICRR },
    { "FREEZEBLAST", DVPTR(FREEZEBLAST), FREEZEBLAST__STATIC, FREEZEBLAST__STATICRR },
    { "DEVISTATORBLAST", DVPTR(DEVISTATORBLAST), DEVISTATORBLAST__STATIC, DEVISTATORBLAST__STATICRR },
    { "SHRINKSPARK", DVPTR(SHRINKSPARK), SHRINKSPARK__STATIC, SHRINKSPARK__STATICRR },
    { "TONGUE", DVPTR(TONGUE), TONGUE__STATIC, TONGUE__STATICRR },
    { "MORTER", DVPTR(MORTER), MORTER__STATIC, MORTER__STATICRR },
    { "SHRINKEREXPLOSION", DVPTR(SHRINKEREXPLOSION), SHRINKEREXPLOSION__STATIC, SHRINKEREXPLOSION__STATICRR },
    { "RADIUSEXPLOSION", DVPTR(RADIUSEXPLOSION), RADIUSEXPLOSION__STATIC, RADIUSEXPLOSION__STATICRR },
    { "FORCERIPPLE", DVPTR(FORCERIPPLE), FORCERIPPLE__STATIC, FORCERIPPLE__STATICRR },
    { "LIZTROOP", DVPTR(LIZTROOP), LIZTROOP__STATIC, 0 },
    { "LIZTROOPRUNNING", DVPTR(LIZTROOPRUNNING), LIZTROOPRUNNING__STATIC, 0 },
    { "LIZTROOPSTAYPUT", DVPTR(LIZTROOPSTAYPUT), LIZTROOPSTAYPUT__STATIC, 0 },
    { "LIZTOP", DVPTR(LIZTOP), LIZTOP__STATIC, 0 },
    { "LIZTROOPSHOOT", DVPTR(LIZTROOPSHOOT), LIZTROOPSHOOT__STATIC, 0 },
    { "LIZTROOPJETPACK", DVPTR(LIZTROOPJETPACK), LIZTROOPJETPACK__STATIC, 0 },
    { "LIZTROOPDSPRITE", DVPTR(LIZTROOPDSPRITE), LIZTROOPDSPRITE__STATIC, 0 },
    { "LIZTROOPONTOILET", DVPTR(LIZTROOPONTOILET), LIZTROOPONTOILET__STATIC, 0 },
    { "LIZTROOPJUSTSIT", DVPTR(LIZTROOPJUSTSIT), LIZTROOPJUSTSIT__STATIC, 0 },
    { "LIZTROOPDUCKING", DVPTR(LIZTROOPDUCKING), LIZTROOPDUCKING__STATIC, 0 },
    { "HEADJIB1", DVPTR(HEADJIB1), HEADJIB1__STATIC, 0 },
    { "ARMJIB1", DVPTR(ARMJIB1), ARMJIB1__STATIC, 0 },
    { "LEGJIB1", DVPTR(LEGJIB1), LEGJIB1__STATIC, 0 },
    { "CANNONBALL", DVPTR(CANNONBALL), CANNONBALL__STATIC, CANNONBALL__STATICRR },
    { "OCTABRAIN", DVPTR(OCTABRAIN), OCTABRAIN__STATIC, 0 },
    { "OCTABRAINSTAYPUT", DVPTR(OCTABRAINSTAYPUT), OCTABRAINSTAYPUT__STATIC, 0 },
    { "OCTATOP", DVPTR(OCTATOP), OCTATOP__STATIC, 0 },
    { "OCTADEADSPRITE", DVPTR(OCTADEADSPRITE), OCTADEADSPRITE__STATIC, 0 },
    { "INNERJAW", DVPTR(INNERJAW), INNERJAW__STATIC, INNERJAW__STATICRR },
    { "DRONE", DVPTR(DRONE), DRONE__STATIC, DRONE__STATICRR },
    { "EXPLOSION2", DVPTR(EXPLOSION2), EXPLOSION2__STATIC, EXPLOSION2__STATICRR },
    { "COMMANDER", DVPTR(COMMANDER), COMMANDER__STATIC, 0 },
    { "COMMANDERSTAYPUT", DVPTR(COMMANDERSTAYPUT), COMMANDERSTAYPUT__STATIC, 0 },
    { "RECON", DVPTR(RECON), RECON__STATIC, RECON__STATICRR },
    { "TANK", DVPTR(TANK), TANK__STATIC, 0 },
    { "PIGCOP", DVPTR(PIGCOP), PIGCOP__STATIC, 0 },
    { "PIGCOPSTAYPUT", DVPTR(PIGCOPSTAYPUT), PIGCOPSTAYPUT__STATIC, 0 },
    { "PIGCOPDIVE", DVPTR(PIGCOPDIVE), PIGCOPDIVE__STATIC, 0 },
    { "PIGCOPDEADSPRITE", DVPTR(PIGCOPDEADSPRITE), PIGCOPDEADSPRITE__STATIC, 0 },
    { "PIGTOP", DVPTR(PIGTOP), PIGTOP__STATIC, 0 },
    { "LIZMAN", DVPTR(LIZMAN), LIZMAN__STATIC, 0 },
    { "LIZMANSTAYPUT", DVPTR(LIZMANSTAYPUT), LIZMANSTAYPUT__STATIC, 0 },
    { "LIZMANSPITTING", DVPTR(LIZMANSPITTING), LIZMANSPITTING__STATIC, 0 },
    { "LIZMANFEEDING", DVPTR(LIZMANFEEDING), LIZMANFEEDING__STATIC, 0 },
    { "LIZMANJUMP", DVPTR(LIZMANJUMP), LIZMANJUMP__STATIC, 0 },
    { "LIZMANDEADSPRITE", DVPTR(LIZMANDEADSPRITE), LIZMANDEADSPRITE__STATIC, 0 },
    { "FECES", DVPTR(FECES), FECES__STATIC, FECES__STATICRR },
    { "LIZMANHEAD1", DVPTR(LIZMANHEAD1), LIZMANHEAD1__STATIC, 0 },
    { "LIZMANARM1", DVPTR(LIZMANARM1), LIZMANARM1__STATIC, 0 },
    { "LIZMANLEG1", DVPTR(LIZMANLEG1), LIZMANLEG1__STATIC, 0 },
    { "EXPLOSION2BOT", DVPTR(EXPLOSION2BOT), EXPLOSION2BOT__STATIC, EXPLOSION2BOT__STATICRR },
    { "USERWEAPON", DVPTR(USERWEAPON), USERWEAPON__STATIC, USERWEAPON__STATICRR },
    { "HEADERBAR", DVPTR(HEADERBAR), HEADERBAR__STATIC, HEADERBAR__STATICRR },
    { "JIBS1", DVPTR(JIBS1), JIBS1__STATIC, JIBS1__STATICRR },
    { "JIBS2", DVPTR(JIBS2), JIBS2__STATIC, JIBS2__STATICRR },
    { "JIBS3", DVPTR(JIBS3), JIBS3__STATIC, JIBS3__STATICRR },
    { "JIBS4", DVPTR(JIBS4), JIBS4__STATIC, JIBS4__STATICRR },
    { "JIBS5", DVPTR(JIBS5), JIBS5__STATIC, JIBS5__STATICRR },
    { "BURNING", DVPTR(BURNING), BURNING__STATIC, BURNING__STATICRR },
    { "FIRE", DVPTR(FIRE), FIRE__STATIC, FIRE__STATICRR },
    { "JIBS6", DVPTR(JIBS6), JIBS6__STATIC, JIBS6__STATICRR },
    { "BLOODSPLAT1", DVPTR(BLOODSPLAT1), BLOODSPLAT1__STATIC, BLOODSPLAT1__STATICRR },
    { "BLOODSPLAT3", DVPTR(BLOODSPLAT3), BLOODSPLAT3__STATIC, BLOODSPLAT3__STATICRR },
    { "BLOODSPLAT2", DVPTR(BLOODSPLAT2), BLOODSPLAT2__STATIC, BLOODSPLAT2__STATICRR },
    { "BLOODSPLAT4", DVPTR(BLOODSPLAT4), BLOODSPLAT4__STATIC, BLOODSPLAT4__STATICRR },
    { "OOZ", DVPTR(OOZ), OOZ__STATIC, OOZ__STATICRR },
    { "OOZ2", DVPTR(OOZ2), OOZ2__STATIC, OOZ2__STATICRR },
    { "WALLBLOOD1", DVPTR(WALLBLOOD1), WALLBLOOD1__STATIC, WALLBLOOD1__STATICRR },
    { "WALLBLOOD2", DVPTR(WALLBLOOD2), WALLBLOOD2__STATIC, WALLBLOOD2__STATICRR },
    { "WALLBLOOD3", DVPTR(WALLBLOOD3), WALLBLOOD3__STATIC, WALLBLOOD3__STATICRR },
    { "WALLBLOOD4", DVPTR(WALLBLOOD4), WALLBLOOD4__STATIC, WALLBLOOD4__STATICRR },
    { "WALLBLOOD5", DVPTR(WALLBLOOD5), WALLBLOOD5__STATIC, WALLBLOOD5__STATICRR },
    { "WALLBLOOD6", DVPTR(WALLBLOOD6), WALLBLOOD6__STATIC, WALLBLOOD6__STATICRR },
    { "WALLBLOOD7", DVPTR(WALLBLOOD7), WALLBLOOD7__STATIC, WALLBLOOD7__STATICRR },
    { "WALLBLOOD8", DVPTR(WALLBLOOD8), WALLBLOOD8__STATIC, WALLBLOOD8__STATICRR },
    { "BURNING2", DVPTR(BURNING2), BURNING2__STATIC, BURNING2__STATICRR },
    { "FIRE2", DVPTR(FIRE2), FIRE2__STATIC, FIRE2__STATICRR },
    { "CRACKKNUCKLES", DVPTR(CRACKKNUCKLES), CRACKKNUCKLES__STATIC, CRACKKNUCKLES__STATICRR },
    { "SMALLSMOKE", DVPTR(SMALLSMOKE), SMALLSMOKE__STATIC, SMALLSMOKE__STATICRR },
    { "SMALLSMOKEMAKER", DVPTR(SMALLSMOKEMAKER), SMALLSMOKEMAKER__STATIC, SMALLSMOKEMAKER__STATICRR },
    { "FLOORFLAME", DVPTR(FLOORFLAME), FLOORFLAME__STATIC, FLOORFLAME__STATICRR },
    { "ROTATEGUN", DVPTR(ROTATEGUN), ROTATEGUN__STATIC, ROTATEGUN__STATICRR },
    { "GREENSLIME", DVPTR(GREENSLIME), GREENSLIME__STATIC, GREENSLIME__STATICRR },
    { "WATERDRIPSPLASH", DVPTR(WATERDRIPSPLASH), WATERDRIPSPLASH__STATIC, WATERDRIPSPLASH__STATICRR },
    { "SCRAP6", DVPTR(SCRAP6), SCRAP6__STATIC, SCRAP6__STATICRR },
    { "SCRAP1", DVPTR(SCRAP1), SCRAP1__STATIC, SCRAP1__STATICRR },
    { "SCRAP2", DVPTR(SCRAP2), SCRAP2__STATIC, SCRAP2__STATICRR },
    { "SCRAP3", DVPTR(SCRAP3), SCRAP3__STATIC, SCRAP3__STATICRR },
    { "SCRAP4", DVPTR(SCRAP4), SCRAP4__STATIC, SCRAP4__STATICRR },
    { "SCRAP5", DVPTR(SCRAP5), SCRAP5__STATIC, SCRAP5__STATICRR },
    { "ORGANTIC", DVPTR(ORGANTIC), ORGANTIC__STATIC, ORGANTIC__STATICRR },
    { "BETAVERSION", DVPTR(BETAVERSION), BETAVERSION__STATIC, BETAVERSION__STATICRR },
    { "PLAYERISHERE", DVPTR(PLAYERISHERE), PLAYERISHERE__STATIC, PLAYERISHERE__STATICRR },
    { "PLAYERWASHERE", DVPTR(PLAYERWASHERE), PLAYERWASHERE__STATIC, PLAYERWASHERE__STATICRR },
    { "SELECTDIR", DVPTR(SELECTDIR), SELECTDIR__STATIC, SELECTDIR__STATICRR },
    { "F1HELP", DVPTR(F1HELP), F1HELP__STATIC, F1HELP__STATICRR },
    { "NOTCHON", DVPTR(NOTCHON), NOTCHON__STATIC, NOTCHON__STATICRR },
    { "NOTCHOFF", DVPTR(NOTCHOFF), NOTCHOFF__STATIC, NOTCHOFF__STATICRR },
    { "GROWSPARK", DVPTR(GROWSPARK), GROWSPARK__STATIC, GROWSPARK__STATICRR },
    { "DUKEICON", DVPTR(DUKEICON), DUKEICON__STATIC, DUKEICON__STATICRR },
    { "BADGUYICON", DVPTR(BADGUYICON), BADGUYICON__STATIC, BADGUYICON__STATICRR },
    { "FOODICON", DVPTR(FOODICON), FOODICON__STATIC, FOODICON__STATICRR },
    { "GETICON", DVPTR(GETICON), GETICON__STATIC, GETICON__STATICRR },
    { "MENUSCREEN", DVPTR(MENUSCREEN), MENUSCREEN__STATIC, MENUSCREEN__STATICRR },
    { "MENUBAR", DVPTR(MENUBAR), MENUBAR__STATIC, MENUBAR__STATICRR },
    { "KILLSICON", DVPTR(KILLSICON), KILLSICON__STATIC, KILLSICON__STATICRR },
    { "FIRSTAID_ICON", DVPTR(FIRSTAID_ICON), FIRSTAID_ICON__STATIC, FIRSTAID_ICON__STATICRR },
    { "HEAT_ICON", DVPTR(HEAT_ICON), HEAT_ICON__STATIC, HEAT_ICON__STATICRR },
    { "BOTTOMSTATUSBAR", DVPTR(BOTTOMSTATUSBAR), BOTTOMSTATUSBAR__STATIC, BOTTOMSTATUSBAR__STATICRR },
    { "BOOT_ICON", DVPTR(BOOT_ICON), BOOT_ICON__STATIC, BOOT_ICON__STATICRR },
    { "FRAGBAR", DVPTR(FRAGBAR), FRAGBAR__STATIC, FRAGBAR__STATICRR },
    { "JETPACK_ICON", DVPTR(JETPACK_ICON), JETPACK_ICON__STATIC, JETPACK_ICON__STATICRR },
    { "AIRTANK_ICON", DVPTR(AIRTANK_ICON), AIRTANK_ICON__STATIC, AIRTANK_ICON__STATICRR },
    { "STEROIDS_ICON", DVPTR(STEROIDS_ICON), STEROIDS_ICON__STATIC, STEROIDS_ICON__STATICRR },
    { "HOLODUKE_ICON", DVPTR(HOLODUKE_ICON), HOLODUKE_ICON__STATIC, HOLODUKE_ICON__STATICRR },
    { "ACCESS_ICON", DVPTR(ACCESS_ICON), ACCESS_ICON__STATIC, ACCESS_ICON__STATICRR },
    { "DIGITALNUM", DVPTR(DIGITALNUM), DIGITALNUM__STATIC, DIGITALNUM__STATICRR },
    { "DUKECAR", DVPTR(DUKECAR), DUKECAR__STATIC, DUKECAR__STATICRR },
    { "CAMCORNER", DVPTR(CAMCORNER), CAMCORNER__STATIC, CAMCORNER__STATICRR },
    { "CAMLIGHT", DVPTR(CAMLIGHT), CAMLIGHT__STATIC, CAMLIGHT__STATICRR },
    { "LOGO", DVPTR(LOGO), LOGO__STATIC, LOGO__STATICRR },
    { "TITLE", DVPTR(TITLE), TITLE__STATIC, TITLE__STATICRR },
    { "NUKEWARNINGICON", DVPTR(NUKEWARNINGICON), NUKEWARNINGICON__STATIC, NUKEWARNINGICON__STATICRR },
    { "MOUSECURSOR", DVPTR(MOUSECURSOR), MOUSECURSOR__STATIC, MOUSECURSOR__STATICRR },
    { "SLIDEBAR", DVPTR(SLIDEBAR), SLIDEBAR__STATIC, SLIDEBAR__STATICRR },
    { "DREALMS", DVPTR(DREALMS), DREALMS__STATIC, DREALMS__STATICRR },
    { "BETASCREEN", DVPTR(BETASCREEN), BETASCREEN__STATIC, BETASCREEN__STATICRR },
    { "WINDOWBORDER1", DVPTR(WINDOWBORDER1), WINDOWBORDER1__STATIC, WINDOWBORDER1__STATICRR },
    { "TEXTBOX", DVPTR(TEXTBOX), TEXTBOX__STATIC, TEXTBOX__STATICRR },
    { "WINDOWBORDER2", DVPTR(WINDOWBORDER2), WINDOWBORDER2__STATIC, WINDOWBORDER2__STATICRR },
    { "DUKENUKEM", DVPTR(DUKENUKEM), DUKENUKEM__STATIC, DUKENUKEM__STATICRR },
    { "THREEDEE", DVPTR(THREEDEE), THREEDEE__STATIC, THREEDEE__STATICRR },
    { "INGAMEDUKETHREEDEE", DVPTR(INGAMEDUKETHREEDEE), INGAMEDUKETHREEDEE__STATIC, INGAMEDUKETHREEDEE__STATICRR },
    { "TENSCREEN", DVPTR(TENSCREEN), TENSCREEN__STATIC, TENSCREEN__STATICRR },
    { "PLUTOPAKSPRITE", DVPTR(PLUTOPAKSPRITE), PLUTOPAKSPRITE__STATIC, PLUTOPAKSPRITE__STATICRR },
    { "DEVISTATOR", DVPTR(DEVISTATOR), DEVISTATOR__STATIC, DEVISTATOR__STATICRR },
    { "KNEE", DVPTR(KNEE), KNEE__STATIC, KNEE__STATICRR },
    { "CROSSHAIR", DVPTR(CROSSHAIR), CROSSHAIR__STATIC, CROSSHAIR__STATICRR },
    { "FIRSTGUN", DVPTR(FIRSTGUN), FIRSTGUN__STATIC, FIRSTGUN__STATICRR },
    { "FIRSTGUNRELOAD", DVPTR(FIRSTGUNRELOAD), FIRSTGUNRELOAD__STATIC, FIRSTGUNRELOAD__STATICRR },
    { "FALLINGCLIP", DVPTR(FALLINGCLIP), FALLINGCLIP__STATIC, FALLINGCLIP__STATICRR },
    { "CLIPINHAND", DVPTR(CLIPINHAND), CLIPINHAND__STATIC, CLIPINHAND__STATICRR },
    { "HAND", DVPTR(HAND), HAND__STATIC, HAND__STATICRR },
    { "SHELL", DVPTR(SHELL), SHELL__STATIC, SHELL__STATICRR },
    { "SHOTGUNSHELL", DVPTR(SHOTGUNSHELL), SHOTGUNSHELL__STATIC, SHOTGUNSHELL__STATICRR },
    { "CHAINGUN", DVPTR(CHAINGUN), CHAINGUN__STATIC, CHAINGUN__STATICRR },
    { "RPGGUN", DVPTR(RPGGUN), RPGGUN__STATIC, RPGGUN__STATICRR },
    { "RPGMUZZLEFLASH", DVPTR(RPGMUZZLEFLASH), RPGMUZZLEFLASH__STATIC, RPGMUZZLEFLASH__STATICRR },
    { "FREEZE", DVPTR(FREEZE), FREEZE__STATIC, FREEZE__STATICRR },
    { "CATLITE", DVPTR(CATLITE), CATLITE__STATIC, CATLITE__STATICRR },
    { "SHRINKER", DVPTR(SHRINKER), SHRINKER__STATIC, SHRINKER__STATICRR },
    { "HANDHOLDINGLASER", DVPTR(HANDHOLDINGLASER), HANDHOLDINGLASER__STATIC, HANDHOLDINGLASER__STATICRR },
    { "TRIPBOMB", DVPTR(TRIPBOMB), TRIPBOMB__STATIC, TRIPBOMB__STATICRR },
    { "LASERLINE", DVPTR(LASERLINE), LASERLINE__STATIC, LASERLINE__STATICRR },
    { "HANDHOLDINGACCESS", DVPTR(HANDHOLDINGACCESS), HANDHOLDINGACCESS__STATIC, HANDHOLDINGACCESS__STATICRR },
    { "HANDREMOTE", DVPTR(HANDREMOTE), HANDREMOTE__STATIC, HANDREMOTE__STATICRR },
    { "HANDTHROW", DVPTR(HANDTHROW), HANDTHROW__STATIC, HANDTHROW__STATICRR },
    { "TIP", DVPTR(TIP), TIP__STATIC, TIP__STATICRR },
    { "GLAIR", DVPTR(GLAIR), GLAIR__STATIC, GLAIR__STATICRR },
    { "SCUBAMASK", DVPTR(SCUBAMASK), SCUBAMASK__STATIC, SCUBAMASK__STATICRR },
    { "SPACEMASK", DVPTR(SPACEMASK), SPACEMASK__STATIC, SPACEMASK__STATICRR },
    { "FORCESPHERE", DVPTR(FORCESPHERE), FORCESPHERE__STATIC, FORCESPHERE__STATICRR },
    { "SHOTSPARK1", DVPTR(SHOTSPARK1), SHOTSPARK1__STATIC, SHOTSPARK1__STATICRR },
    { "DN64TILE2596", DVPTR(DN64TILE2596), DN64TILE2596__STATIC, 0 },
    { "DN64TILE2597", DVPTR(DN64TILE2597), DN64TILE2597__STATIC, 0 },
    { "DN64TILE2598", DVPTR(DN64TILE2598), DN64TILE2598__STATIC, 0 },
    { "DN64TILE2599", DVPTR(DN64TILE2599), DN64TILE2599__STATIC, 0 },
    { "RPG", DVPTR(RPG), RPG__STATIC, RPG__STATICRR },
    { "DN64TILE2606", DVPTR(DN64TILE2606), DN64TILE2606__STATIC, 0 },
    { "LASERSITE", DVPTR(LASERSITE), LASERSITE__STATIC, 0 },
    { "SHOTGUN", DVPTR(SHOTGUN), SHOTGUN__STATIC, SHOTGUN__STATICRR },
    { "BOSS1", DVPTR(BOSS1), BOSS1__STATIC, BOSS1__STATICRR },
    { "BOSS1STAYPUT", DVPTR(BOSS1STAYPUT), BOSS1STAYPUT__STATIC, 0 },
    { "BOSS1SHOOT", DVPTR(BOSS1SHOOT), BOSS1SHOOT__STATIC, 0 },
    { "BOSS1LOB", DVPTR(BOSS1LOB), BOSS1LOB__STATIC, 0 },
    { "BOSSTOP", DVPTR(BOSSTOP), BOSSTOP__STATIC, 0 },
    { "BOSS2", DVPTR(BOSS2), BOSS2__STATIC, BOSS2__STATICRR },
    { "BOSS3", DVPTR(BOSS3), BOSS3__STATIC, BOSS3__STATICRR },
    { "SPINNINGNUKEICON", DVPTR(SPINNINGNUKEICON), SPINNINGNUKEICON__STATIC, SPINNINGNUKEICON__STATICRR },
    { "BIGFNTCURSOR", DVPTR(BIGFNTCURSOR), BIGFNTCURSOR__STATIC, BIGFNTCURSOR__STATICRR },
    { "SMALLFNTCURSOR", DVPTR(SMALLFNTCURSOR), SMALLFNTCURSOR__STATIC, SMALLFNTCURSOR__STATICRR },
    { "STARTALPHANUM", DVPTR(STARTALPHANUM), STARTALPHANUM__STATIC, STARTALPHANUM__STATICRR },
    { "ENDALPHANUM", DVPTR(ENDALPHANUM), ENDALPHANUM__STATIC, ENDALPHANUM__STATICRR },
    { "BIGALPHANUM", DVPTR(BIGALPHANUM), BIGALPHANUM__STATIC, BIGALPHANUM__STATICRR },
    { "BIGPERIOD", DVPTR(BIGPERIOD), BIGPERIOD__STATIC, BIGPERIOD__STATICRR },
    { "BIGCOMMA", DVPTR(BIGCOMMA), BIGCOMMA__STATIC, BIGCOMMA__STATICRR },
    { "BIGX", DVPTR(BIGX_), BIGX__STATIC, BIGX__STATICRR },
    { "BIGQ", DVPTR(BIGQ), BIGQ__STATIC, BIGQ__STATICRR },
    { "BIGSEMI", DVPTR(BIGSEMI), BIGSEMI__STATIC, BIGSEMI__STATICRR },
    { "BIGCOLIN", DVPTR(BIGCOLIN), BIGCOLIN__STATIC, BIGCOLIN__STATICRR },
    { "THREEBYFIVE", DVPTR(THREEBYFIVE), THREEBYFIVE__STATIC, THREEBYFIVE__STATICRR },
    { "BIGAPPOS", DVPTR(BIGAPPOS), BIGAPPOS__STATIC, BIGAPPOS__STATICRR },
    { "BLANK", DVPTR(BLANK), BLANK__STATIC, BLANK__STATICRR },
    { "MINIFONT", DVPTR(MINIFONT), MINIFONT__STATIC, MINIFONT__STATICRR },
    { "BUTTON1", DVPTR(BUTTON1), BUTTON1__STATIC, BUTTON1__STATICRR },
    { "GLASS3", DVPTR(GLASS3), GLASS3__STATIC, GLASS3__STATICRR },
    { "RESPAWNMARKERRED", DVPTR(RESPAWNMARKERRED), RESPAWNMARKERRED__STATIC, RESPAWNMARKERRED__STATICRR },
    { "RESPAWNMARKERYELLOW", DVPTR(RESPAWNMARKERYELLOW), RESPAWNMARKERYELLOW__STATIC, RESPAWNMARKERYELLOW__STATICRR },
    { "RESPAWNMARKERGREEN", DVPTR(RESPAWNMARKERGREEN), RESPAWNMARKERGREEN__STATIC, RESPAWNMARKERGREEN__STATICRR },
    { "BONUSSCREEN", DVPTR(BONUSSCREEN), BONUSSCREEN__STATIC, BONUSSCREEN__STATICRR },
    { "VIEWBORDER", DVPTR(VIEWBORDER), VIEWBORDER__STATIC, VIEWBORDER__STATICRR },
    { "VICTORY1", DVPTR(VICTORY1), VICTORY1__STATIC, VICTORY1__STATICRR },
    { "ORDERING", DVPTR(ORDERING), ORDERING__STATIC, ORDERING__STATICRR },
    { "TEXTSTORY", DVPTR(TEXTSTORY), TEXTSTORY__STATIC, TEXTSTORY__STATICRR },
    { "LOADSCREEN", DVPTR(LOADSCREEN), LOADSCREEN__STATIC, LOADSCREEN__STATICRR },
    { "BORNTOBEWILDSCREEN", DVPTR(BORNTOBEWILDSCREEN), BORNTOBEWILDSCREEN__STATIC, BORNTOBEWILDSCREEN__STATICRR },
    { "BLIMP", DVPTR(BLIMP), BLIMP__STATIC, BLIMP__STATICRR },
    { "FEM9", DVPTR(FEM9), FEM9__STATIC, FEM9__STATICRR },
    { "DN64TILE3627", DVPTR(DN64TILE3627), DN64TILE3627__STATIC, 0 },
    { "DN64TILE3634", DVPTR(DN64TILE3634), DN64TILE3634__STATIC, 0 },
    { "FOOTPRINT", DVPTR(FOOTPRINT), FOOTPRINT__STATIC, FOOTPRINT__STATICRR },
    { "DN64TILE3713", DVPTR(DN64TILE3713), DN64TILE3713__STATIC, 0 },
    { "DN64TILE3714", DVPTR(DN64TILE3714), DN64TILE3714__STATIC, 0 },
    { "DN64TILE3715", DVPTR(DN64TILE3715), DN64TILE3715__STATIC, 0 },
    { "DN64TILE3716", DVPTR(DN64TILE3716), DN64TILE3716__STATIC, 0 },
    { "DN64TILE3727", DVPTR(DN64TILE3727), DN64TILE3727__STATIC, 0 },
    { "DN64TILE3797", DVPTR(DN64TILE3797), DN64TILE3797__STATIC, 0 },
    { "DN64TILE3804", DVPTR(DN64TILE3804), DN64TILE3804__STATIC, 0 },
    { "DN64TILE3805", DVPTR(DN64TILE3805), DN64TILE3805__STATIC, 0 },
    { "DN64TILE3809", DVPTR(DN64TILE3809), DN64TILE3809__STATIC, 0 },
    { "DN64TILE3821", DVPTR(DN64TILE3821), DN64TILE3821__STATIC, 0 },
    { "DN64TILE3831", DVPTR(DN64TILE3831), DN64TILE3831__STATIC, 0 },
    { "DN64TILE3841", DVPTR(DN64TILE3841), DN64TILE3841__STATIC, 0 },
    { "DN64TILE3845", DVPTR(DN64TILE3845), DN64TILE3845__STATIC, 0 },
    { "DN64TILE3922", DVPTR(DN64TILE3922), DN64TILE3922__STATIC, 0 },
    { "DN64TILE3953", DVPTR(DN64TILE3953), DN64TILE3953__STATIC, 0 },
    { "POOP", DVPTR(POOP), POOP__STATIC, POOP__STATICRR },
    { "FRAMEEFFECT1", DVPTR(FRAMEEFFECT1), FRAMEEFFECT1__STATIC, FRAMEEFFECT1__STATICRR },
    { "PANNEL3", DVPTR(PANNEL3), PANNEL3__STATIC, PANNEL3__STATICRR },
    { "SCREENBREAK14", DVPTR(SCREENBREAK14), SCREENBREAK14__STATIC, SCREENBREAK14__STATICRR },
    { "SCREENBREAK15", DVPTR(SCREENBREAK15), SCREENBREAK15__STATIC, SCREENBREAK15__STATICRR },
    { "SCREENBREAK19", DVPTR(SCREENBREAK19), SCREENBREAK19__STATIC, SCREENBREAK19__STATICRR },
    { "SCREENBREAK16", DVPTR(SCREENBREAK16), SCREENBREAK16__STATIC, SCREENBREAK16__STATICRR },
    { "SCREENBREAK17", DVPTR(SCREENBREAK17), SCREENBREAK17__STATIC, SCREENBREAK17__STATICRR },
    { "SCREENBREAK18", DVPTR(SCREENBREAK18), SCREENBREAK18__STATIC, SCREENBREAK18__STATICRR },
    { "W_TECHWALL11", DVPTR(W_TECHWALL11), W_TECHWALL11__STATIC, W_TECHWALL11__STATICRR },
    { "W_TECHWALL12", DVPTR(W_TECHWALL12), W_TECHWALL12__STATIC, W_TECHWALL12__STATICRR },
    { "W_TECHWALL13", DVPTR(W_TECHWALL13), W_TECHWALL13__STATIC, W_TECHWALL13__STATICRR },
    { "W_TECHWALL14", DVPTR(W_TECHWALL14), W_TECHWALL14__STATIC, W_TECHWALL14__STATICRR },
    { "W_TECHWALL5", DVPTR(W_TECHWALL5), W_TECHWALL5__STATIC, W_TECHWALL5__STATICRR },
    { "W_TECHWALL6", DVPTR(W_TECHWALL6), W_TECHWALL6__STATIC, W_TECHWALL6__STATICRR },
    { "W_TECHWALL7", DVPTR(W_TECHWALL7), W_TECHWALL7__STATIC, W_TECHWALL7__STATICRR },
    { "W_TECHWALL8", DVPTR(W_TECHWALL8), W_TECHWALL8__STATIC, W_TECHWALL8__STATICRR },
    { "W_TECHWALL9", DVPTR(W_TECHWALL9), W_TECHWALL9__STATIC, W_TECHWALL9__STATICRR },
    { "BPANNEL3", DVPTR(BPANNEL3), BPANNEL3__STATIC, BPANNEL3__STATICRR },
    { "W_HITTECHWALL16", DVPTR(W_HITTECHWALL16), W_HITTECHWALL16__STATIC, W_HITTECHWALL16__STATICRR },
    { "W_HITTECHWALL10", DVPTR(W_HITTECHWALL10), W_HITTECHWALL10__STATIC, W_HITTECHWALL10__STATICRR },
    { "W_HITTECHWALL15", DVPTR(W_HITTECHWALL15), W_HITTECHWALL15__STATIC, W_HITTECHWALL15__STATICRR },
    { "W_MILKSHELF", DVPTR(W_MILKSHELF), W_MILKSHELF__STATIC, W_MILKSHELF__STATICRR },
    { "W_MILKSHELFBROKE", DVPTR(W_MILKSHELFBROKE), W_MILKSHELFBROKE__STATIC, W_MILKSHELFBROKE__STATICRR },
    { "PURPLELAVA", DVPTR(PURPLELAVA), PURPLELAVA__STATIC, PURPLELAVA__STATICRR },
    { "DN64TILE4250", DVPTR(DN64TILE4250), DN64TILE4250__STATIC, 0 },
    { "LAVABUBBLE", DVPTR(LAVABUBBLE), LAVABUBBLE__STATIC, LAVABUBBLE__STATICRR },
    { "DUKECUTOUT", DVPTR(DUKECUTOUT), DUKECUTOUT__STATIC, DUKECUTOUT__STATICRR },
    { "TARGET", DVPTR(TARGET), TARGET__STATIC, TARGET__STATICRR },
    { "GUNPOWDERBARREL", DVPTR(GUNPOWDERBARREL), GUNPOWDERBARREL__STATIC, GUNPOWDERBARREL__STATICRR },
    { "DUCK", DVPTR(DUCK), DUCK__STATIC, DUCK__STATICRR },
    { "HATRACK", DVPTR(HATRACK), HATRACK__STATIC, HATRACK__STATICRR },
    { "DESKLAMP", DVPTR(DESKLAMP), DESKLAMP__STATIC, DESKLAMP__STATICRR },
    { "COFFEEMACHINE", DVPTR(COFFEEMACHINE), COFFEEMACHINE__STATIC, COFFEEMACHINE__STATICRR },
    { "CUPS", DVPTR(CUPS), CUPS__STATIC, CUPS__STATICRR },
    { "GAVALS", DVPTR(GAVALS), GAVALS__STATIC, GAVALS__STATICRR },
    { "GAVALS2", DVPTR(GAVALS2), GAVALS2__STATIC, GAVALS2__STATICRR },
    { "POLICELIGHTPOLE", DVPTR(POLICELIGHTPOLE), POLICELIGHTPOLE__STATIC, POLICELIGHTPOLE__STATICRR },
    { "FLOORBASKET", DVPTR(FLOORBASKET), FLOORBASKET__STATIC, FLOORBASKET__STATICRR },
    { "PUKE", DVPTR(PUKE), PUKE__STATIC, PUKE__STATICRR },
    { "DOORTILE23", DVPTR(DOORTILE23), DOORTILE23__STATIC, DOORTILE23__STATICRR },
    { "TOPSECRET", DVPTR(TOPSECRET), TOPSECRET__STATIC, TOPSECRET__STATICRR },
    { "SPEAKER", DVPTR(SPEAKER), SPEAKER__STATIC, SPEAKER__STATICRR },
    { "TEDDYBEAR", DVPTR(TEDDYBEAR), TEDDYBEAR__STATIC, TEDDYBEAR__STATICRR },
    { "ROBOTDOG", DVPTR(ROBOTDOG), ROBOTDOG__STATIC, ROBOTDOG__STATICRR },
    { "ROBOTPIRATE", DVPTR(ROBOTPIRATE), ROBOTPIRATE__STATIC, ROBOTPIRATE__STATICRR },
    { "ROBOTMOUSE", DVPTR(ROBOTMOUSE), ROBOTMOUSE__STATIC, ROBOTMOUSE__STATICRR },
    { "MAIL", DVPTR(MAIL), MAIL__STATIC, MAIL__STATICRR },
    { "MAILBAG", DVPTR(MAILBAG), MAILBAG__STATIC, MAILBAG__STATICRR },
    { "HOTMEAT", DVPTR(HOTMEAT), HOTMEAT__STATIC, HOTMEAT__STATICRR },
    { "COFFEEMUG", DVPTR(COFFEEMUG), COFFEEMUG__STATIC, COFFEEMUG__STATICRR },
    { "DONUTS2", DVPTR(DONUTS2), DONUTS2__STATIC, DONUTS2__STATICRR },
    { "TRIPODCAMERA", DVPTR(TRIPODCAMERA), TRIPODCAMERA__STATIC, TRIPODCAMERA__STATICRR },
    { "METER", DVPTR(METER), METER__STATIC, METER__STATICRR },
    { "DESKPHONE", DVPTR(DESKPHONE), DESKPHONE__STATIC, DESKPHONE__STATICRR },
    { "GUMBALLMACHINE", DVPTR(GUMBALLMACHINE), GUMBALLMACHINE__STATIC, GUMBALLMACHINE__STATICRR },
    { "GUMBALLMACHINEBROKE", DVPTR(GUMBALLMACHINEBROKE), GUMBALLMACHINEBROKE__STATIC, GUMBALLMACHINEBROKE__STATICRR },
    { "PAPER", DVPTR(PAPER), PAPER__STATIC, PAPER__STATICRR },
    { "MACE", DVPTR(MACE), MACE__STATIC, MACE__STATICRR },
    { "GENERICPOLE2", DVPTR(GENERICPOLE2), GENERICPOLE2__STATIC, GENERICPOLE2__STATICRR },
    { "XXXSTACY", DVPTR(XXXSTACY), XXXSTACY__STATIC, XXXSTACY__STATICRR },
    { "WETFLOOR", DVPTR(WETFLOOR), WETFLOOR__STATIC, WETFLOOR__STATICRR },
    { "BROOM", DVPTR(BROOM), BROOM__STATIC, BROOM__STATICRR },
    { "MOP", DVPTR(MOP), MOP__STATIC, MOP__STATICRR },
    { "LETTER", DVPTR(LETTER), LETTER__STATIC, 0 },
    { "PIRATE1A", DVPTR(PIRATE1A), PIRATE1A__STATIC, PIRATE1A__STATICRR },
    { "PIRATE4A", DVPTR(PIRATE4A), PIRATE4A__STATIC, PIRATE4A__STATICRR },
    { "PIRATE2A", DVPTR(PIRATE2A), PIRATE2A__STATIC, PIRATE2A__STATICRR },
    { "PIRATE5A", DVPTR(PIRATE5A), PIRATE5A__STATIC, PIRATE5A__STATICRR },
    { "PIRATE3A", DVPTR(PIRATE3A), PIRATE3A__STATIC, PIRATE3A__STATICRR },
    { "PIRATE6A", DVPTR(PIRATE6A), PIRATE6A__STATIC, PIRATE6A__STATICRR },
    { "PIRATEHALF", DVPTR(PIRATEHALF), PIRATEHALF__STATIC, PIRATEHALF__STATICRR },
    { "CHESTOFGOLD", DVPTR(CHESTOFGOLD), CHESTOFGOLD__STATIC, CHESTOFGOLD__STATICRR },
    { "SIDEBOLT1", DVPTR(SIDEBOLT1), SIDEBOLT1__STATIC, SIDEBOLT1__STATICRR },
    { "FOODOBJECT1", DVPTR(FOODOBJECT1), FOODOBJECT1__STATIC, FOODOBJECT1__STATICRR },
    { "FOODOBJECT2", DVPTR(FOODOBJECT2), FOODOBJECT2__STATIC, FOODOBJECT2__STATICRR },
    { "FOODOBJECT3", DVPTR(FOODOBJECT3), FOODOBJECT3__STATIC, FOODOBJECT3__STATICRR },
    { "FOODOBJECT4", DVPTR(FOODOBJECT4), FOODOBJECT4__STATIC, FOODOBJECT4__STATICRR },
    { "FOODOBJECT5", DVPTR(FOODOBJECT5), FOODOBJECT5__STATIC, FOODOBJECT5__STATICRR },
    { "FOODOBJECT6", DVPTR(FOODOBJECT6), FOODOBJECT6__STATIC, FOODOBJECT6__STATICRR },
    { "FOODOBJECT7", DVPTR(FOODOBJECT7), FOODOBJECT7__STATIC, FOODOBJECT7__STATICRR },
    { "FOODOBJECT8", DVPTR(FOODOBJECT8), FOODOBJECT8__STATIC, FOODOBJECT8__STATICRR },
    { "FOODOBJECT9", DVPTR(FOODOBJECT9), FOODOBJECT9__STATIC, FOODOBJECT9__STATICRR },
    { "FOODOBJECT10", DVPTR(FOODOBJECT10), FOODOBJECT10__STATIC, FOODOBJECT10__STATICRR },
    { "FOODOBJECT11", DVPTR(FOODOBJECT11), FOODOBJECT11__STATIC, FOODOBJECT11__STATICRR },
    { "FOODOBJECT12", DVPTR(FOODOBJECT12), FOODOBJECT12__STATIC, FOODOBJECT12__STATICRR },
    { "FOODOBJECT13", DVPTR(FOODOBJECT13), FOODOBJECT13__STATIC, FOODOBJECT13__STATICRR },
    { "FOODOBJECT14", DVPTR(FOODOBJECT14), FOODOBJECT14__STATIC, FOODOBJECT14__STATICRR },
    { "FOODOBJECT15", DVPTR(FOODOBJECT15), FOODOBJECT15__STATIC, FOODOBJECT15__STATICRR },
    { "FOODOBJECT16", DVPTR(FOODOBJECT16), FOODOBJECT16__STATIC, FOODOBJECT16__STATICRR },
    { "FOODOBJECT17", DVPTR(FOODOBJECT17), FOODOBJECT17__STATIC, FOODOBJECT17__STATICRR },
    { "FOODOBJECT18", DVPTR(FOODOBJECT18), FOODOBJECT18__STATIC, FOODOBJECT18__STATICRR },
    { "FOODOBJECT19", DVPTR(FOODOBJECT19), FOODOBJECT19__STATIC, FOODOBJECT19__STATICRR },
    { "FOODOBJECT20", DVPTR(FOODOBJECT20), FOODOBJECT20__STATIC, FOODOBJECT20__STATICRR },
    { "HEADLAMP", DVPTR(HEADLAMP), HEADLAMP__STATIC, HEADLAMP__STATICRR },
    { "TAMPON", DVPTR(TAMPON), TAMPON__STATIC, TAMPON__STATICRR },
    { "SKINNEDCHICKEN", DVPTR(SKINNEDCHICKEN), SKINNEDCHICKEN__STATIC, SKINNEDCHICKEN__STATICRR },
    { "FEATHEREDCHICKEN", DVPTR(FEATHEREDCHICKEN), FEATHEREDCHICKEN__STATIC, FEATHEREDCHICKEN__STATICRR },
    { "ROBOTDOG2", DVPTR(ROBOTDOG2), ROBOTDOG2__STATIC, ROBOTDOG2__STATICRR },
    { "JOLLYMEAL", DVPTR(JOLLYMEAL), JOLLYMEAL__STATIC, JOLLYMEAL__STATICRR },
    { "DUKEBURGER", DVPTR(DUKEBURGER), DUKEBURGER__STATIC, DUKEBURGER__STATICRR },
    { "SHOPPINGCART", DVPTR(SHOPPINGCART), SHOPPINGCART__STATIC, SHOPPINGCART__STATICRR },
    { "CANWITHSOMETHING2", DVPTR(CANWITHSOMETHING2), CANWITHSOMETHING2__STATIC, CANWITHSOMETHING2__STATICRR },
    { "CANWITHSOMETHING3", DVPTR(CANWITHSOMETHING3), CANWITHSOMETHING3__STATIC, CANWITHSOMETHING3__STATICRR },
    { "CANWITHSOMETHING4", DVPTR(CANWITHSOMETHING4), CANWITHSOMETHING4__STATIC, CANWITHSOMETHING4__STATICRR },
    { "SNAKEP", DVPTR(SNAKEP), SNAKEP__STATIC, SNAKEP__STATICRR },
    { "DOLPHIN1", DVPTR(DOLPHIN1), DOLPHIN1__STATIC, DOLPHIN1__STATICRR },
    { "DOLPHIN2", DVPTR(DOLPHIN2), DOLPHIN2__STATIC, DOLPHIN2__STATICRR },
    { "NEWBEAST", DVPTR(NEWBEAST), NEWBEAST__STATIC, 0 },
    { "NEWBEASTSTAYPUT", DVPTR(NEWBEASTSTAYPUT), NEWBEASTSTAYPUT__STATIC, 0 },
    { "NEWBEASTJUMP", DVPTR(NEWBEASTJUMP), NEWBEASTJUMP__STATIC, 0 },
    { "NEWBEASTHANG", DVPTR(NEWBEASTHANG), NEWBEASTHANG__STATIC, 0 },
    { "NEWBEASTHANGDEAD", DVPTR(NEWBEASTHANGDEAD), NEWBEASTHANGDEAD__STATIC, 0 },
    { "DN64TILE4690", DVPTR(DN64TILE4690), DN64TILE4690__STATIC, 0 },
    { "BOSS4", DVPTR(BOSS4), BOSS4__STATIC, BOSS4__STATICRR },
    { "BOSS4STAYPUT", DVPTR(BOSS4STAYPUT), BOSS4STAYPUT__STATIC, 0 },
    { "FEM10", DVPTR(FEM10), FEM10__STATIC, FEM10__STATICRR },
    { "TOUGHGAL", DVPTR(TOUGHGAL), TOUGHGAL__STATIC, TOUGHGAL__STATICRR },
    { "MAN", DVPTR(MAN), MAN__STATIC, MAN__STATICRR },
    { "MAN2", DVPTR(MAN2), MAN2__STATIC, MAN2__STATICRR },
    { "WOMAN", DVPTR(WOMAN), WOMAN__STATIC, WOMAN__STATICRR },
    { "PLEASEWAIT", DVPTR(PLEASEWAIT), PLEASEWAIT__STATIC, PLEASEWAIT__STATICRR },
    { "NATURALLIGHTNING", DVPTR(NATURALLIGHTNING), NATURALLIGHTNING__STATIC, 0 },
    { "WEATHERWARN", DVPTR(WEATHERWARN), WEATHERWARN__STATIC, 0 },
    { "DUKETAG", DVPTR(DUKETAG), DUKETAG__STATIC, DUKETAG__STATICRR },
    { "SIGN1", DVPTR(SIGN1), SIGN1__STATIC, SIGN1__STATICRR },
    { "SIGN2", DVPTR(SIGN2), SIGN2__STATIC, SIGN2__STATICRR },
    { "JURYGUY", DVPTR(JURYGUY), JURYGUY__STATIC, JURYGUY__STATICRR },
    { "RRTILE11", DVPTR(RRTILE11), 0, RRTILE11__STATICRR },
    { "RPG2SPRITE", DVPTR(RPG2SPRITE), 0, RPG2SPRITE__STATICRR },
    { "RRTILE18", DVPTR(RRTILE18), 0, RRTILE18__STATICRR },
    { "RRTILE19", DVPTR(RRTILE19), 0, RRTILE19__STATICRR },
    { "RRTILE34", DVPTR(RRTILE34), 0, RRTILE34__STATICRR },
    { "RRTILE35", DVPTR(RRTILE35), 0, RRTILE35__STATICRR },
    { "DESTRUCTO", DVPTR(DESTRUCTO), 0, DESTRUCTO__STATICRR },
    { "RRTILE38", DVPTR(RRTILE38), 0, RRTILE38__STATICRR },
    { "RRTILE43", DVPTR(RRTILE43), 0, RRTILE43__STATICRR },
    { "GUTMETER", DVPTR(GUTMETER), 0, GUTMETER__STATICRR },
    { "RRTILE63", DVPTR(RRTILE63), 0, RRTILE63__STATICRR },
    { "RRTILE64", DVPTR(RRTILE64), 0, RRTILE64__STATICRR },
    { "RRTILE65", DVPTR(RRTILE65), 0, RRTILE65__STATICRR },
    { "RRTILE66", DVPTR(RRTILE66), 0, RRTILE66__STATICRR },
    { "RRTILE67", DVPTR(RRTILE67), 0, RRTILE67__STATICRR },
    { "RRTILE68", DVPTR(RRTILE68), 0, RRTILE68__STATICRR },
    { "SOUNDFX", DVPTR(SOUNDFX), 0, SOUNDFX__STATICRR },
    { "MOTOAMMO", DVPTR(MOTOAMMO), 0, MOTOAMMO__STATICRR },
    { "UFOBEAM", DVPTR(UFOBEAM), 0, UFOBEAM__STATICRR },
    { "RRTILE280", DVPTR(RRTILE280), 0, RRTILE280__STATICRR },
    { "RRTILE281", DVPTR(RRTILE281), 0, RRTILE281__STATICRR },
    { "RRTILE282", DVPTR(RRTILE282), 0, RRTILE282__STATICRR },
    { "RRTILE283", DVPTR(RRTILE283), 0, RRTILE283__STATICRR },
    { "RRTILE285", DVPTR(RRTILE285), 0, RRTILE285__STATICRR },
    { "RRTILE286", DVPTR(RRTILE286), 0, RRTILE286__STATICRR },
    { "RRTILE287", DVPTR(RRTILE287), 0, RRTILE287__STATICRR },
    { "RRTILE288", DVPTR(RRTILE288), 0, RRTILE288__STATICRR },
    { "RRTILE289", DVPTR(RRTILE289), 0, RRTILE289__STATICRR },
    { "RRTILE290", DVPTR(RRTILE290), 0, RRTILE290__STATICRR },
    { "RRTILE291", DVPTR(RRTILE291), 0, RRTILE291__STATICRR },
    { "RRTILE292", DVPTR(RRTILE292), 0, RRTILE292__STATICRR },
    { "RRTILE293", DVPTR(RRTILE293), 0, RRTILE293__STATICRR },
    { "RRTILE295", DVPTR(RRTILE295), 0, RRTILE295__STATICRR },
    { "RRTILE296", DVPTR(RRTILE296), 0, RRTILE296__STATICRR },
    { "RRTILE297", DVPTR(RRTILE297), 0, RRTILE297__STATICRR },
    { "CDPLAYER", DVPTR(CDPLAYER), 0, CDPLAYER__STATICRR },
    { "RRTILE380", DVPTR(RRTILE380), 0, RRTILE380__STATICRR },
    { "RRTILE403", DVPTR(RRTILE403), 0, RRTILE403__STATICRR },
    { "RRTILE409", DVPTR(RRTILE409), 0, RRTILE409__STATICRR },
    { "GUTMETER_LIGHT1", DVPTR(GUTMETER_LIGHT1), 0, GUTMETER_LIGHT1__STATICRR },
    { "GUTMETER_LIGHT2", DVPTR(GUTMETER_LIGHT2), 0, GUTMETER_LIGHT2__STATICRR },
    { "GUTMETER_LIGHT3", DVPTR(GUTMETER_LIGHT3), 0, GUTMETER_LIGHT3__STATICRR },
    { "GUTMETER_LIGHT4", DVPTR(GUTMETER_LIGHT4), 0, GUTMETER_LIGHT4__STATICRR },
    { "AMMO_ICON", DVPTR(AMMO_ICON), 0, AMMO_ICON__STATICRR },
    { "RRTILE409", DVPTR(RRTILE1076), 0, RRTILE1076__STATICRR },
    { "MUD", DVPTR(MUD), 0, MUD__STATICRR },
    { "EXPLOSION3", DVPTR(EXPLOSION3), 0, EXPLOSION3__STATICRR },
    { "RRTILE1636", DVPTR(RRTILE1636), 0, RRTILE1636__STATICRR },
    { "WEAPONBAR", DVPTR(WEAPONBAR), 0, WEAPONBAR__STATICRR },
    { "RRTILE1752", DVPTR(RRTILE1752), 0, RRTILE1752__STATICRR },
    { "RPG2", DVPTR(RPG2), 0, RPG2__STATICRR },
    { "RRTILE1790", DVPTR(RRTILE1790), 0, RRTILE1790__STATICRR },
    { "RRTILE1792", DVPTR(RRTILE1792), 0, RRTILE1792__STATICRR },
    { "RRTILE1801", DVPTR(RRTILE1801), 0, RRTILE1801__STATICRR },
    { "RRTILE1805", DVPTR(RRTILE1805), 0, RRTILE1805__STATICRR },
    { "RRTILE1807", DVPTR(RRTILE1807), 0, RRTILE1807__STATICRR },
    { "RRTILE1808", DVPTR(RRTILE1808), 0, RRTILE1808__STATICRR },
    { "RRTILE1812", DVPTR(RRTILE1812), 0, RRTILE1812__STATICRR },
    { "RRTILE1814", DVPTR(RRTILE1814), 0, RRTILE1814__STATICRR },
    { "RRTILE1817", DVPTR(RRTILE1817), 0, RRTILE1817__STATICRR },
    { "RRTILE1821", DVPTR(RRTILE1821), 0, RRTILE1821__STATICRR },
    { "RRTILE1824", DVPTR(RRTILE1824), 0, RRTILE1824__STATICRR },
    { "RRTILE1826", DVPTR(RRTILE1826), 0, RRTILE1826__STATICRR },
    { "RRTILE1850", DVPTR(RRTILE1850), 0, RRTILE1850__STATICRR },
    { "RRTILE1851", DVPTR(RRTILE1851), 0, RRTILE1851__STATICRR },
    { "RRTILE1856", DVPTR(RRTILE1856), 0, RRTILE1856__STATICRR },
    { "RRTILE1877", DVPTR(RRTILE1877), 0, RRTILE1877__STATICRR },
    { "RRTILE1878", DVPTR(RRTILE1878), 0, RRTILE1878__STATICRR },
    { "RRTILE1938", DVPTR(RRTILE1938), 0, RRTILE1938__STATICRR },
    { "RRTILE1939", DVPTR(RRTILE1939), 0, RRTILE1939__STATICRR },
    { "RRTILE1942", DVPTR(RRTILE1942), 0, RRTILE1942__STATICRR },
    { "RRTILE1944", DVPTR(RRTILE1944), 0, RRTILE1944__STATICRR },
    { "RRTILE1945", DVPTR(RRTILE1945), 0, RRTILE1945__STATICRR },
    { "RRTILE1947", DVPTR(RRTILE1947), 0, RRTILE1947__STATICRR },
    { "RRTILE1951", DVPTR(RRTILE1951), 0, RRTILE1951__STATICRR },
    { "RRTILE1952", DVPTR(RRTILE1952), 0, RRTILE1952__STATICRR },
    { "RRTILE1953", DVPTR(RRTILE1953), 0, RRTILE1953__STATICRR },
    { "RRTILE1961", DVPTR(RRTILE1961), 0, RRTILE1961__STATICRR },
    { "RRTILE1964", DVPTR(RRTILE1964), 0, RRTILE1964__STATICRR },
    { "RRTILE1973", DVPTR(RRTILE1973), 0, RRTILE1973__STATICRR },
    { "RRTILE1985", DVPTR(RRTILE1985), 0, RRTILE1985__STATICRR },
    { "RRTILE1986", DVPTR(RRTILE1986), 0, RRTILE1986__STATICRR },
    { "RRTILE1987", DVPTR(RRTILE1987), 0, RRTILE1987__STATICRR },
    { "RRTILE1988", DVPTR(RRTILE1988), 0, RRTILE1988__STATICRR },
    { "RRTILE1990", DVPTR(RRTILE1990), 0, RRTILE1990__STATICRR },
    { "RRTILE1995", DVPTR(RRTILE1995), 0, RRTILE1995__STATICRR },
    { "RRTILE1996", DVPTR(RRTILE1996), 0, RRTILE1996__STATICRR },
    { "RRTILE2004", DVPTR(RRTILE2004), 0, RRTILE2004__STATICRR },
    { "RRTILE2005", DVPTR(RRTILE2005), 0, RRTILE2005__STATICRR },
    { "POPCORN", DVPTR(POPCORN), 0, POPCORN__STATICRR },
    { "RRTILE2022", DVPTR(RRTILE2022), 0, RRTILE2022__STATICRR },
    { "LANEPICS", DVPTR(LANEPICS), 0, LANEPICS__STATICRR },
    { "RRTILE2025", DVPTR(RRTILE2025), 0, RRTILE2025__STATICRR },
    { "RRTILE2026", DVPTR(RRTILE2026), 0, RRTILE2026__STATICRR },
    { "RRTILE2027", DVPTR(RRTILE2027), 0, RRTILE2027__STATICRR },
    { "RRTILE2028", DVPTR(RRTILE2028), 0, RRTILE2028__STATICRR },
    { "RRTILE2034", DVPTR(RRTILE2034), 0, RRTILE2034__STATICRR },
    { "RRTILE2050", DVPTR(RRTILE2050), 0, RRTILE2050__STATICRR },
    { "RRTILE2052", DVPTR(RRTILE2052), 0, RRTILE2052__STATICRR },
    { "RRTILE2053", DVPTR(RRTILE2053), 0, RRTILE2053__STATICRR },
    { "RRTILE2056", DVPTR(RRTILE2056), 0, RRTILE2056__STATICRR },
    { "RRTILE2060", DVPTR(RRTILE2060), 0, RRTILE2060__STATICRR },
    { "RRTILE2072", DVPTR(RRTILE2072), 0, RRTILE2072__STATICRR },
    { "RRTILE2074", DVPTR(RRTILE2074), 0, RRTILE2074__STATICRR },
    { "RRTILE2075", DVPTR(RRTILE2075), 0, RRTILE2075__STATICRR },
    { "RRTILE2083", DVPTR(RRTILE2083), 0, RRTILE2083__STATICRR },
    { "RRTILE2097", DVPTR(RRTILE2097), 0, RRTILE2097__STATICRR },
    { "RRTILE2121", DVPTR(RRTILE2121), 0, RRTILE2121__STATICRR },
    { "RRTILE2122", DVPTR(RRTILE2122), 0, RRTILE2122__STATICRR },
    { "RRTILE2123", DVPTR(RRTILE2123), 0, RRTILE2123__STATICRR },
    { "RRTILE2124", DVPTR(RRTILE2124), 0, RRTILE2124__STATICRR },
    { "RRTILE2125", DVPTR(RRTILE2125), 0, RRTILE2125__STATICRR },
    { "RRTILE2126", DVPTR(RRTILE2126), 0, RRTILE2126__STATICRR },
    { "RRTILE2137", DVPTR(RRTILE2137), 0, RRTILE2137__STATICRR },
    { "RRTILE2132", DVPTR(RRTILE2132), 0, RRTILE2132__STATICRR },
    { "RRTILE2136", DVPTR(RRTILE2136), 0, RRTILE2136__STATICRR },
    { "RRTILE2139", DVPTR(RRTILE2139), 0, RRTILE2139__STATICRR },
    { "RRTILE2150", DVPTR(RRTILE2150), 0, RRTILE2150__STATICRR },
    { "RRTILE2151", DVPTR(RRTILE2151), 0, RRTILE2151__STATICRR },
    { "RRTILE2152", DVPTR(RRTILE2152), 0, RRTILE2152__STATICRR },
    { "RRTILE2156", DVPTR(RRTILE2156), 0, RRTILE2156__STATICRR },
    { "RRTILE2157", DVPTR(RRTILE2157), 0, RRTILE2157__STATICRR },
    { "RRTILE2158", DVPTR(RRTILE2158), 0, RRTILE2158__STATICRR },
    { "RRTILE2159", DVPTR(RRTILE2159), 0, RRTILE2159__STATICRR },
    { "RRTILE2160", DVPTR(RRTILE2160), 0, RRTILE2160__STATICRR },
    { "RRTILE2161", DVPTR(RRTILE2161), 0, RRTILE2161__STATICRR },
    { "RRTILE2175", DVPTR(RRTILE2175), 0, RRTILE2175__STATICRR },
    { "RRTILE2176", DVPTR(RRTILE2176), 0, RRTILE2176__STATICRR },
    { "RRTILE2178", DVPTR(RRTILE2178), 0, RRTILE2178__STATICRR },
    { "RRTILE2186", DVPTR(RRTILE2186), 0, RRTILE2186__STATICRR },
    { "RRTILE2214", DVPTR(RRTILE2214), 0, RRTILE2214__STATICRR },
    { "RRTILE2319", DVPTR(RRTILE2319), 0, RRTILE2319__STATICRR },
    { "RRTILE2321", DVPTR(RRTILE2321), 0, RRTILE2321__STATICRR },
    { "RRTILE2326", DVPTR(RRTILE2326), 0, RRTILE2326__STATICRR },
    { "RRTILE2329", DVPTR(RRTILE2329), 0, RRTILE2329__STATICRR },
    { "RRTILE2357", DVPTR(RRTILE2357), 0, RRTILE2357__STATICRR },
    { "RRTILE2382", DVPTR(RRTILE2382), 0, RRTILE2382__STATICRR },
    { "RRTILE2430", DVPTR(RRTILE2430), 0, RRTILE2430__STATICRR },
    { "RRTILE2431", DVPTR(RRTILE2431), 0, RRTILE2431__STATICRR },
    { "RRTILE2432", DVPTR(RRTILE2432), 0, RRTILE2432__STATICRR },
    { "RRTILE2437", DVPTR(RRTILE2437), 0, RRTILE2437__STATICRR },
    { "RRTILE2443", DVPTR(RRTILE2443), 0, RRTILE2443__STATICRR },
    { "RRTILE2445", DVPTR(RRTILE2445), 0, RRTILE2445__STATICRR },
    { "RRTILE2446", DVPTR(RRTILE2446), 0, RRTILE2446__STATICRR },
    { "RRTILE2450", DVPTR(RRTILE2450), 0, RRTILE2450__STATICRR },
    { "RRTILE2451", DVPTR(RRTILE2451), 0, RRTILE2451__STATICRR },
    { "RRTILE2455", DVPTR(RRTILE2455), 0, RRTILE2455__STATICRR },
    { "RRTILE2460", DVPTR(RRTILE2460), 0, RRTILE2460__STATICRR },
    { "RRTILE2465", DVPTR(RRTILE2465), 0, RRTILE2465__STATICRR },
    { "RRTILE2560", DVPTR(RRTILE2560), 0, RRTILE2560__STATICRR },
    { "RRTILE2562", DVPTR(RRTILE2562), 0, RRTILE2562__STATICRR },
    { "RRTILE2564", DVPTR(RRTILE2564), 0, RRTILE2564__STATICRR },
    { "RRTILE2573", DVPTR(RRTILE2573), 0, RRTILE2573__STATICRR },
    { "RRTILE2574", DVPTR(RRTILE2574), 0, RRTILE2574__STATICRR },
    { "RRTILE2577", DVPTR(RRTILE2577), 0, RRTILE2577__STATICRR },
    { "RRTILE2578", DVPTR(RRTILE2578), 0, RRTILE2578__STATICRR },
    { "RRTILE2581", DVPTR(RRTILE2581), 0, RRTILE2581__STATICRR },
    { "RRTILE2583", DVPTR(RRTILE2583), 0, RRTILE2583__STATICRR },
    { "RRTILE2604", DVPTR(RRTILE2604), 0, RRTILE2604__STATICRR },
    { "RRTILE2610", DVPTR(RRTILE2610), 0, RRTILE2610__STATICRR },
    { "RRTILE2613", DVPTR(RRTILE2613), 0, RRTILE2613__STATICRR },
    { "RRTILE2621", DVPTR(RRTILE2621), 0, RRTILE2621__STATICRR },
    { "RRTILE2622", DVPTR(RRTILE2622), 0, RRTILE2622__STATICRR },
    { "RRTILE2636", DVPTR(RRTILE2636), 0, RRTILE2636__STATICRR },
    { "RRTILE2637", DVPTR(RRTILE2637), 0, RRTILE2637__STATICRR },
    { "RRTILE2654", DVPTR(RRTILE2654), 0, RRTILE2654__STATICRR },
    { "RRTILE2656", DVPTR(RRTILE2656), 0, RRTILE2656__STATICRR },
    { "RRTILE2676", DVPTR(RRTILE2676), 0, RRTILE2676__STATICRR },
    { "RRTILE2689", DVPTR(RRTILE2689), 0, RRTILE2689__STATICRR },
    { "RRTILE2697", DVPTR(RRTILE2697), 0, RRTILE2697__STATICRR },
    { "RRTILE2702", DVPTR(RRTILE2702), 0, RRTILE2702__STATICRR },
    { "RRTILE2707", DVPTR(RRTILE2707), 0, RRTILE2707__STATICRR },
    { "RRTILE2732", DVPTR(RRTILE2732), 0, RRTILE2732__STATICRR },
    { "RRTILE2030", DVPTR(RRTILE2030), 0, RRTILE2030__STATICRR },
    { "RRTILE2831", DVPTR(RRTILE2831), 0, RRTILE2831__STATICRR },
    { "RRTILE2832", DVPTR(RRTILE2832), 0, RRTILE2832__STATICRR },
    { "RRTILE2842", DVPTR(RRTILE2842), 0, RRTILE2842__STATICRR },
    { "RRTILE2859", DVPTR(RRTILE2859), 0, RRTILE2859__STATICRR },
    { "RRTILE2876", DVPTR(RRTILE2876), 0, RRTILE2876__STATICRR },
    { "RRTILE2878", DVPTR(RRTILE2878), 0, RRTILE2878__STATICRR },
    { "RRTILE2879", DVPTR(RRTILE2879), 0, RRTILE2879__STATICRR },
    { "RRTILE2893", DVPTR(RRTILE2893), 0, RRTILE2893__STATICRR },
    { "RRTILE2894", DVPTR(RRTILE2894), 0, RRTILE2894__STATICRR },
    { "RRTILE2898", DVPTR(RRTILE2898), 0, RRTILE2898__STATICRR },
    { "RRTILE2899", DVPTR(RRTILE2899), 0, RRTILE2899__STATICRR },
    { "RRTILE2915", DVPTR(RRTILE2915), 0, RRTILE2915__STATICRR },
    { "RRTILE2940", DVPTR(RRTILE2940), 0, RRTILE2940__STATICRR },
    { "RRTILE2944", DVPTR(RRTILE2944), 0, RRTILE2944__STATICRR },
    { "RRTILE2945", DVPTR(RRTILE2945), 0, RRTILE2945__STATICRR },
    { "RRTILE2946", DVPTR(RRTILE2946), 0, RRTILE2946__STATICRR },
    { "RRTILE2947", DVPTR(RRTILE2947), 0, RRTILE2947__STATICRR },
    { "RRTILE2948", DVPTR(RRTILE2948), 0, RRTILE2948__STATICRR },
    { "RRTILE2949", DVPTR(RRTILE2949), 0, RRTILE2949__STATICRR },
    { "RRTILE2961", DVPTR(RRTILE2961), 0, RRTILE2961__STATICRR },
    { "RRTILE2970", DVPTR(RRTILE2970), 0, RRTILE2970__STATICRR },
    { "RRTILE2977", DVPTR(RRTILE2977), 0, RRTILE2977__STATICRR },
    { "RRTILE2978", DVPTR(RRTILE2978), 0, RRTILE2978__STATICRR },
    { "RRTILE2990", DVPTR(RRTILE2990), 0, RRTILE2990__STATICRR },
    { "RRTILE3073", DVPTR(RRTILE3073), 0, RRTILE3073__STATICRR },
    { "RRTILE3083", DVPTR(RRTILE3083), 0, RRTILE3083__STATICRR },
    { "RRTILE3100", DVPTR(RRTILE3100), 0, RRTILE3100__STATICRR },
    { "RRTILE3114", DVPTR(RRTILE3114), 0, RRTILE3114__STATICRR },
    { "RRTILE3115", DVPTR(RRTILE3115), 0, RRTILE3115__STATICRR },
    { "RRTILE3116", DVPTR(RRTILE3116), 0, RRTILE3116__STATICRR },
    { "RRTILE3117", DVPTR(RRTILE3117), 0, RRTILE3117__STATICRR },
    { "RRTILE3120", DVPTR(RRTILE3120), 0, RRTILE3120__STATICRR },
    { "RRTILE3121", DVPTR(RRTILE3121), 0, RRTILE3121__STATICRR },
    { "RRTILE3122", DVPTR(RRTILE3122), 0, RRTILE3122__STATICRR },
    { "RRTILE3123", DVPTR(RRTILE3123), 0, RRTILE3123__STATICRR },
    { "RRTILE3124", DVPTR(RRTILE3124), 0, RRTILE3124__STATICRR },
    { "RRTILE3132", DVPTR(RRTILE3132), 0, RRTILE3132__STATICRR },
    { "RRTILE3139", DVPTR(RRTILE3139), 0, RRTILE3139__STATICRR },
    { "RRTILE3144", DVPTR(RRTILE3144), 0, RRTILE3144__STATICRR },
    { "RRTILE3152", DVPTR(RRTILE3152), 0, RRTILE3152__STATICRR },
    { "RRTILE3153", DVPTR(RRTILE3153), 0, RRTILE3153__STATICRR },
    { "RRTILE3155", DVPTR(RRTILE3155), 0, RRTILE3155__STATICRR },
    { "RRTILE3171", DVPTR(RRTILE3171), 0, RRTILE3171__STATICRR },
    { "RRTILE3172", DVPTR(RRTILE3172), 0, RRTILE3172__STATICRR },
    { "RRTILE3190", DVPTR(RRTILE3190), 0, RRTILE3190__STATICRR },
    { "RRTILE3191", DVPTR(RRTILE3191), 0, RRTILE3191__STATICRR },
    { "RRTILE3192", DVPTR(RRTILE3192), 0, RRTILE3192__STATICRR },
    { "RRTILE3195", DVPTR(RRTILE3195), 0, RRTILE3195__STATICRR },
    { "RRTILE3200", DVPTR(RRTILE3200), 0, RRTILE3200__STATICRR },
    { "RRTILE3201", DVPTR(RRTILE3201), 0, RRTILE3201__STATICRR },
    { "RRTILE3202", DVPTR(RRTILE3202), 0, RRTILE3202__STATICRR },
    { "RRTILE3203", DVPTR(RRTILE3203), 0, RRTILE3203__STATICRR },
    { "RRTILE3204", DVPTR(RRTILE3204), 0, RRTILE3204__STATICRR },
    { "RRTILE3205", DVPTR(RRTILE3205), 0, RRTILE3205__STATICRR },
    { "RRTILE3206", DVPTR(RRTILE3206), 0, RRTILE3206__STATICRR },
    { "RRTILE3207", DVPTR(RRTILE3207), 0, RRTILE3207__STATICRR },
    { "RRTILE3208", DVPTR(RRTILE3208), 0, RRTILE3208__STATICRR },
    { "RRTILE3209", DVPTR(RRTILE3209), 0, RRTILE3209__STATICRR },
    { "RRTILE3216", DVPTR(RRTILE3216), 0, RRTILE3216__STATICRR },
    { "RRTILE3218", DVPTR(RRTILE3218), 0, RRTILE3218__STATICRR },
    { "RRTILE3219", DVPTR(RRTILE3219), 0, RRTILE3219__STATICRR },
    { "RRTILE3232", DVPTR(RRTILE3232), 0, RRTILE3232__STATICRR },
    { "SHOTGUNSHELLS", DVPTR(SHOTGUNSHELLS), 0, SHOTGUNSHELLS__STATICRR },
    { "CIRCLESTUCK", DVPTR(CIRCLESTUCK), 0, CIRCLESTUCK__STATICRR },
    { "RRTILE3410", DVPTR(RRTILE3410), 0, RRTILE3410__STATICRR },
    { "LUMBERBLADE", DVPTR(LUMBERBLADE), 0, LUMBERBLADE__STATICRR },
    { "BOWLINGBALLH", DVPTR(BOWLINGBALLH), 0, BOWLINGBALLH__STATICRR },
    { "BOWLINGBALL", DVPTR(BOWLINGBALL), 0, BOWLINGBALL__STATICRR },
    { "BOWLINGBALLSPRITE", DVPTR(BOWLINGBALLSPRITE), 0, BOWLINGBALLSPRITE__STATICRR },
    { "POWDERH", DVPTR(POWDERH), 0, POWDERH__STATICRR },
    { "RRTILE3440", DVPTR(RRTILE3440), 0, RRTILE3440__STATICRR },
    { "RRTILE3462", DVPTR(RRTILE3462), 0, RRTILE3462__STATICRR },
    { "OWHIP", DVPTR(OWHIP), 0, OWHIP__STATICRR },
    { "UWHIP", DVPTR(UWHIP), 0, UWHIP__STATICRR },
    { "RPGGUN2", DVPTR(RPGGUN2), 0, RPGGUN2__STATICRR },
    { "RRTILE3497", DVPTR(RRTILE3497), 0, RRTILE3497__STATICRR },
    { "RRTILE3498", DVPTR(RRTILE3498), 0, RRTILE3498__STATICRR },
    { "RRTILE3499", DVPTR(RRTILE3499), 0, RRTILE3499__STATICRR },
    { "RRTILE3500", DVPTR(RRTILE3500), 0, RRTILE3500__STATICRR },
    { "SLINGBLADE", DVPTR(SLINGBLADE), 0, SLINGBLADE__STATICRR },
    { "RRTILE3584", DVPTR(RRTILE3584), 0, RRTILE3584__STATICRR },
    { "RRTILE3586", DVPTR(RRTILE3586), 0, RRTILE3586__STATICRR },
    { "RRTILE3587", DVPTR(RRTILE3587), 0, RRTILE3587__STATICRR },
    { "RRTILE3600", DVPTR(RRTILE3600), 0, RRTILE3600__STATICRR },
    { "RRTILE3631", DVPTR(RRTILE3631), 0, RRTILE3631__STATICRR },
    { "RRTILE3635", DVPTR(RRTILE3635), 0, RRTILE3635__STATICRR },
    { "RRTILE3637", DVPTR(RRTILE3637), 0, RRTILE3637__STATICRR },
    { "RRTILE3643", DVPTR(RRTILE3643), 0, RRTILE3643__STATICRR },
    { "RRTILE3647", DVPTR(RRTILE3647), 0, RRTILE3647__STATICRR },
    { "RRTILE3652", DVPTR(RRTILE3652), 0, RRTILE3652__STATICRR },
    { "RRTILE3653", DVPTR(RRTILE3653), 0, RRTILE3653__STATICRR },
    { "RRTILE3668", DVPTR(RRTILE3668), 0, RRTILE3668__STATICRR },
    { "RRTILE3671", DVPTR(RRTILE3671), 0, RRTILE3671__STATICRR },
    { "RRTILE3673", DVPTR(RRTILE3673), 0, RRTILE3673__STATICRR },
    { "RRTILE3677", DVPTR(RRTILE3677), 0, RRTILE3677__STATICRR },
    { "RRTILE3684", DVPTR(RRTILE3684), 0, RRTILE3684__STATICRR },
    { "RRTILE3708", DVPTR(RRTILE3708), 0, RRTILE3708__STATICRR },
    { "RRTILE3714", DVPTR(RRTILE3714), 0, RRTILE3714__STATICRR },
    { "RRTILE3716", DVPTR(RRTILE3716), 0, RRTILE3716__STATICRR },
    { "RRTILE3720", DVPTR(RRTILE3720), 0, RRTILE3720__STATICRR },
    { "RRTILE3723", DVPTR(RRTILE3723), 0, RRTILE3723__STATICRR },
    { "RRTILE3725", DVPTR(RRTILE3725), 0, RRTILE3725__STATICRR },
    { "RRTILE3737", DVPTR(RRTILE3737), 0, RRTILE3737__STATICRR },
    { "RRTILE3754", DVPTR(RRTILE3754), 0, RRTILE3754__STATICRR },
    { "RRTILE3762", DVPTR(RRTILE3762), 0, RRTILE3762__STATICRR },
    { "RRTILE3763", DVPTR(RRTILE3763), 0, RRTILE3763__STATICRR },
    { "RRTILE3764", DVPTR(RRTILE3764), 0, RRTILE3764__STATICRR },
    { "RRTILE3765", DVPTR(RRTILE3765), 0, RRTILE3765__STATICRR },
    { "RRTILE3767", DVPTR(RRTILE3767), 0, RRTILE3767__STATICRR },
    { "RRTILE3773", DVPTR(RRTILE3773), 0, RRTILE3773__STATICRR },
    { "RRTILE3774", DVPTR(RRTILE3774), 0, RRTILE3774__STATICRR },
    { "RRTILE3793", DVPTR(RRTILE3793), 0, RRTILE3793__STATICRR },
    { "RRTILE3795", DVPTR(RRTILE3795), 0, RRTILE3795__STATICRR },
    { "RRTILE3804", DVPTR(RRTILE3804), 0, RRTILE3804__STATICRR },
    { "RRTILE3814", DVPTR(RRTILE3814), 0, RRTILE3814__STATICRR },
    { "RRTILE3815", DVPTR(RRTILE3815), 0, RRTILE3815__STATICRR },
    { "RRTILE3819", DVPTR(RRTILE3819), 0, RRTILE3819__STATICRR },
    { "RRTILE3827", DVPTR(RRTILE3827), 0, RRTILE3827__STATICRR },
    { "RRTILE3837", DVPTR(RRTILE3837), 0, RRTILE3837__STATICRR },
    { "RRTILE5014", DVPTR(RRTILE5014), 0, RRTILE5014__STATICRR },
    { "RRTILE5016", DVPTR(RRTILE5016), 0, RRTILE5016__STATICRR },
    { "RRTILE5017", DVPTR(RRTILE5017), 0, RRTILE5017__STATICRR },
    { "RRTILE5018", DVPTR(RRTILE5018), 0, RRTILE5018__STATICRR },
    { "RRTILE5019", DVPTR(RRTILE5019), 0, RRTILE5019__STATICRR },
    { "RRTILE5020", DVPTR(RRTILE5020), 0, RRTILE5020__STATICRR },
    { "RRTILE5021", DVPTR(RRTILE5021), 0, RRTILE5021__STATICRR },
    { "RRTILE5022", DVPTR(RRTILE5022), 0, RRTILE5022__STATICRR },
    { "RRTILE5023", DVPTR(RRTILE5023), 0, RRTILE5023__STATICRR },
    { "RRTILE5024", DVPTR(RRTILE5024), 0, RRTILE5024__STATICRR },
    { "RRTILE5025", DVPTR(RRTILE5025), 0, RRTILE5025__STATICRR },
    { "RRTILE5026", DVPTR(RRTILE5026), 0, RRTILE5026__STATICRR },
    { "RRTILE5027", DVPTR(RRTILE5027), 0, RRTILE5027__STATICRR },
    { "RRTILE5029", DVPTR(RRTILE5029), 0, RRTILE5029__STATICRR },
    { "RRTILE5030", DVPTR(RRTILE5030), 0, RRTILE5030__STATICRR },
    { "RRTILE5031", DVPTR(RRTILE5031), 0, RRTILE5031__STATICRR },
    { "RRTILE5032", DVPTR(RRTILE5032), 0, RRTILE5032__STATICRR },
    { "RRTILE5033", DVPTR(RRTILE5033), 0, RRTILE5033__STATICRR },
    { "RRTILE5034", DVPTR(RRTILE5034), 0, RRTILE5034__STATICRR },
    { "RRTILE5035", DVPTR(RRTILE5035), 0, RRTILE5035__STATICRR },
    { "RRTILE5036", DVPTR(RRTILE5036), 0, RRTILE5036__STATICRR },
    { "RRTILE5037", DVPTR(RRTILE5037), 0, RRTILE5037__STATICRR },
    { "RRTILE5038", DVPTR(RRTILE5038), 0, RRTILE5038__STATICRR },
    { "RRTILE5039", DVPTR(RRTILE5039), 0, RRTILE5039__STATICRR },
    { "RRTILE5040", DVPTR(RRTILE5040), 0, RRTILE5040__STATICRR },
    { "RRTILE5041", DVPTR(RRTILE5041), 0, RRTILE5041__STATICRR },
    { "RRTILE5043", DVPTR(RRTILE5043), 0, RRTILE5043__STATICRR },
    { "RRTILE5044", DVPTR(RRTILE5044), 0, RRTILE5044__STATICRR },
    { "RRTILE5045", DVPTR(RRTILE5045), 0, RRTILE5045__STATICRR },
    { "RRTILE5046", DVPTR(RRTILE5046), 0, RRTILE5046__STATICRR },
    { "RRTILE5047", DVPTR(RRTILE5047), 0, RRTILE5047__STATICRR },
    { "RRTILE5048", DVPTR(RRTILE5048), 0, RRTILE5048__STATICRR },
    { "RRTILE5049", DVPTR(RRTILE5049), 0, RRTILE5049__STATICRR },
    { "RRTILE5050", DVPTR(RRTILE5050), 0, RRTILE5050__STATICRR },
    { "RRTILE5051", DVPTR(RRTILE5051), 0, RRTILE5051__STATICRR },
    { "RRTILE5052", DVPTR(RRTILE5052), 0, RRTILE5052__STATICRR },
    { "RRTILE5053", DVPTR(RRTILE5053), 0, RRTILE5053__STATICRR },
    { "RRTILE5054", DVPTR(RRTILE5054), 0, RRTILE5054__STATICRR },
    { "RRTILE5055", DVPTR(RRTILE5055), 0, RRTILE5055__STATICRR },
    { "RRTILE5056", DVPTR(RRTILE5056), 0, RRTILE5056__STATICRR },
    { "RRTILE5057", DVPTR(RRTILE5057), 0, RRTILE5057__STATICRR },
    { "RRTILE5058", DVPTR(RRTILE5058), 0, RRTILE5058__STATICRR },
    { "RRTILE5059", DVPTR(RRTILE5059), 0, RRTILE5059__STATICRR },
    { "RRTILE5061", DVPTR(RRTILE5061), 0, RRTILE5061__STATICRR },
    { "RRTILE5062", DVPTR(RRTILE5062), 0, RRTILE5062__STATICRR },
    { "RRTILE5063", DVPTR(RRTILE5063), 0, RRTILE5063__STATICRR },
    { "RRTILE5064", DVPTR(RRTILE5064), 0, RRTILE5064__STATICRR },
    { "RRTILE5065", DVPTR(RRTILE5065), 0, RRTILE5065__STATICRR },
    { "RRTILE5066", DVPTR(RRTILE5066), 0, RRTILE5066__STATICRR },
    { "RRTILE5067", DVPTR(RRTILE5067), 0, RRTILE5067__STATICRR },
    { "RRTILE5068", DVPTR(RRTILE5068), 0, RRTILE5068__STATICRR },
    { "RRTILE5069", DVPTR(RRTILE5069), 0, RRTILE5069__STATICRR },
    { "RRTILE5070", DVPTR(RRTILE5070), 0, RRTILE5070__STATICRR },
    { "RRTILE5071", DVPTR(RRTILE5071), 0, RRTILE5071__STATICRR },
    { "RRTILE5072", DVPTR(RRTILE5072), 0, RRTILE5072__STATICRR },
    { "RRTILE5073", DVPTR(RRTILE5073), 0, RRTILE5073__STATICRR },
    { "RRTILE5074", DVPTR(RRTILE5074), 0, RRTILE5074__STATICRR },
    { "RRTILE5075", DVPTR(RRTILE5075), 0, RRTILE5075__STATICRR },
    { "RRTILE5076", DVPTR(RRTILE5076), 0, RRTILE5076__STATICRR },
    { "RRTILE5077", DVPTR(RRTILE5077), 0, RRTILE5077__STATICRR },
    { "RRTILE5078", DVPTR(RRTILE5078), 0, RRTILE5078__STATICRR },
    { "RRTILE5079", DVPTR(RRTILE5079), 0, RRTILE5079__STATICRR },
    { "RRTILE5080", DVPTR(RRTILE5080), 0, RRTILE5080__STATICRR },
    { "RRTILE5081", DVPTR(RRTILE5081), 0, RRTILE5081__STATICRR },
    { "RRTILE5082", DVPTR(RRTILE5082), 0, RRTILE5082__STATICRR },
    { "RRTILE5083", DVPTR(RRTILE5083), 0, RRTILE5083__STATICRR },
    { "RRTILE5084", DVPTR(RRTILE5084), 0, RRTILE5084__STATICRR },
    { "RRTILE5085", DVPTR(RRTILE5085), 0, RRTILE5085__STATICRR },
    { "RRTILE5086", DVPTR(RRTILE5086), 0, RRTILE5086__STATICRR },
    { "RRTILE5087", DVPTR(RRTILE5087), 0, RRTILE5087__STATICRR },
    { "RRTILE5088", DVPTR(RRTILE5088), 0, RRTILE5088__STATICRR },
    { "RRTILE5090", DVPTR(RRTILE5090), 0, RRTILE5090__STATICRR },
    { "RRTILE6144", DVPTR(RRTILE6144), 0, RRTILE6144__STATICRR },
    { "RRTILE7010", DVPTR(RRTILE7110), 0, RRTILE7110__STATICRR },
    { "RRTILE7011", DVPTR(RRTILE7111), 0, RRTILE7111__STATICRR },
    { "RRTILE7012", DVPTR(RRTILE7112), 0, RRTILE7112__STATICRR },
    { "RRTILE7013", DVPTR(RRTILE7113), 0, RRTILE7113__STATICRR },
    { "MOTOGUN", DVPTR(MOTOGUN), 0, MOTOGUN__STATICRR },
    { "RRTILE7169", DVPTR(RRTILE7169), 0, RRTILE7169__STATICRR },
    { "MOTOHIT", DVPTR(MOTOHIT), 0, MOTOHIT__STATICRR },
    { "BOATHIT", DVPTR(BOATHIT), 0, BOATHIT__STATICRR },
    { "RRTILE7184", DVPTR(RRTILE7184), 0, RRTILE7184__STATICRR },
    { "RRTILE7190", DVPTR(RRTILE7190), 0, RRTILE7190__STATICRR },
    { "RRTILE7191", DVPTR(RRTILE7191), 0, RRTILE7191__STATICRR },
    { "RRTILE7213", DVPTR(RRTILE7213), 0, RRTILE7213__STATICRR },
    { "RRTILE7219", DVPTR(RRTILE7219), 0, RRTILE7219__STATICRR },
    { "EMPTYBIKE", DVPTR(EMPTYBIKE), 0, EMPTYBIKE__STATICRR },
    { "EMPTYBOAT", DVPTR(EMPTYBOAT), 0, EMPTYBOAT__STATICRR },
    { "RRTILE7424", DVPTR(RRTILE7424), 0, RRTILE7424__STATICRR },
    { "RRTILE7430", DVPTR(RRTILE7430), 0, RRTILE7430__STATICRR },
    { "RRTILE7433", DVPTR(RRTILE7433), 0, RRTILE7433__STATICRR },
    { "RRTILE7441", DVPTR(RRTILE7441), 0, RRTILE7441__STATICRR },
    { "RRTILE7547", DVPTR(RRTILE7547), 0, RRTILE7547__STATICRR },
    { "RRTILE7467", DVPTR(RRTILE7467), 0, RRTILE7467__STATICRR },
    { "RRTILE7469", DVPTR(RRTILE7469), 0, RRTILE7469__STATICRR },
    { "RRTILE7470", DVPTR(RRTILE7470), 0, RRTILE7470__STATICRR },
    { "RRTILE7475", DVPTR(RRTILE7475), 0, RRTILE7475__STATICRR },
    { "RRTILE7478", DVPTR(RRTILE7478), 0, RRTILE7478__STATICRR },
    { "RRTILE7505", DVPTR(RRTILE7505), 0, RRTILE7505__STATICRR },
    { "RRTILE7506", DVPTR(RRTILE7506), 0, RRTILE7506__STATICRR },
    { "RRTILE7534", DVPTR(RRTILE7534), 0, RRTILE7534__STATICRR },
    { "RRTILE7540", DVPTR(RRTILE7540), 0, RRTILE7540__STATICRR },
    { "RRTILE7533", DVPTR(RRTILE7533), 0, RRTILE7533__STATICRR },
    { "RRTILE7545", DVPTR(RRTILE7545), 0, RRTILE7545__STATICRR },
    { "RRTILE7552", DVPTR(RRTILE7552), 0, RRTILE7552__STATICRR },
    { "RRTILE7553", DVPTR(RRTILE7553), 0, RRTILE7553__STATICRR },
    { "RRTILE7554", DVPTR(RRTILE7554), 0, RRTILE7554__STATICRR },
    { "RRTILE7555", DVPTR(RRTILE7555), 0, RRTILE7555__STATICRR },
    { "RRTILE7557", DVPTR(RRTILE7557), 0, RRTILE7557__STATICRR },
    { "RRTILE7558", DVPTR(RRTILE7558), 0, RRTILE7558__STATICRR },
    { "RRTILE7559", DVPTR(RRTILE7559), 0, RRTILE7559__STATICRR },
    { "RRTILE7561", DVPTR(RRTILE7561), 0, RRTILE7561__STATICRR },
    { "RRTILE7566", DVPTR(RRTILE7566), 0, RRTILE7566__STATICRR },
    { "RRTILE7568", DVPTR(RRTILE7568), 0, RRTILE7568__STATICRR },
    { "RRTILE7574", DVPTR(RRTILE7574), 0, RRTILE7574__STATICRR },
    { "RRTILE7575", DVPTR(RRTILE7575), 0, RRTILE7575__STATICRR },
    { "RRTILE7576", DVPTR(RRTILE7576), 0, RRTILE7576__STATICRR },
    { "RRTILE7578", DVPTR(RRTILE7578), 0, RRTILE7578__STATICRR },
    { "RRTILE7579", DVPTR(RRTILE7579), 0, RRTILE7579__STATICRR },
    { "RRTILE7580", DVPTR(RRTILE7580), 0, RRTILE7580__STATICRR },
    { "RRTILE7595", DVPTR(RRTILE7595), 0, RRTILE7595__STATICRR },
    { "RRTILE7629", DVPTR(RRTILE7629), 0, RRTILE7629__STATICRR },
    { "RRTILE7636", DVPTR(RRTILE7636), 0, RRTILE7636__STATICRR },
    { "RRTILE7638", DVPTR(RRTILE7638), 0, RRTILE7638__STATICRR },
    { "RRTILE7640", DVPTR(RRTILE7640), 0, RRTILE7640__STATICRR },
    { "RRTILE7644", DVPTR(RRTILE7644), 0, RRTILE7644__STATICRR },
    { "RRTILE7646", DVPTR(RRTILE7646), 0, RRTILE7646__STATICRR },
    { "RRTILE7648", DVPTR(RRTILE7648), 0, RRTILE7648__STATICRR },
    { "RRTILE7650", DVPTR(RRTILE7650), 0, RRTILE7650__STATICRR },
    { "RRTILE7653", DVPTR(RRTILE7653), 0, RRTILE7653__STATICRR },
    { "RRTILE7655", DVPTR(RRTILE7655), 0, RRTILE7655__STATICRR },
    { "RRTILE7657", DVPTR(RRTILE7657), 0, RRTILE7657__STATICRR },
    { "RRTILE7659", DVPTR(RRTILE7659), 0, RRTILE7659__STATICRR },
    { "RRTILE7691", DVPTR(RRTILE7691), 0, RRTILE7691__STATICRR },
    { "RRTILE7694", DVPTR(RRTILE7694), 0, RRTILE7694__STATICRR },
    { "RRTILE7696", DVPTR(RRTILE7696), 0, RRTILE7696__STATICRR },
    { "RRTILE7697", DVPTR(RRTILE7697), 0, RRTILE7697__STATICRR },
    { "RRTILE7700", DVPTR(RRTILE7700), 0, RRTILE7700__STATICRR },
    { "RRTILE7702", DVPTR(RRTILE7702), 0, RRTILE7702__STATICRR },
    { "RRTILE7704", DVPTR(RRTILE7704), 0, RRTILE7704__STATICRR },
    { "RRTILE7705", DVPTR(RRTILE7705), 0, RRTILE7705__STATICRR },
    { "RRTILE7711", DVPTR(RRTILE7711), 0, RRTILE7711__STATICRR },
    { "RRTILE7716", DVPTR(RRTILE7716), 0, RRTILE7716__STATICRR },
    { "RRTILE7756", DVPTR(RRTILE7756), 0, RRTILE7756__STATICRR },
    { "RRTILE7768", DVPTR(RRTILE7768), 0, RRTILE7768__STATICRR },
    { "RRTILE7806", DVPTR(RRTILE7806), 0, RRTILE7806__STATICRR },
    { "RRTILE7820", DVPTR(RRTILE7820), 0, RRTILE7820__STATICRR },
    { "RRTILE7859", DVPTR(RRTILE7859), 0, RRTILE7859__STATICRR },
    { "RRTILE7870", DVPTR(RRTILE7870), 0, RRTILE7870__STATICRR },
    { "RRTILE7873", DVPTR(RRTILE7873), 0, RRTILE7873__STATICRR },
    { "RRTILE7875", DVPTR(RRTILE7875), 0, RRTILE7875__STATICRR },
    { "RRTILE7876", DVPTR(RRTILE7876), 0, RRTILE7876__STATICRR },
    { "RRTILE7879", DVPTR(RRTILE7879), 0, RRTILE7879__STATICRR },
    { "RRTILE7881", DVPTR(RRTILE7881), 0, RRTILE7881__STATICRR },
    { "RRTILE7883", DVPTR(RRTILE7883), 0, RRTILE7883__STATICRR },
    { "RRTILE7885", DVPTR(RRTILE7885), 0, RRTILE7885__STATICRR },
    { "RRTILE7886", DVPTR(RRTILE7886), 0, RRTILE7886__STATICRR },
    { "RRTILE7887", DVPTR(RRTILE7887), 0, RRTILE7887__STATICRR },
    { "RRTILE7888", DVPTR(RRTILE7888), 0, RRTILE7888__STATICRR },
    { "RRTILE7889", DVPTR(RRTILE7889), 0, RRTILE7889__STATICRR },
    { "RRTILE7890", DVPTR(RRTILE7890), 0, RRTILE7890__STATICRR },
    { "RRTILE7900", DVPTR(RRTILE7900), 0, RRTILE7900__STATICRR },
    { "RRTILE7901", DVPTR(RRTILE7901), 0, RRTILE7901__STATICRR },
    { "RRTILE7906", DVPTR(RRTILE7906), 0, RRTILE7906__STATICRR },
    { "RRTILE7912", DVPTR(RRTILE7912), 0, RRTILE7912__STATICRR },
    { "RRTILE7913", DVPTR(RRTILE7913), 0, RRTILE7913__STATICRR },
    { "RRTILE7936", DVPTR(RRTILE7936), 0, RRTILE7936__STATICRR },
    { "RRTILE8047", DVPTR(RRTILE8047), 0, RRTILE8047__STATICRR },
    { "MULTISWITCH2", DVPTR(MULTISWITCH2), 0, MULTISWITCH2__STATICRR },
    { "RRTILE8059", DVPTR(RRTILE8059), 0, RRTILE8059__STATICRR },
    { "RRTILE8060", DVPTR(RRTILE8060), 0, RRTILE8060__STATICRR },
    { "RRTILE8063", DVPTR(RRTILE8063), 0, RRTILE8063__STATICRR },
    { "RRTILE8067", DVPTR(RRTILE8067), 0, RRTILE8067__STATICRR },
    { "RRTILE8076", DVPTR(RRTILE8076), 0, RRTILE8076__STATICRR },
    { "RRTILE8094", DVPTR(RRTILE8094), 0, RRTILE8094__STATICRR },
    { "RRTILE8096", DVPTR(RRTILE8096), 0, RRTILE8096__STATICRR },
    { "RRTILE8099", DVPTR(RRTILE8099), 0, RRTILE8099__STATICRR },
    { "RRTILE8106", DVPTR(RRTILE8106), 0, RRTILE8106__STATICRR },
    { "RRTILE8162", DVPTR(RRTILE8162), 0, RRTILE8162__STATICRR },
    { "RRTILE8163", DVPTR(RRTILE8163), 0, RRTILE8163__STATICRR },
    { "RRTILE8164", DVPTR(RRTILE8164), 0, RRTILE8164__STATICRR },
    { "RRTILE8165", DVPTR(RRTILE8165), 0, RRTILE8165__STATICRR },
    { "RRTILE8166", DVPTR(RRTILE8166), 0, RRTILE8166__STATICRR },
    { "RRTILE8167", DVPTR(RRTILE8167), 0, RRTILE8167__STATICRR },
    { "RRTILE8168", DVPTR(RRTILE8168), 0, RRTILE8168__STATICRR },
    { "RRTILE8192", DVPTR(RRTILE8192), 0, RRTILE8192__STATICRR },
    { "RRTILE8193", DVPTR(RRTILE8193), 0, RRTILE8193__STATICRR },
    { "RRTILE8215", DVPTR(RRTILE8215), 0, RRTILE8215__STATICRR },
    { "RRTILE8216", DVPTR(RRTILE8216), 0, RRTILE8216__STATICRR },
    { "RRTILE8217", DVPTR(RRTILE8217), 0, RRTILE8217__STATICRR },
    { "RRTILE8218", DVPTR(RRTILE8218), 0, RRTILE8218__STATICRR },
    { "RRTILE8220", DVPTR(RRTILE8220), 0, RRTILE8220__STATICRR },
    { "RRTILE8221", DVPTR(RRTILE8221), 0, RRTILE8221__STATICRR },
    { "RRTILE8222", DVPTR(RRTILE8222), 0, RRTILE8222__STATICRR },
    { "RRTILE8223", DVPTR(RRTILE8223), 0, RRTILE8223__STATICRR },
    { "RRTILE8224", DVPTR(RRTILE8224), 0, RRTILE8224__STATICRR },
    { "RRTILE8227", DVPTR(RRTILE8227), 0, RRTILE8227__STATICRR },
    { "RRTILE8312", DVPTR(RRTILE8312), 0, RRTILE8312__STATICRR },
    { "RRTILE8370", DVPTR(RRTILE8370), 0, RRTILE8370__STATICRR },
    { "RRTILE8371", DVPTR(RRTILE8371), 0, RRTILE8371__STATICRR },
    { "RRTILE8372", DVPTR(RRTILE8372), 0, RRTILE8372__STATICRR },
    { "RRTILE8373", DVPTR(RRTILE8373), 0, RRTILE8373__STATICRR },
    { "RRTILE8379", DVPTR(RRTILE8379), 0, RRTILE8379__STATICRR },
    { "RRTILE8380", DVPTR(RRTILE8380), 0, RRTILE8380__STATICRR },
    { "RRTILE8385", DVPTR(RRTILE8385), 0, RRTILE8385__STATICRR },
    { "RRTILE8386", DVPTR(RRTILE8386), 0, RRTILE8386__STATICRR },
    { "RRTILE8387", DVPTR(RRTILE8387), 0, RRTILE8387__STATICRR },
    { "RRTILE8388", DVPTR(RRTILE8388), 0, RRTILE8388__STATICRR },
    { "RRTILE8389", DVPTR(RRTILE8389), 0, RRTILE8389__STATICRR },
    { "RRTILE8390", DVPTR(RRTILE8390), 0, RRTILE8390__STATICRR },
    { "RRTILE8391", DVPTR(RRTILE8391), 0, RRTILE8391__STATICRR },
    { "RRTILE8392", DVPTR(RRTILE8392), 0, RRTILE8392__STATICRR },
    { "RRTILE8394", DVPTR(RRTILE8394), 0, RRTILE8394__STATICRR },
    { "RRTILE8395", DVPTR(RRTILE8395), 0, RRTILE8395__STATICRR },
    { "RRTILE8396", DVPTR(RRTILE8396), 0, RRTILE8396__STATICRR },
    { "RRTILE8397", DVPTR(RRTILE8397), 0, RRTILE8397__STATICRR },
    { "RRTILE8398", DVPTR(RRTILE8398), 0, RRTILE8398__STATICRR },
    { "RRTILE8399", DVPTR(RRTILE8399), 0, RRTILE8399__STATICRR },
    { "RRTILE8423", DVPTR(RRTILE8423), 0, RRTILE8423__STATICRR },
    { "RRTILE8448", DVPTR(RRTILE8448), 0, RRTILE8448__STATICRR },
    { "RRTILE8450", DVPTR(RRTILE8450), 0, RRTILE8450__STATICRR },
    { "BOATAMMO", DVPTR(BOATAMMO), 0, BOATAMMO__STATICRR },
    { "RRTILE8461", DVPTR(RRTILE8461), 0, RRTILE8461__STATICRR },
    { "RRTILE8462", DVPTR(RRTILE8462), 0, RRTILE8462__STATICRR },
    { "RRTILE8464", DVPTR(RRTILE8464), 0, RRTILE8464__STATICRR },
    { "RRTILE8475", DVPTR(RRTILE8475), 0, RRTILE8475__STATICRR },
    { "RRTILE8487", DVPTR(RRTILE8487), 0, RRTILE8487__STATICRR },
    { "RRTILE8488", DVPTR(RRTILE8488), 0, RRTILE8488__STATICRR },
    { "RRTILE8489", DVPTR(RRTILE8489), 0, RRTILE8489__STATICRR },
    { "RRTILE8490", DVPTR(RRTILE8490), 0, RRTILE8490__STATICRR },
    { "RRTILE8496", DVPTR(RRTILE8496), 0, RRTILE8496__STATICRR },
    { "RRTILE8497", DVPTR(RRTILE8497), 0, RRTILE8497__STATICRR },
    { "RRTILE8498", DVPTR(RRTILE8498), 0, RRTILE8498__STATICRR },
    { "RRTILE8499", DVPTR(RRTILE8499), 0, RRTILE8499__STATICRR },
    { "RRTILE8503", DVPTR(RRTILE8503), 0, RRTILE8503__STATICRR },
    { "RRTILE8525", DVPTR(RRTILE8525), 0, RRTILE8525__STATICRR },
    { "RRTILE8537", DVPTR(RRTILE8537), 0, RRTILE8537__STATICRR },
    { "RRTILE8565", DVPTR(RRTILE8565), 0, RRTILE8565__STATICRR },
    { "RRTILE8567", DVPTR(RRTILE8567), 0, RRTILE8567__STATICRR },
    { "RRTILE8568", DVPTR(RRTILE8568), 0, RRTILE8568__STATICRR },
    { "RRTILE8569", DVPTR(RRTILE8569), 0, RRTILE8569__STATICRR },
    { "RRTILE8570", DVPTR(RRTILE8570), 0, RRTILE8570__STATICRR },
    { "RRTILE8571", DVPTR(RRTILE8571), 0, RRTILE8571__STATICRR },
    { "RRTILE8579", DVPTR(RRTILE8579), 0, RRTILE8579__STATICRR },
    { "RRTILE8588", DVPTR(RRTILE8588), 0, RRTILE8588__STATICRR },
    { "RRTILE8589", DVPTR(RRTILE8589), 0, RRTILE8589__STATICRR },
    { "RRTILE8590", DVPTR(RRTILE8590), 0, RRTILE8590__STATICRR },
    { "RRTILE8591", DVPTR(RRTILE8591), 0, RRTILE8591__STATICRR },
    { "RRTILE8592", DVPTR(RRTILE8592), 0, RRTILE8592__STATICRR },
    { "RRTILE8593", DVPTR(RRTILE8593), 0, RRTILE8593__STATICRR },
    { "RRTILE8594", DVPTR(RRTILE8594), 0, RRTILE8594__STATICRR },
    { "RRTILE8595", DVPTR(RRTILE8595), 0, RRTILE8595__STATICRR },
    { "RRTILE8596", DVPTR(RRTILE8596), 0, RRTILE8596__STATICRR },
    { "RRTILE8598", DVPTR(RRTILE8598), 0, RRTILE8598__STATICRR },
    { "RRTILE8605", DVPTR(RRTILE8605), 0, RRTILE8605__STATICRR },
    { "RRTILE8608", DVPTR(RRTILE8608), 0, RRTILE8608__STATICRR },
    { "RRTILE8609", DVPTR(RRTILE8609), 0, RRTILE8609__STATICRR },
    { "RRTILE8611", DVPTR(RRTILE8611), 0, RRTILE8611__STATICRR },
    { "RRTILE8617", DVPTR(RRTILE8617), 0, RRTILE8617__STATICRR },
    { "RRTILE8618", DVPTR(RRTILE8618), 0, RRTILE8618__STATICRR },
    { "RRTILE8620", DVPTR(RRTILE8620), 0, RRTILE8620__STATICRR },
    { "RRTILE8621", DVPTR(RRTILE8621), 0, RRTILE8621__STATICRR },
    { "RRTILE8622", DVPTR(RRTILE8622), 0, RRTILE8622__STATICRR },
    { "RRTILE8623", DVPTR(RRTILE8623), 0, RRTILE8623__STATICRR },
    { "RRTILE8624", DVPTR(RRTILE8624), 0, RRTILE8624__STATICRR },
    { "RRTILE8640", DVPTR(RRTILE8640), 0, RRTILE8640__STATICRR },
    { "RRTILE8651", DVPTR(RRTILE8651), 0, RRTILE8651__STATICRR },
    { "RRTILE8660", DVPTR(RRTILE8660), 0, RRTILE8660__STATICRR },
    { "RRTILE8677", DVPTR(RRTILE8677), 0, RRTILE8677__STATICRR },
    { "RRTILE8679", DVPTR(RRTILE8679), 0, RRTILE8679__STATICRR },
    { "RRTILE8680", DVPTR(RRTILE8680), 0, RRTILE8680__STATICRR },
    { "RRTILE8681", DVPTR(RRTILE8681), 0, RRTILE8681__STATICRR },
    { "RRTILE8682", DVPTR(RRTILE8682), 0, RRTILE8682__STATICRR },
    { "RRTILE8683", DVPTR(RRTILE8683), 0, RRTILE8683__STATICRR },
    { "RRTILE8704", DVPTR(RRTILE8704), 0, RRTILE8704__STATICRR },
    { "BOULDER", DVPTR(BOULDER), 0, BOULDER__STATICRR },
    { "BOULDER1", DVPTR(BOULDER1), 0, BOULDER1__STATICRR },
    { "TORNADO", DVPTR(TORNADO), 0, TORNADO__STATICRR },
    { "CHEERBOMB", DVPTR(CHEERBOMB), 0, CHEERBOMB__STATICRR },
    { "CHEERBLADE", DVPTR(CHEERBLADE), 0, CHEERBLADE__STATICRR },
    { "DOGATTACK", DVPTR(DOGATTACK), 0, DOGATTACK__STATICRR },
    { "BILLYWALK", DVPTR(BILLYWALK), 0, BILLYWALK__STATICRR },
    { "BILLYDIE", DVPTR(BILLYDIE), 0, BILLYDIE__STATICRR },
    { "BILLYCOCK", DVPTR(BILLYCOCK), 0, BILLYCOCK__STATICRR },
    { "BILLYRAY", DVPTR(BILLYRAY), 0, BILLYRAY__STATICRR },
    { "BILLYRAYSTAYPUT", DVPTR(BILLYRAYSTAYPUT), 0, BILLYRAYSTAYPUT__STATICRR },
    { "BILLYBUT", DVPTR(BILLYBUT), 0, BILLYBUT__STATICRR },
    { "BILLYSCRATCH", DVPTR(BILLYSCRATCH), 0, BILLYSCRATCH__STATICRR },
    { "BILLYSNIFF", DVPTR(BILLYSNIFF), 0, BILLYSNIFF__STATICRR },
    { "BILLYWOUND", DVPTR(BILLYWOUND), 0, BILLYWOUND__STATICRR },
    { "BILLYGORE", DVPTR(BILLYGORE), 0, BILLYGORE__STATICRR },
    { "BILLYJIBA", DVPTR(BILLYJIBA), 0, BILLYJIBA__STATICRR },
    { "BILLYJIBB", DVPTR(BILLYJIBB), 0, BILLYJIBB__STATICRR },
    { "BRAYSNIPER", DVPTR(BRAYSNIPER), 0, BRAYSNIPER__STATICRR },
    { "DOGRUN", DVPTR(DOGRUN), 0, DOGRUN__STATICRR },
    { "DOGDIE", DVPTR(DOGDIE), 0, DOGDIE__STATICRR },
    { "DOGDEAD", DVPTR(DOGDEAD), 0, DOGDEAD__STATICRR },
    { "DOGBARK", DVPTR(DOGBARK), 0, DOGBARK__STATICRR },
    { "LTH", DVPTR(LTH), 0, LTH__STATICRR },
    { "LTHSTRAFE", DVPTR(LTHSTRAFE), 0, LTHSTRAFE__STATICRR },
    { "HULKHANG", DVPTR(HULKHANG), 0, HULKHANG__STATICRR },
    { "HULKHANGDEAD", DVPTR(HULKHANGDEAD), 0, HULKHANGDEAD__STATICRR },
    { "HULKJUMP", DVPTR(HULKJUMP), 0, HULKJUMP__STATICRR },
    { "LTHLOAD", DVPTR(LTHLOAD), 0, LTHLOAD__STATICRR },
    { "LTHDIE", DVPTR(LTHDIE), 0, LTHDIE__STATICRR },
    { "BUBBASCRATCH", DVPTR(BUBBASCRATCH), 0, BUBBASCRATCH__STATICRR },
    { "BUBBANOSE", DVPTR(BUBBANOSE), 0, BUBBANOSE__STATICRR },
    { "BUBBAPISS", DVPTR(BUBBAPISS), 0, BUBBAPISS__STATICRR },
    { "BUBBASTAND", DVPTR(BUBBASTAND), 0, BUBBASTAND__STATICRR },
    { "BUBBAOUCH", DVPTR(BUBBAOUCH), 0, BUBBAOUCH__STATICRR },
    { "BUBBADIE", DVPTR(BUBBADIE), 0, BUBBADIE__STATICRR },
    { "BUBBADEAD", DVPTR(BUBBADEAD), 0, BUBBADEAD__STATICRR },
    { "HULK", DVPTR(HULK), 0, HULK__STATICRR },
    { "HULKSTAYPUT", DVPTR(HULKSTAYPUT), 0, HULKSTAYPUT__STATICRR },
    { "HULKA", DVPTR(HULKA), 0, HULKA__STATICRR },
    { "HULKB", DVPTR(HULKB), 0, HULKB__STATICRR },
    { "HULKC", DVPTR(HULKC), 0, HULKC__STATICRR },
    { "HULKJIBA", DVPTR(HULKJIBA), 0, HULKJIBA__STATICRR },
    { "HULKJIBB", DVPTR(HULKJIBB), 0, HULKJIBB__STATICRR },
    { "HULKJIBC", DVPTR(HULKJIBC), 0, HULKJIBC__STATICRR },
    { "SBSWIPE", DVPTR(SBSWIPE), 0, SBSWIPE__STATICRR },
    { "SBPAIN", DVPTR(SBPAIN), 0, SBPAIN__STATICRR },
    { "SBDIE", DVPTR(SBDIE), 0, SBDIE__STATICRR },
    { "HEN", DVPTR(HEN), 0, HEN__STATICRR },
    { "HENSTAYPUT", DVPTR(HENSTAYPUT), 0, HENSTAYPUT__STATICRR },
    { "HENSTAND", DVPTR(HENSTAND), 0, HENSTAND__STATICRR },
    { "PIG", DVPTR(PIG), 0, PIG__STATICRR },
    { "PIGSTAYPUT", DVPTR(PIGSTAYPUT), 0, PIGSTAYPUT__STATICRR },
    { "PIGEAT", DVPTR(PIGEAT), 0, PIGEAT__STATICRR },
    { "SBMOVE", DVPTR(SBMOVE), 0, SBMOVE__STATICRR },
    { "SBSPIT", DVPTR(SBSPIT), 0, SBSPIT__STATICRR },
    { "SBDIP", DVPTR(SBDIP), 0, SBDIP__STATICRR },
    { "MINION", DVPTR(MINION), 0, MINION__STATICRR },
    { "MINIONSTAYPUT", DVPTR(MINIONSTAYPUT), 0, MINIONSTAYPUT__STATICRR },
    { "UFO1", DVPTR(UFO1), 0, UFO1__STATICRR },
    { "UFO2", DVPTR(UFO2), 0, UFO2__STATICRR },
    { "UFO3", DVPTR(UFO3), 0, UFO3__STATICRR },
    { "UFO4", DVPTR(UFO4), 0, UFO4__STATICRR },
    { "UFO5", DVPTR(UFO5), 0, UFO5__STATICRR },
    { "MINJIBA", DVPTR(MINJIBA), 0, MINJIBA__STATICRR },
    { "MINJIBB", DVPTR(MINJIBB), 0, MINJIBB__STATICRR },
    { "MINJIBC", DVPTR(MINJIBC), 0, MINJIBC__STATICRR },
    { "COW", DVPTR(COW), 0, COW__STATICRR },
    { "COOT", DVPTR(COOT), 0, COOT__STATICRR },
    { "COOTSTAYPUT", DVPTR(COOTSTAYPUT), 0, COOTSTAYPUT__STATICRR },
    { "COOTSHOOT", DVPTR(COOTSHOOT), 0, COOTSHOOT__STATICRR },
    { "COOTDIE", DVPTR(COOTDIE), 0, COOTDIE__STATICRR },
    { "COOTDUCK", DVPTR(COOTDUCK), 0, COOTDUCK__STATICRR },
    { "COOTPAIN", DVPTR(COOTPAIN), 0, COOTPAIN__STATICRR },
    { "COOTTRANS", DVPTR(COOTTRANS), 0, COOTTRANS__STATICRR },
    { "COOTGETUP", DVPTR(COOTGETUP), 0, COOTGETUP__STATICRR },
    { "COOTJIBA", DVPTR(COOTJIBA), 0, COOTJIBA__STATICRR },
    { "COOTJIBB", DVPTR(COOTJIBB), 0, COOTJIBB__STATICRR },
    { "COOTJIBC", DVPTR(COOTJIBC), 0, COOTJIBC__STATICRR },
    { "VIXEN", DVPTR(VIXEN), 0, VIXEN__STATICRR },
    { "VIXENPAIN", DVPTR(VIXENPAIN), 0, VIXENPAIN__STATICRR },
    { "VIXENDIE", DVPTR(VIXENDIE), 0, VIXENDIE__STATICRR },
    { "VIXENSHOOT", DVPTR(VIXENSHOOT), 0, VIXENSHOOT__STATICRR },
    { "VIXENWDN", DVPTR(VIXENWDN), 0, VIXENWDN__STATICRR },
    { "VIXENWUP", DVPTR(VIXENWUP), 0, VIXENWUP__STATICRR },
    { "VIXENKICK", DVPTR(VIXENKICK), 0, VIXENKICK__STATICRR },
    { "VIXENTELE", DVPTR(VIXENTELE), 0, VIXENTELE__STATICRR },
    { "VIXENTEAT", DVPTR(VIXENTEAT), 0, VIXENTEAT__STATICRR },
    { "BIKEJIBA", DVPTR(BIKEJIBA), 0, BIKEJIBA__STATICRR },
    { "BIKEJIBB", DVPTR(BIKEJIBB), 0, BIKEJIBB__STATICRR },
    { "BIKEJIBC", DVPTR(BIKEJIBC), 0, BIKEJIBC__STATICRR },
    { "BIKERB", DVPTR(BIKERB), 0, BIKERB__STATICRR },
    { "BIKERBV2", DVPTR(BIKERBV2), 0, BIKERBV2__STATICRR },
    { "BIKER", DVPTR(BIKER), 0, BIKER__STATICRR },
    { "BIKERJIBA", DVPTR(BIKERJIBA), 0, BIKERJIBA__STATICRR },
    { "BIKERJIBB", DVPTR(BIKERJIBB), 0, BIKERJIBB__STATICRR },
    { "BIKERJIBC", DVPTR(BIKERJIBC), 0, BIKERJIBC__STATICRR },
    { "BIKERJIBD", DVPTR(BIKERJIBD), 0, BIKERJIBD__STATICRR },
    { "MAKEOUT", DVPTR(MAKEOUT), 0, MAKEOUT__STATICRR },
    { "CHEERB", DVPTR(CHEERB), 0, CHEERB__STATICRR },
    { "CHEER", DVPTR(CHEER), 0, CHEER__STATICRR },
    { "CHEERSTAYPUT", DVPTR(CHEERSTAYPUT), 0, CHEERSTAYPUT__STATICRR },
    { "CHEERJIBA", DVPTR(CHEERJIBA), 0, CHEERJIBA__STATICRR },
    { "CHEERJIBB", DVPTR(CHEERJIBB), 0, CHEERJIBB__STATICRR },
    { "CHEERJIBC", DVPTR(CHEERJIBC), 0, CHEERJIBC__STATICRR },
    { "CHEERJIBD", DVPTR(CHEERJIBD), 0, CHEERJIBD__STATICRR },
    { "FBOATJIBA", DVPTR(FBOATJIBA), 0, FBOATJIBA__STATICRR },
    { "FBOATJIBB", DVPTR(FBOATJIBB), 0, FBOATJIBB__STATICRR },
    { "COOTPLAY", DVPTR(COOTPLAY), 0, COOTPLAY__STATICRR },
    { "BILLYPLAY", DVPTR(BILLYPLAY), 0, BILLYPLAY__STATICRR },
    { "MINIONBOAT", DVPTR(MINIONBOAT), 0, MINIONBOAT__STATICRR },
    { "HULKBOAT", DVPTR(HULKBOAT), 0, HULKBOAT__STATICRR },
    { "CHEERBOAT", DVPTR(CHEERBOAT), 0, CHEERBOAT__STATICRR },
    { "RRTILE7274", DVPTR(RRTILE7274), 0, RRTILE7274__STATICRR },
    { "RABBIT", DVPTR(RABBIT), 0, RABBIT__STATICRR },
    { "RABBITJIBA", DVPTR(RABBITJIBA), 0, RABBITJIBA__STATICRR },
    { "RABBITJIBB", DVPTR(RABBITJIBB), 0, RABBITJIBB__STATICRR },
    { "RABBITJIBC", DVPTR(RABBITJIBC), 0, RABBITJIBC__STATICRR },
    { "ROCK", DVPTR(ROCK), 0, ROCK__STATICRR },
    { "ROCK2", DVPTR(ROCK2), 0, ROCK2__STATICRR },
    { "MAMACLOUD", DVPTR(MAMACLOUD), 0, MAMACLOUD__STATICRR },
    { "MAMA", DVPTR(MAMA), 0, MAMA__STATICRR },
    { "MAMAJIBA", DVPTR(MAMAJIBA), 0, MAMAJIBA__STATICRR },
    { "MAMAJIBB", DVPTR(MAMAJIBB), 0, MAMAJIBB__STATICRR },
    { NULL, NULL, -1, -1 },
};

int32_t SECTOREFFECTOR = SECTOREFFECTOR__STATIC;
int32_t ACTIVATOR = ACTIVATOR__STATIC;
int32_t TOUCHPLATE = TOUCHPLATE__STATIC;
int32_t ACTIVATORLOCKED = ACTIVATORLOCKED__STATIC;
int32_t MUSICANDSFX = MUSICANDSFX__STATIC;
int32_t LOCATORS = LOCATORS__STATIC;
int32_t CYCLER = CYCLER__STATIC;
int32_t MASTERSWITCH = MASTERSWITCH__STATIC;
int32_t RESPAWN = RESPAWN__STATIC;
int32_t GPSPEED = GPSPEED__STATIC;
int32_t FOF = FOF__STATIC;
int32_t ARROW = ARROW__STATIC;
int32_t FIRSTGUNSPRITE = FIRSTGUNSPRITE__STATIC;
int32_t CHAINGUNSPRITE = CHAINGUNSPRITE__STATIC;
int32_t RPGSPRITE = RPGSPRITE__STATIC;
int32_t FREEZESPRITE = FREEZESPRITE__STATIC;
int32_t SHRINKERSPRITE = SHRINKERSPRITE__STATIC;
int32_t HEAVYHBOMB = HEAVYHBOMB__STATIC;
int32_t TRIPBOMBSPRITE = TRIPBOMBSPRITE__STATIC;
int32_t SHOTGUNSPRITE = SHOTGUNSPRITE__STATIC;
int32_t DEVISTATORSPRITE = DEVISTATORSPRITE__STATIC;
int32_t HEALTHBOX = HEALTHBOX__STATIC;
int32_t AMMOBOX = AMMOBOX__STATIC;
int32_t GROWSPRITEICON = GROWSPRITEICON__STATIC;
int32_t INVENTORYBOX = INVENTORYBOX__STATIC;
int32_t DN64TILE34 = DN64TILE34__STATIC;
int32_t FREEZEAMMO = FREEZEAMMO__STATIC;
int32_t AMMO = AMMO__STATIC;
int32_t BATTERYAMMO = BATTERYAMMO__STATIC;
int32_t DEVISTATORAMMO = DEVISTATORAMMO__STATIC;
int32_t DN64TILE43 = DN64TILE43__STATIC;
int32_t RPGAMMO = RPGAMMO__STATIC;
int32_t GROWAMMO = GROWAMMO__STATIC;
int32_t CRYSTALAMMO = CRYSTALAMMO__STATIC;
int32_t HBOMBAMMO = HBOMBAMMO__STATIC;
int32_t AMMOLOTS = AMMOLOTS__STATIC;
int32_t SHOTGUNAMMO = SHOTGUNAMMO__STATIC;
int32_t DN64TILE50 = DN64TILE50__STATIC;
int32_t COLA = COLA__STATIC;
int32_t SIXPAK = SIXPAK__STATIC;
int32_t FIRSTAID = FIRSTAID__STATIC;
int32_t SHIELD = SHIELD__STATIC;
int32_t STEROIDS = STEROIDS__STATIC;
int32_t AIRTANK = AIRTANK__STATIC;
int32_t JETPACK = JETPACK__STATIC;
int32_t HEATSENSOR = HEATSENSOR__STATIC;
int32_t ACCESSCARD = ACCESSCARD__STATIC;
int32_t BOOTS = BOOTS__STATIC;
int32_t DN64TILE65 = DN64TILE65__STATIC;
int32_t DN64TILE66 = DN64TILE66__STATIC;
int32_t MIRRORBROKE = MIRRORBROKE__STATIC;
int32_t CLOUDYOCEAN = CLOUDYOCEAN__STATIC;
int32_t CLOUDYSKIES = CLOUDYSKIES__STATIC;
int32_t MOONSKY1 = MOONSKY1__STATIC;
int32_t MOONSKY2 = MOONSKY2__STATIC;
int32_t MOONSKY3 = MOONSKY3__STATIC;
int32_t MOONSKY4 = MOONSKY4__STATIC;
int32_t BIGORBIT1 = BIGORBIT1__STATIC;
int32_t BIGORBIT2 = BIGORBIT2__STATIC;
int32_t BIGORBIT3 = BIGORBIT3__STATIC;
int32_t BIGORBIT4 = BIGORBIT4__STATIC;
int32_t BIGORBIT5 = BIGORBIT5__STATIC;
int32_t LA = LA__STATIC;
int32_t REDSKY1 = REDSKY1__STATIC;
int32_t REDSKY2 = REDSKY2__STATIC;
int32_t ATOMICHEALTH = ATOMICHEALTH__STATIC;
int32_t TECHLIGHT2 = TECHLIGHT2__STATIC;
int32_t TECHLIGHTBUST2 = TECHLIGHTBUST2__STATIC;
int32_t TECHLIGHT4 = TECHLIGHT4__STATIC;
int32_t TECHLIGHTBUST4 = TECHLIGHTBUST4__STATIC;
int32_t WALLLIGHT4 = WALLLIGHT4__STATIC;
int32_t WALLLIGHTBUST4 = WALLLIGHTBUST4__STATIC;
int32_t ACCESSSWITCH = ACCESSSWITCH__STATIC;
int32_t SLOTDOOR = SLOTDOOR__STATIC;
int32_t LIGHTSWITCH = LIGHTSWITCH__STATIC;
int32_t SPACEDOORSWITCH = SPACEDOORSWITCH__STATIC;
int32_t SPACELIGHTSWITCH = SPACELIGHTSWITCH__STATIC;
int32_t FRANKENSTINESWITCH = FRANKENSTINESWITCH__STATIC;
int32_t NUKEBUTTON = NUKEBUTTON__STATIC;
int32_t MULTISWITCH = MULTISWITCH__STATIC;
int32_t DOORTILE5 = DOORTILE5__STATIC;
int32_t DOORTILE6 = DOORTILE6__STATIC;
int32_t DOORTILE1 = DOORTILE1__STATIC;
int32_t DOORTILE2 = DOORTILE2__STATIC;
int32_t DOORTILE3 = DOORTILE3__STATIC;
int32_t DOORTILE4 = DOORTILE4__STATIC;
int32_t DOORTILE7 = DOORTILE7__STATIC;
int32_t DOORTILE8 = DOORTILE8__STATIC;
int32_t DOORTILE9 = DOORTILE9__STATIC;
int32_t DOORTILE10 = DOORTILE10__STATIC;
int32_t DOORSHOCK = DOORSHOCK__STATIC;
int32_t DIPSWITCH = DIPSWITCH__STATIC;
int32_t DIPSWITCH2 = DIPSWITCH2__STATIC;
int32_t TECHSWITCH = TECHSWITCH__STATIC;
int32_t DIPSWITCH3 = DIPSWITCH3__STATIC;
int32_t ACCESSSWITCH2 = ACCESSSWITCH2__STATIC;
int32_t DN64TILE172 = DN64TILE172__STATIC;
int32_t DN64TILE174 = DN64TILE174__STATIC;
int32_t DN64TILE176 = DN64TILE176__STATIC;
int32_t DN64TILE178 = DN64TILE178__STATIC;
int32_t REFLECTWATERTILE = REFLECTWATERTILE__STATIC;
int32_t FLOORSLIME = FLOORSLIME__STATIC;
int32_t BIGFORCE = BIGFORCE__STATIC;
int32_t EPISODE = EPISODE__STATIC;
int32_t MASKWALL9 = MASKWALL9__STATIC;
int32_t W_LIGHT = W_LIGHT__STATIC;
int32_t SCREENBREAK1 = SCREENBREAK1__STATIC;
int32_t SCREENBREAK2 = SCREENBREAK2__STATIC;
int32_t SCREENBREAK3 = SCREENBREAK3__STATIC;
int32_t SCREENBREAK4 = SCREENBREAK4__STATIC;
int32_t SCREENBREAK5 = SCREENBREAK5__STATIC;
int32_t SCREENBREAK6 = SCREENBREAK6__STATIC;
int32_t SCREENBREAK7 = SCREENBREAK7__STATIC;
int32_t SCREENBREAK8 = SCREENBREAK8__STATIC;
int32_t SCREENBREAK9 = SCREENBREAK9__STATIC;
int32_t SCREENBREAK10 = SCREENBREAK10__STATIC;
int32_t SCREENBREAK11 = SCREENBREAK11__STATIC;
int32_t SCREENBREAK12 = SCREENBREAK12__STATIC;
int32_t SCREENBREAK13 = SCREENBREAK13__STATIC;
int32_t MASKWALL1 = MASKWALL1__STATIC;
int32_t W_TECHWALL1 = W_TECHWALL1__STATIC;
int32_t W_TECHWALL2 = W_TECHWALL2__STATIC;
int32_t W_TECHWALL15 = W_TECHWALL15__STATIC;
int32_t W_TECHWALL3 = W_TECHWALL3__STATIC;
int32_t W_TECHWALL4 = W_TECHWALL4__STATIC;
int32_t W_TECHWALL10 = W_TECHWALL10__STATIC;
int32_t W_TECHWALL16 = W_TECHWALL16__STATIC;
int32_t WATERTILE2 = WATERTILE2__STATIC;
int32_t BPANNEL1 = BPANNEL1__STATIC;
int32_t PANNEL1 = PANNEL1__STATIC;
int32_t PANNEL2 = PANNEL2__STATIC;
int32_t WATERTILE = WATERTILE__STATIC;
int32_t STATIC = STATIC__STATIC;
int32_t W_SCREENBREAK = W_SCREENBREAK__STATIC;
int32_t W_HITTECHWALL3 = W_HITTECHWALL3__STATIC;
int32_t W_HITTECHWALL4 = W_HITTECHWALL4__STATIC;
int32_t W_HITTECHWALL2 = W_HITTECHWALL2__STATIC;
int32_t W_HITTECHWALL1 = W_HITTECHWALL1__STATIC;
int32_t MASKWALL10 = MASKWALL10__STATIC;
int32_t MASKWALL11 = MASKWALL11__STATIC;
int32_t DOORTILE22 = DOORTILE22__STATIC;
int32_t FANSPRITE = FANSPRITE__STATIC;
int32_t FANSPRITEBROKE = FANSPRITEBROKE__STATIC;
int32_t FANSHADOW = FANSHADOW__STATIC;
int32_t FANSHADOWBROKE = FANSHADOWBROKE__STATIC;
int32_t DOORTILE18 = DOORTILE18__STATIC;
int32_t DOORTILE19 = DOORTILE19__STATIC;
int32_t DOORTILE20 = DOORTILE20__STATIC;
int32_t SATELLITE = SATELLITE__STATIC;
int32_t VIEWSCREEN2 = VIEWSCREEN2__STATIC;
int32_t VIEWSCREENBROKE = VIEWSCREENBROKE__STATIC;
int32_t VIEWSCREEN = VIEWSCREEN__STATIC;
int32_t GLASS = GLASS__STATIC;
int32_t GLASS2 = GLASS2__STATIC;
int32_t STAINGLASS1 = STAINGLASS1__STATIC;
int32_t MASKWALL5 = MASKWALL5__STATIC;
int32_t SATELITE = SATELITE__STATIC;
int32_t FUELPOD = FUELPOD__STATIC;
int32_t SLIMEPIPE = SLIMEPIPE__STATIC;
int32_t CRACK1 = CRACK1__STATIC;
int32_t CRACK2 = CRACK2__STATIC;
int32_t CRACK3 = CRACK3__STATIC;
int32_t CRACK4 = CRACK4__STATIC;
int32_t FOOTPRINTS = FOOTPRINTS__STATIC;
int32_t DOMELITE = DOMELITE__STATIC;
int32_t CAMERAPOLE = CAMERAPOLE__STATIC;
int32_t CHAIR1 = CHAIR1__STATIC;
int32_t CHAIR2 = CHAIR2__STATIC;
int32_t BROKENCHAIR = BROKENCHAIR__STATIC;
int32_t MIRROR = MIRROR__STATIC;
int32_t WATERFOUNTAIN = WATERFOUNTAIN__STATIC;
int32_t WATERFOUNTAINBROKE = WATERFOUNTAINBROKE__STATIC;
int32_t FEMMAG1 = FEMMAG1__STATIC;
int32_t TOILET = TOILET__STATIC;
int32_t STALL = STALL__STATIC;
int32_t STALLBROKE = STALLBROKE__STATIC;
int32_t FEMMAG2 = FEMMAG2__STATIC;
int32_t REACTOR2 = REACTOR2__STATIC;
int32_t REACTOR2BURNT = REACTOR2BURNT__STATIC;
int32_t REACTOR2SPARK = REACTOR2SPARK__STATIC;
int32_t GRATE1 = GRATE1__STATIC;
int32_t BGRATE1 = BGRATE1__STATIC;
int32_t SOLARPANNEL = SOLARPANNEL__STATIC;
int32_t NAKED1 = NAKED1__STATIC;
int32_t ANTENNA = ANTENNA__STATIC;
int32_t MASKWALL12 = MASKWALL12__STATIC;
int32_t TOILETBROKE = TOILETBROKE__STATIC;
int32_t PIPE2 = PIPE2__STATIC;
int32_t PIPE1B = PIPE1B__STATIC;
int32_t PIPE3 = PIPE3__STATIC;
int32_t PIPE1 = PIPE1__STATIC;
int32_t CAMERA1 = CAMERA1__STATIC;
int32_t BRICK = BRICK__STATIC;
int32_t SPLINTERWOOD = SPLINTERWOOD__STATIC;
int32_t PIPE2B = PIPE2B__STATIC;
int32_t BOLT1 = BOLT1__STATIC;
int32_t W_NUMBERS = W_NUMBERS__STATIC;
int32_t WATERDRIP = WATERDRIP__STATIC;
int32_t WATERBUBBLE = WATERBUBBLE__STATIC;
int32_t WATERBUBBLEMAKER = WATERBUBBLEMAKER__STATIC;
int32_t W_FORCEFIELD = W_FORCEFIELD__STATIC;
int32_t VACUUM = VACUUM__STATIC;
int32_t FOOTPRINTS2 = FOOTPRINTS2__STATIC;
int32_t FOOTPRINTS3 = FOOTPRINTS3__STATIC;
int32_t FOOTPRINTS4 = FOOTPRINTS4__STATIC;
int32_t EGG = EGG__STATIC;
int32_t SCALE = SCALE__STATIC;
int32_t CHAIR3 = CHAIR3__STATIC;
int32_t CAMERALIGHT = CAMERALIGHT__STATIC;
int32_t MOVIECAMERA = MOVIECAMERA__STATIC;
int32_t IVUNIT = IVUNIT__STATIC;
int32_t POT1 = POT1__STATIC;
int32_t POT2 = POT2__STATIC;
int32_t POT3 = POT3__STATIC;
int32_t PIPE3B = PIPE3B__STATIC;
int32_t WALLLIGHT3 = WALLLIGHT3__STATIC;
int32_t WALLLIGHTBUST3 = WALLLIGHTBUST3__STATIC;
int32_t WALLLIGHT1 = WALLLIGHT1__STATIC;
int32_t WALLLIGHTBUST1 = WALLLIGHTBUST1__STATIC;
int32_t WALLLIGHT2 = WALLLIGHT2__STATIC;
int32_t WALLLIGHTBUST2 = WALLLIGHTBUST2__STATIC;
int32_t LIGHTSWITCH2 = LIGHTSWITCH2__STATIC;
int32_t WAITTOBESEATED = WAITTOBESEATED__STATIC;
int32_t DOORTILE14 = DOORTILE14__STATIC;
int32_t STATUE = STATUE__STATIC;
int32_t MIKE = MIKE__STATIC;
int32_t VASE = VASE__STATIC;
int32_t SUSHIPLATE1 = SUSHIPLATE1__STATIC;
int32_t SUSHIPLATE2 = SUSHIPLATE2__STATIC;
int32_t SUSHIPLATE3 = SUSHIPLATE3__STATIC;
int32_t SUSHIPLATE4 = SUSHIPLATE4__STATIC;
int32_t DOORTILE16 = DOORTILE16__STATIC;
int32_t SUSHIPLATE5 = SUSHIPLATE5__STATIC;
int32_t OJ = OJ__STATIC;
int32_t MASKWALL13 = MASKWALL13__STATIC;
int32_t HURTRAIL = HURTRAIL__STATIC;
int32_t POWERSWITCH1 = POWERSWITCH1__STATIC;
int32_t LOCKSWITCH1 = LOCKSWITCH1__STATIC;
int32_t POWERSWITCH2 = POWERSWITCH2__STATIC;
int32_t ATM = ATM__STATIC;
int32_t STATUEFLASH = STATUEFLASH__STATIC;
int32_t ATMBROKE = ATMBROKE__STATIC;
int32_t BIGHOLE2 = BIGHOLE2__STATIC;
int32_t STRIPEBALL = STRIPEBALL__STATIC;
int32_t QUEBALL = QUEBALL__STATIC;
int32_t POCKET = POCKET__STATIC;
int32_t WOODENHORSE = WOODENHORSE__STATIC;
int32_t TREE1 = TREE1__STATIC;
int32_t TREE2 = TREE2__STATIC;
int32_t CACTUS = CACTUS__STATIC;
int32_t MASKWALL2 = MASKWALL2__STATIC;
int32_t MASKWALL3 = MASKWALL3__STATIC;
int32_t MASKWALL4 = MASKWALL4__STATIC;
int32_t FIREEXT = FIREEXT__STATIC;
int32_t TOILETWATER = TOILETWATER__STATIC;
int32_t NEON1 = NEON1__STATIC;
int32_t NEON2 = NEON2__STATIC;
int32_t CACTUSBROKE = CACTUSBROKE__STATIC;
int32_t BOUNCEMINE = BOUNCEMINE__STATIC;
int32_t BROKEFIREHYDRENT = BROKEFIREHYDRENT__STATIC;
int32_t BOX = BOX__STATIC;
int32_t BULLETHOLE = BULLETHOLE__STATIC;
int32_t BOTTLE1 = BOTTLE1__STATIC;
int32_t BOTTLE2 = BOTTLE2__STATIC;
int32_t BOTTLE3 = BOTTLE3__STATIC;
int32_t BOTTLE4 = BOTTLE4__STATIC;
int32_t FEMPIC5 = FEMPIC5__STATIC;
int32_t FEMPIC6 = FEMPIC6__STATIC;
int32_t FEMPIC7 = FEMPIC7__STATIC;
int32_t HYDROPLANT = HYDROPLANT__STATIC;
int32_t OCEANSPRITE1 = OCEANSPRITE1__STATIC;
int32_t OCEANSPRITE2 = OCEANSPRITE2__STATIC;
int32_t OCEANSPRITE3 = OCEANSPRITE3__STATIC;
int32_t OCEANSPRITE4 = OCEANSPRITE4__STATIC;
int32_t OCEANSPRITE5 = OCEANSPRITE5__STATIC;
int32_t GENERICPOLE = GENERICPOLE__STATIC;
int32_t CONE = CONE__STATIC;
int32_t HANGLIGHT = HANGLIGHT__STATIC;
int32_t HYDRENT = HYDRENT__STATIC;
int32_t MASKWALL14 = MASKWALL14__STATIC;
int32_t TIRE = TIRE__STATIC;
int32_t PIPE5 = PIPE5__STATIC;
int32_t PIPE6 = PIPE6__STATIC;
int32_t PIPE4 = PIPE4__STATIC;
int32_t PIPE4B = PIPE4B__STATIC;
int32_t BROKEHYDROPLANT = BROKEHYDROPLANT__STATIC;
int32_t PIPE5B = PIPE5B__STATIC;
int32_t NEON3 = NEON3__STATIC;
int32_t NEON4 = NEON4__STATIC;
int32_t NEON5 = NEON5__STATIC;
int32_t BOTTLE5 = BOTTLE5__STATIC;
int32_t BOTTLE6 = BOTTLE6__STATIC;
int32_t BOTTLE8 = BOTTLE8__STATIC;
int32_t SPOTLITE = SPOTLITE__STATIC;
int32_t HANGOOZ = HANGOOZ__STATIC;
int32_t MASKWALL15 = MASKWALL15__STATIC;
int32_t BOTTLE7 = BOTTLE7__STATIC;
int32_t HORSEONSIDE = HORSEONSIDE__STATIC;
int32_t GLASSPIECES = GLASSPIECES__STATIC;
int32_t HORSELITE = HORSELITE__STATIC;
int32_t DONUTS = DONUTS__STATIC;
int32_t NEON6 = NEON6__STATIC;
int32_t MASKWALL6 = MASKWALL6__STATIC;
int32_t CLOCK = CLOCK__STATIC;
int32_t RUBBERCAN = RUBBERCAN__STATIC;
int32_t BROKENCLOCK = BROKENCLOCK__STATIC;
int32_t PLUG = PLUG__STATIC;
int32_t OOZFILTER = OOZFILTER__STATIC;
int32_t FLOORPLASMA = FLOORPLASMA__STATIC;
int32_t REACTOR = REACTOR__STATIC;
int32_t REACTORSPARK = REACTORSPARK__STATIC;
int32_t REACTORBURNT = REACTORBURNT__STATIC;
int32_t DOORTILE15 = DOORTILE15__STATIC;
int32_t HANDSWITCH = HANDSWITCH__STATIC;
int32_t CIRCLEPANNEL = CIRCLEPANNEL__STATIC;
int32_t CIRCLEPANNELBROKE = CIRCLEPANNELBROKE__STATIC;
int32_t PULLSWITCH = PULLSWITCH__STATIC;
int32_t MASKWALL8 = MASKWALL8__STATIC;
int32_t BIGHOLE = BIGHOLE__STATIC;
int32_t ALIENSWITCH = ALIENSWITCH__STATIC;
int32_t DOORTILE21 = DOORTILE21__STATIC;
int32_t HANDPRINTSWITCH = HANDPRINTSWITCH__STATIC;
int32_t BOTTLE10 = BOTTLE10__STATIC;
int32_t BOTTLE11 = BOTTLE11__STATIC;
int32_t BOTTLE12 = BOTTLE12__STATIC;
int32_t BOTTLE13 = BOTTLE13__STATIC;
int32_t BOTTLE14 = BOTTLE14__STATIC;
int32_t BOTTLE15 = BOTTLE15__STATIC;
int32_t BOTTLE16 = BOTTLE16__STATIC;
int32_t BOTTLE17 = BOTTLE17__STATIC;
int32_t BOTTLE18 = BOTTLE18__STATIC;
int32_t BOTTLE19 = BOTTLE19__STATIC;
int32_t DOORTILE17 = DOORTILE17__STATIC;
int32_t MASKWALL7 = MASKWALL7__STATIC;
int32_t JAILBARBREAK = JAILBARBREAK__STATIC;
int32_t DOORTILE11 = DOORTILE11__STATIC;
int32_t DOORTILE12 = DOORTILE12__STATIC;
int32_t VENDMACHINE = VENDMACHINE__STATIC;
int32_t VENDMACHINEBROKE = VENDMACHINEBROKE__STATIC;
int32_t COLAMACHINE = COLAMACHINE__STATIC;
int32_t COLAMACHINEBROKE = COLAMACHINEBROKE__STATIC;
int32_t CRANEPOLE = CRANEPOLE__STATIC;
int32_t CRANE = CRANE__STATIC;
int32_t BARBROKE = BARBROKE__STATIC;
int32_t BLOODPOOL = BLOODPOOL__STATIC;
int32_t NUKEBARREL = NUKEBARREL__STATIC;
int32_t NUKEBARRELDENTED = NUKEBARRELDENTED__STATIC;
int32_t NUKEBARRELLEAKED = NUKEBARRELLEAKED__STATIC;
int32_t CANWITHSOMETHING = CANWITHSOMETHING__STATIC;
int32_t MONEY = MONEY__STATIC;
int32_t BANNER = BANNER__STATIC;
int32_t EXPLODINGBARREL = EXPLODINGBARREL__STATIC;
int32_t EXPLODINGBARREL2 = EXPLODINGBARREL2__STATIC;
int32_t FIREBARREL = FIREBARREL__STATIC;
int32_t SEENINE = SEENINE__STATIC;
int32_t SEENINEDEAD = SEENINEDEAD__STATIC;
int32_t STEAM = STEAM__STATIC;
int32_t CEILINGSTEAM = CEILINGSTEAM__STATIC;
int32_t PIPE6B = PIPE6B__STATIC;
int32_t TRANSPORTERBEAM = TRANSPORTERBEAM__STATIC;
int32_t RAT = RAT__STATIC;
int32_t TRASH = TRASH__STATIC;
int32_t FEMPIC1 = FEMPIC1__STATIC;
int32_t FEMPIC2 = FEMPIC2__STATIC;
int32_t BLANKSCREEN = BLANKSCREEN__STATIC;
int32_t PODFEM1 = PODFEM1__STATIC;
int32_t FEMPIC3 = FEMPIC3__STATIC;
int32_t FEMPIC4 = FEMPIC4__STATIC;
int32_t FEM1 = FEM1__STATIC;
int32_t FEM2 = FEM2__STATIC;
int32_t FEM3 = FEM3__STATIC;
int32_t FEM5 = FEM5__STATIC;
int32_t BLOODYPOLE = BLOODYPOLE__STATIC;
int32_t FEM4 = FEM4__STATIC;
int32_t FEM6 = FEM6__STATIC;
int32_t FEM6PAD = FEM6PAD__STATIC;
int32_t FEM8 = FEM8__STATIC;
int32_t HELECOPT = HELECOPT__STATIC;
int32_t FETUSJIB = FETUSJIB__STATIC;
int32_t HOLODUKE = HOLODUKE__STATIC;
int32_t SPACEMARINE = SPACEMARINE__STATIC;
int32_t INDY = INDY__STATIC;
int32_t FETUS = FETUS__STATIC;
int32_t FETUSBROKE = FETUSBROKE__STATIC;
int32_t MONK = MONK__STATIC;
int32_t LUKE = LUKE__STATIC;
int32_t COOLEXPLOSION1 = COOLEXPLOSION1__STATIC;
int32_t WATERSPLASH2 = WATERSPLASH2__STATIC;
int32_t FIREVASE = FIREVASE__STATIC;
int32_t SCRATCH = SCRATCH__STATIC;
int32_t FEM7 = FEM7__STATIC;
int32_t APLAYERTOP = APLAYERTOP__STATIC;
int32_t APLAYER = APLAYER__STATIC;
int32_t PLAYERONWATER = PLAYERONWATER__STATIC;
int32_t DUKELYINGDEAD = DUKELYINGDEAD__STATIC;
int32_t DUKETORSO = DUKETORSO__STATIC;
int32_t DUKEGUN = DUKEGUN__STATIC;
int32_t DUKELEG = DUKELEG__STATIC;
int32_t SHARK = SHARK__STATIC;
int32_t BLOOD = BLOOD__STATIC;
int32_t FIRELASER = FIRELASER__STATIC;
int32_t TRANSPORTERSTAR = TRANSPORTERSTAR__STATIC;
int32_t SPIT = SPIT__STATIC;
int32_t LOOGIE = LOOGIE__STATIC;
int32_t FIST = FIST__STATIC;
int32_t FREEZEBLAST = FREEZEBLAST__STATIC;
int32_t DEVISTATORBLAST = DEVISTATORBLAST__STATIC;
int32_t SHRINKSPARK = SHRINKSPARK__STATIC;
int32_t TONGUE = TONGUE__STATIC;
int32_t MORTER = MORTER__STATIC;
int32_t SHRINKEREXPLOSION = SHRINKEREXPLOSION__STATIC;
int32_t RADIUSEXPLOSION = RADIUSEXPLOSION__STATIC;
int32_t FORCERIPPLE = FORCERIPPLE__STATIC;
int32_t LIZTROOP = LIZTROOP__STATIC;
int32_t LIZTROOPRUNNING = LIZTROOPRUNNING__STATIC;
int32_t LIZTROOPSTAYPUT = LIZTROOPSTAYPUT__STATIC;
int32_t LIZTOP = LIZTOP__STATIC;
int32_t LIZTROOPSHOOT = LIZTROOPSHOOT__STATIC;
int32_t LIZTROOPJETPACK = LIZTROOPJETPACK__STATIC;
int32_t LIZTROOPDSPRITE = LIZTROOPDSPRITE__STATIC;
int32_t LIZTROOPONTOILET = LIZTROOPONTOILET__STATIC;
int32_t LIZTROOPJUSTSIT = LIZTROOPJUSTSIT__STATIC;
int32_t LIZTROOPDUCKING = LIZTROOPDUCKING__STATIC;
int32_t HEADJIB1 = HEADJIB1__STATIC;
int32_t ARMJIB1 = ARMJIB1__STATIC;
int32_t LEGJIB1 = LEGJIB1__STATIC;
int32_t CANNONBALL = CANNONBALL__STATIC;
int32_t OCTABRAIN = OCTABRAIN__STATIC;
int32_t OCTABRAINSTAYPUT = OCTABRAINSTAYPUT__STATIC;
int32_t OCTATOP = OCTATOP__STATIC;
int32_t OCTADEADSPRITE = OCTADEADSPRITE__STATIC;
int32_t INNERJAW = INNERJAW__STATIC;
int32_t DRONE = DRONE__STATIC;
int32_t EXPLOSION2 = EXPLOSION2__STATIC;
int32_t COMMANDER = COMMANDER__STATIC;
int32_t COMMANDERSTAYPUT = COMMANDERSTAYPUT__STATIC;
int32_t RECON = RECON__STATIC;
int32_t TANK = TANK__STATIC;
int32_t PIGCOP = PIGCOP__STATIC;
int32_t PIGCOPSTAYPUT = PIGCOPSTAYPUT__STATIC;
int32_t PIGCOPDIVE = PIGCOPDIVE__STATIC;
int32_t PIGCOPDEADSPRITE = PIGCOPDEADSPRITE__STATIC;
int32_t PIGTOP = PIGTOP__STATIC;
int32_t LIZMAN = LIZMAN__STATIC;
int32_t LIZMANSTAYPUT = LIZMANSTAYPUT__STATIC;
int32_t LIZMANSPITTING = LIZMANSPITTING__STATIC;
int32_t LIZMANFEEDING = LIZMANFEEDING__STATIC;
int32_t LIZMANJUMP = LIZMANJUMP__STATIC;
int32_t LIZMANDEADSPRITE = LIZMANDEADSPRITE__STATIC;
int32_t FECES = FECES__STATIC;
int32_t LIZMANHEAD1 = LIZMANHEAD1__STATIC;
int32_t LIZMANARM1 = LIZMANARM1__STATIC;
int32_t LIZMANLEG1 = LIZMANLEG1__STATIC;
int32_t EXPLOSION2BOT = EXPLOSION2BOT__STATIC;
int32_t USERWEAPON = USERWEAPON__STATIC;
int32_t HEADERBAR = HEADERBAR__STATIC;
int32_t JIBS1 = JIBS1__STATIC;
int32_t JIBS2 = JIBS2__STATIC;
int32_t JIBS3 = JIBS3__STATIC;
int32_t JIBS4 = JIBS4__STATIC;
int32_t JIBS5 = JIBS5__STATIC;
int32_t BURNING = BURNING__STATIC;
int32_t FIRE = FIRE__STATIC;
int32_t JIBS6 = JIBS6__STATIC;
int32_t BLOODSPLAT1 = BLOODSPLAT1__STATIC;
int32_t BLOODSPLAT3 = BLOODSPLAT3__STATIC;
int32_t BLOODSPLAT2 = BLOODSPLAT2__STATIC;
int32_t BLOODSPLAT4 = BLOODSPLAT4__STATIC;
int32_t OOZ = OOZ__STATIC;
int32_t OOZ2 = OOZ2__STATIC;
int32_t WALLBLOOD1 = WALLBLOOD1__STATIC;
int32_t WALLBLOOD2 = WALLBLOOD2__STATIC;
int32_t WALLBLOOD3 = WALLBLOOD3__STATIC;
int32_t WALLBLOOD4 = WALLBLOOD4__STATIC;
int32_t WALLBLOOD5 = WALLBLOOD5__STATIC;
int32_t WALLBLOOD6 = WALLBLOOD6__STATIC;
int32_t WALLBLOOD7 = WALLBLOOD7__STATIC;
int32_t WALLBLOOD8 = WALLBLOOD8__STATIC;
int32_t BURNING2 = BURNING2__STATIC;
int32_t FIRE2 = FIRE2__STATIC;
int32_t CRACKKNUCKLES = CRACKKNUCKLES__STATIC;
int32_t SMALLSMOKE = SMALLSMOKE__STATIC;
int32_t SMALLSMOKEMAKER = SMALLSMOKEMAKER__STATIC;
int32_t FLOORFLAME = FLOORFLAME__STATIC;
int32_t ROTATEGUN = ROTATEGUN__STATIC;
int32_t GREENSLIME = GREENSLIME__STATIC;
int32_t WATERDRIPSPLASH = WATERDRIPSPLASH__STATIC;
int32_t SCRAP6 = SCRAP6__STATIC;
int32_t SCRAP1 = SCRAP1__STATIC;
int32_t SCRAP2 = SCRAP2__STATIC;
int32_t SCRAP3 = SCRAP3__STATIC;
int32_t SCRAP4 = SCRAP4__STATIC;
int32_t SCRAP5 = SCRAP5__STATIC;
int32_t ORGANTIC = ORGANTIC__STATIC;
int32_t BETAVERSION = BETAVERSION__STATIC;
int32_t PLAYERISHERE = PLAYERISHERE__STATIC;
int32_t PLAYERWASHERE = PLAYERWASHERE__STATIC;
int32_t SELECTDIR = SELECTDIR__STATIC;
int32_t F1HELP = F1HELP__STATIC;
int32_t NOTCHON = NOTCHON__STATIC;
int32_t NOTCHOFF = NOTCHOFF__STATIC;
int32_t GROWSPARK = GROWSPARK__STATIC;
int32_t DUKEICON = DUKEICON__STATIC;
int32_t BADGUYICON = BADGUYICON__STATIC;
int32_t FOODICON = FOODICON__STATIC;
int32_t GETICON = GETICON__STATIC;
int32_t MENUSCREEN = MENUSCREEN__STATIC;
int32_t MENUBAR = MENUBAR__STATIC;
int32_t KILLSICON = KILLSICON__STATIC;
int32_t FIRSTAID_ICON = FIRSTAID_ICON__STATIC;
int32_t HEAT_ICON = HEAT_ICON__STATIC;
int32_t BOTTOMSTATUSBAR = BOTTOMSTATUSBAR__STATIC;
int32_t BOOT_ICON = BOOT_ICON__STATIC;
int32_t FRAGBAR = FRAGBAR__STATIC;
int32_t JETPACK_ICON = JETPACK_ICON__STATIC;
int32_t AIRTANK_ICON = AIRTANK_ICON__STATIC;
int32_t STEROIDS_ICON = STEROIDS_ICON__STATIC;
int32_t HOLODUKE_ICON = HOLODUKE_ICON__STATIC;
int32_t ACCESS_ICON = ACCESS_ICON__STATIC;
int32_t DIGITALNUM = DIGITALNUM__STATIC;
int32_t DUKECAR = DUKECAR__STATIC;
int32_t CAMCORNER = CAMCORNER__STATIC;
int32_t CAMLIGHT = CAMLIGHT__STATIC;
int32_t LOGO = LOGO__STATIC;
int32_t TITLE = TITLE__STATIC;
int32_t NUKEWARNINGICON = NUKEWARNINGICON__STATIC;
int32_t MOUSECURSOR = MOUSECURSOR__STATIC;
int32_t SLIDEBAR = SLIDEBAR__STATIC;
int32_t DREALMS = DREALMS__STATIC;
int32_t BETASCREEN = BETASCREEN__STATIC;
int32_t WINDOWBORDER1 = WINDOWBORDER1__STATIC;
int32_t TEXTBOX = TEXTBOX__STATIC;
int32_t WINDOWBORDER2 = WINDOWBORDER2__STATIC;
int32_t DUKENUKEM = DUKENUKEM__STATIC;
int32_t THREEDEE = THREEDEE__STATIC;
int32_t INGAMEDUKETHREEDEE = INGAMEDUKETHREEDEE__STATIC;
int32_t TENSCREEN = TENSCREEN__STATIC;
int32_t PLUTOPAKSPRITE = PLUTOPAKSPRITE__STATIC;
int32_t DEVISTATOR = DEVISTATOR__STATIC;
int32_t KNEE = KNEE__STATIC;
int32_t CROSSHAIR = CROSSHAIR__STATIC;
int32_t FIRSTGUN = FIRSTGUN__STATIC;
int32_t FIRSTGUNRELOAD = FIRSTGUNRELOAD__STATIC;
int32_t FALLINGCLIP = FALLINGCLIP__STATIC;
int32_t CLIPINHAND = CLIPINHAND__STATIC;
int32_t HAND = HAND__STATIC;
int32_t SHELL = SHELL__STATIC;
int32_t SHOTGUNSHELL = SHOTGUNSHELL__STATIC;
int32_t CHAINGUN = CHAINGUN__STATIC;
int32_t RPGGUN = RPGGUN__STATIC;
int32_t RPGMUZZLEFLASH = RPGMUZZLEFLASH__STATIC;
int32_t FREEZE = FREEZE__STATIC;
int32_t CATLITE = CATLITE__STATIC;
int32_t SHRINKER = SHRINKER__STATIC;
int32_t HANDHOLDINGLASER = HANDHOLDINGLASER__STATIC;
int32_t TRIPBOMB = TRIPBOMB__STATIC;
int32_t LASERLINE = LASERLINE__STATIC;
int32_t HANDHOLDINGACCESS = HANDHOLDINGACCESS__STATIC;
int32_t HANDREMOTE = HANDREMOTE__STATIC;
int32_t HANDTHROW = HANDTHROW__STATIC;
int32_t TIP = TIP__STATIC;
int32_t GLAIR = GLAIR__STATIC;
int32_t SCUBAMASK = SCUBAMASK__STATIC;
int32_t SPACEMASK = SPACEMASK__STATIC;
int32_t FORCESPHERE = FORCESPHERE__STATIC;
int32_t SHOTSPARK1 = SHOTSPARK1__STATIC;
int32_t DN64TILE2596 = DN64TILE2596__STATIC;
int32_t DN64TILE2597 = DN64TILE2597__STATIC;
int32_t DN64TILE2598 = DN64TILE2598__STATIC;
int32_t DN64TILE2599 = DN64TILE2599__STATIC;
int32_t RPG = RPG__STATIC;
int32_t DN64TILE2606 = DN64TILE2606__STATIC;
int32_t LASERSITE = LASERSITE__STATIC;
int32_t SHOTGUN = SHOTGUN__STATIC;
int32_t BOSS1 = BOSS1__STATIC;
int32_t BOSS1STAYPUT = BOSS1STAYPUT__STATIC;
int32_t BOSS1SHOOT = BOSS1SHOOT__STATIC;
int32_t BOSS1LOB = BOSS1LOB__STATIC;
int32_t BOSSTOP = BOSSTOP__STATIC;
int32_t BOSS2 = BOSS2__STATIC;
int32_t BOSS3 = BOSS3__STATIC;
int32_t SPINNINGNUKEICON = SPINNINGNUKEICON__STATIC;
int32_t BIGFNTCURSOR = BIGFNTCURSOR__STATIC;
int32_t SMALLFNTCURSOR = SMALLFNTCURSOR__STATIC;
int32_t STARTALPHANUM = STARTALPHANUM__STATIC;
int32_t ENDALPHANUM = ENDALPHANUM__STATIC;
int32_t BIGALPHANUM = BIGALPHANUM__STATIC;
int32_t BIGPERIOD = BIGPERIOD__STATIC;
int32_t BIGCOMMA = BIGCOMMA__STATIC;
// "BIGX" clashes on the Wii?
int32_t BIGX_ = BIGX__STATIC;
int32_t BIGQ = BIGQ__STATIC;
int32_t BIGSEMI = BIGSEMI__STATIC;
int32_t BIGCOLIN = BIGCOLIN__STATIC;
int32_t THREEBYFIVE = THREEBYFIVE__STATIC;
int32_t BIGAPPOS = BIGAPPOS__STATIC;
int32_t BLANK = BLANK__STATIC;
int32_t MINIFONT = MINIFONT__STATIC;
int32_t BUTTON1 = BUTTON1__STATIC;
int32_t GLASS3 = GLASS3__STATIC;
int32_t RESPAWNMARKERRED = RESPAWNMARKERRED__STATIC;
int32_t RESPAWNMARKERYELLOW = RESPAWNMARKERYELLOW__STATIC;
int32_t RESPAWNMARKERGREEN = RESPAWNMARKERGREEN__STATIC;
int32_t BONUSSCREEN = BONUSSCREEN__STATIC;
int32_t VIEWBORDER = VIEWBORDER__STATIC;
int32_t VICTORY1 = VICTORY1__STATIC;
int32_t ORDERING = ORDERING__STATIC;
int32_t TEXTSTORY = TEXTSTORY__STATIC;
int32_t LOADSCREEN = LOADSCREEN__STATIC;
int32_t BORNTOBEWILDSCREEN = BORNTOBEWILDSCREEN__STATIC;
int32_t BLIMP = BLIMP__STATIC;
int32_t FEM9 = FEM9__STATIC;
int32_t DN64TILE3627 = DN64TILE3627__STATIC;
int32_t DN64TILE3634 = DN64TILE3634__STATIC;
int32_t FOOTPRINT = FOOTPRINT__STATIC;
int32_t DN64TILE3713 = DN64TILE3713__STATIC;
int32_t DN64TILE3714 = DN64TILE3714__STATIC;
int32_t DN64TILE3715 = DN64TILE3715__STATIC;
int32_t DN64TILE3716 = DN64TILE3716__STATIC;
int32_t DN64TILE3727 = DN64TILE3727__STATIC;
int32_t DN64TILE3797 = DN64TILE3797__STATIC;
int32_t DN64TILE3804 = DN64TILE3804__STATIC;
int32_t DN64TILE3805 = DN64TILE3805__STATIC;
int32_t DN64TILE3809 = DN64TILE3809__STATIC;
int32_t DN64TILE3821 = DN64TILE3821__STATIC;
int32_t DN64TILE3831 = DN64TILE3831__STATIC;
int32_t DN64TILE3841 = DN64TILE3841__STATIC;
int32_t DN64TILE3845 = DN64TILE3845__STATIC;
int32_t DN64TILE3922 = DN64TILE3922__STATIC;
int32_t DN64TILE3953 = DN64TILE3953__STATIC;
int32_t POOP = POOP__STATIC;
int32_t FRAMEEFFECT1 = FRAMEEFFECT1__STATIC;
int32_t PANNEL3 = PANNEL3__STATIC;
int32_t SCREENBREAK14 = SCREENBREAK14__STATIC;
int32_t SCREENBREAK15 = SCREENBREAK15__STATIC;
int32_t SCREENBREAK19 = SCREENBREAK19__STATIC;
int32_t SCREENBREAK16 = SCREENBREAK16__STATIC;
int32_t SCREENBREAK17 = SCREENBREAK17__STATIC;
int32_t SCREENBREAK18 = SCREENBREAK18__STATIC;
int32_t W_TECHWALL11 = W_TECHWALL11__STATIC;
int32_t W_TECHWALL12 = W_TECHWALL12__STATIC;
int32_t W_TECHWALL13 = W_TECHWALL13__STATIC;
int32_t W_TECHWALL14 = W_TECHWALL14__STATIC;
int32_t W_TECHWALL5 = W_TECHWALL5__STATIC;
int32_t W_TECHWALL6 = W_TECHWALL6__STATIC;
int32_t W_TECHWALL7 = W_TECHWALL7__STATIC;
int32_t W_TECHWALL8 = W_TECHWALL8__STATIC;
int32_t W_TECHWALL9 = W_TECHWALL9__STATIC;
int32_t BPANNEL3 = BPANNEL3__STATIC;
int32_t W_HITTECHWALL16 = W_HITTECHWALL16__STATIC;
int32_t W_HITTECHWALL10 = W_HITTECHWALL10__STATIC;
int32_t W_HITTECHWALL15 = W_HITTECHWALL15__STATIC;
int32_t W_MILKSHELF = W_MILKSHELF__STATIC;
int32_t W_MILKSHELFBROKE = W_MILKSHELFBROKE__STATIC;
int32_t PURPLELAVA = PURPLELAVA__STATIC;
int32_t DN64TILE4250 = DN64TILE4250__STATIC;
int32_t LAVABUBBLE = LAVABUBBLE__STATIC;
int32_t DUKECUTOUT = DUKECUTOUT__STATIC;
int32_t TARGET = TARGET__STATIC;
int32_t GUNPOWDERBARREL = GUNPOWDERBARREL__STATIC;
int32_t DUCK = DUCK__STATIC;
int32_t HATRACK = HATRACK__STATIC;
int32_t DESKLAMP = DESKLAMP__STATIC;
int32_t COFFEEMACHINE = COFFEEMACHINE__STATIC;
int32_t CUPS = CUPS__STATIC;
int32_t GAVALS = GAVALS__STATIC;
int32_t GAVALS2 = GAVALS2__STATIC;
int32_t POLICELIGHTPOLE = POLICELIGHTPOLE__STATIC;
int32_t FLOORBASKET = FLOORBASKET__STATIC;
int32_t PUKE = PUKE__STATIC;
int32_t DOORTILE23 = DOORTILE23__STATIC;
int32_t TOPSECRET = TOPSECRET__STATIC;
int32_t SPEAKER = SPEAKER__STATIC;
int32_t TEDDYBEAR = TEDDYBEAR__STATIC;
int32_t ROBOTDOG = ROBOTDOG__STATIC;
int32_t ROBOTPIRATE = ROBOTPIRATE__STATIC;
int32_t ROBOTMOUSE = ROBOTMOUSE__STATIC;
int32_t MAIL = MAIL__STATIC;
int32_t MAILBAG = MAILBAG__STATIC;
int32_t HOTMEAT = HOTMEAT__STATIC;
int32_t COFFEEMUG = COFFEEMUG__STATIC;
int32_t DONUTS2 = DONUTS2__STATIC;
int32_t TRIPODCAMERA = TRIPODCAMERA__STATIC;
int32_t METER = METER__STATIC;
int32_t DESKPHONE = DESKPHONE__STATIC;
int32_t GUMBALLMACHINE = GUMBALLMACHINE__STATIC;
int32_t GUMBALLMACHINEBROKE = GUMBALLMACHINEBROKE__STATIC;
int32_t PAPER = PAPER__STATIC;
int32_t MACE = MACE__STATIC;
int32_t GENERICPOLE2 = GENERICPOLE2__STATIC;
int32_t XXXSTACY = XXXSTACY__STATIC;
int32_t WETFLOOR = WETFLOOR__STATIC;
int32_t BROOM = BROOM__STATIC;
int32_t MOP = MOP__STATIC;
int32_t LETTER = LETTER__STATIC;
int32_t PIRATE1A = PIRATE1A__STATIC;
int32_t PIRATE4A = PIRATE4A__STATIC;
int32_t PIRATE2A = PIRATE2A__STATIC;
int32_t PIRATE5A = PIRATE5A__STATIC;
int32_t PIRATE3A = PIRATE3A__STATIC;
int32_t PIRATE6A = PIRATE6A__STATIC;
int32_t PIRATEHALF = PIRATEHALF__STATIC;
int32_t CHESTOFGOLD = CHESTOFGOLD__STATIC;
int32_t SIDEBOLT1 = SIDEBOLT1__STATIC;
int32_t FOODOBJECT1 = FOODOBJECT1__STATIC;
int32_t FOODOBJECT2 = FOODOBJECT2__STATIC;
int32_t FOODOBJECT3 = FOODOBJECT3__STATIC;
int32_t FOODOBJECT4 = FOODOBJECT4__STATIC;
int32_t FOODOBJECT5 = FOODOBJECT5__STATIC;
int32_t FOODOBJECT6 = FOODOBJECT6__STATIC;
int32_t FOODOBJECT7 = FOODOBJECT7__STATIC;
int32_t FOODOBJECT8 = FOODOBJECT8__STATIC;
int32_t FOODOBJECT9 = FOODOBJECT9__STATIC;
int32_t FOODOBJECT10 = FOODOBJECT10__STATIC;
int32_t FOODOBJECT11 = FOODOBJECT11__STATIC;
int32_t FOODOBJECT12 = FOODOBJECT12__STATIC;
int32_t FOODOBJECT13 = FOODOBJECT13__STATIC;
int32_t FOODOBJECT14 = FOODOBJECT14__STATIC;
int32_t FOODOBJECT15 = FOODOBJECT15__STATIC;
int32_t FOODOBJECT16 = FOODOBJECT16__STATIC;
int32_t FOODOBJECT17 = FOODOBJECT17__STATIC;
int32_t FOODOBJECT18 = FOODOBJECT18__STATIC;
int32_t FOODOBJECT19 = FOODOBJECT19__STATIC;
int32_t FOODOBJECT20 = FOODOBJECT20__STATIC;
int32_t HEADLAMP = HEADLAMP__STATIC;
int32_t TAMPON = TAMPON__STATIC;
int32_t SKINNEDCHICKEN = SKINNEDCHICKEN__STATIC;
int32_t FEATHEREDCHICKEN = FEATHEREDCHICKEN__STATIC;
int32_t ROBOTDOG2 = ROBOTDOG2__STATIC;
int32_t JOLLYMEAL = JOLLYMEAL__STATIC;
int32_t DUKEBURGER = DUKEBURGER__STATIC;
int32_t SHOPPINGCART = SHOPPINGCART__STATIC;
int32_t CANWITHSOMETHING2 = CANWITHSOMETHING2__STATIC;
int32_t CANWITHSOMETHING3 = CANWITHSOMETHING3__STATIC;
int32_t CANWITHSOMETHING4 = CANWITHSOMETHING4__STATIC;
int32_t SNAKEP = SNAKEP__STATIC;
int32_t DOLPHIN1 = DOLPHIN1__STATIC;
int32_t DOLPHIN2 = DOLPHIN2__STATIC;
int32_t NEWBEAST = NEWBEAST__STATIC;
int32_t NEWBEASTSTAYPUT = NEWBEASTSTAYPUT__STATIC;
int32_t NEWBEASTJUMP = NEWBEASTJUMP__STATIC;
int32_t NEWBEASTHANG = NEWBEASTHANG__STATIC;
int32_t NEWBEASTHANGDEAD = NEWBEASTHANGDEAD__STATIC;
int32_t DN64TILE4690 = DN64TILE4690__STATIC;
int32_t BOSS4 = BOSS4__STATIC;
int32_t BOSS4STAYPUT = BOSS4STAYPUT__STATIC;
int32_t FEM10 = FEM10__STATIC;
int32_t TOUGHGAL = TOUGHGAL__STATIC;
int32_t MAN = MAN__STATIC;
int32_t MAN2 = MAN2__STATIC;
int32_t WOMAN = WOMAN__STATIC;
int32_t PLEASEWAIT = PLEASEWAIT__STATIC;
int32_t NATURALLIGHTNING = NATURALLIGHTNING__STATIC;
int32_t WEATHERWARN = WEATHERWARN__STATIC;
int32_t DUKETAG = DUKETAG__STATIC;
int32_t SIGN1 = SIGN1__STATIC;
int32_t SIGN2 = SIGN2__STATIC;
int32_t JURYGUY = JURYGUY__STATIC;

int32_t RRTILE11 = 0;
int32_t RPG2SPRITE = 0;
int32_t RRTILE18 = 0;
int32_t RRTILE19 = 0;
int32_t RRTILE34 = 0;
int32_t RRTILE35 = 0;
int32_t DESTRUCTO = 0;
int32_t RRTILE38 = 0;
int32_t RRTILE43 = 0;
int32_t GUTMETER = 0;
int32_t RRTILE63 = 0;
int32_t RRTILE64 = 0;
int32_t RRTILE65 = 0;
int32_t RRTILE66 = 0;
int32_t RRTILE67 = 0;
int32_t RRTILE68 = 0;
int32_t SOUNDFX = 0;
int32_t MOTOAMMO = 0;
int32_t UFOBEAM = 0;
int32_t RRTILE280 = 0;
int32_t RRTILE281 = 0;
int32_t RRTILE282 = 0;
int32_t RRTILE283 = 0;
int32_t RRTILE285 = 0;
int32_t RRTILE286 = 0;
int32_t RRTILE287 = 0;
int32_t RRTILE288 = 0;
int32_t RRTILE289 = 0;
int32_t RRTILE290 = 0;
int32_t RRTILE291 = 0;
int32_t RRTILE292 = 0;
int32_t RRTILE293 = 0;
int32_t RRTILE295 = 0;
int32_t RRTILE296 = 0;
int32_t RRTILE297 = 0;
int32_t CDPLAYER = 0;
int32_t RRTILE380 = 0;
int32_t RRTILE403 = 0;
int32_t RRTILE409 = 0;
int32_t GUTMETER_LIGHT1 = 0;
int32_t GUTMETER_LIGHT2 = 0;
int32_t GUTMETER_LIGHT3 = 0;
int32_t GUTMETER_LIGHT4 = 0;
int32_t AMMO_ICON = 0;
int32_t RRTILE1076 = 0;
int32_t MUD = 0;
int32_t EXPLOSION3 = 0;
int32_t RRTILE1636 = 0;
int32_t WEAPONBAR = 0;
int32_t RRTILE1752 = 0;
int32_t RPG2 = 0;
int32_t RRTILE1790 = 0;
int32_t RRTILE1792 = 0;
int32_t RRTILE1801 = 0;
int32_t RRTILE1805 = 0;
int32_t RRTILE1807 = 0;
int32_t RRTILE1808 = 0;
int32_t RRTILE1812 = 0;
int32_t RRTILE1814 = 0;
int32_t RRTILE1817 = 0;
int32_t RRTILE1821 = 0;
int32_t RRTILE1824 = 0;
int32_t RRTILE1826 = 0;
int32_t RRTILE1850 = 0;
int32_t RRTILE1851 = 0;
int32_t RRTILE1856 = 0;
int32_t RRTILE1877 = 0;
int32_t RRTILE1878 = 0;
int32_t RRTILE1938 = 0;
int32_t RRTILE1939 = 0;
int32_t RRTILE1942 = 0;
int32_t RRTILE1944 = 0;
int32_t RRTILE1945 = 0;
int32_t RRTILE1947 = 0;
int32_t RRTILE1951 = 0;
int32_t RRTILE1952 = 0;
int32_t RRTILE1953 = 0;
int32_t RRTILE1961 = 0;
int32_t RRTILE1964 = 0;
int32_t RRTILE1973 = 0;
int32_t RRTILE1985 = 0;
int32_t RRTILE1986 = 0;
int32_t RRTILE1987 = 0;
int32_t RRTILE1988 = 0;
int32_t RRTILE1990 = 0;
int32_t RRTILE1995 = 0;
int32_t RRTILE1996 = 0;
int32_t RRTILE2004 = 0;
int32_t RRTILE2005 = 0;
int32_t POPCORN = 0;
int32_t RRTILE2022 = 0;
int32_t LANEPICS = 0;
int32_t RRTILE2025 = 0;
int32_t RRTILE2026 = 0;
int32_t RRTILE2027 = 0;
int32_t RRTILE2028 = 0;
int32_t RRTILE2034 = 0;
int32_t RRTILE2050 = 0;
int32_t RRTILE2052 = 0;
int32_t RRTILE2053 = 0;
int32_t RRTILE2056 = 0;
int32_t RRTILE2060 = 0;
int32_t RRTILE2072 = 0;
int32_t RRTILE2074 = 0;
int32_t RRTILE2075 = 0;
int32_t RRTILE2083 = 0;
int32_t RRTILE2097 = 0;
int32_t RRTILE2121 = 0;
int32_t RRTILE2122 = 0;
int32_t RRTILE2123 = 0;
int32_t RRTILE2124 = 0;
int32_t RRTILE2125 = 0;
int32_t RRTILE2126 = 0;
int32_t RRTILE2137 = 0;
int32_t RRTILE2132 = 0;
int32_t RRTILE2136 = 0;
int32_t RRTILE2139 = 0;
int32_t RRTILE2150 = 0;
int32_t RRTILE2151 = 0;
int32_t RRTILE2152 = 0;
int32_t RRTILE2156 = 0;
int32_t RRTILE2157 = 0;
int32_t RRTILE2158 = 0;
int32_t RRTILE2159 = 0;
int32_t RRTILE2160 = 0;
int32_t RRTILE2161 = 0;
int32_t RRTILE2175 = 0;
int32_t RRTILE2176 = 0;
int32_t RRTILE2178 = 0;
int32_t RRTILE2186 = 0;
int32_t RRTILE2214 = 0;
int32_t RRTILE2319 = 0;
int32_t RRTILE2321 = 0;
int32_t RRTILE2326 = 0;
int32_t RRTILE2329 = 0;
int32_t RRTILE2357 = 0;
int32_t RRTILE2382 = 0;
int32_t RRTILE2430 = 0;
int32_t RRTILE2431 = 0;
int32_t RRTILE2432 = 0;
int32_t RRTILE2437 = 0;
int32_t RRTILE2443 = 0;
int32_t RRTILE2445 = 0;
int32_t RRTILE2446 = 0;
int32_t RRTILE2450 = 0;
int32_t RRTILE2451 = 0;
int32_t RRTILE2455 = 0;
int32_t RRTILE2460 = 0;
int32_t RRTILE2465 = 0;
int32_t RRTILE2560 = 0;
int32_t RRTILE2562 = 0;
int32_t RRTILE2564 = 0;
int32_t RRTILE2573 = 0;
int32_t RRTILE2574 = 0;
int32_t RRTILE2577 = 0;
int32_t RRTILE2578 = 0;
int32_t RRTILE2581 = 0;
int32_t RRTILE2583 = 0;
int32_t RRTILE2604 = 0;
int32_t RRTILE2610 = 0;
int32_t RRTILE2613 = 0;
int32_t RRTILE2621 = 0;
int32_t RRTILE2622 = 0;
int32_t RRTILE2636 = 0;
int32_t RRTILE2637 = 0;
int32_t RRTILE2654 = 0;
int32_t RRTILE2656 = 0;
int32_t RRTILE2676 = 0;
int32_t RRTILE2689 = 0;
int32_t RRTILE2697 = 0;
int32_t RRTILE2702 = 0;
int32_t RRTILE2707 = 0;
int32_t RRTILE2732 = 0;
int32_t RRTILE2030 = 0;
int32_t RRTILE2831 = 0;
int32_t RRTILE2832 = 0;
int32_t RRTILE2842 = 0;
int32_t RRTILE2859 = 0;
int32_t RRTILE2876 = 0;
int32_t RRTILE2878 = 0;
int32_t RRTILE2879 = 0;
int32_t RRTILE2893 = 0;
int32_t RRTILE2894 = 0;
int32_t RRTILE2898 = 0;
int32_t RRTILE2899 = 0;
int32_t RRTILE2915 = 0;
int32_t RRTILE2940 = 0;
int32_t RRTILE2944 = 0;
int32_t RRTILE2945 = 0;
int32_t RRTILE2946 = 0;
int32_t RRTILE2947 = 0;
int32_t RRTILE2948 = 0;
int32_t RRTILE2949 = 0;
int32_t RRTILE2961 = 0;
int32_t RRTILE2970 = 0;
int32_t RRTILE2977 = 0;
int32_t RRTILE2978 = 0;
int32_t RRTILE2990 = 0;
int32_t RRTILE3073 = 0;
int32_t RRTILE3083 = 0;
int32_t RRTILE3100 = 0;
int32_t RRTILE3114 = 0;
int32_t RRTILE3115 = 0;
int32_t RRTILE3116 = 0;
int32_t RRTILE3117 = 0;
int32_t RRTILE3120 = 0;
int32_t RRTILE3121 = 0;
int32_t RRTILE3122 = 0;
int32_t RRTILE3123 = 0;
int32_t RRTILE3124 = 0;
int32_t RRTILE3132 = 0;
int32_t RRTILE3139 = 0;
int32_t RRTILE3144 = 0;
int32_t RRTILE3152 = 0;
int32_t RRTILE3153 = 0;
int32_t RRTILE3155 = 0;
int32_t RRTILE3171 = 0;
int32_t RRTILE3172 = 0;
int32_t RRTILE3190 = 0;
int32_t RRTILE3191 = 0;
int32_t RRTILE3192 = 0;
int32_t RRTILE3195 = 0;
int32_t RRTILE3200 = 0;
int32_t RRTILE3201 = 0;
int32_t RRTILE3202 = 0;
int32_t RRTILE3203 = 0;
int32_t RRTILE3204 = 0;
int32_t RRTILE3205 = 0;
int32_t RRTILE3206 = 0;
int32_t RRTILE3207 = 0;
int32_t RRTILE3208 = 0;
int32_t RRTILE3209 = 0;
int32_t RRTILE3216 = 0;
int32_t RRTILE3218 = 0;
int32_t RRTILE3219 = 0;
int32_t RRTILE3232 = 0;
int32_t SHOTGUNSHELLS = 0;
int32_t CIRCLESTUCK = 0;
int32_t RRTILE3410 = 0;
int32_t LUMBERBLADE = 0;
int32_t BOWLINGBALLH = 0;
int32_t BOWLINGBALL = 0;
int32_t BOWLINGBALLSPRITE = 0;
int32_t POWDERH = 0;
int32_t RRTILE3440 = 0;
int32_t RRTILE3462 = 0;
int32_t OWHIP = 0;
int32_t UWHIP = 0;
int32_t RPGGUN2 = 0;
int32_t RRTILE3497 = 0;
int32_t RRTILE3498 = 0;
int32_t RRTILE3499 = 0;
int32_t RRTILE3500 = 0;
int32_t SLINGBLADE = 0;
int32_t RRTILE3584 = 0;
int32_t RRTILE3586 = 0;
int32_t RRTILE3587 = 0;
int32_t RRTILE3600 = 0;
int32_t RRTILE3631 = 0;
int32_t RRTILE3635 = 0;
int32_t RRTILE3637 = 0;
int32_t RRTILE3643 = 0;
int32_t RRTILE3647 = 0;
int32_t RRTILE3652 = 0;
int32_t RRTILE3653 = 0;
int32_t RRTILE3668 = 0;
int32_t RRTILE3671 = 0;
int32_t RRTILE3673 = 0;
int32_t RRTILE3677 = 0;
int32_t RRTILE3684 = 0;
int32_t RRTILE3708 = 0;
int32_t RRTILE3714 = 0;
int32_t RRTILE3716 = 0;
int32_t RRTILE3720 = 0;
int32_t RRTILE3723 = 0;
int32_t RRTILE3725 = 0;
int32_t RRTILE3737 = 0;
int32_t RRTILE3754 = 0;
int32_t RRTILE3762 = 0;
int32_t RRTILE3763 = 0;
int32_t RRTILE3764 = 0;
int32_t RRTILE3765 = 0;
int32_t RRTILE3767 = 0;
int32_t RRTILE3773 = 0;
int32_t RRTILE3774 = 0;
int32_t RRTILE3793 = 0;
int32_t RRTILE3795 = 0;
int32_t RRTILE3804 = 0;
int32_t RRTILE3814 = 0;
int32_t RRTILE3815 = 0;
int32_t RRTILE3819 = 0;
int32_t RRTILE3827 = 0;
int32_t RRTILE3837 = 0;
int32_t RRTILE5014 = 0;
int32_t RRTILE5016 = 0;
int32_t RRTILE5017 = 0;
int32_t RRTILE5018 = 0;
int32_t RRTILE5019 = 0;
int32_t RRTILE5020 = 0;
int32_t RRTILE5021 = 0;
int32_t RRTILE5022 = 0;
int32_t RRTILE5023 = 0;
int32_t RRTILE5024 = 0;
int32_t RRTILE5025 = 0;
int32_t RRTILE5026 = 0;
int32_t RRTILE5027 = 0;
int32_t RRTILE5029 = 0;
int32_t RRTILE5030 = 0;
int32_t RRTILE5031 = 0;
int32_t RRTILE5032 = 0;
int32_t RRTILE5033 = 0;
int32_t RRTILE5034 = 0;
int32_t RRTILE5035 = 0;
int32_t RRTILE5036 = 0;
int32_t RRTILE5037 = 0;
int32_t RRTILE5038 = 0;
int32_t RRTILE5039 = 0;
int32_t RRTILE5040 = 0;
int32_t RRTILE5041 = 0;
int32_t RRTILE5043 = 0;
int32_t RRTILE5044 = 0;
int32_t RRTILE5045 = 0;
int32_t RRTILE5046 = 0;
int32_t RRTILE5047 = 0;
int32_t RRTILE5048 = 0;
int32_t RRTILE5049 = 0;
int32_t RRTILE5050 = 0;
int32_t RRTILE5051 = 0;
int32_t RRTILE5052 = 0;
int32_t RRTILE5053 = 0;
int32_t RRTILE5054 = 0;
int32_t RRTILE5055 = 0;
int32_t RRTILE5056 = 0;
int32_t RRTILE5057 = 0;
int32_t RRTILE5058 = 0;
int32_t RRTILE5059 = 0;
int32_t RRTILE5061 = 0;
int32_t RRTILE5062 = 0;
int32_t RRTILE5063 = 0;
int32_t RRTILE5064 = 0;
int32_t RRTILE5065 = 0;
int32_t RRTILE5066 = 0;
int32_t RRTILE5067 = 0;
int32_t RRTILE5068 = 0;
int32_t RRTILE5069 = 0;
int32_t RRTILE5070 = 0;
int32_t RRTILE5071 = 0;
int32_t RRTILE5072 = 0;
int32_t RRTILE5073 = 0;
int32_t RRTILE5074 = 0;
int32_t RRTILE5075 = 0;
int32_t RRTILE5076 = 0;
int32_t RRTILE5077 = 0;
int32_t RRTILE5078 = 0;
int32_t RRTILE5079 = 0;
int32_t RRTILE5080 = 0;
int32_t RRTILE5081 = 0;
int32_t RRTILE5082 = 0;
int32_t RRTILE5083 = 0;
int32_t RRTILE5084 = 0;
int32_t RRTILE5085 = 0;
int32_t RRTILE5086 = 0;
int32_t RRTILE5087 = 0;
int32_t RRTILE5088 = 0;
int32_t RRTILE5090 = 0;
int32_t RRTILE6144 = 0;
int32_t RRTILE7110 = 0;
int32_t RRTILE7111 = 0;
int32_t RRTILE7112 = 0;
int32_t RRTILE7113 = 0;
int32_t MOTOGUN = 0;
int32_t RRTILE7169 = 0;
int32_t MOTOHIT = 0;
int32_t BOATHIT = 0;
int32_t RRTILE7184 = 0;
int32_t RRTILE7190 = 0;
int32_t RRTILE7191 = 0;
int32_t RRTILE7213 = 0;
int32_t RRTILE7219 = 0;
int32_t EMPTYBIKE = 0;
int32_t EMPTYBOAT = 0;
int32_t RRTILE7424 = 0;
int32_t RRTILE7430 = 0;
int32_t RRTILE7433 = 0;
int32_t RRTILE7441 = 0;
int32_t RRTILE7547 = 0;
int32_t RRTILE7467 = 0;
int32_t RRTILE7469 = 0;
int32_t RRTILE7470 = 0;
int32_t RRTILE7475 = 0;
int32_t RRTILE7478 = 0;
int32_t RRTILE7505 = 0;
int32_t RRTILE7506 = 0;
int32_t RRTILE7534 = 0;
int32_t RRTILE7540 = 0;
int32_t RRTILE7533 = 0;
int32_t RRTILE7545 = 0;
int32_t RRTILE7552 = 0;
int32_t RRTILE7553 = 0;
int32_t RRTILE7554 = 0;
int32_t RRTILE7555 = 0;
int32_t RRTILE7557 = 0;
int32_t RRTILE7558 = 0;
int32_t RRTILE7559 = 0;
int32_t RRTILE7561 = 0;
int32_t RRTILE7566 = 0;
int32_t RRTILE7568 = 0;
int32_t RRTILE7574 = 0;
int32_t RRTILE7575 = 0;
int32_t RRTILE7576 = 0;
int32_t RRTILE7578 = 0;
int32_t RRTILE7579 = 0;
int32_t RRTILE7580 = 0;
int32_t RRTILE7595 = 0;
int32_t RRTILE7629 = 0;
int32_t RRTILE7636 = 0;
int32_t RRTILE7638 = 0;
int32_t RRTILE7640 = 0;
int32_t RRTILE7644 = 0;
int32_t RRTILE7646 = 0;
int32_t RRTILE7648 = 0;
int32_t RRTILE7650 = 0;
int32_t RRTILE7653 = 0;
int32_t RRTILE7655 = 0;
int32_t RRTILE7657 = 0;
int32_t RRTILE7659 = 0;
int32_t RRTILE7691 = 0;
int32_t RRTILE7694 = 0;
int32_t RRTILE7696 = 0;
int32_t RRTILE7697 = 0;
int32_t RRTILE7700 = 0;
int32_t RRTILE7702 = 0;
int32_t RRTILE7704 = 0;
int32_t RRTILE7705 = 0;
int32_t RRTILE7711 = 0;
int32_t RRTILE7716 = 0;
int32_t RRTILE7756 = 0;
int32_t RRTILE7768 = 0;
int32_t RRTILE7806 = 0;
int32_t RRTILE7820 = 0;
int32_t RRTILE7859 = 0;
int32_t RRTILE7870 = 0;
int32_t RRTILE7873 = 0;
int32_t RRTILE7875 = 0;
int32_t RRTILE7876 = 0;
int32_t RRTILE7879 = 0;
int32_t RRTILE7881 = 0;
int32_t RRTILE7883 = 0;
int32_t RRTILE7885 = 0;
int32_t RRTILE7886 = 0;
int32_t RRTILE7887 = 0;
int32_t RRTILE7888 = 0;
int32_t RRTILE7889 = 0;
int32_t RRTILE7890 = 0;
int32_t RRTILE7900 = 0;
int32_t RRTILE7901 = 0;
int32_t RRTILE7906 = 0;
int32_t RRTILE7912 = 0;
int32_t RRTILE7913 = 0;
int32_t RRTILE7936 = 0;
int32_t RRTILE8047 = 0;
int32_t MULTISWITCH2 = 0;
int32_t RRTILE8059 = 0;
int32_t RRTILE8060 = 0;
int32_t RRTILE8063 = 0;
int32_t RRTILE8067 = 0;
int32_t RRTILE8076 = 0;
int32_t RRTILE8094 = 0;
int32_t RRTILE8096 = 0;
int32_t RRTILE8099 = 0;
int32_t RRTILE8106 = 0;
int32_t RRTILE8162 = 0;
int32_t RRTILE8163 = 0;
int32_t RRTILE8164 = 0;
int32_t RRTILE8165 = 0;
int32_t RRTILE8166 = 0;
int32_t RRTILE8167 = 0;
int32_t RRTILE8168 = 0;
int32_t RRTILE8192 = 0;
int32_t RRTILE8193 = 0;
int32_t RRTILE8215 = 0;
int32_t RRTILE8216 = 0;
int32_t RRTILE8217 = 0;
int32_t RRTILE8218 = 0;
int32_t RRTILE8220 = 0;
int32_t RRTILE8221 = 0;
int32_t RRTILE8222 = 0;
int32_t RRTILE8223 = 0;
int32_t RRTILE8224 = 0;
int32_t RRTILE8227 = 0;
int32_t RRTILE8312 = 0;
int32_t RRTILE8370 = 0;
int32_t RRTILE8371 = 0;
int32_t RRTILE8372 = 0;
int32_t RRTILE8373 = 0;
int32_t RRTILE8379 = 0;
int32_t RRTILE8380 = 0;
int32_t RRTILE8385 = 0;
int32_t RRTILE8386 = 0;
int32_t RRTILE8387 = 0;
int32_t RRTILE8388 = 0;
int32_t RRTILE8389 = 0;
int32_t RRTILE8390 = 0;
int32_t RRTILE8391 = 0;
int32_t RRTILE8392 = 0;
int32_t RRTILE8394 = 0;
int32_t RRTILE8395 = 0;
int32_t RRTILE8396 = 0;
int32_t RRTILE8397 = 0;
int32_t RRTILE8398 = 0;
int32_t RRTILE8399 = 0;
int32_t RRTILE8423 = 0;
int32_t RRTILE8448 = 0;
int32_t RRTILE8450 = 0;
int32_t BOATAMMO = 0;
int32_t RRTILE8461 = 0;
int32_t RRTILE8462 = 0;
int32_t RRTILE8464 = 0;
int32_t RRTILE8475 = 0;
int32_t RRTILE8487 = 0;
int32_t RRTILE8488 = 0;
int32_t RRTILE8489 = 0;
int32_t RRTILE8490 = 0;
int32_t RRTILE8496 = 0;
int32_t RRTILE8497 = 0;
int32_t RRTILE8498 = 0;
int32_t RRTILE8499 = 0;
int32_t RRTILE8503 = 0;
int32_t RRTILE8525 = 0;
int32_t RRTILE8537 = 0;
int32_t RRTILE8565 = 0;
int32_t RRTILE8567 = 0;
int32_t RRTILE8568 = 0;
int32_t RRTILE8569 = 0;
int32_t RRTILE8570 = 0;
int32_t RRTILE8571 = 0;
int32_t RRTILE8579 = 0;
int32_t RRTILE8588 = 0;
int32_t RRTILE8589 = 0;
int32_t RRTILE8590 = 0;
int32_t RRTILE8591 = 0;
int32_t RRTILE8592 = 0;
int32_t RRTILE8593 = 0;
int32_t RRTILE8594 = 0;
int32_t RRTILE8595 = 0;
int32_t RRTILE8596 = 0;
int32_t RRTILE8598 = 0;
int32_t RRTILE8605 = 0;
int32_t RRTILE8608 = 0;
int32_t RRTILE8609 = 0;
int32_t RRTILE8611 = 0;
int32_t RRTILE8617 = 0;
int32_t RRTILE8618 = 0;
int32_t RRTILE8620 = 0;
int32_t RRTILE8621 = 0;
int32_t RRTILE8622 = 0;
int32_t RRTILE8623 = 0;
int32_t RRTILE8624 = 0;
int32_t RRTILE8640 = 0;
int32_t RRTILE8651 = 0;
int32_t RRTILE8660 = 0;
int32_t RRTILE8677 = 0;
int32_t RRTILE8679 = 0;
int32_t RRTILE8680 = 0;
int32_t RRTILE8681 = 0;
int32_t RRTILE8682 = 0;
int32_t RRTILE8683 = 0;
int32_t RRTILE8704 = 0;
int32_t BOULDER = 0;
int32_t BOULDER1 = 0;
int32_t TORNADO = 0;
int32_t CHEERBOMB = 0;
int32_t CHEERBLADE = 0;
int32_t DOGATTACK = 0;
int32_t BILLYWALK = 0;
int32_t BILLYDIE = 0;
int32_t BILLYCOCK = 0;
int32_t BILLYRAY = 0;
int32_t BILLYRAYSTAYPUT = 0;
int32_t BILLYBUT = 0;
int32_t BILLYSCRATCH = 0;
int32_t BILLYSNIFF = 0;
int32_t BILLYWOUND = 0;
int32_t BILLYGORE = 0;
int32_t BILLYJIBA = 0;
int32_t BILLYJIBB = 0;
int32_t BRAYSNIPER = 0;
int32_t DOGRUN = 0;
int32_t DOGDIE = 0;
int32_t DOGDEAD = 0;
int32_t DOGBARK = 0;
int32_t LTH = 0;
int32_t LTHSTRAFE = 0;
int32_t HULKHANG = 0;
int32_t HULKHANGDEAD = 0;
int32_t HULKJUMP = 0;
int32_t LTHLOAD = 0;
int32_t LTHDIE = 0;
int32_t BUBBASCRATCH = 0;
int32_t BUBBANOSE = 0;
int32_t BUBBAPISS = 0;
int32_t BUBBASTAND = 0;
int32_t BUBBAOUCH = 0;
int32_t BUBBADIE = 0;
int32_t BUBBADEAD = 0;
int32_t HULK = 0;
int32_t HULKSTAYPUT = 0;
int32_t HULKA = 0;
int32_t HULKB = 0;
int32_t HULKC = 0;
int32_t HULKJIBA = 0;
int32_t HULKJIBB = 0;
int32_t HULKJIBC = 0;
int32_t SBSWIPE = 0;
int32_t SBPAIN = 0;
int32_t SBDIE = 0;
int32_t HEN = 0;
int32_t HENSTAYPUT = 0;
int32_t HENSTAND = 0;
int32_t PIG = 0;
int32_t PIGSTAYPUT = 0;
int32_t PIGEAT = 0;
int32_t SBMOVE = 0;
int32_t SBSPIT = 0;
int32_t SBDIP = 0;
int32_t MINION = 0;
int32_t MINIONSTAYPUT = 0;
int32_t UFO1 = 0;
int32_t UFO2 = 0;
int32_t UFO3 = 0;
int32_t UFO4 = 0;
int32_t UFO5 = 0;
int32_t MINJIBA = 0;
int32_t MINJIBB = 0;
int32_t MINJIBC = 0;
int32_t COW = 0;
int32_t COOT = 0;
int32_t COOTSTAYPUT = 0;
int32_t COOTSHOOT = 0;
int32_t COOTDIE = 0;
int32_t COOTDUCK = 0;
int32_t COOTPAIN = 0;
int32_t COOTTRANS = 0;
int32_t COOTGETUP = 0;
int32_t COOTJIBA = 0;
int32_t COOTJIBB = 0;
int32_t COOTJIBC = 0;
int32_t VIXEN = 0;
int32_t VIXENPAIN = 0;
int32_t VIXENDIE = 0;
int32_t VIXENSHOOT = 0;
int32_t VIXENWDN = 0;
int32_t VIXENWUP = 0;
int32_t VIXENKICK = 0;
int32_t VIXENTELE = 0;
int32_t VIXENTEAT = 0;
int32_t BIKEJIBA = 0;
int32_t BIKEJIBB = 0;
int32_t BIKEJIBC = 0;
int32_t BIKERB = 0;
int32_t BIKERBV2 = 0;
int32_t BIKER = 0;
int32_t BIKERJIBA = 0;
int32_t BIKERJIBB = 0;
int32_t BIKERJIBC = 0;
int32_t BIKERJIBD = 0;
int32_t MAKEOUT = 0;
int32_t CHEERB = 0;
int32_t CHEER = 0;
int32_t CHEERSTAYPUT = 0;
int32_t CHEERJIBA = 0;
int32_t CHEERJIBB = 0;
int32_t CHEERJIBC = 0;
int32_t CHEERJIBD = 0;
int32_t FBOATJIBA = 0;
int32_t FBOATJIBB = 0;
int32_t COOTPLAY = 0;
int32_t BILLYPLAY = 0;
int32_t MINIONBOAT = 0;
int32_t HULKBOAT = 0;
int32_t CHEERBOAT = 0;
int32_t RRTILE7274 = 0;
int32_t RABBIT = 0;
int32_t RABBITJIBA = 0;
int32_t RABBITJIBB = 0;
int32_t RABBITJIBC = 0;
int32_t ROCK = 0;
int32_t ROCK2 = 0;
int32_t MAMACLOUD = 0;
int32_t MAMA = 0;
int32_t MAMAJIBA = 0;
int32_t MAMAJIBB = 0;

#if 0
static hashtable_t h_names = {512, NULL};

void G_ProcessDynamicTileMapping(const char *szLabel, int32_t lValue)
{
    int32_t i;

    if ((unsigned)lValue >= MAXTILES || !szLabel)
        return;

    i = hash_find(&h_names,szLabel);
    if (i>=0)
    {
        struct dynitem *di = &g_dynTileList[i];
#ifdef DEBUGGINGAIDS
        if (g_scriptDebug && di->staticval != lValue)
            OSD_Printf("REMAP %s (%d) --> %d\n", di->str, di->staticval, lValue);
#endif
        *di->dynvalptr = lValue;
    }
}

void inithashnames(void)
{
    int32_t i;

    hash_init(&h_names);

    for (i=0; g_dynTileList[i].staticval >= 0; i++)
        hash_add(&h_names, g_dynTileList[i].str, i, 0);
}

void freehashnames(void)
{
    hash_free(&h_names);
}
#endif


static struct dynitem g_dynWeaponList[] =
{
    { "KNEE_WEAPON", DVPTR(KNEE_WEAPON), KNEE_WEAPON__STATIC, KNEE_WEAPON__STATIC, 0 },
    { "PISTOL_WEAPON", DVPTR(PISTOL_WEAPON), PISTOL_WEAPON__STATIC, PISTOL_WEAPON__STATIC, 1 },
    { "SHOTGUN_WEAPON", DVPTR(SHOTGUN_WEAPON), SHOTGUN_WEAPON__STATIC, SHOTGUN_WEAPON__STATIC, 2 },
    { "CHAINGUN_WEAPON", DVPTR(CHAINGUN_WEAPON), CHAINGUN_WEAPON__STATIC, CHAINGUN_WEAPON__STATIC, 3 },
    { "RPG_WEAPON", DVPTR(RPG_WEAPON), RPG_WEAPON__STATIC, HANDBOMB_WEAPON__STATIC, 8 },
    { "HANDBOMB_WEAPON", DVPTR(HANDBOMB_WEAPON), HANDBOMB_WEAPON__STATIC, RPG_WEAPON__STATIC, 5 },
    { "SHRINKER_WEAPON", DVPTR(SHRINKER_WEAPON), SHRINKER_WEAPON__STATIC, SHRINKER_WEAPON__STATIC, 6 },
    { "DEVISTATOR_WEAPON", DVPTR(DEVISTATOR_WEAPON), DEVISTATOR_WEAPON__STATIC, FREEZE_WEAPON__STATIC, 4 },
    { "TRIPBOMB_WEAPON", DVPTR(TRIPBOMB_WEAPON), TRIPBOMB_WEAPON__STATIC, TRIPBOMB_WEAPON__STATIC, 9 },
    { "FREEZE_WEAPON", DVPTR(FREEZE_WEAPON), FREEZE_WEAPON__STATIC, DEVISTATOR_WEAPON__STATIC, 10 },
    { "HANDREMOTE_WEAPON", DVPTR(HANDREMOTE_WEAPON), HANDREMOTE_WEAPON__STATIC, HANDREMOTE_WEAPON__STATIC, 11 },
    { "GROW_WEAPON", DVPTR(GROW_WEAPON), GROW_WEAPON__STATIC, GROW_WEAPON__STATIC, 7 },
    { "BOWLINGBALL_WEAPON", DVPTR(BOWLINGBALL_WEAPON), BOWLINGBALL_WEAPON__STATIC, BOWLINGBALL_WEAPON__STATIC, 12 },
    { "MOTORCYCLE_WEAPON", DVPTR(MOTORCYCLE_WEAPON), MOTORCYCLE_WEAPON__STATIC, MOTORCYCLE_WEAPON__STATIC, 13 },
    { "BOAT_WEAPON", DVPTR(BOAT_WEAPON), BOAT_WEAPON__STATIC, BOAT_WEAPON__STATIC, 14 },
    { "SLINGBLADE_WEAPON", DVPTR(SLINGBLADE_WEAPON), SLINGBLADE_WEAPON__STATIC, SLINGBLADE_WEAPON__STATIC, SLINGBLADE_WEAPON__STATIC },
    { "CHICKEN_WEAPON", DVPTR(CHICKEN_WEAPON), CHICKEN_WEAPON__STATIC, CHICKEN_WEAPON__STATIC, CHICKEN_WEAPON__STATIC },
    { NULL, NULL, -1, -1 },
};

int32_t KNEE_WEAPON = KNEE_WEAPON__STATIC;
int32_t PISTOL_WEAPON = PISTOL_WEAPON__STATIC;
int32_t SHOTGUN_WEAPON = SHOTGUN_WEAPON__STATIC;
int32_t CHAINGUN_WEAPON = CHAINGUN_WEAPON__STATIC;
int32_t RPG_WEAPON = RPG_WEAPON__STATIC;
int32_t HANDBOMB_WEAPON = HANDBOMB_WEAPON__STATIC;
int32_t SHRINKER_WEAPON = SHRINKER_WEAPON__STATIC;
int32_t DEVISTATOR_WEAPON = DEVISTATOR_WEAPON__STATIC;
int32_t TRIPBOMB_WEAPON = TRIPBOMB_WEAPON__STATIC;
int32_t FREEZE_WEAPON = FREEZE_WEAPON__STATIC;
int32_t HANDREMOTE_WEAPON = HANDREMOTE_WEAPON__STATIC;
int32_t GROW_WEAPON = GROW_WEAPON__STATIC;
int32_t BOWLINGBALL_WEAPON = BOWLINGBALL_WEAPON__STATIC;
int32_t MOTORCYCLE_WEAPON = MOTORCYCLE_WEAPON__STATIC;
int32_t BOAT_WEAPON = BOAT_WEAPON__STATIC;
int32_t SLINGBLADE_WEAPON = SLINGBLADE_WEAPON__STATIC;
int32_t CHICKEN_WEAPON = CHICKEN_WEAPON__STATIC;

// This is run after all CON define's have been processed to set up the
// dynamic->static tile mapping.
void G_InitDynamicTiles(void)
{
    int32_t i;

    Bmemset(DynamicTileMap, 0, sizeof(DynamicTileMap));

    if (REALITY)
    {
        for (i = 0; g_dynWeaponList[i].staticval >= 0; i++)
            *(g_dynWeaponList[i].dynvalptr) = g_dynWeaponList[i].staticval_dn64;
    }
    if (RR)
    {
        for (i = 0; g_dynTileList[i].staticval >= 0; i++) {
            *(g_dynTileList[i].dynvalptr) = -g_dynTileList[i].staticval_rr;
            if (RRRA && *(g_dynTileList[i].dynvalptr) == -UFO1__STATICRR) *(g_dynTileList[i].dynvalptr) = -UFO1__STATICRRRA;
            DynamicTileMap[*(g_dynTileList[i].dynvalptr)] = g_dynTileList[i].staticval_rr;
        }
        for (i = 0; g_dynWeaponList[i].staticval >= 0; i++)
            *(g_dynWeaponList[i].dynvalptr) = g_dynWeaponList[i].staticval_rr;

        PHEIGHT = PHEIGHT_RR;
    }

    for (i=0; g_dynTileList[i].staticval >= 0; i++)
        if (g_dynTileList[i].staticval > 0)
            DynamicTileMap[*(g_dynTileList[i].dynvalptr)] = g_dynTileList[i].staticval;

    for (i=0; g_dynWeaponList[i].staticval >= 0; i++)
        DynamicWeaponMap[*(g_dynWeaponList[i].dynvalptr)] = g_dynWeaponList[i].staticval;

    DynamicTileMap[0] = 0;

    g_blimpSpawnItems[0] = RPGSPRITE;
    g_blimpSpawnItems[1] = CHAINGUNSPRITE;
    g_blimpSpawnItems[2] = DEVISTATORAMMO;
    g_blimpSpawnItems[3] = RPGAMMO;
    g_blimpSpawnItems[4] = RPGAMMO;
    g_blimpSpawnItems[5] = JETPACK;
    g_blimpSpawnItems[6] = SHIELD;
    g_blimpSpawnItems[7] = FIRSTAID;
    g_blimpSpawnItems[8] = STEROIDS;
    g_blimpSpawnItems[9] = RPGAMMO;
    g_blimpSpawnItems[10] = RPGAMMO;
    g_blimpSpawnItems[11] = RPGSPRITE;
    g_blimpSpawnItems[12] = RPGAMMO;
    g_blimpSpawnItems[13] = FREEZESPRITE;
    g_blimpSpawnItems[14] = FREEZEAMMO;

    if (RR)
    {
        WeaponPickupSprites[0] = KNEE;
        WeaponPickupSprites[1] = FIRSTGUNSPRITE;
        WeaponPickupSprites[2] = SHOTGUNSPRITE;
        WeaponPickupSprites[3] = CHAINGUNSPRITE;
        WeaponPickupSprites[4] = RPGSPRITE;
        WeaponPickupSprites[5] = HEAVYHBOMB;
        WeaponPickupSprites[6] = SHRINKERSPRITE;
        WeaponPickupSprites[7] = DEVISTATORSPRITE;
        WeaponPickupSprites[8] = TRIPBOMBSPRITE;
        WeaponPickupSprites[9] = BOWLINGBALLSPRITE;
        WeaponPickupSprites[10] = FREEZEBLAST;
        WeaponPickupSprites[11] = HEAVYHBOMB;
    }
    else if (REALITY)
    {
        WeaponPickupSprites[0] = BOOTS;
        WeaponPickupSprites[1] = FIRSTGUNSPRITE;
        WeaponPickupSprites[2] = SHOTGUNSPRITE;
        WeaponPickupSprites[3] = CHAINGUNSPRITE;
        WeaponPickupSprites[4] = RPGSPRITE;
        WeaponPickupSprites[5] = HEAVYHBOMB;
        WeaponPickupSprites[6] = SHRINKERSPRITE;
        WeaponPickupSprites[7] = GROWSPRITEICON;
        WeaponPickupSprites[8] = DEVISTATORSPRITE;
        WeaponPickupSprites[9] = TRIPBOMBSPRITE;
        WeaponPickupSprites[10] = FREEZESPRITE;
        WeaponPickupSprites[11] = HEAVYHBOMB;
        WeaponPickupSprites[12] = FIRSTGUNSPRITE;
        WeaponPickupSprites[13] = SHOTGUNSPRITE;
        WeaponPickupSprites[14] = DEVISTATORSPRITE;

        g_blimpSpawnItems[0] = RPGSPRITE;
        g_blimpSpawnItems[1] = CHAINGUNSPRITE;
        g_blimpSpawnItems[2] = RPGAMMO;
        g_blimpSpawnItems[3] = DEVISTATORAMMO;
        g_blimpSpawnItems[4] = DEVISTATORAMMO;
        g_blimpSpawnItems[5] = JETPACK;
        g_blimpSpawnItems[6] = SHIELD;
        g_blimpSpawnItems[7] = FIRSTAID;
        g_blimpSpawnItems[8] = STEROIDS;
        g_blimpSpawnItems[9] = DEVISTATORAMMO;
        g_blimpSpawnItems[10] = DEVISTATORAMMO;
        g_blimpSpawnItems[11] = DEVISTATORSPRITE;
        g_blimpSpawnItems[12] = DEVISTATORAMMO;
        g_blimpSpawnItems[13] = FREEZESPRITE;
        g_blimpSpawnItems[14] = FREEZEAMMO;
    }
    else
    {
        WeaponPickupSprites[0] = KNEE;
        WeaponPickupSprites[1] = FIRSTGUNSPRITE;
        WeaponPickupSprites[2] = SHOTGUNSPRITE;
        WeaponPickupSprites[3] = CHAINGUNSPRITE;
        WeaponPickupSprites[4] = RPGSPRITE;
        WeaponPickupSprites[5] = HEAVYHBOMB;
        WeaponPickupSprites[6] = SHRINKERSPRITE;
        WeaponPickupSprites[7] = DEVISTATORSPRITE;
        WeaponPickupSprites[8] = TRIPBOMBSPRITE;
        WeaponPickupSprites[9] = FREEZESPRITE;
        WeaponPickupSprites[10] = HEAVYHBOMB;
        WeaponPickupSprites[11] = SHRINKERSPRITE;
    }

    // ouch... the big background image takes up a fuckload of memory and takes a second to load!
#ifdef EDUKE32_GLES
    MENUSCREEN = LOADSCREEN = BETASCREEN;
#endif
}
