#!/bin/bash

# scale.youtube.com: downloads the images linking to the videos
#                    from website http://www.youtube.com

#
# CONFIGURATION SECTION BEGINS HERE
#

Configuration=".wmphoto+5"
Browser="firefox"
Backup="no"

#Channel="recommended"       ; Prefix="mq"
#Channel="videos"            ; Prefix="mq"
Channel="music"             ; Prefix=""
#Channel="music/alternative" ; Prefix="mq"
#Channel="music/rock"        ; Prefix="mq"
#Channel="music/jazz"        ; Prefix="mq"
#Channel="live"              ; Prefix=""
#Channel="education"         ; Prefix=""
#Channel="news"              ; Prefix=""

#
# CONFIGURATION SECTION ENDS HERE
#

if [ "`which lynx 2> /dev/null`" == "" ]
then
    echo "scale.youtube.com: there's no lynx program in the system"
    exit
fi

if [ "$Backup" == "yes" ] && [ ! -d backup ]
then
    mkdir backup
fi

for file in `find . -maxdepth 1 -name "*.xpm.gz" -mtime 1`
do
    if [ "$Backup" == "yes" ]
    then
	mv $file backup
	mv `echo $file | sed 's/.xpm.gz//'` backup
	mv `echo $file | sed 's/.xpm.gz/.jpg/'` backup
    else
	rm $file
	rm `echo $file | sed 's/.xpm.gz//'`
	rm `echo $file | sed 's/.xpm.gz/.jpg/'`
    fi
done

lynx --source http://www.youtube.com/$Channel > index.html

#cat index.html | sed 's#<#\n<#g' | grep -E "watch\?|default.jpg|video-time" | sed 's#.*data-thumb="//##;s#.*img src="//##;s#.*href="##;s#.*"video-time">##;s#/watch#\n/watch#g;s#/watch.*title="##;s#".*##;s# #_#g' | grep -v '^$' | perl -pe 's#\n# #g' | sed 's#/watch#\n/watch#g' | grep '[0-9]:[0-9][0-9]' | sed 's# <.*##' | sed 's#^#http://youtube.com#;s# $##'
#exit

for field in `cat index.html | sed 's#<#\n<#g' | grep -E "watch\?|default.jpg|video-time" | sed 's#.*data-thumb="//##;s#.*img src="//##;s#.*href="##;s#.*"video-time">##;s#/watch#\n/watch#g;s#/watch.*title="##;s#".*##;s# #_#g' | grep -v '^$' | perl -pe 's#\n# #g' | sed 's#/watch#\n/watch#g' | grep '[0-9]:[0-9][0-9]' | sed 's# <.*##' | sed 's#^#http://youtube.com#;s# $##'`
do
    time=""
    if [ "`echo $field | grep 'http://youtube.com'`" != "" ]
    then
	destination=`echo $field | sed 's#.*\?v=##;s#\&amp.*##'`
    fi
    if [ "`echo $field | grep -E '[0-9]:[0-9]+'`" != "" ]
    then
	time=$field
    fi
    if [ "`echo $field | grep 'http://youtube.com'`" != "" ]
    then
	echo "$field" | sed "s@\&amp;.*@@" > ./$destination
	sed -i "s#^http://#$Browser http://#" ./$destination
	echo "/home/$USER/$Configuration/command" >> ./$destination
    elif [ "`echo $field | grep 'default.jpg'`" != "" ]
    then
	wget -Nnd $field 2> /dev/null
	if [ -f ${Prefix}default.jpg ] && [ ! -f ./$destination.jpg ]
	then
	    mv ${Prefix}default.jpg ./$destination.jpg
	fi
    elif [ "$time" == "$field" ]
    then
	echo "$time" >> ./$destination
    else
	echo "$field" | perl -pe "s@\&amp;@\&@g;s@\&quot;@\"@g;s@\&#39;@'@g;s@_@ @g" >> ./$destination
    fi
done

for source in *.jpg
do
    destination=`echo $source | sed 's#\.jpg$##'`
    if [ ! -f ./$destination.xpm.gz ] || [ ./$source -nt ./$destination.xpm.gz ]
    then
	size=`identify ./$source | cut -d " " -f 3`
	if [ "$size" == "320x180" ]
	then
	    crop="-crop 180x180+70+0"
	    unsharp="-unsharp 0.125"
	elif [ "$size" == "120x90" ]
	then
	    crop="-crop 54x54+33+18"
	    unsharp=""
	fi
	touch ./$destination
	time=`cat ./$destination | grep -E '[0-9]:[0-9]+'`
	if [ "$time" == "" ] || [ "`echo $time | grep 'wmphoto'`" != "" ]
	then
	    rm ./$source ./$destination
	fi
	if [ -f ./$source ]
	then
	    montage ./$source $crop -colors 256 -geometry 54x54 -size 54x54 -pointsize 11 -fill white -stroke black -strokewidth 3 -gravity Center -annotate 0x0+0+20 $time -stroke none -gravity Center -annotate 0x0+0+20 $time $unsharp +adjoin ./$destination.xpm.gz
	fi
    fi
done
