#include <glib/gi18n.h>
#include "thunar-sgsearch.h"


static void thunarx_sgsearch_menu_provider_init (ThunarxMenuProviderIface *iface);
static GList *thunarx_sgsearch_get_file_actions (ThunarxMenuProvider *provider, GtkWidget *window, GList *files);
static GList *thunarx_sgsearch_get_folder_actions (ThunarxMenuProvider *provider, GtkWidget *window, ThunarxFileInfo *folder);
static void thunarx_sgsearch_activated (ThunarxMenuItem *menuitem, gpointer *data);

struct _ThunarxSGSearchClass {
	GObjectClass parent;
};

struct _ThunarxSGSearch {
	GObject parent;
};

THUNARX_DEFINE_TYPE_WITH_CODE (ThunarxSGSearch, thunarx_sgsearch, G_TYPE_OBJECT,
	THUNARX_IMPLEMENT_INTERFACE (THUNARX_TYPE_MENU_PROVIDER, thunarx_sgsearch_menu_provider_init));

static void thunarx_sgsearch_class_init (ThunarxSGSearchClass *cls) {}
static void thunarx_sgsearch_init (ThunarxSGSearch *sgsearch) {}


static void thunarx_sgsearch_menu_provider_init (ThunarxMenuProviderIface *iface) {
	iface->get_file_menu_items = thunarx_sgsearch_get_file_actions;
	iface->get_folder_menu_items = thunarx_sgsearch_get_folder_actions;
}


static GList *thunarx_sgsearch_get_file_actions (ThunarxMenuProvider *provider, GtkWidget *window, GList *files) {
	if (G_LIKELY (files != NULL && files->next == NULL && thunarx_file_info_is_directory (files->data))) {
		return thunarx_sgsearch_get_folder_actions (provider, window, files->data);
	} else {
		return NULL;
	}
}


static GList* thunarx_sgsearch_get_folder_actions (ThunarxMenuProvider *provider, GtkWidget *window, ThunarxFileInfo *folder) {
	ThunarxMenuItem *menuitem = thunarx_menu_item_new ("sgsearch::do-search", gettext ("Search"), gettext ("Search from that folder"), "sgsearch");
	GFile *file = thunarx_file_info_get_location (folder);
	gchar *path = g_file_get_path (file);
	g_signal_connect (G_OBJECT (menuitem), "activate", G_CALLBACK (thunarx_sgsearch_activated), window);
	g_object_set_data_full (G_OBJECT (menuitem), "path", path, g_free);
	//g_free (path) //don't
	g_object_unref (file);
	return g_list_prepend (NULL, menuitem);
}


static void thunarx_sgsearch_activated (ThunarxMenuItem *menuitem, gpointer *data) {
	const gchar *path = g_object_get_data (G_OBJECT (menuitem), "path");
	gchar *commandline = g_strdup_printf ("sgsearch \"%s\"", path);
	g_spawn_command_line_async (commandline, NULL);
	g_free (commandline);
}


