#include <glib/gi18n.h>
#include <locale.h>
#include "thunar-sgsearch.h"
#include "config.h"


//~ https://developer.gnome.org/gobject/unstable/chapter-gtype.html
//~ /usr/share/gtk-doc/html/thunarx/index.html
//~ /usr/share/gtk-doc/html/thunarx/thunarx-writing-extensions-getting-started.html


static GType type_list[1];


void thunar_extension_initialize (ThunarxProviderPlugin *plugin) {
	const gchar *mismatch;
	mismatch = thunarx_check_version (THUNARX_MAJOR_VERSION, THUNARX_MINOR_VERSION, THUNARX_MICRO_VERSION);
	if (G_UNLIKELY (mismatch != NULL)) {
		g_warning ("Version mismatch: %s", mismatch);
		return;
	}
	
	setlocale (LC_ALL, "");
	bindtextdomain (PROJECT_NAME, LOCALE_DIR);
	bind_textdomain_codeset (PROJECT_NAME, "UTF-8");
	textdomain (PROJECT_NAME);
	
	thunarx_sgsearch_register_type (plugin);
	type_list[0] = THUNARX_TYPE_SGSEARCH;
}


void thunar_extension_shutdown (void) {}


void thunar_extension_list_types (const GType **types, gint *n_types) {
	*types = type_list;
	*n_types = G_N_ELEMENTS (type_list);
}

