typedef struct {
	GtkBuilder *builder;
	GtkApplicationWindow *main_application;
	GtkAboutDialog *about_dialog;
	
	GtkFileChooser *startfolder;
	GtkEntry *filename;
	GtkEntry *content;
	GtkButton *search;
	GtkButton *cancel;
	GtkTreeView *foundfiles;
	GtkProgressBar *progressbar;
	GtkMenu *contextmenu;
} T_GUI;
T_GUI *gui;

typedef struct {
	gchar *startfolder; 
	GtkListStore *foundfiles;
	gchar *path; //for use in context menu
	gchar *texteditor;
	
	GPid pid;
	guint output_watcher;
	guint pulse_watcher;
	GIOChannel *stdout_ioc;
	GThread *thread;
} T_APP;
T_APP *app;

void load_gui();

void load_parameters(int argc, char *argv[]);

gboolean new_filefound_handler (GIOChannel *source, GIOCondition condition, gpointer data);

void on_cancel_clicked (GtkWidget *widget, gpointer data);

void on_default_action_activate(GtkWidget *widget, gpointer data);

gboolean on_files_treeview_button_press_event (GtkWidget *widget, GdkEvent *event, gpointer data);

void on_open_text_activate(GtkWidget *widget, gpointer data);

void on_open_folder_activate(GtkWidget *widget, gpointer data);

void on_process_end (GPid pid, gint status, gpointer data);

void on_search_clicked (GtkWidget *widget, gpointer data);

gboolean progress_handler (gpointer data);

gpointer run_search(gpointer data);
