//~ gcc -lzip -o docIndex docIndex.c
#include <zip.h>
#include <stdlib.h>
//~ #include <libxml/xmlreader.h>
#define ODT_CONTENT "content.xml"

zip_t *open_zip(const char *filename) {
	int *z_error;
	zip_t *z_archive = zip_open(filename, ZIP_RDONLY, z_error);
	if (z_archive == NULL) {
		if (*z_error == ZIP_ER_NOENT) {
			printf("error: file not found: %s\n", filename);
		} else if (*z_error == ZIP_ER_NOZIP) {
			printf("error: not is zip file: %s\n", filename);
		}
	}
	return z_archive;
}

zip_uint64_t zip_size(zip_t *z_archive, const char *filename) {
	zip_uint64_t size = 0;
	zip_stat_t *z_stat = (zip_stat_t *) malloc(sizeof(zip_stat_t));
	zip_stat_init(z_stat);
	if (zip_stat(z_archive, filename, ZIP_STAT_SIZE, z_stat) == -1) {
		printf("error: file not in archive: %s\n", filename);
	} else {
		size = z_stat->size;
		free(z_stat);
	}
	return size;
}

char *load_content(zip_t *z_archive, const char *filename) {
	char *content = NULL;
	zip_uint64_t size = zip_size(z_archive, filename);
	zip_file_t *z_file = zip_fopen(z_archive, filename, 0);
	if (z_file != NULL && size != 0) {
		content = (char *) malloc(size * sizeof(char) + 1);
		content[zip_fread(z_file, content, size)] = '\0';
		zip_fclose(z_file);
	}
	return content;
}
	

int main(int argc, char *argv[]) {
	if (argc != 2) {
		printf("usage: %s path/to/ooxml\n", argv[0]);
		printf("example: %s test.odt\n", argv[0]);
		return 1;
	}
	char *filename = argv[1];
	zip_t *z_archive = open_zip(filename);
	if (z_archive == NULL) {
		return 2;
	}
	
	char *content = load_content(z_archive, ODT_CONTENT);
	if (content != NULL) {
		printf("%s\n", content);
		free(content);
	}
	
	zip_close(z_archive);
	return 0;
}
