## Purpose

SGSearch is a frontend to the `find` and `grep` commands allowing respectively 
to search for file names or file content.
It is meant to be a companion to file managers like Thunar (extension is 
provided) and works over GVFS.


## License

Copyright Frank ENDRES (2010-04-03)
frankendres@tuxfamily.org (disabled; use: first@last.fr).

This software is governed by the [CeCILL license](http://cecill.info/licences/Licence_CeCILL_V2-en.html) 
under French law, compatible with the GPL (General Public License).


## Usage

### GUI interface

- Select root lookup folder and enter file name (wildcards allowed) and 
some words (if searching for file content), then press search button.
- Double-click on a file to open it with its default application, or right-click 
to get more options.

### From the command line

SGSearch can be parameterized from the command line, allowing integration 
with Thunar or XFCE WhiskerMenu plugin for example.

- Root lookup folder setup:
```sh
sgsearch /path/to/lookup/folder
```

- Search initialisation (auto-start):
```sh
sgsearch [/path/to/lookup/folder] *name*parts*
sgsearch [/path/to/lookup/folder] "/some content"
sgsearch [/path/to/lookup/folder] *name*parts* "/some content"
```
