/*
 * (SLIK) SimpLIstic sKin functions
 * (C) 2005 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */

#ifndef UI2_INCLUDES_H
#define UI2_INCLUDES_H

/*
 *-------------------------------------------------------------------
 * since all files include this first, a few comments are placed here
 *-------------------------------------------------------------------
 * It has been attempted to break SLIK out into its own self contained set of
 * files, for the most part this includes all the ui2_*.[ch] files.
 *
 * In addition, SLIK requires all or part of the functions in these files:
 *   config.h		generated by configure
 *                      (you _are_ using automake/autoconf, aren't you ?)
 *   pixbuf_ops.[ch]:	manipulate pixel buffers (pixbuf), drawing, etc.
 *   fileops.[ch]:	generic filesystem functions
 *   intl.h:		used when internationalization is disabled
 *
 * The editor also uses:
 *   tabcomp.[ch]:	tab completion for path entries
 *   pixbuf_save.[ch]:	save pixbuf to png
 *   utildlg.[ch]:	generic dialog for warnings
 *   pathsel.[ch]:      path selection list
 *
 * While some code to support the editor is also in ui2_main/display.c, it
 * has been made generic such that ui2_editor.[ch] is not needed for SLIK to
 * to compile/work if you do not want to include the skin editor.
 * 
 * The default skin is defined in ui2_default.c, with any luck this is the
 * only file that needs significant editing.
 *
 * Usually, the files display.[ch] are the glue between SLIK and the rest of
 * the application, and window.[ch] usually sets up the main window as a SLIK
 * window. For consistency these are the prefered file names. The global slik_*
 * variables can be changed at any time, but note for color and transparency
 * changes to take effect (usually changed in user preferences) the skin must
 * be reloaded.
 * 
 * Adding new widgets is currently a pain in the A$$, as the code must be
 * sprinkled through at least ui2_widget_name.[ch], ui2_widget.c, ui2_parse.c,
 * ui2_typedefs.h, and to support the skin editor, all over the place in
 * ui2_editor.c.
 * 
 */

/*
 *-------------------------------------
 * includes for system libs
 *-------------------------------------
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif
#include "intl.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

/*
 *-------------------------------------
 * includes for glib / gtk / etc.
 *-------------------------------------
 */

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#endif




