/*
 * (SLIK) SimpLIstic sKin functions
 * (C) 2002 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */

#include "gqradio.h"
#include "skin.h"

#include "ui2_button.h"
#include "ui2_item.h"
#include "ui2_main.h"
#include "ui2_parse.h"
#include "ui2_skin.h"
#include "ui2_text.h"
#include "ui2_util.h"
#include "ui2_widget.h"


#include "default_skin/nf_back.xpm"
#include "default_skin/nf_btn_prefs.xpm"
#include "default_skin/nf_btn_quit.xpm"


static WidgetData *add_button(const gchar *key, gchar **data, gint prelight, gint light, gint x, gint y,
			      gchar **clip_data, SkinData *skin, const gchar *text_id)
{
	ButtonData *button;

	button = button_new_from_data(data, x, y, prelight, light, clip_data);
	return button_register(skin, button, key, text_id);
}

static WidgetData *add_text(const gchar *key, const gchar *font, gint width, gint sizeable,
			    guint8 r, guint8 g, guint8 b, guint8 a,
			    gint x, gint y, SkinData *skin, const gchar *text_id)
{
	TextData *text;

	text = text_new_from_x(font, x, y, width, sizeable, 0);
	text_set_color(text, r, g, b, a);
	return text_register(skin, text, key, text_id);
}

static SkinData *skin_message(const gchar *message1, const gchar *message2)
{
	SkinData *skin;
	WidgetData *wd;

	skin = skin_new();

	skin->real_overlay = util_size_pixbuf(gdk_pixbuf_new_from_xpm_data((const char **)nf_back_xpm), TRUE);
	skin->border_top = 22;
	skin->border_bottom = 46;
	skin->border_left = 60;
	skin->border_right = 15;
	skin->has_border = TRUE;
	skin->width = 280;
	skin->height = 96;

	add_button("config", (gchar **)nf_btn_prefs_xpm, FALSE, FALSE, 210, 59, NULL, skin, NULL);
	add_button("exit", (gchar **)nf_btn_quit_xpm, FALSE, FALSE, 143, 59, NULL, skin, NULL);

	wd = add_text("message1", "-*-helvetica-bold-r-*-*-14-*-*-*-*-*-*-*", 252, TRUE, 0, 0, 0, 179, 13, 19, skin, NULL);
	ui_widget_set_data(wd, "data", message1);
	wd = add_text("message2", "-*-helvetica-bold-r-*-*-14-*-*-*-*-*-*-*", 252, TRUE, 0, 0, 0, 179, 13, 35, skin, NULL);
	ui_widget_set_data(wd, "data", message2);

	skin->width_def = skin->width_min = skin->width_max = skin->width;
	skin->height_def = skin->height_min = skin->height_max = skin->height;

	return skin;
}

SkinData *skin_load_default_cb(UIData *ui, const gchar *key, gpointer data)
{
	SkinData *skin;
	gchar *datafile;

	if (!key) key = "skindata";

	datafile = g_strconcat(GQRADIO_SKIN_DEFAULT, "/", key, NULL);
	skin = skin_parse(GQRADIO_SKIN_DEFAULT, datafile, TRUE);
	g_free(datafile);

	if (!skin) skin = skin_message(_("Default skin not found:"), GQRADIO_SKIN_DEFAULT);

	return skin;
}

void ui_set_message(UIData *ui, const gchar *path, const gchar *key,
		    const gchar *message1, const gchar *message2)
{
	SkinData *skin;

	skin = NULL;
	if (!key) key = "skindata_dialog";

	if (path)
		{
		gchar *datafile;

		datafile = g_strconcat(path, "/", key, NULL);
		skin = skin_parse(path, datafile, TRUE);
		g_free(datafile);
		}

	if (skin)
		{
		text_set_text("message1", ui, message1);
		text_set_text("message2", ui, message2);
		}
	else
		{
		skin = skin_message(message1, message2);
		}

	ui_skin_set(ui, skin, path, NULL);
}

