/*
 * GQradio
 * (C) 2003 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#ifndef IO_RADIO_H
#define IO_RADIO_H

/* the default min and max values (MHz) */
#define RADIO_FREQ_MIN  87500000
#define RADIO_FREQ_MAX 108000000

/* # is per second, the interval to check mono/stereo and signal strength */
#define RADIO_STATUS_INTERVAL 2

/* this is the 'settling time' to determine signal strength */
#define RADIO_SCANS_PER_SECOND 8

/* scan station increment for autoseek, (results are clamped to freq_step setting) */
#define RADIO_SCAN_INCREMENT 50000

#define RADIO_DEFAULT_STEP 100000

/* this is the strength at which to accept a station
 * 24% seems to work for me, less and it detects almost all frequencies...
 * if your tuner/driver does not report/support signal strength, auto-scan is useless
 */
#define RADIO_SCAN_SENSITIVITY 24

#if defined(linux) && defined(HAVE_VIDEO4LINUX)
  #define RADIO_DEVICE "/dev/radio"
#elif defined(HAVE_IOCTL_BT848)
  #define RADIO_DEVICE "/dev/tuner"
#else
  /* to allow compilation on unsupported systems, set this define to _something_ */
  #define RADIO_DEVICE "/dev/radio"
#endif


extern gint radio_volume_boost;


gint radio_test(gint recheck);
gint radio_init(void);
gint radio_status(gint *stereo, gint *strength);
gint radio_startup(guint32 freq);
gint radio_shutdown(void);
gint radio_set_freq(guint32 freq);
gint radio_set_mute(gint mute);
void radio_set_device(const gchar *device);

guint32 radio_limit_get_lower(void);
guint32 radio_limit_get_upper(void);

void radio_limit_by_card_set(gint use);
gint radio_limit_by_card_get(void);


gint radio_freq_get_major(guint32 freq);
gint radio_freq_get_minor(guint32 freq);
gchar *radio_freq_to_text(guint32 freq);
guint32 radio_freq_from_text(const gchar *text);

guint32 radio_freq_clamp_to_increment(guint32 freq, guint32 step);


gint radio_path_is_radio(const gchar *path);

gchar *radio_freq_to_path(guint32 freq, const gchar *title);
guint32 radio_path_to_freq(const gchar *path);
gchar *radio_path_to_title(const gchar *path);


#endif

