/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import music.cpp.client.App;
import music.cpp.client.BOMReader;
import music.cpp.client.MusicClient;
import music.cpp.client.StringUtil;

public class StringResource {
    static String mode = "en_es";
    TreeMap map = new TreeMap();

    public StringResource() {
        try {
            this.loadLanguage("english.rc");
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Unable to load strings!", "Error", 0);
            System.exit(0);
        }
        try {
            String string = System.getProperty("user.language");
            if ("de".equals(string)) {
                this.loadLanguage("deutsch.rc");
            } else if ("es".equals(string)) {
                this.loadLanguage("espanol.rc");
            } else if ("fr".equals(string)) {
                this.loadLanguage("francais.rc");
            } else if ("ru".equals(string)) {
                this.loadLanguage("russian.rc");
            } else if ("it".equals(string)) {
                this.loadLanguage("italiano.rc");
            } else if ("se".equals(string)) {
                this.loadLanguage("svenska.rc");
            }
        }
        catch (IOException iOException) {
            App.logException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadLanguage(String string) throws IOException {
        String string2 = System.getProperty("install.root");
        InputStream inputStream = null;
        try {
            File file = new File(string2, "cpp/win32/" + string);
            if (file.exists()) {
                inputStream = new FileInputStream(file);
            } else {
                URL uRL = MusicClient.class.getResource("/music/cpp/win32/" + string);
                if (uRL == null) throw new IOException();
                inputStream = uRL.openStream();
            }
            if (inputStream == null) {
                throw new IOException();
            }
            this.load(inputStream);
            Object var7_6 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                App.logException(iOException);
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            App.logException(iOException);
        }
    }

    public void load(InputStream inputStream) throws IOException {
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(new BOMReader(new InputStreamReader(inputStream)));
        while ((string = lineNumberReader.readLine()) != null) {
            int n;
            if (!string.startsWith("IDSTR")) continue;
            int n2 = string.indexOf(32);
            int n3 = string.indexOf(9);
            if (n2 < 0 && n3 < 0) continue;
            int n4 = n2 < 0 ? n3 : (n3 < 0 ? n2 : (n2 < n3 ? n2 : n3));
            if (string.charAt(n4 + 1) == '+') {
                n4 = string.indexOf(32, n4 + 3);
            }
            String string2 = string.substring(0, n4);
            String string3 = string.substring(n4).trim();
            int n5 = string3.indexOf("L\"");
            if (n5 < 0 || (n = string3.indexOf("\"", n5 + 2)) < n5 + 2) continue;
            this.map.put(string2, string3.substring(n5 + 2, n));
        }
        lineNumberReader.close();
    }

    public String get(String string) {
        String string2 = (String)this.map.get(string);
        if (string2 == null) {
            return "";
        }
        return StringResource.replace(string2, "\\n", "\n");
    }

    public String expand(String string, String[] stringArray) {
        String string2 = (String)this.map.get(string);
        if (string2 == null) {
            return "";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = StringResource.replace(string2, "%s", stringArray[i]);
        }
        return StringResource.replace(string2, "\\n", "\n");
    }

    public static String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String translate(String string) {
        return null;
    }

    public static void main(String[] stringArray) throws IOException {
        String[] stringArray2;
        Object object;
        StringResource stringResource = new StringResource();
        File file = new File(new File(stringArray[0]).getParent(), "strings.html");
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write("<HTML><HEAD><TITLE>Strings</TITLE><STYLE>\nTD { font-family: Arial; font-size: 8pt; }\nTH { font-family: Arial; font-size: 10pt; }\n</STYLE></HEAD><BODY>");
        int n = 300 + 402 * stringArray.length;
        fileWriter.write("<TABLE BORDER=1 CELPADDING=0 CELLSPACING=0 WIDTH=" + n + "><TR><TH> </TH>");
        OutputStreamWriter outputStreamWriter = null;
        if (stringArray.length == 2) {
            mode = stringArray[0].substring(0, 2) + "_" + stringArray[1].substring(0, 2);
            outputStreamWriter = new FileWriter(new File(new File(stringArray[0]).getParent(), mode + ".txt"));
        }
        TreeMap<String, String[]> treeMap = new TreeMap<String, String[]>();
        for (int i = 0; i < stringArray.length; ++i) {
            object = new File(stringArray[i]);
            fileWriter.write("<TH>" + ((File)object).getName() + "</TH>");
            stringResource.load(new FileInputStream((File)object));
            stringArray2 = stringResource.map.keySet().iterator();
            while (stringArray2.hasNext()) {
                String string = (String)stringArray2.next();
                String string2 = stringResource.get(string);
                String[] stringArray3 = (String[])treeMap.get(string);
                if (stringArray3 == null) {
                    stringArray3 = new String[stringArray.length];
                }
                stringArray3[i] = string2;
                treeMap.put(string, stringArray3);
            }
            stringResource.map.clear();
        }
        fileWriter.write("</TR>");
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            fileWriter.write("<TR><TD WIDTH=300>" + (String)object + "</TD>");
            stringArray2 = (String[])treeMap.get(object);
            for (int i = 0; i < stringArray.length; ++i) {
                fileWriter.write("<TD WIDTH=400>");
                if (stringArray2[i] != null) {
                    for (int j = 0; j < stringArray2[i].length(); ++j) {
                        char c;
                        char c2 = stringArray2[i].charAt(j);
                        if ((char)c2 == '%' && j < stringArray2[i].length() - 1 && Character.isLetter(c = stringArray2[i].charAt(j + 1))) {
                            fileWriter.write("<FONT COLOR=#0000ff>" + (char)c2 + "" + c + "</FONT>");
                            ++j;
                            continue;
                        }
                        if (c2 == '\n') {
                            fileWriter.write("<FONT COLOR=#00ff00>\\n</FONT>");
                            continue;
                        }
                        if (c2 >= ' ' && c2 < '\u0080') {
                            fileWriter.write(c2);
                            continue;
                        }
                        fileWriter.write("&#" + c2 + ";");
                    }
                } else {
                    fileWriter.write("<FONT COLOR=#ff0000>Missing!</FONT>");
                    if (stringArray.length == 2 && i == 1 && stringArray2[0] != null) {
                        String string = StringUtil.replace(stringArray2[0], "\n", " ");
                        String string3 = StringResource.translate(string);
                        if (string3 != null) {
                            string3 = string3.trim();
                        }
                        System.out.println("-----------------\n" + (String)object + "\n" + string + "\n" + string3);
                        if (outputStreamWriter != null) {
                            StringBuffer stringBuffer = new StringBuffer();
                            for (int j = ((String)object).length(); j < 40; ++j) {
                                stringBuffer.append(" ");
                            }
                            outputStreamWriter.write((String)object + stringBuffer + "L\"" + (string3 == null ? StringResource.replace(stringArray2[0], "\n", "\\n") : string3) + "\"\n");
                        }
                    }
                }
                fileWriter.write("</TD>");
            }
            fileWriter.write("</TR>");
        }
        fileWriter.write("</TABLE></BODY></HTML>");
        fileWriter.close();
        if (outputStreamWriter != null) {
            outputStreamWriter.close();
        }
        Runtime.getRuntime().exec(new String[]{"C:\\Program Files\\Internet Explorer\\iexplore.exe", "-nohome", file.getCanonicalPath()});
    }
}

