/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.BorderLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import music.cpp.client.Label2;
import music.cpp.client.MusicClient;
import music.cpp.client.SongFilter;
import music.cpp.client.Status;
import music.cpp.client.StringUtil;

public class StatusBar
extends JPanel {
    static final String iSongs = MusicClient.STRINGS.get("IDSTR_STATUS_SONGS");
    static final String iAnalysis = MusicClient.STRINGS.get("IDSTR_STATUS_ANALYSIS");
    MusicClient client;
    JLabel label;

    public StatusBar(MusicClient musicClient) {
        super(new BorderLayout());
        this.client = musicClient;
        this.label = new Label2("");
        this.add("West", this.label);
    }

    void update() {
        String string;
        Status status = this.client.getStatus();
        SongFilter songFilter = this.client.getFilter();
        String string2 = songFilter == null ? null : songFilter.getName();
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = StringUtil.l2ac(status.getTotal());
        String string4 = StringUtil.l2ac(status.getHasData());
        String string5 = StringUtil.l2ac(status.getPending());
        String string6 = iSongs + (string2 == null ? ": " : " (" + string2 + "): ");
        if (this.client.areWorkersRunning()) {
            stringBuffer.append(string6 + string3 + " (" + this.ready(string4) + ")");
            string = this.client.getWorkerStatus();
            if (string != null && string.length() > 0) {
                stringBuffer.append(" -- " + iAnalysis + " " + string);
            }
        } else if (status.getPending() == 0) {
            stringBuffer.append(string6 + string3 + " (" + this.ready(string4) + ")");
        } else if (status.getVerify() == 0) {
            stringBuffer.append(string6 + string3 + " (" + this.ready(string4) + ", " + this.toAnalyze(string5) + ")");
        } else if (status.getVerify() == status.getPending()) {
            stringBuffer.append(string6 + string3 + " (" + this.ready(string4) + ", " + this.toVerify(string5) + ")");
        } else {
            stringBuffer.append(string6 + string3 + " (" + this.ready(string4) + ", " + this.toAnalyzeVerify(string5) + ")");
        }
        string = stringBuffer.toString();
        if (!this.label.getText().equals(string)) {
            // empty if block
        }
        this.label.setText(string);
    }

    String ready(String string) {
        return MusicClient.STRINGS.expand("IDSTR_STATUS_READY", new String[]{string});
    }

    String toAnalyze(String string) {
        return MusicClient.STRINGS.expand("IDSTR_STATUS_ANALYZE", new String[]{string});
    }

    String toVerify(String string) {
        return MusicClient.STRINGS.expand("IDSTR_STATUS_VERIFY", new String[]{string});
    }

    String toAnalyzeVerify(String string) {
        return MusicClient.STRINGS.expand("IDSTR_STATUS_ANALYZE_VERIFY", new String[]{string});
    }
}

